/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.server;

import java.io.IOException;
import java.io.Writer;
import org.apache.soap.encoding.soapenc.SoapEncUtils;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.TypeMapping;
import org.apache.soap.util.Bean;
import org.apache.soap.util.StringUtils;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TypeMappingSerializer
implements Serializer,
Deserializer {
    static /* synthetic */ Class class$org$apache$soap$server$TypeMapping;

    public void marshall(String inScopeEncStyle, Class javaType, Object src, Object context, Writer sink, NSStack nsStack, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException, IOException {
        TypeMapping tm = (TypeMapping)src;
        nsStack.pushScope();
        SoapEncUtils.generateStructureHeader(inScopeEncStyle, javaType, context, sink, nsStack, xjmr);
        sink.write(StringUtils.lineSeparator);
        String xsiPrefix = nsStack.getPrefixFromURI("http://www.w3.org/2001/XMLSchema-instance");
        String xsdPrefix = nsStack.getPrefixFromURI("http://www.w3.org/2001/XMLSchema");
        if (xsiPrefix == null || xsdPrefix == null) {
            throw new IllegalArgumentException("required namespace names 'http://www.w3.org/2001/XMLSchema-instance' and/or 'http://www.w3.org/2001/XMLSchema' is not defined.");
        }
        if (tm.encodingStyle != null) {
            sink.write("<encodingStyle " + xsiPrefix + ":type=\"" + xsdPrefix + ":string\">" + tm.encodingStyle + "</encodingStyle>");
            sink.write(StringUtils.lineSeparator);
        }
        if (tm.elementType != null) {
            sink.write("<elementType-ns " + xsiPrefix + ":type=\"" + xsdPrefix + ":string\">" + tm.elementType.getNamespaceURI() + "</elementType-ns>");
            sink.write(StringUtils.lineSeparator);
            sink.write("<elementType-lp " + xsiPrefix + ":type=\"" + xsdPrefix + ":string\">" + tm.elementType.getLocalPart() + "</elementType-lp>");
            sink.write(StringUtils.lineSeparator);
        }
        if (tm.javaType != null) {
            sink.write("<javaType " + xsiPrefix + ":type=\"" + xsdPrefix + ":string\">" + tm.javaType + "</javaType>");
            sink.write(StringUtils.lineSeparator);
        }
        if (tm.xml2JavaClassName != null) {
            sink.write("<xml2JavaClassName " + xsiPrefix + ":type=\"" + xsdPrefix + ":string\">" + tm.xml2JavaClassName + "</xml2JavaClassName>");
            sink.write(StringUtils.lineSeparator);
        }
        if (tm.java2XMLClassName != null) {
            sink.write("<java2XMLClassName " + xsiPrefix + ":type=\"" + xsdPrefix + ":string\">" + tm.java2XMLClassName + "</java2XMLClassName>");
            sink.write(StringUtils.lineSeparator);
        }
        sink.write("</" + context + '>');
        nsStack.popScope();
    }

    public Bean unmarshall(String inScopeEncStyle, QName elementType, Node src, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException {
        NodeList nl = src.getChildNodes();
        int nKids = nl.getLength();
        String encodingStyle = null;
        String elTypeNS = null;
        String elTypeLP = null;
        QName qname = null;
        String javaType = null;
        String java2XMLClassName = null;
        String xml2JavaClassName = null;
        for (int i = 0; i < nKids; ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            Element e2 = (Element)n;
            String tagName = e2.getTagName();
            String elData = DOMUtils.getChildCharacterData(e2);
            if (tagName.equals("encodingStyle")) {
                encodingStyle = elData;
                continue;
            }
            if (tagName.equals("elementType-ns")) {
                elTypeNS = elData;
                continue;
            }
            if (tagName.equals("elementType-lp")) {
                elTypeLP = elData;
                continue;
            }
            if (tagName.equals("javaType")) {
                javaType = elData;
                continue;
            }
            if (tagName.equals("java2XMLClassName")) {
                java2XMLClassName = elData;
                continue;
            }
            if (tagName.equals("xml2JavaClassName")) {
                xml2JavaClassName = elData;
                continue;
            }
            throw new IllegalArgumentException("unknown element '" + tagName + "' while " + "unmarshalling a TypeMapping");
        }
        if (elTypeNS != null && elTypeLP != null) {
            qname = new QName(elTypeNS, elTypeLP);
        }
        return new Bean(class$org$apache$soap$server$TypeMapping == null ? (class$org$apache$soap$server$TypeMapping = TypeMappingSerializer.class$("org.apache.soap.server.TypeMapping")) : class$org$apache$soap$server$TypeMapping, new TypeMapping(encodingStyle, qname, javaType, java2XMLClassName, xml2JavaClassName));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

