/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.server;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.Constants;
import org.apache.soap.SOAPException;
import org.apache.soap.server.BaseConfigManager;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.server.http.ServerHTTPUtils;
import org.apache.soap.util.ConfigManager;
import org.apache.soap.util.xml.XMLParserUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLConfigManager
extends BaseConfigManager
implements ConfigManager {
    protected DocumentBuilder xdb = XMLParserUtils.getXMLDocBuilder();
    protected String filename = "DeployedServices.xml";

    public void setOptions(Hashtable options) {
        if (options == null) {
            return;
        }
        String value2 = (String)options.get("filename");
        if (value2 != null && !"".equals(value2)) {
            this.filename = value2;
        }
    }

    public void loadRegistry() throws SOAPException {
        this.dds = null;
        try {
            File file = ServerHTTPUtils.getFileFromNameAndContext(this.filename, this.context);
            FileReader rd = new FileReader(file);
            Document doc = null;
            Element root = null;
            try {
                doc = this.xdb.parse(new InputSource(rd));
                root = doc.getDocumentElement();
            }
            catch (Exception e2) {
                e2.printStackTrace();
                throw new SOAPException(Constants.FAULT_CODE_SERVER, e2.getMessage());
            }
            NodeList deploymentElements = root.getElementsByTagNameNS("http://xml.apache.org/xml-soap/deployment", "service");
            int count = deploymentElements.getLength();
            this.dds = new Hashtable();
            for (int i = 0; i < count; ++i) {
                Element deploymentElement = (Element)deploymentElements.item(i);
                DeploymentDescriptor dd = DeploymentDescriptor.fromXML(deploymentElement);
                String id = dd.getID();
                this.dds.put(id, dd);
            }
        }
        catch (Exception e3) {
            this.dds = new Hashtable();
            System.err.println("SOAP Service Manager: Unable to read '" + this.filename + "': assuming fresh start");
        }
    }

    public void saveRegistry() throws SOAPException {
        try {
            File file = ServerHTTPUtils.getFileFromNameAndContext(this.filename, this.context);
            PrintWriter pw = new PrintWriter(new FileWriter(file));
            Enumeration e2 = this.dds.elements();
            pw.println("<deployedServices>");
            pw.println();
            while (e2.hasMoreElements()) {
                DeploymentDescriptor dd = (DeploymentDescriptor)e2.nextElement();
                dd.toXML(pw);
                pw.println();
            }
            pw.println("</deployedServices>");
            pw.close();
        }
        catch (Exception e3) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Error saving services registry: " + e3.getMessage());
        }
    }
}

