/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.server.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.Body;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.Fault;
import org.apache.soap.SOAPException;
import org.apache.soap.providers.MsgJavaProvider;
import org.apache.soap.rpc.Response;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.server.ServerUtils;
import org.apache.soap.server.ServiceManager;
import org.apache.soap.server.http.ServerHTTPUtils;
import org.apache.soap.transport.EnvelopeEditor;
import org.apache.soap.transport.EnvelopeEditorFactory;
import org.apache.soap.transport.TransportMessage;
import org.apache.soap.util.Provider;
import org.apache.soap.util.xml.XMLParserUtils;
import org.w3c.dom.Element;

public class MessageRouterServlet
extends HttpServlet {
    private EnvelopeEditor editor = null;
    private String configFilename = null;

    public void init() throws ServletException {
        String tempStr;
        EnvelopeEditorFactory factory;
        ClassLoader servletClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            servletClassLoader.loadClass(((Object)((Object)this)).getClass().getName());
        }
        catch (ClassNotFoundException e2) {
            servletClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        }
        if (servletClassLoader == null) {
            servletClassLoader = ClassLoader.getSystemClassLoader();
        }
        ServletConfig servletConfig = this.getServletConfig();
        ServletContext servletContext = servletConfig.getServletContext();
        String envelopeEditorFactoryClassName = servletConfig.getInitParameter("EnvelopeEditorFactory");
        if (envelopeEditorFactoryClassName != null && (factory = (EnvelopeEditorFactory)this.createObject(envelopeEditorFactoryClassName, servletClassLoader)) != null) {
            try {
                Properties props = new Properties();
                Enumeration enumeration = servletConfig.getInitParameterNames();
                while (enumeration.hasMoreElements()) {
                    String name2 = (String)enumeration.nextElement();
                    if ("EnvelopeEditorFactory".equals(name2) || "XMLParser".equals(name2)) continue;
                    props.put(name2, servletConfig.getInitParameter(name2));
                }
                String servletContextPath = servletContext.getRealPath("");
                if (servletContextPath != null) {
                    props.put("SOAPServerContextPath", servletContextPath);
                }
                this.editor = factory.create(props);
            }
            catch (SOAPException e3) {
                throw new ServletException("Can't create editor", (Throwable)e3);
            }
        }
        if ((tempStr = servletConfig.getInitParameter("ConfigFile")) != null) {
            this.configFilename = tempStr;
        }
        if ((tempStr = servletConfig.getInitParameter("XMLParser")) != null) {
            XMLParserUtils.refreshDocumentBuilderFactory(tempStr, true, false);
        }
        ServerHTTPUtils.setServletClassLoaderIntoContext(servletContext, servletClassLoader);
    }

    private Object createObject(String className, ClassLoader classLoader) throws ServletException {
        try {
            return classLoader.loadClass(className).newInstance();
        }
        catch (ClassNotFoundException e2) {
            throw new ServletException("Can't find class named '" + className + "'.");
        }
        catch (InstantiationException e3) {
            throw new ServletException("Can't instantiate class '" + className + "'.");
        }
        catch (IllegalAccessException e4) {
            throw new ServletException("WARNING: Can't access the constructor of the class '" + className + "'.");
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setContentType("text/html");
        PrintWriter out = res.getWriter();
        out.println("<html><head><title>SOAP Message Router</title></head>");
        out.println("<body><h1>SOAP Message Router</h1>");
        out.println("<p>Sorry, I don't speak via HTTP GET- you have to use");
        out.println("HTTP POST to talk to me.</p></body></html>");
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ServletConfig config2 = this.getServletConfig();
        ServletContext context = config2.getServletContext();
        HttpSession session = req.getSession();
        ServiceManager serviceManager = ServerHTTPUtils.getServiceManagerFromContext(context, this.configFilename);
        DeploymentDescriptor dd = null;
        SOAPContext reqCtx = new SOAPContext();
        SOAPContext resCtx = new SOAPContext();
        reqCtx.setClassLoader(ServerHTTPUtils.getServletClassLoaderFromContext(context));
        try {
            int status;
            TransportMessage sres;
            try {
                reqCtx.setProperty(Constants.BAG_HTTPSERVLET, (Object)this);
                reqCtx.setProperty(Constants.BAG_HTTPSESSION, session);
                reqCtx.setProperty(Constants.BAG_HTTPSERVLETREQUEST, req);
                reqCtx.setProperty(Constants.BAG_HTTPSERVLETRESPONSE, res);
                DocumentBuilder xdb = XMLParserUtils.getXMLDocBuilder();
                Envelope msgEnv = ServerHTTPUtils.readEnvelopeFromRequest(xdb, req.getContentType(), req.getContentLength(), (InputStream)req.getInputStream(), this.editor, res, reqCtx);
                if (msgEnv == null) {
                    return;
                }
                Body body = msgEnv.getBody();
                Element e2 = (Element)body.getBodyEntries().elementAt(0);
                if (e2 == null) {
                    throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Message envelope's body is empty!");
                }
                String targetID = e2.getNamespaceURI();
                String messageName = e2.getLocalName();
                dd = serviceManager.query(targetID);
                reqCtx.setProperty(Constants.BAG_DEPLOYMENTDESCRIPTOR, dd);
                Provider provider = dd.getProviderType() == 0 ? new MsgJavaProvider() : (dd.getProviderType() == 3 ? ServerUtils.loadProvider(dd, reqCtx) : new MsgJavaProvider());
                provider.locate(dd, msgEnv, null, messageName, targetID, reqCtx);
                provider.invoke(reqCtx, resCtx);
                sres = new TransportMessage(null, resCtx, null);
                sres.editOutgoing(this.editor);
                status = 200;
            }
            catch (Throwable t) {
                SOAPException e3 = null;
                e3 = t instanceof SOAPException ? (SOAPException)t : new SOAPException(Constants.FAULT_CODE_SERVER + ".Exception:", "", t);
                Fault fault2 = new Fault(e3);
                fault2.setFaultActorURI(req.getRequestURI());
                if (dd != null) {
                    dd.buildFaultRouter(reqCtx).notifyListeners(fault2, e3);
                }
                status = 500;
                resCtx = new SOAPContext();
                Response resp = new Response(null, null, fault2, null, null, "http://schemas.xmlsoap.org/soap/encoding/", resCtx);
                Envelope env = resp.buildEnvelope();
                StringWriter sw = new StringWriter();
                env.marshall(sw, ServerHTTPUtils.getSMRFromContext(context), resp.getSOAPContext());
                String envelopeString = sw.toString();
                sres = new TransportMessage(envelopeString, resCtx, null);
            }
            sres.save();
            res.setStatus(status);
            res.setContentType(sres.getContentType());
            Enumeration headers = sres.getHeaderNames();
            while (headers.hasMoreElements()) {
                String name2 = (String)headers.nextElement();
                res.setHeader(name2, sres.getHeader(name2));
            }
            res.setContentLength(sres.getContentLength());
            ServletOutputStream outStream = res.getOutputStream();
            sres.writeTo((OutputStream)outStream);
        }
        catch (Exception e4) {
            throw new ServletException("Error building response envelope: " + e4);
        }
    }
}

