/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.transport;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.transport.EnvelopeEditor;
import org.apache.soap.transport.SOAPTransport;
import org.apache.soap.util.xml.XMLParserUtils;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FilterTransport
implements SOAPTransport {
    private EnvelopeEditor editor;
    private SOAPTransport transport;

    public FilterTransport(EnvelopeEditor editor, SOAPTransport transport2) {
        this.editor = editor;
        this.transport = transport2;
    }

    public void send(URL sendTo, String action, Hashtable headers, Envelope env, SOAPMappingRegistry smr, SOAPContext ctx) throws SOAPException {
        this.send(sendTo, action, headers, env, smr, ctx, null);
    }

    public void send(URL sendTo, String action, Hashtable headers, Envelope env, SOAPMappingRegistry smr, SOAPContext ctx, String host) throws SOAPException {
        try {
            StringWriter sout = new StringWriter();
            env.marshall(sout, smr, ctx);
            StringReader sin = new StringReader(sout.getBuffer().toString());
            if (this.editor != null) {
                sout = new StringWriter();
                this.editor.editOutgoing(sin, sout);
                sout.flush();
                sin = new StringReader(sout.getBuffer().toString());
            }
            DocumentBuilder xdb = XMLParserUtils.getXMLDocBuilder();
            Element docElem = xdb.parse(new InputSource(sin)).getDocumentElement();
            Envelope env2 = Envelope.unmarshall(docElem);
            this.transport.send(sendTo, action, headers, env2, smr, ctx);
        }
        catch (IllegalArgumentException e2) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, e2.getMessage(), e2);
        }
        catch (SAXException e3) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, e3.getMessage(), e3);
        }
        catch (IOException e4) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, e4.getMessage(), e4);
        }
    }

    public BufferedReader receive() {
        try {
            BufferedReader in = this.transport.receive();
            if (this.editor == null || in == null) {
                return in;
            }
            StringWriter sout = new StringWriter();
            this.editor.editIncoming(in, sout);
            sout.flush();
            StringReader sin = new StringReader(sout.getBuffer().toString());
            return new BufferedReader(sin);
        }
        catch (SOAPException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public Hashtable getHeaders() {
        return this.transport.getHeaders();
    }

    public SOAPContext getResponseSOAPContext() {
        return this.transport.getResponseSOAPContext();
    }
}

