/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.util;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;

public class PropUtils {
    public static final String CONFIG_PROPS = "soap_config.properties";
    private String _cfgFile;
    private Properties _props = new Properties();

    public PropUtils() {
        this._cfgFile = CONFIG_PROPS;
        this.init();
    }

    public PropUtils(String config_name) {
        this._cfgFile = config_name;
        this.init();
    }

    public Properties getProperties() {
        return this._props;
    }

    public void init() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null && (cl = this.getClass().getClassLoader()) == null) {
            return;
        }
        final ClassLoader fcl = cl;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                InputStream is = fcl.getResourceAsStream(PropUtils.this._cfgFile);
                try {
                    PropUtils.this._props.load(is);
                }
                catch (IOException ioe) {
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    public String getProperty(String key) {
        return this._props.getProperty(key);
    }
}

