/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.util.mime;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;

public class MimeUtils {
    private static final String hexmap = "0123456789ABCDEF";

    public static String getUniqueValue() {
        String host = null;
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            host = "localhost";
        }
        StringBuffer s = new StringBuffer();
        s.append(s.hashCode()).append('.').append(System.currentTimeMillis()).append(".apache-soap.").append(host);
        return s.toString();
    }

    public static String getEncoding(String type, String defaultEncoding) {
        String encoding = null;
        try {
            if (type != null && !type.equals("")) {
                encoding = new ContentType(type).getParameter("charset");
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        encoding = encoding == null ? defaultEncoding : MimeUtility.javaCharset((String)encoding);
        return encoding;
    }

    public static String decode(String s) {
        StringBuffer ret = new StringBuffer();
        block4: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    ret.append(' ');
                    continue block4;
                }
                case '%': {
                    ret.append((char)((hexmap.indexOf(s.charAt(++i)) << 4) + hexmap.indexOf(s.charAt(++i))));
                    continue block4;
                }
                default: {
                    ret.append(c);
                }
            }
        }
        return ret.toString();
    }
}

