/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.util.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.mail.MessagingException;
import org.apache.soap.SOAPException;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.transport.TransportMessage;
import org.apache.soap.util.mime.ByteArrayDataSource;
import org.apache.soap.util.net.SSLUtils;

public class HTTPUtils {
    private static final String HTTP_VERSION = "1.0";
    private static final int HTTP_DEFAULT_PORT = 80;
    private static final int HTTPS_DEFAULT_PORT = 443;
    public static final int DEFAULT_OUTPUT_BUFFER_SIZE = 512;
    public static boolean traceEnabled = SSLUtils.traceEnabled;
    public static boolean nonProxyTraceEnabled = false;
    static /* synthetic */ Class class$java$lang$String;

    public static boolean shouldUseProxy(String host, String nonProxyHosts) {
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.HTTPUtils.shouldUseProxy > Entry");
            System.out.println("org.apache.soap.util.net.HTTPUtils.shouldUseProxy: host=" + host + " nonProxyHosts=" + nonProxyHosts);
        }
        if (nonProxyHosts == null || host == null) {
            if (traceEnabled) {
                System.out.println("org.apache.soap.util.net.HTTPUtils.shouldUseProxy returns true < Exit");
            }
            return true;
        }
        StringTokenizer tokenizer = new StringTokenizer(nonProxyHosts, "|\"");
        while (tokenizer.hasMoreTokens()) {
            String pattern = tokenizer.nextToken();
            if (!HTTPUtils.match(pattern, host, false, nonProxyTraceEnabled)) continue;
            if (traceEnabled) {
                System.out.println("org.apache.soap.util.net.HTTPUtils.shouldUseProxy returns false < Exit");
            }
            return false;
        }
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.HTTPUtils.shouldUseProxy returns true < Exit");
        }
        return true;
    }

    private static Socket buildSocket(URL url, int targetPort, String httpProxyHost, int httpProxyPort, String httpProxyUserName, String httpProxyPassword, Boolean tcpNoDelay, String hostname) throws Exception {
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.buildSocket > Entry");
            System.out.println("org.apache.soap.util.net.buildSocket: url=" + url + " targetPort=" + targetPort + " httpProxyHost=" + httpProxyHost + " httpProxyPort=" + httpProxyPort + " httpProxyUserName=" + httpProxyUserName + " httpProxyPassword=***** tcpNoDelay=" + tcpNoDelay + " host=" + hostname);
        }
        Socket s = null;
        String host = null;
        int port2 = targetPort;
        host = url.getHost();
        if (url.getProtocol().equalsIgnoreCase("HTTPS")) {
            if (traceEnabled) {
                System.out.println("org.apache.soap.util.net.buildSocket: protocol is HTTPS");
            }
            Class<?> SSLUtilsClass = Class.forName("org.apache.soap.util.net.SSLUtils");
            Class[] paramTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = HTTPUtils.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE, class$java$lang$String == null ? (class$java$lang$String = HTTPUtils.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE, class$java$lang$String == null ? (class$java$lang$String = HTTPUtils.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = HTTPUtils.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = HTTPUtils.class$("java.lang.String")) : class$java$lang$String};
            Method buildSSLSocket = SSLUtilsClass.getMethod("buildSSLSocket", paramTypes);
            Object[] params = new Object[]{host, new Integer(port2), httpProxyHost, new Integer(httpProxyPort), httpProxyUserName, httpProxyPassword, hostname};
            s = (Socket)buildSSLSocket.invoke(null, params);
        } else {
            if (traceEnabled) {
                System.out.println("org.apache.soap.util.net.buildSocket: protocol is HTTP");
            }
            if (httpProxyHost != null) {
                String tmpHost;
                String string = tmpHost = hostname != null ? hostname : host;
                if (HTTPUtils.shouldUseProxy(tmpHost, System.getProperty("http.nonProxyHosts"))) {
                    host = httpProxyHost;
                    port2 = httpProxyPort;
                }
            }
            s = new Socket(host, port2);
        }
        if (tcpNoDelay != null && s != null) {
            s.setTcpNoDelay(tcpNoDelay);
        }
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.buildSocket < Exit");
        }
        return s;
    }

    private static int getPort(URL url) throws IOException {
        int port2;
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.getPort > Entry");
            System.out.println("org.apache.soap.util.net.getPort: url=" + url);
        }
        if ((port2 = url.getPort()) < 0) {
            port2 = url.getProtocol().equalsIgnoreCase("HTTPS") ? 443 : 80;
        }
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.getPort returns " + port2 + " < Exit");
        }
        return port2;
    }

    public static TransportMessage post(URL url, TransportMessage request, int timeout, String httpProxyHost, int httpProxyPort) throws IllegalArgumentException, IOException, SOAPException {
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.post (url,request,timeout,httpProxyHost,httpProxyPort)> Entry");
        }
        TransportMessage response = HTTPUtils.post(url, request, timeout, httpProxyHost, httpProxyPort, null, null, 512, null);
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.post (url,request,timeout,httpProxyHost,httpProxyPort)< Exit");
        }
        return response;
    }

    public static TransportMessage post(URL url, TransportMessage request, int timeout, String httpProxyHost, int httpProxyPort, int outputBufferSize) throws IllegalArgumentException, IOException, SOAPException {
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.post (url,request,timeout,httpProxyHost,httpProxyPort,outputBufferSize) > Entry");
        }
        TransportMessage response = HTTPUtils.post(url, request, timeout, httpProxyHost, httpProxyPort, null, null, outputBufferSize, null);
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.post (url,request,timeout,httpProxyHost,httpProxyPort,outputBufferSize)< Exit");
        }
        return response;
    }

    public static TransportMessage post(URL url, TransportMessage request, int timeout, String httpProxyHost, int httpProxyPort, String httpProxyUserName, String httpProxyPassword, int outputBufferSize, Boolean tcpNoDelay) throws IllegalArgumentException, IOException, SOAPException {
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.post (url,request,timeout,httpProxyHost,httpProxyPort,outputBufferSize,tcpNoDelay)< Exit");
        }
        TransportMessage response = HTTPUtils.post(url, request, timeout, httpProxyHost, httpProxyPort, httpProxyUserName, httpProxyPassword, outputBufferSize, tcpNoDelay, null);
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.post (url,request,timeout,httpProxyHost,httpProxyPort,outputBufferSize,tcpNoDelay)< Exit");
        }
        return response;
    }

    public static TransportMessage post(URL url, TransportMessage request, int timeout, String httpProxyHost, int httpProxyPort, String httpProxyUserName, String httpProxyPassword, int outputBufferSize, Boolean tcpNoDelay, String host) throws IllegalArgumentException, IOException, SOAPException {
        TransportMessage response;
        int offset;
        String URI2;
        Socket s;
        int port2;
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.post (url,request,timeout,httpProxyHost,httpProxyPort,outputBufferSize,tcpNoDelay)> Entry");
            System.out.println("org.apache.soap.util.net.post: url=" + url + " timeout=" + timeout + " httpProxyHost=" + httpProxyHost + " httpProxyPort=" + httpProxyPort + " outputBufferSize=" + outputBufferSize + " tcpNoDelay=" + tcpNoDelay + " host=" + host);
        }
        OutputStream outStream = null;
        InputStream inStream = null;
        Object in = null;
        try {
            port2 = HTTPUtils.getPort(url);
            s = HTTPUtils.buildSocket(url, port2, httpProxyHost, httpProxyPort, httpProxyUserName, httpProxyPassword, tcpNoDelay, host);
            if (url.getProtocol().equalsIgnoreCase("HTTPS")) {
                if (traceEnabled) {
                    System.out.println("org.apache.soap.util.net.post: protocol is HTTPS, Ignore proxy from now on. Buildsocket takes handles it");
                }
                httpProxyHost = null;
            }
            if (timeout > 0) {
                s.setSoTimeout(timeout);
            }
            outStream = s.getOutputStream();
            inStream = s.getInputStream();
        }
        catch (Exception e2) {
            Throwable t = e2;
            if (t instanceof InvocationTargetException) {
                t = ((InvocationTargetException)t).getTargetException();
            }
            if (traceEnabled) {
                System.out.println("org.apache.soap.util.net.post: Caught exception " + e2.toString());
                if (t != e2) {
                    System.out.println("org.apache.soap.util.net.post: Target exception " + t.toString());
                }
                e2.printStackTrace();
                System.out.println("org.apache.soap.util.net.post: Throwing IllegalArgumentException");
            }
            IllegalArgumentException iae = new IllegalArgumentException("Error opening socket: " + t);
            iae.initCause(t);
            throw iae;
        }
        String string = URI2 = httpProxyHost == null ? url.getFile() : url.toString();
        if (URI2.length() == 0) {
            URI2 = "/";
        }
        StringBuffer headerbuf = new StringBuffer();
        headerbuf.append("POST").append(' ').append(URI2).append(" HTTP/").append(HTTP_VERSION).append("\r\n").append("Host").append(": ").append(url.getHost()).append(':').append(port2).append("\r\n").append("Content-Type").append(": ").append(request.getContentType()).append("\r\n").append("Content-Length").append(": ").append(request.getContentLength()).append("\r\n");
        Enumeration e3 = request.getHeaderNames();
        while (e3.hasMoreElements()) {
            Object key = e3.nextElement();
            headerbuf.append(key).append(": ").append(request.getHeader((String)key)).append("\r\n");
        }
        headerbuf.append("\r\n");
        BufferedOutputStream bOutStream = new BufferedOutputStream(outStream, outputBufferSize);
        bOutStream.write(headerbuf.toString().getBytes("iso-8859-1"));
        request.writeTo(bOutStream);
        bOutStream.flush();
        outStream.flush();
        BufferedInputStream bInStream = new BufferedInputStream(inStream);
        int statusCode = 0;
        String statusString = null;
        StringBuffer linebuf = new StringBuffer();
        int b = 0;
        while (b != 10 && b != -1) {
            b = bInStream.read();
            if (b == 10 || b == 13 || b == -1) continue;
            linebuf.append((char)b);
        }
        String line = linebuf.toString();
        try {
            StringTokenizer st = new StringTokenizer(line);
            st.nextToken();
            statusCode = Integer.parseInt(st.nextToken());
            StringBuffer sb = new StringBuffer();
            while (st.hasMoreTokens()) {
                sb.append(st.nextToken());
                if (!st.hasMoreTokens()) continue;
                sb.append(" ");
            }
            statusString = sb.toString();
        }
        catch (Exception e4) {
            if (traceEnabled) {
                System.out.println("org.apache.soap.util.net.post: Caught exception " + e4.toString());
                e4.printStackTrace();
                System.out.println("org.apache.soap.util.net.post: Throwing IllegalArgumentException");
            }
            IllegalArgumentException iae = new IllegalArgumentException("Error parsing HTTP status line \"" + line + "\": " + e4);
            iae.initCause(e4);
            throw iae;
        }
        ByteArrayDataSource ds = new ByteArrayDataSource(bInStream, "iso-8859-1");
        byte[] bytes = ds.toByteArray();
        Hashtable<String, String> respHeaders = new Hashtable<String, String>();
        int respContentLength = -1;
        String respContentType = null;
        StringBuffer namebuf = new StringBuffer();
        StringBuffer valuebuf = new StringBuffer();
        boolean parsingName = true;
        for (offset = 0; offset < bytes.length; ++offset) {
            if (bytes[offset] == 10) {
                if (namebuf.length() == 0) break;
                String name2 = namebuf.toString();
                int valueLen = valuebuf.length();
                if (valueLen > 0 && valuebuf.charAt(valueLen - 1) == ';') {
                    valuebuf.deleteCharAt(valueLen - 1);
                }
                String value2 = valuebuf.toString();
                if (name2.equalsIgnoreCase("Content-Length")) {
                    respContentLength = Integer.parseInt(value2.trim());
                } else if (name2.equalsIgnoreCase("Content-Type")) {
                    respContentType = value2;
                } else {
                    String previousValue = respHeaders.put(name2, value2);
                    if (previousValue != null && (name2.equalsIgnoreCase("Set-Cookie") || name2.equalsIgnoreCase("Set-Cookie2"))) {
                        respHeaders.put(name2, previousValue + "," + value2);
                    }
                }
                namebuf = new StringBuffer();
                valuebuf = new StringBuffer();
                parsingName = true;
                continue;
            }
            if (bytes[offset] == 13) continue;
            if (parsingName) {
                if (bytes[offset] == 58) {
                    parsingName = false;
                    if (offset == bytes.length - 1 || bytes[offset + 1] != 32) continue;
                    ++offset;
                    continue;
                }
                namebuf.append((char)bytes[offset]);
                continue;
            }
            valuebuf.append((char)bytes[offset]);
        }
        InputStream is = ds.getInputStream();
        is.skip(offset + 1);
        if (respContentLength < 0) {
            respContentLength = ds.getSize() - offset - 1;
        }
        try {
            SOAPContext ctx = new SOAPContext();
            response = new TransportMessage(is, respContentLength, respContentType, ctx, respHeaders);
            response.read();
        }
        catch (MessagingException me) {
            if (traceEnabled) {
                System.out.println("org.apache.soap.util.net.post: Caught exception " + me.toString());
                me.printStackTrace();
                System.out.println("org.apache.soap.util.net.post: Throwing IllegalArgumentException");
            }
            throw new IllegalArgumentException("Error parsing response: " + (Object)((Object)me));
        }
        is.close();
        bOutStream.close();
        outStream.close();
        bInStream.close();
        inStream.close();
        s.close();
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.post (url,request,timeout,httpProxyHost,httpProxyPort,outputBufferSize,tcpNoDelay)< Exit");
        }
        return response;
    }

    private static boolean match(String pattern, String str, boolean isCaseSensitive, boolean traceMatch) {
        char ch;
        int i;
        char[] patArr = pattern.toCharArray();
        char[] strArr = str.toCharArray();
        int patIdxStart = 0;
        int patIdxEnd = patArr.length - 1;
        int strIdxStart = 0;
        int strIdxEnd = strArr.length - 1;
        boolean containsStar = false;
        if (traceMatch) {
            System.out.println("org.apache.soap.util.net.HTTPUtils.match: pattern=" + pattern + " str=" + str + " isCaseSensitive=" + isCaseSensitive);
        }
        for (i = 0; i < patArr.length; ++i) {
            if (patArr[i] != '*') continue;
            containsStar = true;
            break;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                if (traceMatch) {
                    System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning false. Pattern and string are not the same size");
                }
                return false;
            }
            for (i = 0; i <= patIdxEnd; ++i) {
                char ch2 = patArr[i];
                if (isCaseSensitive && ch2 != strArr[i]) {
                    if (traceMatch) {
                        System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning false. Case sensitive character mismatch");
                    }
                    return false;
                }
                if (isCaseSensitive || Character.toUpperCase(ch2) == Character.toUpperCase(strArr[i])) continue;
                if (traceMatch) {
                    System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning false. Case insensitive character mismatch");
                }
                return false;
            }
            if (traceMatch) {
                System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning true.  Pattern matches.");
            }
            return true;
        }
        if (patIdxEnd == 0) {
            if (traceMatch) {
                System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning true.  Pattern contains only star.");
            }
            return true;
        }
        if (traceMatch) {
            System.out.println("org.apache.soap.util.net.HTTPUtils.match: Processing chars before first star");
        }
        while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd) {
            if (isCaseSensitive && ch != strArr[strIdxStart]) {
                if (traceMatch) {
                    System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning false. Case sensitive character mismatch with chars before first star.");
                }
                return false;
            }
            if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart])) {
                if (traceMatch) {
                    System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning false. Case insensitive character mismatch with chars before first star.");
                }
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            for (i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                if (traceMatch) {
                    System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning false. All characters in the string are used, non-stars left in pattern (1).");
                }
                return false;
            }
            if (traceMatch) {
                System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning true. All characters in the string are used, only-stars left in pattern (1).");
            }
            return true;
        }
        if (traceMatch) {
            System.out.println("org.apache.soap.util.net.HTTPUtils.match: Processing chars after last star");
        }
        while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd) {
            if (isCaseSensitive && ch != strArr[strIdxEnd]) {
                if (traceMatch) {
                    System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning false. Case sensitive character mismatch with chars after last star.");
                }
                return false;
            }
            if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxEnd])) {
                if (traceMatch) {
                    System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning false. Case insensitive character mismatch with chars after last star.");
                }
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                if (traceMatch) {
                    System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning false. All characters in the string are used, non-stars left in pattern (2).");
                }
                return false;
            }
            if (traceMatch) {
                System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning true. All characters in the string are used, only-stars left in pattern (2).");
            }
            return true;
        }
        if (traceMatch) {
            System.out.println("org.apache.soap.util.net.HTTPUtils.match: Processing between stars");
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i2 = patIdxStart + 1; i2 <= patIdxEnd; ++i2) {
                if (patArr[i2] != '*') continue;
                patIdxTmp = i2;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block8: for (int i3 = 0; i3 <= strLength - patLength; ++i3) {
                for (int j = 0; j < patLength; ++j) {
                    ch = patArr[patIdxStart + j + 1];
                    if (isCaseSensitive && ch != strArr[strIdxStart + i3 + j] || !isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart + i3 + j])) continue block8;
                }
                foundIdx = strIdxStart + i3;
                break;
            }
            if (foundIdx == -1) {
                if (traceMatch) {
                    System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning false");
                }
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (i = patIdxStart; i <= patIdxEnd; ++i) {
            if (patArr[i] == '*') continue;
            if (traceMatch) {
                System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning false. All characters in the string are used, non-stars left in pattern (3).");
            }
            return false;
        }
        if (traceMatch) {
            System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning true. All characters in the string are used, only-stars left in pattern (3).");
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String propName = "org.apache.soap.nonProxy.debug";
        try {
            String envString = System.getProperty(propName);
            boolean envValue = SSLUtils.isTrueExplicitly(envString);
            if (envValue) {
                nonProxyTraceEnabled = true;
            }
            if (nonProxyTraceEnabled) {
                String strSetting = envValue ? "enabled" : "disabled";
                System.out.println(propName + " is " + strSetting);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

