/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.util.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.soap.encoding.soapenc.Base64;
import org.apache.soap.util.net.HTTPUtils;
import sun.net.www.protocol.http.HttpURLConnection;

public class SSLUtils {
    static String tunnelHost;
    static int tunnelPort;
    static String tunnelUserName;
    static String tunnelUserPassword;
    public static boolean traceEnabled;
    static int workedLast;

    public static final boolean isTrueExplicitly(String value2) {
        return value2 != null && (value2.equalsIgnoreCase("true") || value2.equals("1") || value2.equalsIgnoreCase("yes"));
    }

    public static Socket buildSSLSocket(String host, int port2, String httpProxyHost, int httpProxyPort, String httpProxyUserName, String httpProxyPassword) throws IOException, UnknownHostException {
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.SSLUtils.buildSSLSocket > Entry");
        }
        Socket tunnel = SSLUtils.buildSSLSocket(host, port2, httpProxyHost, httpProxyPort, httpProxyUserName, httpProxyPassword, null);
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.SSLUtils.doTunnelHandshake < Exit");
        }
        return tunnel;
    }

    public static Socket buildSSLSocket(String host, int port2, String httpProxyHost, int httpProxyPort, String httpProxyUserName, String httpProxyPassword, String hostname) throws IOException, UnknownHostException {
        boolean shouldTunnel;
        String tmpHost;
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.SSLUtils.buildSSLSocket > Entry");
            System.out.println("org.apache.soap.util.net.SSLUtils.buildSSLSocket (input values):\n  host={" + host + "}\n  port={" + port2 + "}\n  proxyHost={" + tunnelHost + "}\n  proxyPort={" + tunnelPort + "}");
            if (tunnelUserName != null && !"".equals(tunnelUserName)) {
                System.out.println("  proxyUserName={*****}");
            } else {
                System.out.println("  proxyUserName={" + tunnelUserName + "}");
            }
            if (tunnelUserPassword != null && !"".equals(tunnelUserPassword)) {
                System.out.println("  proxyPassword={*****}");
            } else {
                System.out.println("  proxyPassword={" + tunnelUserPassword + "}");
                System.out.println(hostname);
            }
        }
        SSLSocket sslSocket = null;
        SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        tunnelHost = System.getProperty("https.proxyHost");
        tunnelPort = Integer.getInteger("https.proxyPort", 80);
        tunnelUserName = System.getProperty("https.proxyUserName");
        tunnelUserPassword = System.getProperty("https.proxyPassword");
        String nonProxyHosts = System.getProperty("https.nonProxyHosts");
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.SSLUtils.buildSSLSocket (system values):\n  https.nonProxyHosts={" + nonProxyHosts + "}\n  https.proxyHost={" + tunnelHost + "}\n  https.proxyPort={" + tunnelPort + "}");
            if (tunnelUserName != null && !"".equals(tunnelUserName)) {
                System.out.println("  https.proxyUserName={*****}");
            } else {
                System.out.println("  https.proxyUserName={" + tunnelUserName + "}");
            }
            if (tunnelUserPassword != null && !"".equals(tunnelUserPassword)) {
                System.out.println("  https.proxyPassword={*****}");
            } else {
                System.out.println("  https.proxyPassword={" + tunnelUserPassword + "}");
                System.out.println(hostname);
            }
        }
        if (tunnelHost != null) {
            String string = tmpHost = hostname != null ? hostname : host;
            if (traceEnabled) {
                System.out.println("tmpHost=" + tmpHost);
            }
            shouldTunnel = HTTPUtils.shouldUseProxy(tmpHost, nonProxyHosts);
        } else {
            tunnelHost = httpProxyHost;
            tunnelPort = httpProxyPort;
            tunnelUserName = httpProxyUserName;
            tunnelUserPassword = httpProxyPassword;
            String string = tmpHost = hostname != null ? hostname : host;
            if (traceEnabled) {
                System.out.println("tmpHost=" + tmpHost);
            }
            shouldTunnel = HTTPUtils.shouldUseProxy(tmpHost, nonProxyHosts);
            if (traceEnabled) {
                System.out.println("org.apache.soap.util.net.SSLUtils.buildSSLSocket (final values):\n  shouldTunnel={" + shouldTunnel + "}\n  tunnelHost={" + tunnelHost + "}\n  tunnelPort={" + tunnelPort + "}\n  host={" + tmpHost + "}\n  port={" + port2 + "}");
                if (tunnelUserName != null && !"".equals(tunnelUserName)) {
                    System.out.println("  tunnelUserName={*****}");
                } else {
                    System.out.println("  tunnelUserName={" + tunnelUserName + "}");
                }
                if (tunnelUserPassword != null && !"".equals(tunnelUserPassword)) {
                    System.out.println("  tunnelUserPassword={*****}");
                } else {
                    System.out.println("  tunnelUserPassword={" + tunnelUserPassword + "}");
                }
            }
        }
        if (tunnelHost == null || !shouldTunnel) {
            sslSocket = (SSLSocket)factory.createSocket(host, port2);
            if (traceEnabled) {
                System.out.println("org.apache.soap.util.net.SSLUtils.buildSSLSocket: SSL socket created successfully");
            }
        } else {
            Socket tunnel = SSLUtils.doTunnelHandshake(host, port2, tunnelHost, tunnelPort, tunnelUserName, tunnelUserPassword);
            if (traceEnabled) {
                System.out.println("org.apache.soap.util.net.SSLUtils.buildSSLSocket: Returned from doTunnelHandshake");
            }
            if (traceEnabled) {
                System.out.println("org.apache.soap.util.net.SSLUtils.buildSSLSocket: Creating SSL socket through tunnel.");
            }
            sslSocket = (SSLSocket)factory.createSocket(tunnel, host, port2, true);
            if (traceEnabled) {
                System.out.println("org.apache.soap.util.net.SSLUtils.buildSSLSocket: SSL socket through tunnel created successfully");
            }
        }
        sslSocket.startHandshake();
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.SSLUtils.buildSSLSocket: Returned from sslSocket.startHandshake");
        }
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.SSLUtils.buildSSLSocket < Exit");
        }
        return sslSocket;
    }

    private static Socket doTunnelHandshake(String host, int port2, String tunnelHost, int tunnelPort, String tunnelUserName, String tunnelUserPassword) throws IOException {
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.SSLUtils.doTunnelHandshake > Entry");
        }
        String msg = null;
        int numProxyStrings = 2;
        int firstToTry = workedLast;
        boolean loopedOnce = false;
        int numAttempted = 0;
        Socket tunnel = null;
        for (int stringToTry = firstToTry; stringToTry < numProxyStrings; ++stringToTry) {
            String replyStr;
            byte[] b;
            if (loopedOnce) {
                if (stringToTry == firstToTry) {
                    continue;
                }
            } else {
                loopedOnce = true;
            }
            if (traceEnabled) {
                System.out.println("org.apache.soap.util.net.SSLUtils.doTunnelHandshake: Opening socket to " + tunnelHost + ":" + tunnelPort);
            }
            tunnel = new Socket(tunnelHost, tunnelPort);
            OutputStream out = tunnel.getOutputStream();
            ++numAttempted;
            switch (stringToTry) {
                case 0: {
                    if (tunnelUserName == null || tunnelUserPassword == null) {
                        msg = "CONNECT " + host + ":" + port2 + " HTTP/1.0\n" + "User-Agent: " + HttpURLConnection.userAgent + "\r\n\r\n";
                        break;
                    }
                    msg = "CONNECT " + host + ":" + port2 + " HTTP/1.0\n" + "User-Agent: " + HttpURLConnection.userAgent + "\nProxy-authorization: " + " basic " + Base64.encode((tunnelUserName + ":" + tunnelUserPassword).getBytes("8859_1")) + "\r\n\r\n";
                    break;
                }
                case 1: {
                    msg = tunnelUserName == null || tunnelUserPassword == null ? "CONNECT " + host + ":" + port2 + " HTTP/1.0" + "\r\nUser-Agent: " + HttpURLConnection.userAgent + "\r\n\r\n" : "CONNECT " + host + ":" + port2 + " HTTP/1.0" + "\r\nProxy-Authorization: Basic " + Base64.encode((tunnelUserName + ":" + tunnelUserPassword).getBytes("8859_1")) + "\r\nUser-Agent: " + HttpURLConnection.userAgent + "\r\n\r\n";
                }
            }
            if (traceEnabled) {
                System.out.println("org.apache.soap.util.net.SSLUtils.doTunnelHandshake: Attempting proxy string " + stringToTry);
                System.out.println("org.apache.soap.util.net.SSLUtils.doTunnelHandshake: msg to tunnel={\n" + msg + "}");
            }
            try {
                b = msg.getBytes("ASCII7");
            }
            catch (UnsupportedEncodingException ignored) {
                b = msg.getBytes();
            }
            out.write(b);
            out.flush();
            if (traceEnabled) {
                System.out.println("org.apache.soap.util.net.SSLUtils.doTunnelHandshake: out.write was successful");
            }
            byte[] reply = new byte[200];
            int replyLen = 0;
            int newlinesSeen = 0;
            boolean headerDone = false;
            InputStream in = tunnel.getInputStream();
            boolean error = false;
            while (newlinesSeen < 2) {
                int i = in.read();
                if (i < 0) {
                    if (traceEnabled) {
                        System.out.println("org.apache.soap.util.net.SSLUtils.doTunnelHandshake: Unexpected EOF from proxy");
                    }
                    throw new IOException("Unexpected EOF from proxy");
                }
                if (i == 10) {
                    headerDone = true;
                    ++newlinesSeen;
                    continue;
                }
                if (i == 13) continue;
                newlinesSeen = 0;
                if (headerDone || replyLen >= reply.length) continue;
                reply[replyLen++] = (byte)i;
            }
            try {
                replyStr = new String(reply, 0, replyLen, "ASCII7");
            }
            catch (UnsupportedEncodingException ignored) {
                replyStr = new String(reply, 0, replyLen);
            }
            if (traceEnabled) {
                System.out.println("org.apache.soap.util.net.SSLUtils.doTunnelHandshake: return from tunnel={" + replyStr + "}");
            }
            StringTokenizer st = new StringTokenizer(replyStr);
            st.nextToken();
            if (!st.nextToken().startsWith("200")) {
                if (numAttempted == numProxyStrings) {
                    String exStr = "Unable to tunnel through " + tunnelHost + ":" + tunnelPort + ".  Proxy returns \"" + replyStr + "\"";
                    if (traceEnabled) {
                        System.out.println("org.apache.soap.util.net.SSLUtils.doTunnelHandshake: " + exStr);
                    }
                    throw new IOException(exStr);
                }
                if (stringToTry == firstToTry && stringToTry != 0) {
                    stringToTry = -1;
                }
                if (traceEnabled) {
                    System.out.println("org.apache.soap.util.net.SSLUtils.doTunnelHandshake: Closing socket, retry with different string.");
                }
                tunnel.close();
                continue;
            }
            workedLast = stringToTry;
        }
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.SSLUtils.doTunnelHandshake < Exit");
        }
        return tunnel;
    }

    static {
        traceEnabled = false;
        String propName = "org.apache.soap.debug";
        try {
            String envString = System.getProperty(propName);
            boolean envValue = SSLUtils.isTrueExplicitly(envString);
            if (envValue) {
                traceEnabled = true;
            }
            if (traceEnabled) {
                String strSetting = envValue ? "enabled" : "disabled";
                System.out.println(propName + " is " + strSetting);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        workedLast = 0;
    }
}

