/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.attachments;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.activation.DataHandler;
import org.apache.wsif.WSIFException;
import org.apache.wsif.logging.Trc;

public class WSIFAttachmentPart
implements Cloneable {
    private static final long serialVersionUID = 1L;
    private transient DataHandler dh;
    private Map properties;

    public WSIFAttachmentPart() {
        Trc.entry(this);
        this.dh = null;
        this.properties = new HashMap();
        Trc.exit();
    }

    public WSIFAttachmentPart(DataHandler dh) {
        Trc.entry((Object)this, dh);
        this.dh = dh;
        this.properties = new HashMap();
        Trc.exit();
    }

    public WSIFAttachmentPart(Object obj) {
        Trc.entry((Object)this, obj);
        this.dh = (DataHandler)obj;
        this.properties = new HashMap();
        Trc.exit();
    }

    public WSIFAttachmentPart(DataHandler dh, Map properties) throws WSIFException {
        Trc.entry(this, dh, properties);
        this.validateProperties(properties);
        this.dh = dh;
        this.properties = properties;
        Trc.exit();
    }

    public void setProperty(String name2, String value2) throws WSIFException {
        Trc.entry(this, name2, value2);
        this.properties.put(name2, value2);
        Trc.exit();
    }

    public void setProperties(Map properties) throws WSIFException {
        Trc.entry((Object)this, properties);
        this.validateProperties(properties);
        properties.putAll(properties);
        Trc.exit();
    }

    public String getProperty(String name2) {
        Trc.entry((Object)this, name2);
        String value2 = (String)this.properties.get(name2);
        Trc.exit(value2);
        return value2;
    }

    public boolean containsProperty(String name2) {
        Trc.entry((Object)this, name2);
        boolean ok = this.properties.containsKey(name2);
        Trc.exit(ok);
        return ok;
    }

    public Iterator getPropertyIterator() {
        Trc.entry(this);
        Iterator it = this.properties.keySet().iterator();
        Trc.exit(it);
        return it;
    }

    public void clearProperties() {
        Trc.entry(this);
        this.properties = new HashMap();
        Trc.exit();
    }

    public DataHandler getDataHandler() {
        Trc.entry(this);
        Trc.exit(this.dh);
        return this.dh;
    }

    public void setDataHandler(DataHandler dh) {
        Trc.entry((Object)this, dh);
        this.dh = dh;
        Trc.exit();
    }

    private void validateProperties(Map properties) throws WSIFException {
        Trc.entry((Object)this, properties);
        Iterator it = properties.keySet().iterator();
        while (it.hasNext()) {
            String next = (String)it.next();
            if (properties.get(next) instanceof String) continue;
            throw new WSIFException("Property " + next + " was not a String.");
        }
        Trc.exit();
    }

    public Object clone() throws CloneNotSupportedException {
        Trc.entry(this);
        DataHandler dh1 = new DataHandler(this.dh.getDataSource());
        HashMap properties1 = new HashMap(this.properties);
        WSIFAttachmentPart wap = null;
        try {
            wap = new WSIFAttachmentPart(dh1, properties1);
        }
        catch (WSIFException we) {
            Trc.exception(we);
            throw new CloneNotSupportedException(we.toString());
        }
        Trc.exit(wap);
        return wap;
    }
}

