/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.base;

import com.ibm.jrom.JROMValue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Message;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.base.WSIFObjectInputStream;
import org.apache.wsif.base.WSIFServiceImpl;
import org.apache.wsif.logging.Trc;

public class WSIFDefaultMessage
implements WSIFMessage {
    private static final long serialVersionUID = 1L;
    protected Map parts;
    protected String name;
    protected String style;
    protected Message msgDefinition;
    private boolean JROMAvailable = false;

    public WSIFDefaultMessage() {
        Trc.entry(this);
        this.JROMAvailable = WSIFServiceImpl.getJROMAvailability();
        Trc.exit();
    }

    public String getName() {
        Trc.entry(this);
        Trc.exit(this.name);
        return this.name;
    }

    public void setName(String name2) {
        Trc.entry((Object)this, name2);
        this.name = name2;
        Trc.exit();
    }

    public String getRepresentationStyle() {
        Trc.entry(this);
        Trc.exit(this.style);
        return this.style;
    }

    public void setRepresentationStyle(String rStyle) {
        Trc.entry((Object)this, rStyle);
        this.style = rStyle;
        Trc.exit();
    }

    public Iterator getParts() {
        Trc.entry(this);
        if (this.parts == null) {
            this.parts = new HashMap();
        }
        Iterator it = this.parts.values().iterator();
        Trc.exit(it);
        return it;
    }

    public void setParts(Map sourceParts) {
        Trc.entry((Object)this, sourceParts);
        if (this.parts == null) {
            this.parts = new HashMap();
        } else {
            this.parts.clear();
        }
        Iterator names2 = sourceParts.keySet().iterator();
        while (names2.hasNext()) {
            String name2 = (String)names2.next();
            Object part = sourceParts.get(name2);
            this.parts.put(name2, part);
        }
        Trc.exit();
    }

    public Message getMessageDefinition() {
        Trc.entry(this);
        Trc.exit(this.msgDefinition);
        return this.msgDefinition;
    }

    public void setMessageDefinition(Message msgDef) {
        Trc.entry((Object)this, this.msgDefinition);
        this.msgDefinition = msgDef;
        Trc.exit();
    }

    public void setObjectPart(String name2, Object part) throws WSIFException {
        Trc.entry(this, name2, part);
        if (this.parts == null) {
            this.parts = new HashMap();
        }
        if (this.JROMAvailable && part instanceof JROMValue) {
            this.style = "http://www.apache.org/namespaces/jrom";
        }
        this.parts.put(name2, part);
        Trc.exit();
    }

    public Object getObjectPart(String name2) throws WSIFException {
        Trc.entry((Object)this, name2);
        if (this.parts == null) {
            this.handleNoPartsException(name2, "Object");
            Trc.exit(null);
            return null;
        }
        if (this.parts.get(name2) == null) {
            if (!this.parts.keySet().contains(name2)) {
                this.handlePartNotFoundException(name2);
            }
            Trc.exit(null);
            return null;
        }
        Object o = this.parts.get(name2);
        Trc.exit(o);
        return o;
    }

    public Object getObjectPart(String name2, Class sourceClass) throws WSIFException {
        Trc.entry(this, name2, sourceClass);
        if (this.parts == null) {
            this.handleNoPartsException(name2, "Object");
            Trc.exit(null);
            return null;
        }
        Object part = this.parts.get(name2);
        if (part == null) {
            if (!this.parts.keySet().contains(name2)) {
                this.handlePartNotFoundException(name2);
            }
            Trc.exit(null);
            return null;
        }
        if (part.getClass().getName().equals(sourceClass.getName())) {
            Trc.exit(part);
            return part;
        }
        this.handleSourcedPartNotFoundException(name2, sourceClass);
        Trc.exit(null);
        return null;
    }

    public byte getBytePart(String name2) throws WSIFException {
        Trc.entry((Object)this, name2);
        if (this.parts == null) {
            this.handleNoPartsException(name2, "byte");
        }
        try {
            byte b = (Byte)this.parts.get(name2);
            Trc.exit(b);
            return b;
        }
        catch (NullPointerException ne) {
            Trc.exception(ne);
            this.handlePartNotFoundException(name2);
            Trc.exit(0);
            return 0;
        }
        catch (ClassCastException ce) {
            Trc.exception(ce);
            this.handlePartCastException(name2, this.parts.get(name2).getClass().getName(), "Byte");
            Trc.exit(0);
            return 0;
        }
    }

    public void setBytePart(String name2, byte part) {
        Trc.entry(this, name2, new Byte(part));
        if (this.parts == null) {
            this.parts = new HashMap();
        }
        this.parts.put(name2, new Byte(part));
        Trc.exit();
    }

    public char getCharPart(String name2) throws WSIFException {
        Trc.entry((Object)this, name2);
        if (this.parts == null) {
            this.handleNoPartsException(name2, "char");
        }
        try {
            char c = ((Character)this.parts.get(name2)).charValue();
            Trc.exit(c);
            return c;
        }
        catch (NullPointerException ne) {
            Trc.exception(ne);
            this.handlePartNotFoundException(name2);
            Trc.exit(0);
            return '\u0000';
        }
        catch (ClassCastException ce) {
            try {
                String s = (String)this.parts.get(name2);
                if (s != null && s.length() == 1) {
                    char c = s.charAt(0);
                    Trc.exit(c);
                    return c;
                }
                throw ce;
            }
            catch (ClassCastException ce2) {
                Trc.exception(ce);
                this.handlePartCastException(name2, this.parts.get(name2).getClass().getName(), "Character");
                Trc.exit(0);
                return '\u0000';
            }
        }
    }

    public void setCharPart(String name2, char part) {
        Trc.entry(this, name2, new Character(part));
        if (this.parts == null) {
            this.parts = new HashMap();
        }
        this.parts.put(name2, new Character(part));
        Trc.exit();
    }

    public int getIntPart(String name2) throws WSIFException {
        Trc.entry((Object)this, name2);
        if (this.parts == null) {
            this.handleNoPartsException(name2, "int");
        }
        try {
            int i = (Integer)this.parts.get(name2);
            Trc.exit(i);
            return i;
        }
        catch (NullPointerException ne) {
            Trc.exception(ne);
            this.handlePartNotFoundException(name2);
            Trc.exit(0);
            return 0;
        }
        catch (ClassCastException ce) {
            Trc.exception(ce);
            this.handlePartCastException(name2, this.parts.get(name2).getClass().getName(), "Integer");
            Trc.exit(0);
            return 0;
        }
    }

    public void setIntPart(String name2, int part) {
        Trc.entry(this, name2, new Integer(part));
        if (this.parts == null) {
            this.parts = new HashMap();
        }
        this.parts.put(name2, new Integer(part));
        Trc.exit();
    }

    public long getLongPart(String name2) throws WSIFException {
        Trc.entry((Object)this, name2);
        if (this.parts == null) {
            this.handleNoPartsException(name2, "long");
        }
        try {
            long l = (Long)this.parts.get(name2);
            Trc.exit(new Long(l));
            return l;
        }
        catch (NullPointerException ne) {
            Trc.exception(ne);
            this.handlePartNotFoundException(name2);
            Trc.exit(0);
            return 0L;
        }
        catch (ClassCastException ce) {
            Trc.exception(ce);
            this.handlePartCastException(name2, this.parts.get(name2).getClass().getName(), "Long");
            Trc.exit(0);
            return 0L;
        }
    }

    public void setLongPart(String name2, long part) {
        Trc.entry(this, name2, new Long(part));
        if (this.parts == null) {
            this.parts = new HashMap();
        }
        this.parts.put(name2, new Long(part));
        Trc.exit();
    }

    public short getShortPart(String name2) throws WSIFException {
        Trc.entry((Object)this, name2);
        if (this.parts == null) {
            this.handleNoPartsException(name2, "short");
        }
        try {
            short s = (Short)this.parts.get(name2);
            Trc.exit(s);
            return s;
        }
        catch (NullPointerException ne) {
            Trc.exception(ne);
            this.handlePartNotFoundException(name2);
            Trc.exit(0);
            return 0;
        }
        catch (ClassCastException ce) {
            Trc.exception(ce);
            this.handlePartCastException(name2, this.parts.get(name2).getClass().getName(), "Short");
            Trc.exit(0);
            return 0;
        }
    }

    public void setShortPart(String name2, short part) {
        Trc.entry(this, name2, new Short(part));
        if (this.parts == null) {
            this.parts = new HashMap();
        }
        this.parts.put(name2, new Short(part));
        Trc.exit();
    }

    public float getFloatPart(String name2) throws WSIFException {
        Trc.entry((Object)this, name2);
        if (this.parts == null) {
            this.handleNoPartsException(name2, "float");
        }
        try {
            float f = ((Float)this.parts.get(name2)).floatValue();
            Trc.exit(new Float(f));
            return f;
        }
        catch (NullPointerException ne) {
            Trc.exception(ne);
            this.handlePartNotFoundException(name2);
            Trc.exit(0);
            return 0.0f;
        }
        catch (ClassCastException ce) {
            Trc.exception(ce);
            this.handlePartCastException(name2, this.parts.get(name2).getClass().getName(), "Float");
            Trc.exit(0);
            return 0.0f;
        }
    }

    public void setFloatPart(String name2, float part) {
        Trc.entry(this, name2, new Float(part));
        if (this.parts == null) {
            this.parts = new HashMap();
        }
        this.parts.put(name2, new Float(part));
        Trc.exit();
    }

    public double getDoublePart(String name2) throws WSIFException {
        Trc.entry((Object)this, name2);
        if (this.parts == null) {
            this.handleNoPartsException(name2, "double");
        }
        try {
            double d = (Double)this.parts.get(name2);
            Trc.exit(new Double(d));
            return d;
        }
        catch (NullPointerException ne) {
            Trc.exception(ne);
            this.handlePartNotFoundException(name2);
            Trc.exit(0);
            return 0.0;
        }
        catch (ClassCastException ce) {
            Trc.exception(ce);
            this.handlePartCastException(name2, this.parts.get(name2).getClass().getName(), "Double");
            Trc.exit(0);
            return 0.0;
        }
    }

    public void setDoublePart(String name2, double part) {
        Trc.entry(this, name2, new Double(part));
        if (this.parts == null) {
            this.parts = new HashMap();
        }
        this.parts.put(name2, new Double(part));
        Trc.exit();
    }

    public boolean getBooleanPart(String name2) throws WSIFException {
        Trc.entry((Object)this, name2);
        if (this.parts == null) {
            this.handleNoPartsException(name2, "boolean");
        }
        try {
            boolean b = (Boolean)this.parts.get(name2);
            Trc.exit(b);
            return b;
        }
        catch (NullPointerException ne) {
            Trc.exception(ne);
            this.handlePartNotFoundException(name2);
            Trc.exit(false);
            return false;
        }
        catch (ClassCastException ce) {
            Trc.exception(ce);
            this.handlePartCastException(name2, this.parts.get(name2).getClass().getName(), "Boolean");
            Trc.exit(false);
            return false;
        }
    }

    public void setBooleanPart(String name2, boolean part) {
        Trc.entry(this, name2, new Boolean(part));
        if (this.parts == null) {
            this.parts = new HashMap();
        }
        this.parts.put(name2, new Boolean(part));
        Trc.exit();
    }

    public Iterator getPartNames() {
        Trc.entry(this);
        if (this.parts == null) {
            this.parts = new HashMap();
        }
        Iterator it = this.parts.keySet().iterator();
        Trc.exit(it);
        return it;
    }

    public Object clone() throws CloneNotSupportedException {
        Trc.entry(this);
        WSIFDefaultMessage dm = new WSIFDefaultMessage();
        dm.setName(this.name);
        dm.setRepresentationStyle(this.style);
        dm.setMessageDefinition(this.msgDefinition);
        if (this.parts != null) {
            Iterator it = this.getPartNames();
            while (it.hasNext()) {
                String pn = (String)it.next();
                Object po = this.parts.get(pn);
                if (po == null) {
                    try {
                        dm.setObjectPart(pn, null);
                        continue;
                    }
                    catch (Exception e2) {
                        Trc.exception(e2);
                        throw new CloneNotSupportedException("Exception thrown whilst cloning part " + pn + ". Message is " + e2.getMessage());
                    }
                }
                Object simpleTypeObj = null;
                if (po instanceof String || po instanceof Integer || po instanceof Float || po instanceof Byte || po instanceof Long || po instanceof Short || po instanceof Double || po instanceof Boolean) {
                    simpleTypeObj = po;
                }
                try {
                    if (simpleTypeObj != null) {
                        dm.setObjectPart(pn, simpleTypeObj);
                        continue;
                    }
                }
                catch (Exception e3) {
                    Trc.exception(e3);
                    throw new CloneNotSupportedException("Exception thrown whilst cloning part " + pn + ". Message is " + e3.getMessage());
                }
                if (po instanceof Cloneable) {
                    final Class<?> cls = po.getClass();
                    try {
                        Method clone = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws NoSuchMethodException {
                                return cls.getMethod("clone", null);
                            }
                        });
                        Object poc = clone.invoke(po, null);
                        dm.setObjectPart(pn, poc);
                        continue;
                    }
                    catch (InvocationTargetException e4) {
                        Trc.exception(e4);
                        throw new CloneNotSupportedException("Exception thrown whilst cloning part " + pn + ". Message is " + e4.getTargetException().getMessage());
                    }
                    catch (Exception e5) {
                        if (e5 instanceof PrivilegedActionException) {
                            e5 = ((PrivilegedActionException)e5).getException();
                        }
                        Trc.exception(e5);
                        throw new CloneNotSupportedException("Exception thrown whilst cloning part " + pn + ". Message is " + e5.getMessage());
                    }
                }
                if (po instanceof Serializable) {
                    try {
                        ByteArrayOutputStream b = new ByteArrayOutputStream();
                        ObjectOutputStream out = new ObjectOutputStream(b);
                        out.writeObject(po);
                        out.flush();
                        out.close();
                        byte[] data = b.toByteArray();
                        WSIFObjectInputStream in = new WSIFObjectInputStream(new ByteArrayInputStream(data));
                        Object poc = in.readObject();
                        in.close();
                        dm.setObjectPart(pn, poc);
                        continue;
                    }
                    catch (Exception e6) {
                        Trc.exception(e6);
                        throw new CloneNotSupportedException("Exception thrown whilst cloning part " + pn + " by serialization. Message is " + e6.getMessage());
                    }
                }
                throw new CloneNotSupportedException("Part " + pn + " cannot be cloned");
            }
        }
        if (Trc.ON) {
            Trc.exit(dm.deep());
        }
        return dm;
    }

    private void handleNoPartsException(String part, String type) throws WSIFException {
        throw new WSIFException("Cannot get " + type + " part '" + part + "'. No parts are set on the message");
    }

    private void handlePartNotFoundException(String part) throws WSIFException {
        throw new WSIFException("Cannot get part '" + part + "'. Part was not found in message");
    }

    private void handleSourcedPartNotFoundException(String part, Class sclass) throws WSIFException {
        throw new WSIFException("Cannot get part. Part '" + part + "' with source '" + sclass + "' was not found in message");
    }

    private void handlePartCastException(String part, String act, String exp) throws WSIFException {
        throw new WSIFException("Cannot get part '" + part + "'. Cannot convert " + "from " + act + " to " + exp);
    }

    public String toString() {
        return this.deep();
    }

    public String deep() {
        String buff = "";
        try {
            buff = new String(super.toString());
            buff = buff + " name:" + this.name;
            buff = buff + " JROM:" + this.JROMAvailable;
            buff = this.parts == null ? buff + " parts:null" : buff + Trc.brief(2, " parts", this.parts.values());
        }
        catch (Exception e2) {
            Trc.exceptionInTrace(e2);
        }
        return buff;
    }
}

