/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.base;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Operation;
import javax.xml.namespace.QName;
import org.apache.wsif.WSIFCorrelationId;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.WSIFOperation;
import org.apache.wsif.WSIFPort;
import org.apache.wsif.WSIFResponseHandler;
import org.apache.wsif.base.WSIFDefaultMessage;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.util.WSIFUtils;
import org.apache.wsif.wsdl.extensions.jms.JMSProperty;
import org.apache.wsif.wsdl.extensions.jms.JMSPropertyValue;

public abstract class WSIFDefaultOperation
implements WSIFOperation {
    private static final long serialVersionUID = 1L;
    protected transient HashMap inJmsProps = new HashMap();
    protected transient HashMap outJmsProps = new HashMap();
    protected transient HashMap inJmsPropVals = new HashMap();
    protected WSIFMessage context;
    protected boolean closed = false;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;

    public abstract boolean executeRequestResponseOperation(WSIFMessage var1, WSIFMessage var2, WSIFMessage var3) throws WSIFException;

    public abstract void executeInputOnlyOperation(WSIFMessage var1) throws WSIFException;

    public WSIFCorrelationId executeRequestResponseAsync(WSIFMessage input, WSIFResponseHandler handler2) throws WSIFException {
        throw new WSIFException("asynchronous operations not supportted");
    }

    public WSIFCorrelationId executeRequestResponseAsync(WSIFMessage input) throws WSIFException {
        throw new WSIFException("asynchronous operations not supportted");
    }

    public void fireAsyncResponse(Object response) throws WSIFException {
        throw new WSIFException("asynchronous operations not supportted");
    }

    public boolean processAsyncResponse(Object response, WSIFMessage output, WSIFMessage fault2) throws WSIFException {
        throw new WSIFException("asynchronous operations not supportted");
    }

    public WSIFMessage createInputMessage() {
        Trc.entry(this);
        WSIFDefaultMessage msg = new WSIFDefaultMessage();
        if (msg != null) {
            try {
                msg.setMessageDefinition(this.getOperation().getInput().getMessage());
            }
            catch (Exception e2) {
                Trc.ignoredException(e2);
            }
        }
        Trc.exit(msg);
        return msg;
    }

    public WSIFMessage createInputMessage(String name2) {
        Trc.entry((Object)this, name2);
        WSIFDefaultMessage msg = new WSIFDefaultMessage();
        if (msg != null) {
            msg.setName(name2);
            try {
                msg.setMessageDefinition(this.getOperation().getInput().getMessage());
            }
            catch (Exception e2) {
                Trc.ignoredException(e2);
            }
        }
        Trc.exit(msg);
        return msg;
    }

    public WSIFMessage createOutputMessage() {
        Trc.entry(this);
        WSIFDefaultMessage msg = new WSIFDefaultMessage();
        if (msg != null) {
            try {
                msg.setMessageDefinition(this.getOperation().getOutput().getMessage());
            }
            catch (Exception e2) {
                Trc.ignoredException(e2);
            }
        }
        Trc.exit(msg);
        return msg;
    }

    public WSIFMessage createOutputMessage(String name2) {
        Trc.entry((Object)this, name2);
        WSIFDefaultMessage msg = new WSIFDefaultMessage();
        if (msg != null) {
            msg.setName(name2);
            try {
                msg.setMessageDefinition(this.getOperation().getOutput().getMessage());
            }
            catch (Exception e2) {
                Trc.ignoredException(e2);
            }
        }
        Trc.exit(msg);
        return msg;
    }

    public WSIFMessage createFaultMessage() {
        Trc.entry(this);
        WSIFDefaultMessage wm = new WSIFDefaultMessage();
        Trc.exit(wm);
        return wm;
    }

    public WSIFMessage createFaultMessage(String name2) {
        Trc.entry((Object)this, name2);
        WSIFDefaultMessage msg = new WSIFDefaultMessage();
        if (msg != null) {
            msg.setName(name2);
            try {
                msg.setMessageDefinition(this.getOperation().getFault(name2).getMessage());
            }
            catch (Exception e2) {
                Trc.ignoredException(e2);
            }
        }
        Trc.exit(msg);
        return msg;
    }

    public void setInputJmsProperties(List list) throws WSIFException {
        Trc.entry((Object)this, list);
        this.inJmsProps = this.makeSomeKindOfJmsMap(list);
        Trc.exit();
    }

    public void setOutputJmsProperties(List list) throws WSIFException {
        Trc.entry((Object)this, list);
        this.outJmsProps = this.makeSomeKindOfJmsMap(list);
        Trc.exit();
    }

    public void setInputJmsProperties(HashMap hm) {
        Trc.entry((Object)this, hm);
        this.inJmsProps = hm;
        Trc.exit();
    }

    public void setOutputJmsProperties(HashMap hm) {
        Trc.entry((Object)this, hm);
        this.outJmsProps = hm;
        Trc.exit();
    }

    public HashMap getInputJmsProperties() {
        Trc.entry(this);
        Trc.exit(this.inJmsProps);
        return this.inJmsProps;
    }

    public HashMap getOutputJmsProperties() {
        Trc.entry(this);
        Trc.exit(this.outJmsProps);
        return this.outJmsProps;
    }

    public abstract WSIFPort getWSIFPort();

    public void addInputJmsPropertyValues(List list) throws WSIFException {
        Trc.entry((Object)this, list);
        if (list != null && !list.isEmpty()) {
            HashMap newPvs = this.makeSomeKindOfJmsMap(list);
            newPvs.putAll(this.inJmsPropVals);
            this.inJmsPropVals = newPvs;
        }
        Trc.exit();
    }

    public void setInputJmsPropertyValues(HashMap hm) {
        Trc.entry((Object)this, hm);
        this.inJmsPropVals = hm;
        Trc.exit();
    }

    public HashMap getInputJmsPropertyValues() {
        Trc.entry(this);
        Trc.exit(this.inJmsPropVals);
        return this.inJmsPropVals;
    }

    protected HashMap makeSomeKindOfJmsMap(List list) throws WSIFException {
        Trc.entry((Object)this, list);
        Map simpleTypeReg = WSIFUtils.getSimpleTypesMap();
        HashMap<String, String> props = new HashMap<String, String>(list.size());
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Object obj;
            String name2;
            block20: {
                Object ee = it.next();
                if (ee instanceof JMSProperty) {
                    JMSProperty prop = (JMSProperty)ee;
                    props.put(prop.getPart(), prop.getName());
                    continue;
                }
                if (!(ee instanceof JMSPropertyValue)) continue;
                JMSPropertyValue propVal = (JMSPropertyValue)ee;
                name2 = propVal.getName();
                if (name2 == null || name2.length() == 0) {
                    throw new WSIFException("jms:propertyValue found without a name");
                }
                QName type = propVal.getType();
                if (type == null) {
                    throw new WSIFException("jms:propertyValue " + name2 + " did not have a type");
                }
                if (type.getNamespaceURI() == null || type.getLocalPart() == null) {
                    throw new WSIFException("jms:propertyValue " + name2 + " has a badly formed type");
                }
                String value2 = propVal.getValue();
                if (value2 == null || value2.length() == 0) {
                    throw new WSIFException("jms:propertyValue " + name2 + " did not have a value");
                }
                String cls = (String)simpleTypeReg.get(type);
                if (cls == null) {
                    throw new WSIFException("jms:propertyValue " + name2 + " had a type that was " + "unknown or was not a simple type");
                }
                Class<?> javaClass = null;
                ClassNotFoundException classNotFound = null;
                try {
                    javaClass = Class.forName(cls, true, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException cce) {
                    Trc.exception(cce);
                    classNotFound = cce;
                }
                obj = null;
                try {
                    if ((class$java$lang$String == null ? WSIFDefaultOperation.class$("java.lang.String") : class$java$lang$String).equals(javaClass)) {
                        obj = value2;
                        break block20;
                    }
                    if ("int".equals(cls) || (class$java$lang$Integer == null ? WSIFDefaultOperation.class$("java.lang.Integer") : class$java$lang$Integer).equals(javaClass)) {
                        obj = new Integer(value2);
                        break block20;
                    }
                    if ("boolean".equals(cls) || (class$java$lang$Boolean == null ? WSIFDefaultOperation.class$("java.lang.Boolean") : class$java$lang$Boolean).equals(javaClass)) {
                        obj = new Boolean(value2);
                        break block20;
                    }
                    if ("byte".equals(cls) || (class$java$lang$Byte == null ? WSIFDefaultOperation.class$("java.lang.Byte") : class$java$lang$Byte).equals(javaClass)) {
                        obj = new Byte(value2);
                        break block20;
                    }
                    if ("double".equals(cls) || (class$java$lang$Double == null ? WSIFDefaultOperation.class$("java.lang.Double") : class$java$lang$Double).equals(javaClass)) {
                        obj = new Double(value2);
                        break block20;
                    }
                    if ("float".equals(cls) || (class$java$lang$Float == null ? WSIFDefaultOperation.class$("java.lang.Float") : class$java$lang$Float).equals(javaClass)) {
                        obj = new Float(value2);
                        break block20;
                    }
                    if ("long".equals(cls) || (class$java$lang$Long == null ? WSIFDefaultOperation.class$("java.lang.Long") : class$java$lang$Long).equals(javaClass)) {
                        obj = new Long(value2);
                        break block20;
                    }
                    if ("short".equals(cls) || (class$java$lang$Short == null ? WSIFDefaultOperation.class$("java.lang.Short") : class$java$lang$Short).equals(javaClass)) {
                        obj = new Short(value2);
                        break block20;
                    }
                    if (classNotFound != null) {
                        throw new WSIFException("Unexpected ClassNotFoundException when processing jms:propertyValue " + name2 + ". Could not convert the type to a java class. " + classNotFound);
                    }
                    throw new WSIFException("jms:propertyValue " + name2 + " had an invalid type");
                }
                catch (NumberFormatException nfe) {
                    Trc.exception(nfe);
                    throw new WSIFException("jms:propertyValue " + name2 + " a value that could not " + "be converted into the specified type. Caught NumberFormatException. " + nfe);
                }
            }
            props.put(name2, (String)obj);
        }
        Trc.exit(props);
        return props;
    }

    public void setContext(WSIFMessage context) {
        Trc.entry((Object)this, context);
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        this.context = context;
        Trc.exit();
    }

    public WSIFMessage getContext() throws WSIFException {
        WSIFMessage contextCopy;
        Trc.entry(this);
        try {
            contextCopy = this.context == null ? (WSIFMessage)this.getWSIFPort().getContext().clone() : (WSIFMessage)this.context.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new WSIFException("CloneNotSupportedException cloning context", e2);
        }
        Trc.exit(contextCopy);
        return contextCopy;
    }

    protected abstract Operation getOperation() throws Exception;

    protected void close() throws WSIFException {
        Trc.entry(this);
        if (this.closed) {
            throw new WSIFException("Cannot reuse a WSIFOperation to invoke multiple operations");
        }
        this.closed = true;
        Trc.exit();
    }
}

