/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.base;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.WSIFPort;
import org.apache.wsif.base.WSIFDefaultMessage;
import org.apache.wsif.logging.Trc;

public abstract class WSIFDefaultPort
implements WSIFPort {
    private static final long serialVersionUID = 1L;
    protected WSIFMessage context;

    public void close() throws WSIFException {
        Trc.entry(this);
        Trc.exit();
    }

    public void finalize() throws Throwable {
        Trc.entry(this);
        try {
            this.close();
        }
        catch (WSIFException ex) {
            Trc.ignoredException(ex);
        }
        super.finalize();
        Trc.exit();
    }

    protected String getKey(String name2, String inputName, String outputName) {
        Trc.entry(this, name2, inputName, outputName);
        String s = name2 + (inputName != null ? ":" + inputName : "") + (outputName != null ? ":" + outputName : "");
        Trc.exit(s);
        return s;
    }

    protected Object getExtElem(Object ctx, Class extType, List extElems) throws WSIFException {
        Trc.entry(this, ctx, extType, extElems);
        Object found = null;
        if (extElems != null) {
            Iterator i = extElems.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (!extType.isAssignableFrom(o.getClass())) continue;
                if (found != null) {
                    throw new WSIFException("duplicated extensibility element " + extType.getClass().getName() + " in " + ctx);
                }
                found = o;
            }
        }
        Trc.exit(found);
        return found;
    }

    protected List getExtElems(Object ctx, Class extType, List extElems) throws WSIFException {
        Trc.entry(this, ctx, extType, extElems);
        ArrayList found = new ArrayList();
        if (extElems != null) {
            Iterator i = extElems.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (!extType.isAssignableFrom(o.getClass())) continue;
                found.add(o);
            }
        }
        if (found.size() == 0) {
            return null;
        }
        Trc.exit(found);
        return found;
    }

    public boolean supportsSync() {
        Trc.entry(this);
        Trc.exit(true);
        return true;
    }

    public boolean supportsAsync() {
        Trc.entry(this);
        Trc.exit(false);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public WSIFMessage getContext() throws WSIFException {
        void var1_1;
        WSIFMessage contextCopy;
        Trc.entry(this);
        if (this.context == null) {
            contextCopy = new WSIFDefaultMessage();
        } else {
            try {
                contextCopy = (WSIFMessage)this.context.clone();
            }
            catch (CloneNotSupportedException e2) {
                throw new WSIFException("CloneNotSupportedException cloning context", e2);
            }
        }
        Trc.exit(var1_1);
        return var1_1;
    }

    public void setContext(WSIFMessage newContext) {
        Trc.entry((Object)this, newContext);
        if (newContext == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        this.context = newContext;
        Trc.exit(null);
    }
}

