/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.base;

import java.util.Hashtable;
import org.apache.wsif.logging.Trc;

public class WSIFServiceCache
extends Hashtable {
    static final int CUSHION_PERCENT = 10;
    LRUWrapper oldestObject = null;
    LRUWrapper newestObject = null;
    int cushionSize = 1;
    int cacheLimit = 0;
    int currentSize = 0;

    WSIFServiceCache(int size) {
        super(size);
        this.cacheLimit = size;
        this.cushionSize = this.cacheLimit * 10 / 100;
        if (this.cushionSize == 0) {
            this.cushionSize = 1;
        }
        Trc.event(this, "WSIFServiceCache created - cache limit:" + this.cacheLimit + " Cushion:" + this.cushionSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheSize(int newSize) {
        WSIFServiceCache wSIFServiceCache = this;
        synchronized (wSIFServiceCache) {
            this.cacheLimit = newSize;
            this.cushionSize = this.cacheLimit * 10 / 100;
        }
    }

    public Object put(Object key, Object value2) {
        LRUWrapper newObject = new LRUWrapper(key, value2);
        if (this.currentSize >= this.cacheLimit) {
            this.shrinkCache();
        }
        if (this.oldestObject == null) {
            this.oldestObject = newObject;
            this.newestObject = newObject;
        } else {
            this.addToTopOfLRUList(newObject);
        }
        newObject = super.put(key, newObject);
        ++this.currentSize;
        Trc.event(this, "WSIFServiceCache (put). Current cache size: " + this.currentSize);
        if (newObject == null) {
            return null;
        }
        return newObject.value;
    }

    public Object get(Object key) {
        LRUWrapper tempObject = (LRUWrapper)super.get(key);
        if (tempObject == null) {
            Trc.event(this, "WSIFServiceCache (get). No hit. Cache size: " + this.currentSize);
            return null;
        }
        Trc.event(this, "WSIFServiceCache (get). MATCH FOUND. Cache size: " + this.currentSize);
        if (this.newestObject != tempObject) {
            this.removeFromLRUList(tempObject);
            this.addToTopOfLRUList(tempObject);
        }
        return tempObject.value;
    }

    private void addToTopOfLRUList(LRUWrapper newObject) {
        this.newestObject.nextObject = newObject;
        newObject.prevObject = this.newestObject;
        this.newestObject = newObject;
    }

    private void removeFromLRUList(LRUWrapper oldObject) {
        if (oldObject != this.oldestObject) {
            oldObject.prevObject.nextObject = oldObject.nextObject;
            oldObject.nextObject.prevObject = oldObject.prevObject;
        } else {
            oldObject.nextObject.prevObject = null;
            this.oldestObject = oldObject.nextObject;
        }
    }

    private void shrinkCache() {
        LRUWrapper currentLRUWrapper = this.oldestObject;
        for (int i = 1; i <= this.cushionSize; ++i) {
            super.remove(currentLRUWrapper.key);
            currentLRUWrapper = currentLRUWrapper.nextObject;
        }
        this.oldestObject = currentLRUWrapper;
        this.currentSize -= this.cushionSize;
        Trc.event(this, "WSIFServiceCache (put). Cache size after shrinkage: " + this.currentSize);
    }

    class LRUWrapper {
        LRUWrapper nextObject = null;
        LRUWrapper prevObject = null;
        Object value = null;
        Object key = null;

        LRUWrapper(Object inKey, Object inValue) {
            this.value = inValue;
            this.key = inKey;
        }
    }
}

