/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.compiler.schema.tools;

import com.ibm.wsdl.util.xml.DOMUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.wsif.compiler.schema.SchemaException;
import org.apache.wsif.compiler.schema.tools.Conventions;
import org.apache.wsif.compiler.schema.tools.SchemaAttribute;
import org.apache.wsif.compiler.schema.tools.SchemaComplexType;
import org.apache.wsif.compiler.schema.tools.SchemaElement;
import org.apache.wsif.compiler.schema.tools.SchemaSimpleType;
import org.apache.wsif.compiler.schema.tools.SchemaType;
import org.apache.wsif.compiler.util.TypeMapping;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Schema2JROM {
    private HashMap registry = new HashMap();
    private HashMap namespaceRegistry = new HashMap();
    private HashMap undefinedRegistry = new HashMap();
    private Vector schemaElementList = new Vector();
    private String packageName = "";
    private boolean verbose = true;
    private boolean overwrite = false;
    private boolean javac = true;

    public Schema2JROM(String schemaURI) {
        this.registry.put(new QName(schemaURI, "string"), "com.ibm.jrom.JROMStringValue");
        this.registry.put(new QName(schemaURI, "float"), "com.ibm.jrom.JROMFloatValue");
        this.registry.put(new QName(schemaURI, "double"), "com.ibm.jrom.JROMDoubleValue");
        this.registry.put(new QName(schemaURI, "integer"), "com.ibm.jrom.JROMIntegerValue");
        this.registry.put(new QName(schemaURI, "int"), "com.ibm.jrom.JROMIntegerValue");
        this.registry.put(new QName(schemaURI, "boolean"), "com.ibm.jrom.JROMBooleanValue");
        this.registry.put(new QName(schemaURI, "byte"), "com.ibm.jrom.JROMByteValue");
        this.registry.put(new QName(schemaURI, "short"), "com.ibm.jrom.JROMShortValue");
        this.registry.put(new QName(schemaURI, "long"), "com.ibm.jrom.JROMLongValue");
        this.registry.put(new QName(schemaURI, "decimal"), "com.ibm.jrom.JROMDecimalValue");
        this.registry.put(new QName(schemaURI, "QName"), "com.ibm.jrom.JROMQNameValue");
        this.registry.put(new QName(schemaURI, "date"), "com.ibm.jrom.JROMDateValue");
        if (schemaURI.equals("http://www.w3.org/2001/XMLSchema")) {
            this.registry.put(new QName(schemaURI, "dateTime"), "com.ibm.jrom.JROMTimeValue");
        } else {
            this.registry.put(new QName(schemaURI, "timeInstant"), "com.ibm.jrom.JROMTimeValue");
        }
        this.registry.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "string"), "com.ibm.jrom.JROMStringValue");
        this.registry.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "float"), "com.ibm.jrom.JROMFloatValue");
        this.registry.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "double"), "com.ibm.jrom.JROMDoubleValue");
        this.registry.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "integer"), "com.ibm.jrom.JROMIntegerValue");
        this.registry.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "int"), "com.ibm.jrom.JROMIntegerValue");
        this.registry.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "boolean"), "com.ibm.jrom.JROMBooleanValue");
        this.registry.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "byte"), "com.ibm.jrom.JROMByteValue");
        this.registry.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "short"), "com.ibm.jrom.JROMShortValue");
        this.registry.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "long"), "com.ibm.jrom.JROMLongValue");
        this.registry.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "decimal"), "com.ibm.jrom.JROMDecimalValue");
        this.registry.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "base64"), "com.ibm.jrom.JROMBase64BinaryValue");
        this.registry.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "QName"), "com.ibm.jrom.JROMQNameValue");
        this.registry.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "date"), "com.ibm.jrom.JROMDateValue");
        if (schemaURI.equals("http://www.w3.org/2001/XMLSchema")) {
            this.registry.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "dateTime"), "com.ibm.jrom.JROMTimeValue");
        } else {
            this.registry.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "timeInstant"), "com.ibm.jrom.JROMTimeValue");
        }
        this.registry.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "Array"), "com.ibm.jrom.JROMComplexValue");
    }

    public Map createJROMMapping(Element root, Map reg) throws SchemaException {
        if (root == null || reg == null) {
            throw new IllegalArgumentException("Argument to 'createJROMMapping' cannot be null.");
        }
        String targetURI = root.getAttribute("targetNamespace");
        Vector elements = this.parseSchemaRoot(root, targetURI);
        for (int i = 0; i < elements.size(); ++i) {
            this.schemaElementList.addElement(elements.elementAt(i));
        }
        this.updateRegistry(this.schemaElementList);
        return this.getRegistry(reg);
    }

    private QName getAttributeQName(Element element, String attr) {
        if (element == null || attr == null) {
            throw new IllegalArgumentException("Argument to 'getAttrQName' cannot be null.");
        }
        String name2 = DOMUtils.getAttribute(element, attr);
        if (name2 == null) {
            return null;
        }
        int index = name2.lastIndexOf(":");
        String prefix = null;
        if (index != -1) {
            prefix = name2.substring(0, index);
            name2 = name2.substring(index + 1);
        }
        String uri = DOMUtils.getNamespaceURIFromPrefix(element, prefix);
        return new QName(uri, name2);
    }

    public String getNamespaceURIMapping(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("Argument to 'getNamespaceURIMapping' cannot be null.");
        }
        if (namespaceURI.compareTo("") == 0) {
            return "";
        }
        if (this.packageName != null && !this.packageName.equals("")) {
            return this.packageName;
        }
        String javaPath = (String)this.namespaceRegistry.get(namespaceURI);
        if (javaPath == null) {
            javaPath = Conventions.namespaceURI2JavaPath(namespaceURI);
            this.namespaceRegistry.put(namespaceURI, javaPath);
        }
        return javaPath;
    }

    public Map getRegistry(Map reg) {
        Iterator it = this.registry.keySet().iterator();
        while (it.hasNext()) {
            QName key = (QName)it.next();
            reg.put(key, new TypeMapping(key, (String)this.registry.get(key)));
        }
        return reg;
    }

    private Vector parseSchemaRoot(Element root, String targetURI) throws SchemaException {
        if (root == null) {
            throw new IllegalArgumentException("Argument to 'parseSchemaRoot' cannot be null.");
        }
        Vector<SchemaType> elements = new Vector<SchemaType>();
        for (Node child2 = root.getFirstChild(); child2 != null; child2 = child2.getNextSibling()) {
            if (child2.getNodeType() != 1) continue;
            Element element = (Element)child2;
            String elementType = element.getLocalName();
            if (elementType == null) {
                return null;
            }
            String name2 = DOMUtils.getAttribute(element, "name");
            QName type = this.getAttributeQName(element, "type");
            boolean isArray = false;
            if (elementType.equals("complexType")) {
                boolean isFinal = false;
                boolean isAbstract = false;
                QName base = null;
                Vector children = this.parseSchemaRoot(element, targetURI);
                elements.addElement(new SchemaComplexType(name2, base, isAbstract, isFinal, children, targetURI));
                continue;
            }
            if (elementType.equals("element")) {
                QName ref = null;
                elements.addElement(new SchemaElement(name2, ref, type, isArray, null, targetURI));
                continue;
            }
            return this.parseSchemaRoot(element, targetURI);
        }
        return elements;
    }

    public void setNamespaceURIMapping(String namespaceURI, String javaPath) {
        if (namespaceURI == null || javaPath == null) {
            throw new IllegalArgumentException("Argument to 'setNamespaceURIMapping' cannot be null.");
        }
        this.namespaceRegistry.put(namespaceURI, javaPath);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    private void updateRegistry(Vector elements) throws SchemaException {
        QName qName;
        SchemaType element;
        int i;
        if (elements == null) {
            throw new IllegalArgumentException("Argument to 'updateRegistry' cannot be null.");
        }
        HashMap<QName, SchemaType> simpleTypeTable = new HashMap<QName, SchemaType>();
        for (int i2 = 0; i2 < elements.size(); ++i2) {
            SchemaType element2 = (SchemaType)elements.elementAt(i2);
            String name2 = element2.getName();
            if (name2 == null) {
                name2 = "";
            }
            QName qName2 = new QName(element2.getTargetURI(), name2);
            if (element2.getElementType() != 1) continue;
            simpleTypeTable.put(qName2, element2);
        }
        boolean changed = true;
        while (changed) {
            changed = false;
            Iterator it = simpleTypeTable.keySet().iterator();
            while (it.hasNext()) {
                QName qName3 = (QName)it.next();
                SchemaSimpleType simpleType = (SchemaSimpleType)simpleTypeTable.get(qName3);
                QName base = simpleType.getBase();
                boolean isList = simpleType.isList();
                if (base != null) {
                    String javaType = (String)this.registry.get(base);
                    if (javaType == null) {
                        if (simpleTypeTable.containsKey(base)) continue;
                        javaType = "com.ibm.jrom.JROMComplexValue";
                    }
                    if (isList) {
                        javaType = javaType + "[]";
                    }
                    this.registry.put(qName3, javaType);
                    changed = true;
                    simpleTypeTable.remove(qName3);
                    continue;
                }
                throw new SchemaException("'simpleType' must have 'base' attribute.");
            }
        }
        Iterator it2 = simpleTypeTable.keySet().iterator();
        while (it2.hasNext()) {
            if (this.registry.containsKey((QName)it2.next())) continue;
            throw new SchemaException("'simpleType' definitions have cyclic dependency.");
        }
        block13: for (i = 0; i < elements.size(); ++i) {
            String name3;
            element = (SchemaType)elements.elementAt(i);
            String targetURI = element.getTargetURI();
            String targetNSPrefix = this.getNamespaceURIMapping(targetURI);
            if (targetNSPrefix.compareTo("") != 0) {
                targetNSPrefix = targetNSPrefix + ".";
            }
            if ((name3 = element.getName()) == null) {
                name3 = "";
            }
            qName = new QName(targetURI, name3);
            switch (element.getElementType()) {
                case 0: {
                    this.registry.put(qName, "com.ibm.jrom.JROMComplexValue");
                    continue block13;
                }
                case 5: {
                    this.registry.put(qName, "com.ibm.jrom.JROMComplexValue");
                    continue block13;
                }
                case 4: {
                    this.registry.put(qName, "com.ibm.jrom.JROMComplexValue");
                }
            }
        }
        block14: for (i = 0; i < elements.size(); ++i) {
            element = (SchemaType)elements.elementAt(i);
            String name4 = element.getName();
            String targetURI = element.getTargetURI();
            String targetNSPrefix = this.getNamespaceURIMapping(targetURI);
            if (targetNSPrefix.compareTo("") != 0) {
                targetNSPrefix = targetNSPrefix + ".";
            }
            if (name4 == null) {
                name4 = "";
            }
            qName = new QName(targetURI, name4);
            switch (element.getElementType()) {
                case 2: {
                    SchemaElement schemaElement = (SchemaElement)element;
                    QName type = schemaElement.getType();
                    SchemaType child2 = schemaElement.getChild();
                    if (type != null) {
                        String javaType = (String)this.registry.get(type);
                        if (javaType == null) continue block14;
                        this.registry.put(qName, javaType);
                        continue block14;
                    }
                    if (child2 == null) continue block14;
                    if (child2.getElementType() == 1) {
                        QName base = ((SchemaSimpleType)child2).getBase();
                        String javaType = (String)this.registry.get(base);
                        if (javaType == null) continue block14;
                        if (((SchemaSimpleType)child2).isList()) {
                            javaType = javaType + "[]";
                        }
                        this.registry.put(qName, javaType);
                        continue block14;
                    }
                    if (child2.getElementType() != 0) continue block14;
                    this.registry.put(qName, "com.ibm.jrom.JROMComplexValue");
                    continue block14;
                }
                case 3: {
                    QName base;
                    String javaType;
                    SchemaAttribute schemaAttribute = (SchemaAttribute)element;
                    QName type = schemaAttribute.getType();
                    SchemaSimpleType simpleType = schemaAttribute.getChild();
                    if (type != null) {
                        String javaType2 = (String)this.registry.get(type);
                        if (javaType2 == null) continue block14;
                        this.registry.put(qName, javaType2);
                        continue block14;
                    }
                    if (simpleType == null || (javaType = (String)this.registry.get(base = simpleType.getBase())) == null) continue block14;
                    if (simpleType.isList()) {
                        javaType = javaType + "[]";
                    }
                    this.registry.put(qName, javaType);
                }
            }
        }
    }
}

