/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.compiler.util;

import com.ibm.wsdl.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Types;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.xml.namespace.QName;
import org.apache.wsif.WSIFException;
import org.apache.wsif.compiler.util.TypeMapping;

public class Utils {
    public static void addAllTypesElements(Definition def, List toList) {
        Map imports;
        Types types = def.getTypes();
        if (types != null) {
            Iterator extEleIt = types.getExtensibilityElements().iterator();
            while (extEleIt.hasNext()) {
                UnknownExtensibilityElement typesElement = (UnknownExtensibilityElement)extEleIt.next();
                toList.add(typesElement);
            }
        }
        if ((imports = def.getImports()) != null) {
            Iterator valueIterator = imports.values().iterator();
            while (valueIterator.hasNext()) {
                List importList = (List)valueIterator.next();
                if (importList == null) continue;
                Iterator importIterator = importList.iterator();
                while (importIterator.hasNext()) {
                    Definition importedDef;
                    Import tempImport = (Import)importIterator.next();
                    if (tempImport == null || (importedDef = tempImport.getDefinition()) == null) continue;
                    Utils.addAllTypesElements(importedDef, toList);
                }
            }
        }
    }

    public static List getAllTypesElements(Definition def) {
        Vector ret = new Vector();
        Utils.addAllTypesElements(def, ret);
        return ret;
    }

    public static String getPackageName(String fqClassName) {
        int index;
        String packageName = "";
        if (fqClassName != null && (index = fqClassName.lastIndexOf(46)) != -1) {
            packageName = fqClassName.substring(0, index);
        }
        return packageName;
    }

    public static String getClassName(String fqClassName) {
        int index;
        if (fqClassName != null && (index = fqClassName.lastIndexOf(46)) != -1) {
            fqClassName = fqClassName.substring(index + 1);
        }
        return fqClassName;
    }

    public static String queryJavaTypeName(QName type, String encodingStyleURI, Hashtable typeReg) throws IllegalArgumentException {
        TypeMapping tm = (TypeMapping)typeReg.get(type);
        if (tm != null) {
            return tm.javaType;
        }
        if (encodingStyleURI != null && encodingStyleURI.equals("http://xml.apache.org/xml-soap/literalxml")) {
            return "org.w3c.dom.Element";
        }
        throw new IllegalArgumentException("No mapping was found for '" + type + "'.");
    }

    public static String getQuotedString(Reader source, int indent) throws WSIFException {
        char[] indentArray = new char[indent];
        Arrays.fill(indentArray, ' ');
        String indentStr = new String(indentArray);
        try {
            BufferedReader br = new BufferedReader(source);
            StringWriter sw = new StringWriter();
            int count = 0;
            String tempLine = null;
            while ((tempLine = br.readLine()) != null) {
                sw.write((count > 0 ? " + \"" + StringUtils.lineSeparatorStr + "\" +" + StringUtils.lineSeparator : "") + indentStr + '\"' + StringUtils.cleanString(tempLine) + '\"');
                ++count;
            }
            return sw.toString();
        }
        catch (IOException e2) {
            throw new WSIFException("Problem writing strings.", e2);
        }
    }

    public static String convertToObject(String sourceClassName, String expr) throws WSIFException {
        return Utils.convertClass(sourceClassName, expr, "java.lang.Object");
    }

    public static String convertFromObject(String expr, String targetClassName) throws WSIFException {
        return Utils.convertClass("java.lang.Object", expr, targetClassName);
    }

    private static String convertClass(String sourceClassName, String expr, String targetClassName) throws WSIFException {
        if (sourceClassName == null || targetClassName == null) {
            throw new WSIFException("I was unable to convert an object from " + sourceClassName + " to " + targetClassName + ".");
        }
        String shortTargetClassName = Utils.getShortName(targetClassName);
        if (sourceClassName.equals("java.lang.Object")) {
            if (Utils.isPrimitive(targetClassName)) {
                return "((" + Utils.getWrapperClassName(targetClassName) + ")" + expr + ")." + shortTargetClassName + "Value()";
            }
            return "(" + targetClassName + ")" + expr;
        }
        if (Utils.isPrimitive(sourceClassName) && targetClassName.equals("java.lang.Object")) {
            return "new " + Utils.getWrapperClassName(sourceClassName) + "(" + expr + ")";
        }
        return expr;
    }

    private static String getShortName(String className) {
        if (className.startsWith("java.lang.")) {
            return className.substring(10);
        }
        return className;
    }

    private static String getWrapperClassName(String primitiveClassName) {
        if (primitiveClassName.equals("int")) {
            return "Integer";
        }
        if (primitiveClassName.equals("char")) {
            return "Character";
        }
        return Utils.getCapitalized(primitiveClassName);
    }

    private static String getCapitalized(String className) {
        return Character.toUpperCase(className.charAt(0)) + className.substring(1);
    }

    private static boolean isPrimitive(String className) {
        String[] primNames = new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double", "void"};
        for (int i = 0; i < primNames.length; ++i) {
            if (!primNames[i].equals(className)) continue;
            return true;
        }
        return false;
    }
}

