/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.mapping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.mapping.MappingHelper;
import org.apache.wsif.mapping.WSIFDefaultMappingConvention;
import org.apache.wsif.mapping.WSIFMapper;
import org.apache.wsif.mapping.WSIFMappingConvention;
import org.apache.wsif.schema.ComplexType;
import org.apache.wsif.schema.ElementType;
import org.apache.wsif.schema.SchemaType;
import org.apache.wsif.schema.SimpleType;

public class WSIFDefaultMapper
implements WSIFMapper {
    private boolean includeStandardMappings = false;
    private WSIFMappingConvention convention = new WSIFDefaultMappingConvention();
    private Hashtable typeMappings = new Hashtable();

    public boolean getIncludeStandardMappings() {
        return this.includeStandardMappings;
    }

    public void setIncludeStandardMappings(boolean b) {
        this.includeStandardMappings = b;
    }

    public WSIFMappingConvention getMappingConvention() {
        return this.convention;
    }

    public void setMappingConvention(WSIFMappingConvention con) {
        this.convention = con;
    }

    public void overrideTypeMapping(QName xmlName, String className) {
        if (className != null && xmlName != null) {
            this.typeMappings.put(xmlName, className);
        }
    }

    public Map getMappings(SchemaType[] types) {
        String extraDims;
        Trc.entry((Object)this, types);
        HashMap<QName, String> table = new HashMap<QName, String>();
        if (types == null) {
            Trc.exit(table);
            return table;
        }
        HashMap standards = null;
        if (this.includeStandardMappings) {
            MappingHelper.populateWithStandardXMLJavaMappings(table, "http://www.w3.org/1999/XMLSchema", true);
            MappingHelper.populateWithStandardXMLJavaMappings(table, "http://www.w3.org/2000/10/XMLSchema", false);
            MappingHelper.populateWithStandardXMLJavaMappings(table, "http://www.w3.org/2001/XMLSchema", false);
        } else {
            standards = new HashMap();
            MappingHelper.populateWithStandardXMLJavaMappings(standards, "http://www.w3.org/1999/XMLSchema", true);
            MappingHelper.populateWithStandardXMLJavaMappings(standards, "http://www.w3.org/2000/10/XMLSchema", false);
            MappingHelper.populateWithStandardXMLJavaMappings(standards, "http://www.w3.org/2001/XMLSchema", false);
        }
        ArrayList<SchemaType> arrays = new ArrayList<SchemaType>();
        ArrayList<SchemaType> elements = new ArrayList<SchemaType>();
        for (int i = 0; i < types.length; ++i) {
            QName typeName;
            SchemaType st = types[i];
            if (st == null || (typeName = st.getTypeName()) == null) continue;
            if (st.isArray()) {
                arrays.add(st);
                continue;
            }
            if (st instanceof ElementType) {
                QName baseType = ((ElementType)st).getElementType();
                if (baseType != null) {
                    String wrapperClass;
                    if (((ElementType)st).isNillable() && (wrapperClass = this.getWrapperClassName(baseType)) != null) {
                        table.put(typeName, wrapperClass);
                        continue;
                    }
                    String baseClassName = (String)this.typeMappings.get(baseType);
                    if (baseClassName == null) {
                        baseClassName = (String)table.get(baseType);
                    }
                    if (baseClassName == null && !this.includeStandardMappings) {
                        baseClassName = (String)standards.get(baseType);
                    }
                    if (baseClassName != null) {
                        table.put(typeName, baseClassName);
                        continue;
                    }
                    elements.add(st);
                    continue;
                }
                String className = this.convention.getClassNameForElementType(typeName);
                if (className == null) continue;
                table.put(typeName, className);
                continue;
            }
            String className = null;
            if (st instanceof ComplexType) {
                className = this.convention.getClassNameForComplexType(typeName);
            } else if (st instanceof SimpleType) {
                className = this.convention.getClassNameForSimpleType(typeName);
            }
            if (className == null) continue;
            table.put(typeName, className);
        }
        ArrayList<SchemaType> multiArrays = new ArrayList<SchemaType>();
        Iterator ai = arrays.iterator();
        while (ai.hasNext()) {
            QName arrayType;
            SchemaType st = (SchemaType)ai.next();
            QName theType = st.getTypeName();
            if (theType == null || (arrayType = st.getArrayType()) == null || theType == null) continue;
            String baseClass = (String)this.typeMappings.get(arrayType);
            if (baseClass == null) {
                baseClass = (String)table.get(arrayType);
            }
            if (baseClass == null && standards != null) {
                baseClass = (String)standards.get(arrayType);
            }
            if (baseClass == null) {
                String lp = arrayType.getLocalPart();
                if (lp == null || !lp.startsWith("ArrayOf")) continue;
                multiArrays.add(st);
                continue;
            }
            extraDims = "";
            for (int x = 1; x < st.getArrayDimension(); ++x) {
                extraDims = extraDims + "[";
            }
            if (baseClass == null) continue;
            if (baseClass.equals("int")) {
                table.put(theType, extraDims + "[I");
                continue;
            }
            if (baseClass.equals("float")) {
                table.put(theType, extraDims + "[F");
                continue;
            }
            if (baseClass.equals("long")) {
                table.put(theType, extraDims + "[J");
                continue;
            }
            if (baseClass.equals("double")) {
                table.put(theType, extraDims + "[D");
                continue;
            }
            if (baseClass.equals("boolean")) {
                table.put(theType, extraDims + "[Z");
                continue;
            }
            if (baseClass.equals("byte")) {
                table.put(theType, extraDims + "[B");
                continue;
            }
            if (baseClass.equals("short")) {
                table.put(theType, extraDims + "[S");
                continue;
            }
            if (baseClass.startsWith("[")) {
                String arrayOfBase = "[" + baseClass;
                table.put(theType, arrayOfBase);
                continue;
            }
            String arrayOfBase = extraDims + "[L" + baseClass + ";";
            table.put(theType, arrayOfBase);
        }
        Iterator mi = multiArrays.iterator();
        while (mi.hasNext()) {
            QName arrayType;
            SchemaType st = (SchemaType)mi.next();
            QName theType = st.getTypeName();
            if (theType == null || (arrayType = st.getArrayType()) == null || theType == null) continue;
            extraDims = "";
            for (int x = 1; x < st.getArrayDimension(); ++x) {
                extraDims = extraDims + "[";
            }
            String baseClass = (String)this.typeMappings.get(arrayType);
            if (baseClass == null) {
                baseClass = (String)table.get(arrayType);
            }
            if (baseClass == null || !baseClass.startsWith("[")) continue;
            String arrayOfBase = "[" + baseClass;
            table.put(theType, arrayOfBase);
        }
        Iterator ei = elements.iterator();
        while (ei.hasNext()) {
            SchemaType st = (SchemaType)ei.next();
            QName theType = st.getTypeName();
            if (theType == null) continue;
            QName baseType = null;
            if (st instanceof ElementType) {
                baseType = ((ElementType)st).getElementType();
            }
            if (baseType == null) continue;
            String baseClassName = (String)this.typeMappings.get(baseType);
            if (baseClassName == null) {
                baseClassName = (String)table.get(baseType);
            }
            if (baseClassName == null) continue;
            table.put(theType, baseClassName);
        }
        table.putAll(this.typeMappings);
        Trc.exit(table);
        return table;
    }

    protected String getWrapperClassName(QName qn) {
        if (qn == null) {
            return null;
        }
        String ns = qn.getNamespaceURI();
        if ("http://www.w3.org/1999/XMLSchema".equals(ns) || "http://www.w3.org/2000/10/XMLSchema".equals(ns) || "http://www.w3.org/2001/XMLSchema".equals(ns)) {
            String lp = qn.getLocalPart();
            if (lp == null) {
                return null;
            }
            if (lp.equals("int")) {
                return "java.lang.Integer";
            }
            if (lp.equals("long")) {
                return "java.lang.Long";
            }
            if (lp.equals("float")) {
                return "java.lang.Float";
            }
            if (lp.equals("short")) {
                return "java.lang.Short";
            }
            if (lp.equals("double")) {
                return "java.lang.Double";
            }
            if (lp.equals("boolean")) {
                return "java.lang.Boolean";
            }
            if (lp.equals("byte")) {
                return "java.lang.Byte";
            }
        }
        return null;
    }
}

