/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.mapping;

import org.apache.wsif.WSIFException;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.mapping.WSIFMapper;
import org.apache.wsif.util.WSIFProperties;

public class WSIFMapperFactory {
    private static final String DEFAULT_MAPPER_CLASS = "org.apache.wsif.mapping.WSIFDefaultMapper";
    private static StringBuffer mapperClassNameBuffer = new StringBuffer();

    public static WSIFMapper newMapper() throws WSIFException {
        return WSIFMapperFactory.newMapper(false);
    }

    public static WSIFMapper newMapper(boolean refresh) throws WSIFException {
        StringBuffer stringBuffer = mapperClassNameBuffer;
        synchronized (stringBuffer) {
            if (mapperClassNameBuffer.length() == 0 || refresh) {
                String mapperClassName = null;
                try {
                    mapperClassName = System.getProperty("org.apache.wsif.mapper");
                }
                catch (SecurityException s) {
                    Trc.ignoredException(s);
                }
                if (mapperClassName == null) {
                    mapperClassName = WSIFProperties.getProperty("org.apache.wsif.mapper");
                }
                if (mapperClassName == null) {
                    mapperClassName = DEFAULT_MAPPER_CLASS;
                }
                if (refresh) {
                    mapperClassNameBuffer.delete(0, mapperClassNameBuffer.length());
                }
                mapperClassNameBuffer.insert(0, mapperClassName);
            }
            try {
                Class<?> c = Class.forName(mapperClassNameBuffer.toString(), true, Thread.currentThread().getContextClassLoader());
                return (WSIFMapper)c.newInstance();
            }
            catch (ClassNotFoundException cnf) {
                throw new WSIFException("Unable to create new mapper", cnf);
            }
            catch (Exception e2) {
                throw new WSIFException("Unable to create new mapper", e2);
            }
        }
    }

    public static WSIFMapper newMapper(String mapperClassName) throws WSIFException {
        try {
            Class<?> c = Class.forName(mapperClassName, true, Thread.currentThread().getContextClassLoader());
            return (WSIFMapper)c.newInstance();
        }
        catch (ClassNotFoundException cnf) {
            throw new WSIFException("Unable to create new mapper", cnf);
        }
        catch (Exception e2) {
            throw new WSIFException("Unable to create new mapper", e2);
        }
    }
}

