/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.mapping;

import org.apache.wsif.WSIFException;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.mapping.WSIFMappingConvention;
import org.apache.wsif.util.WSIFProperties;

public class WSIFMappingConventionFactory {
    private static final String DEFAULT_MAPPINGCONVENTION_CLASS = "org.apache.wsif.mapping.WSIFDefaultMappingConvention";
    private static StringBuffer mappingConvClassNameBuffer = new StringBuffer();

    public static WSIFMappingConvention newMappingConvention() throws WSIFException {
        return WSIFMappingConventionFactory.newMappingConvention(false);
    }

    public static WSIFMappingConvention newMappingConvention(boolean refresh) throws WSIFException {
        StringBuffer stringBuffer = mappingConvClassNameBuffer;
        synchronized (stringBuffer) {
            if (mappingConvClassNameBuffer.length() == 0 || refresh) {
                String mappingConvClassName = null;
                try {
                    mappingConvClassName = System.getProperty("org.apache.wsif.mappingconvention");
                }
                catch (SecurityException s) {
                    Trc.ignoredException(s);
                }
                if (mappingConvClassName == null) {
                    mappingConvClassName = WSIFProperties.getProperty("org.apache.wsif.mappingconvention");
                }
                if (mappingConvClassName == null) {
                    mappingConvClassName = DEFAULT_MAPPINGCONVENTION_CLASS;
                }
                if (refresh) {
                    mappingConvClassNameBuffer.delete(0, mappingConvClassNameBuffer.length());
                }
                mappingConvClassNameBuffer.insert(0, mappingConvClassName);
            }
            try {
                Class<?> c = Class.forName(mappingConvClassNameBuffer.toString(), true, Thread.currentThread().getContextClassLoader());
                return (WSIFMappingConvention)c.newInstance();
            }
            catch (ClassNotFoundException cnf) {
                throw new WSIFException("Unable to create new mapping convention", cnf);
            }
            catch (Exception e2) {
                throw new WSIFException("Unable to create new mapping convention", e2);
            }
        }
    }

    public static WSIFMappingConvention newMappingConvention(String mappingConvClassName) throws WSIFException {
        try {
            Class<?> c = Class.forName(mappingConvClassName, true, Thread.currentThread().getContextClassLoader());
            return (WSIFMappingConvention)c.newInstance();
        }
        catch (ClassNotFoundException cnf) {
            throw new WSIFException("Unable to create new mapping convention", cnf);
        }
        catch (Exception e2) {
            throw new WSIFException("Unable to create new mapping convention", e2);
        }
    }
}

