/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.naming;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.wsif.WSIFService;
import org.apache.wsif.WSIFServiceFactory;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.naming.WSIFServiceRef;
import org.apache.wsif.naming.WSIFServiceStubRef;

public class WSIFServiceObjectFactory
implements ObjectFactory {
    public WSIFServiceObjectFactory() {
        Trc.entry(this);
        Trc.exit();
    }

    public Object getObjectInstance(Object obj, Name name2, Context context, Hashtable env) throws Exception {
        Trc.entry(this, obj, name2, context, env);
        if (obj instanceof Reference && obj != null) {
            Reference ref = (Reference)obj;
            if (ref.getClassName().equals(WSIFServiceRef.class.getName())) {
                String wsdlLoc = this.resolveString(ref.get("wsdlLoc"));
                String serviceNS = this.resolveString(ref.get("serviceNS"));
                String serviceName = this.resolveString(ref.get("serviceName"));
                String portTypeNS = this.resolveString(ref.get("portTypeNS"));
                String portTypeName = this.resolveString(ref.get("portTypeName"));
                if (wsdlLoc != null) {
                    WSIFServiceFactory factory = WSIFServiceFactory.newInstance();
                    WSIFService service = factory.getService(wsdlLoc, serviceNS, serviceName, portTypeNS, portTypeName);
                    Trc.exit(service);
                    return service;
                }
            } else if (ref.getClassName().equals(WSIFServiceStubRef.class.getName())) {
                String wsdlLoc = this.resolveString(ref.get("wsdlLoc"));
                String serviceNS = this.resolveString(ref.get("serviceNS"));
                String serviceName = this.resolveString(ref.get("serviceName"));
                String portTypeNS = this.resolveString(ref.get("portTypeNS"));
                String portTypeName = this.resolveString(ref.get("portTypeName"));
                String preferredPort = this.resolveString(ref.get("preferredPort"));
                String className = this.resolveString(ref.get("className"));
                if (wsdlLoc != null) {
                    WSIFServiceFactory factory = WSIFServiceFactory.newInstance();
                    WSIFService service = factory.getService(wsdlLoc, serviceNS, serviceName, portTypeNS, portTypeName);
                    Class<?> iface = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
                    Object stub = service.getStub(preferredPort, iface);
                    Trc.exit(stub);
                    return stub;
                }
            }
        }
        Trc.exit();
        return null;
    }

    private String resolveString(RefAddr a) {
        String e2 = "";
        String s = (String)a.getContent();
        return e2.equals(s) ? null : s;
    }
}

