/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.BindingOperation;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.extensions.ExtensibilityElement;
import org.apache.wsif.WSIFCorrelationId;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.WSIFOperation;
import org.apache.wsif.WSIFResponseHandler;
import org.apache.wsif.attachments.WSIFAttachmentPart;
import org.apache.wsif.base.WSIFDefaultMessage;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.InvocationHelper;
import org.apache.wsif.providers.ModelWSIFPort;
import org.apache.wsif.providers.Part;
import org.apache.wsif.providers.ProviderUtils;

public abstract class ModelWSIFOperation
implements WSIFOperation {
    protected ModelWSIFPort wsifPort;
    protected BindingOperation bindingOperation;
    protected Operation portTypeOperation;
    protected List inputParts;
    protected List outputParts;
    protected WSIFResponseHandler asyncResponseHandler;
    protected WSIFMessage context;
    protected boolean used;

    public ModelWSIFOperation(ModelWSIFPort wsifPort, BindingOperation bindingOperation) throws WSIFException {
        this.wsifPort = wsifPort;
        this.bindingOperation = bindingOperation;
    }

    public void executeInputOnlyOperation(WSIFMessage inMsg) throws WSIFException {
        Trc.entry((Object)this, inMsg);
        this.markAsUsed();
        if (inMsg == null) {
            throw new IllegalArgumentException("input message is null");
        }
        this.invokeInputOnlyOperation(inMsg);
        Trc.exit();
    }

    public boolean executeRequestResponseOperation(WSIFMessage inMsg, WSIFMessage outMsg, WSIFMessage faultMsg) throws WSIFException {
        Trc.entry(this, inMsg, outMsg, faultMsg);
        this.markAsUsed();
        if (!this.wsifPort.supportsSync()) {
            throw new WSIFException("synchronus operations not supported");
        }
        if (inMsg == null) {
            throw new IllegalArgumentException("input message is null");
        }
        if (outMsg == null) {
            throw new IllegalArgumentException("output message is null");
        }
        if (faultMsg == null) {
            throw new IllegalArgumentException("fault message is null");
        }
        boolean ok = this.invokeRequestResponseOperation(inMsg, outMsg, faultMsg);
        Trc.exit(ok);
        return ok;
    }

    public WSIFCorrelationId executeRequestResponseAsync(WSIFMessage inMsg) throws WSIFException {
        Trc.entry((Object)this, inMsg);
        this.markAsUsed();
        if (!this.wsifPort.supportsAsync()) {
            throw new WSIFException("asynchronous operations not supportted");
        }
        if (inMsg == null) {
            throw new IllegalArgumentException("input message is null");
        }
        WSIFCorrelationId cid = this.invokeRequestResponseAsync(inMsg, null);
        Trc.exit(cid);
        return cid;
    }

    public WSIFCorrelationId executeRequestResponseAsync(WSIFMessage inMsg, WSIFResponseHandler handler2) throws WSIFException {
        Trc.entry(this, inMsg, handler2);
        this.markAsUsed();
        if (!this.wsifPort.supportsAsync()) {
            throw new WSIFException("asynchronous operations not supportted");
        }
        if (inMsg == null) {
            throw new IllegalArgumentException("input message is null");
        }
        if (handler2 == null) {
            throw new IllegalArgumentException("WSIFResponseHandler is null");
        }
        WSIFCorrelationId cid = this.invokeRequestResponseAsync(inMsg, handler2);
        Trc.exit(cid);
        return cid;
    }

    public void fireAsyncResponse(Object response) throws WSIFException {
        Trc.entry((Object)this, response);
        if (!this.wsifPort.supportsAsync()) {
            throw new WSIFException("asynchronous operations not supportted");
        }
        if (this.asyncResponseHandler == null) {
            throw new WSIFException("asyncResponseHandler is null!");
        }
        Map results = this.doDeserialiseResponse(response);
        WSIFMessage outMsg = this.createOutputMessage();
        WSIFMessage faultMsg = this.createFaultMessage();
        this.buildResponseMessages(results, outMsg, faultMsg);
        this.asyncResponseHandler.executeAsyncResponse(outMsg, faultMsg);
        Trc.exit();
    }

    public boolean processAsyncResponse(Object response, WSIFMessage outMsg, WSIFMessage faultMsg) throws WSIFException {
        Trc.entry(this, response, outMsg, faultMsg);
        Trc.exit();
        throw new WSIFException("not implemented yet");
    }

    protected boolean invokeRequestResponseOperation(WSIFMessage inMsg, WSIFMessage outMsg, WSIFMessage faultMsg) throws WSIFException {
        boolean invokedOK = false;
        this.setPartValues(this.inputParts, inMsg);
        List inputArgs = this.getInputArguments();
        ArrayList responseValues = new ArrayList();
        this.setInvocationContext();
        invokedOK = this.doInvokeRequestResponse(inputArgs, responseValues);
        if (invokedOK) {
            if (outMsg != null) {
                this.setPartValues(this.outputParts, responseValues);
                this.setMessagePartValues(outMsg, this.outputParts);
            }
        } else if (faultMsg != null) {
            this.setFaultObjects(faultMsg, responseValues);
        }
        return invokedOK;
    }

    protected boolean doInvokeRequestResponse(List inputArgs, List responseArgs) throws WSIFException {
        throw new WSIFException("doInvoke must be implemented by subclass!");
    }

    protected void invokeInputOnlyOperation(WSIFMessage inMsg) throws WSIFException {
        this.invokeRequestResponseOperation(inMsg, null, null);
        boolean invokedOK = false;
        this.setPartValues(this.inputParts, inMsg);
        List inputArgs = this.getInputArguments();
        ArrayList responseValues = new ArrayList();
        this.setInvocationContext();
        this.doInvokeInputOnly(inputArgs);
    }

    protected void doInvokeInputOnly(List inputArgs) throws WSIFException {
        this.doInvokeRequestResponse(inputArgs, new ArrayList());
    }

    protected WSIFCorrelationId invokeRequestResponseAsync(WSIFMessage inMsg, WSIFResponseHandler handler2) throws WSIFException {
        this.setPartValues(this.inputParts, inMsg);
        List inputArgs = this.getInputArguments();
        this.setInvocationContext();
        WSIFCorrelationId cid = this.doInvokeRequestResponseAsync(inputArgs);
        return cid;
    }

    protected WSIFCorrelationId doInvokeRequestResponseAsync(List inputArgs) throws WSIFException {
        throw new WSIFException("doInvokeAsync must be implemented by subclass!");
    }

    protected Map doDeserialiseResponse(Object response) throws WSIFException {
        throw new WSIFException("doDeserialiseResponse must be implemented by subclass!");
    }

    protected void buildResponseMessages(Map results, WSIFMessage outMsg, WSIFMessage faultMsg) throws WSIFException {
        throw new WSIFException("buildResponseMessages must be implemented by subclass!");
    }

    protected void setPartValues(List parts, WSIFMessage msg) throws WSIFException {
        Iterator i = parts.iterator();
        while (i.hasNext()) {
            Object partValue;
            Part part = (Part)i.next();
            try {
                partValue = msg.getObjectPart(part.getName());
                this.validatePartValue(part, partValue);
            }
            catch (WSIFException e2) {
                partValue = this.doMissingPart(msg, part);
            }
            part.setValue(partValue);
        }
    }

    protected void setPartValues(List parts, List responseValues) throws WSIFException {
        Iterator responses = responseValues.iterator();
        Iterator i = parts.iterator();
        while (i.hasNext()) {
            Object partValue;
            Part part = (Part)i.next();
            if (responses.hasNext()) {
                partValue = responses.next();
                this.validatePartValue(part, partValue);
            } else {
                partValue = this.doMissingOutputValue(part);
            }
            part.setValue(partValue);
        }
    }

    protected void setMessagePartValues(WSIFMessage msg, List parts) throws WSIFException {
        Iterator i = parts.iterator();
        while (i.hasNext()) {
            Part part = (Part)i.next();
            msg.setObjectPart(part.getName(), part.getValue());
        }
    }

    protected void setFaultObjects(WSIFMessage msg, List responseObjects) throws WSIFException {
        int faultNumber = 0;
        Iterator i = responseObjects.iterator();
        while (i.hasNext()) {
            Object faultValue = i.next();
            String faultName = "fault" + faultNumber++;
            msg.setObjectPart(faultName, faultValue);
        }
    }

    protected List getInputArguments() throws WSIFException {
        ArrayList<Object> args = new ArrayList<Object>();
        Iterator i = this.inputParts.iterator();
        while (i.hasNext()) {
            Part part = (Part)i.next();
            Object value2 = part.getValue();
            args.add(value2);
        }
        return args;
    }

    protected Object doMissingPart(WSIFMessage msg, Part part) {
        Trc.event(this, "message " + msg.getName() + "has missing input part '" + part.getName() + "', defaulting to null");
        return null;
    }

    protected Object doMissingOutputValue(Part part) {
        Trc.event(this, "response value missing for part: " + part.getName());
        return null;
    }

    protected void validatePartValue(Part part, Object value2) throws WSIFException {
        if (value2 != null) {
            Class<?> valueClass = value2.getClass();
            if (!(part.getJavaClass().isAssignableFrom(valueClass) || value2 instanceof WSIFAttachmentPart || "javax.activation.DataHandler".equals(valueClass))) {
                throw new WSIFException("WSIFMessage part '" + part.getName() + "' has invalid type, expecting " + part.getJavaClass() + " found " + value2.getClass());
            }
        }
    }

    protected void initialise() throws WSIFException {
        this.used = false;
        if (this.inputParts == null) {
            this.prepare();
        }
        this.doInitialise();
    }

    protected void doInitialise() {
    }

    protected void prepare() throws WSIFException {
        this.inputParts = new ArrayList();
        this.outputParts = new ArrayList();
        Operation op = this.getPortTypeOperation();
        boolean unwrap = ProviderUtils.isUnwrapable(op);
        if (unwrap) {
            boolean bl = unwrap = !this.isWrappedInContext();
        }
        if (op.getInput() != null) {
            Message inMsg = op.getInput().getMessage();
            this.initialiseParts(inMsg, unwrap, this.inputParts);
        }
        if (op.getOutput() != null) {
            Message outMsg = op.getOutput().getMessage();
            this.initialiseParts(outMsg, unwrap, this.outputParts);
        }
        this.initializeOperationExtensibilityElement();
        this.doPrepare();
    }

    protected void initializeOperationExtensibilityElement() throws WSIFException {
        Class c = this.getOperationExtensibilityClass();
        if (c != null) {
            if (!ExtensibilityElement.class.isAssignableFrom(c)) {
                throw new WSIFException("getOperationExtensabilityClass must return a subclass of ExtensibilityElement");
            }
            ExtensibilityElement ee = null;
            List ees = this.bindingOperation.getExtensibilityElements();
            Iterator i = ees.iterator();
            while (ee == null && i.hasNext()) {
                Object o = i.next();
                if (!c.isAssignableFrom(o.getClass())) continue;
                ee = (ExtensibilityElement)o;
            }
            if (ee != null) {
                this.validateOperationExtensibilityElement(ee);
            }
        }
    }

    protected Class getOperationExtensibilityClass() {
        return null;
    }

    protected void validateOperationExtensibilityElement(ExtensibilityElement address) throws WSIFException {
    }

    protected void doPrepare() {
    }

    protected void initialiseParts(Message msg, boolean unwrap, List parts) throws WSIFException {
        List msgParts = msg.getOrderedParts(null);
        if (msgParts != null && !msgParts.isEmpty()) {
            if (unwrap) {
                Part p = (Part)msgParts.get(0);
                List unwrappedParts = ProviderUtils.unWrapPart(p.getWsdlPart(), this.wsifPort.getDefinition(), this.getContext());
                msgParts.remove(p);
                msgParts.add(0, unwrappedParts);
            }
            Iterator i = msgParts.iterator();
            while (i.hasNext()) {
                javax.wsdl.Part wsdlPart = (javax.wsdl.Part)i.next();
                Part part = new Part(wsdlPart);
                part.setJavaClass(this.wsifPort.getClassForPart(wsdlPart));
                parts.add(part);
            }
        }
    }

    protected boolean isWrappedInContext() {
        boolean wrappedInContext = false;
        String value2 = null;
        try {
            WSIFMessage context = this.getContext();
            value2 = (String)context.getObjectPart("org.apache.wsif.axis.operationStyle");
        }
        catch (WSIFException e2) {
            Trc.ignoredException(e2);
        }
        if ("wrapped".equals(value2)) {
            wrappedInContext = true;
        }
        return wrappedInContext;
    }

    protected boolean isUnwrappedInContext() {
        boolean unWrapInContext = false;
        String value2 = null;
        try {
            WSIFMessage context = this.getContext();
            value2 = (String)context.getObjectPart("org.apache.wsif.axis.operationStyle");
        }
        catch (WSIFException e2) {
            Trc.ignoredException(e2);
        }
        if ("unwrapped".equals(value2)) {
            unWrapInContext = true;
        }
        return unWrapInContext;
    }

    protected Operation getOperation() throws WSIFException {
        Trc.entry(this);
        this.getPortTypeOperation();
        Trc.exit(this.portTypeOperation);
        return this.portTypeOperation;
    }

    public Operation getPortTypeOperation() {
        Trc.entry(this);
        if (this.portTypeOperation == null) {
            String inputName = null;
            if (this.bindingOperation.getBindingInput() != null) {
                inputName = this.bindingOperation.getBindingInput().getName();
            }
            String outputName = null;
            if (this.bindingOperation.getBindingOutput() != null) {
                outputName = this.bindingOperation.getBindingOutput().getName();
            }
            this.portTypeOperation = this.wsifPort.getPort().getBinding().getPortType().getOperation(this.bindingOperation.getName(), inputName, outputName);
            if (this.portTypeOperation == null) {
                throw new RuntimeException("no WSDL portType operation found for binding opertion: " + this.bindingOperation.getName() + ":" + inputName + ":" + outputName);
            }
        }
        Trc.exit(this.portTypeOperation);
        return this.portTypeOperation;
    }

    public WSIFMessage createInputMessage() {
        Trc.entry(this);
        WSIFMessage msg = this.createInputMessage(null);
        Trc.exit(msg);
        return msg;
    }

    public WSIFMessage createInputMessage(String name2) {
        Trc.entry((Object)this, name2);
        WSIFDefaultMessage msg = new WSIFDefaultMessage();
        msg.setName(name2);
        Input in = this.getPortTypeOperation().getInput();
        if (in != null) {
            msg.setMessageDefinition(in.getMessage());
        }
        Trc.exit(msg);
        return msg;
    }

    public WSIFMessage createOutputMessage() {
        Trc.entry(this);
        WSIFMessage msg = this.createOutputMessage(null);
        Trc.exit(msg);
        return msg;
    }

    public WSIFMessage createOutputMessage(String name2) {
        Trc.entry((Object)this, name2);
        WSIFDefaultMessage msg = new WSIFDefaultMessage();
        msg.setName(name2);
        Output out = this.getPortTypeOperation().getOutput();
        if (out != null) {
            msg.setMessageDefinition(out.getMessage());
        }
        Trc.exit(msg);
        return msg;
    }

    public WSIFMessage createFaultMessage() {
        Trc.entry(this);
        WSIFMessage msg = this.createFaultMessage(null);
        Trc.exit(msg);
        return msg;
    }

    public WSIFMessage createFaultMessage(String name2) {
        Trc.entry((Object)this, name2);
        WSIFDefaultMessage msg = new WSIFDefaultMessage();
        msg.setName(name2);
        Fault fault2 = this.getPortTypeOperation().getFault(name2);
        if (fault2 != null) {
            msg.setMessageDefinition(fault2.getMessage());
        }
        Trc.exit(msg);
        return msg;
    }

    protected List getInputParts() {
        return this.inputParts;
    }

    protected void setInputParts(List parts) throws WSIFException {
        this.inputParts = parts;
    }

    protected void setInputPartOrder(List partNames) throws WSIFException {
        this.inputParts = this.setPartOrder(partNames, this.inputParts);
    }

    protected Part getReturnPart() {
        Part returnPart = this.outputParts.size() > 0 ? (Part)this.outputParts.get(0) : null;
        return returnPart;
    }

    protected void SetReturnPart(String returnPartName) throws WSIFException {
        Part p = this.getNamedPart(returnPartName, this.outputParts);
        if (p == null) {
            throw new WSIFException("part does not exist: " + returnPartName);
        }
        this.SetReturnPart(p);
    }

    protected void SetReturnPart(Part returnPart) throws WSIFException {
        if (!this.outputParts.contains(returnPart)) {
            throw new WSIFException("part does not exist: " + returnPart);
        }
        this.outputParts.remove(returnPart);
        this.outputParts.add(0, returnPart);
    }

    protected List getOutputParts() {
        return this.outputParts;
    }

    protected void setOutputPartOrder(List partNames) throws WSIFException {
        this.outputParts = this.setPartOrder(partNames, this.outputParts);
    }

    protected List setPartOrder(List partNames, List parts) throws WSIFException {
        ArrayList<Part> oldPartOrder = parts;
        if (partNames != null) {
            ArrayList<Part> newPartOrder = new ArrayList<Part>();
            Iterator i = partNames.iterator();
            while (i.hasNext()) {
                String partName = (String)i.next();
                Part p = this.getNamedPart(partName, parts);
                if (p != null) {
                    newPartOrder.add(p);
                    oldPartOrder.remove(p);
                    continue;
                }
                throw new WSIFException("part does not exists: " + partName);
            }
            i = oldPartOrder.iterator();
            while (i.hasNext()) {
                newPartOrder.add((Part)i.next());
            }
            parts = newPartOrder;
        }
        return parts;
    }

    protected Part getNamedPart(String partName, List parts) {
        Part part = null;
        Iterator i = parts.iterator();
        while (part == null && i.hasNext()) {
            Part p = (Part)i.next();
            if (!p.getName().equals(partName)) continue;
            part = p;
        }
        return part;
    }

    protected Part getNamedPart(String partName, Map parts) {
        Part part = null;
        Iterator i = parts.keySet().iterator();
        while (part == null && i.hasNext()) {
            Part p = (Part)i.next();
            if (!p.getName().equals(partName)) continue;
            part = p;
        }
        return part;
    }

    public WSIFMessage getContext() throws WSIFException {
        WSIFMessage contextCopy;
        Trc.entry(this);
        try {
            if (this.context == null) {
                this.context = (WSIFMessage)this.wsifPort.getContext().clone();
            }
            contextCopy = (WSIFMessage)this.context.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new WSIFException("CloneNotSupportedException cloning context", e2);
        }
        Trc.exit(contextCopy);
        return contextCopy;
    }

    public void setContext(WSIFMessage context) {
        Trc.entry((Object)this, context);
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        this.context = context;
        Trc.exit();
    }

    protected void setInvocationContext() throws WSIFException {
        WSIFMessage ctxt = this.getContext();
        if (this.context == null) {
            this.getContext();
        }
        InvocationHelper.setMessageContext(this.context);
    }

    protected void markAsUsed() throws WSIFException {
        if (this.used) {
            throw new WSIFException("WSIFOperations has already been executed");
        }
        this.used = true;
    }

    public String deep() {
        StringBuffer buff = new StringBuffer(super.toString());
        buff.append(":\n");
        buff.append("portTypeOperation:" + Trc.brief(this.portTypeOperation));
        buff.append(", bindingOperation:" + Trc.brief(this.bindingOperation));
        buff.append(", wsifPort:" + this.wsifPort);
        buff.append(", used:" + this.used);
        buff.append(", inputParts:" + this.inputParts);
        buff.append(", outputParts:" + this.outputParts);
        buff.append(", asyncResponseHandler:" + this.asyncResponseHandler);
        buff.append(", context:" + this.context);
        return buff.toString();
    }
}

