/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.WSIFDynamicTypeMapping;
import org.apache.wsif.util.WSIFUtils;

public class WSIFDynamicTypeMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Vector typeMapList = new Vector();
    protected Vector xmlTypes = new Vector();
    protected ArrayList allTypes;

    public WSIFDynamicTypeMap() {
        Trc.entry(this);
        this.allTypes = new ArrayList();
        Trc.exit();
    }

    public WSIFDynamicTypeMap(ArrayList aList) {
        Trc.entry((Object)this, aList);
        this.allTypes = aList;
        Trc.exit();
    }

    public void mapType(QName xmlType, Class javaType) {
        Trc.entry(this, xmlType, javaType);
        this.mapType(xmlType, javaType, true);
        Trc.exit();
    }

    public void mapType(QName xmlType, Class javaType, boolean force) {
        Trc.entry(this, xmlType, javaType);
        int i = this.xmlTypes.indexOf(xmlType);
        if (i < 0) {
            this.typeMapList.add(new WSIFDynamicTypeMapping(xmlType, javaType));
            this.xmlTypes.add(xmlType);
        } else if (force) {
            this.typeMapList.setElementAt(new WSIFDynamicTypeMapping(xmlType, javaType), i);
        }
        Trc.exit();
    }

    public void mapPackage(String namespace, String packageName) {
        Trc.entry(this, namespace, packageName);
        Iterator it = this.allTypes.iterator();
        while (it.hasNext()) {
            QName qname = (QName)it.next();
            String ns = qname.getNamespaceURI();
            if (ns == null || !ns.equals(namespace)) continue;
            this.resolveMapping(qname, packageName);
        }
        Trc.exit();
    }

    protected void resolveMapping(QName qn, String pn) {
        Trc.entry(this, qn, pn);
        try {
            String xmlName = qn.getLocalPart();
            if (xmlName != null) {
                String javaName = WSIFUtils.getJavaClassNameFromXMLName(xmlName);
                String classname = pn + "." + javaName;
                Class<?> cl = Class.forName(classname, true, Thread.currentThread().getContextClassLoader());
                this.mapType(qn, cl);
            }
        }
        catch (Exception e2) {
            Trc.ignoredException(e2);
        }
        Trc.exit();
    }

    public void setAllTypes(ArrayList aList) {
        Trc.entry((Object)this, aList);
        this.allTypes = aList;
        Trc.exit();
    }

    public Iterator iterator() {
        Trc.entry(this);
        Trc.exit();
        return this.typeMapList.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WSIFDynamicTypeMap copy() {
        Vector vector = this.typeMapList;
        synchronized (vector) {
            WSIFDynamicTypeMap tm = new WSIFDynamicTypeMap();
            ArrayList arrayList = this.allTypes;
            synchronized (arrayList) {
                tm.setAllTypes((ArrayList)this.allTypes.clone());
            }
            Iterator it = this.typeMapList.iterator();
            while (it.hasNext()) {
                WSIFDynamicTypeMapping temp = (WSIFDynamicTypeMapping)it.next();
                tm.mapType(temp.getXmlType(), temp.getJavaType());
            }
            return tm;
        }
    }

    public Class getClassForXmlType(QName xmlType) {
        if (!this.xmlTypes.contains(xmlType)) {
            return null;
        }
        Iterator it = this.typeMapList.iterator();
        while (it.hasNext()) {
            WSIFDynamicTypeMapping mapping = (WSIFDynamicTypeMapping)it.next();
            if (!mapping.xmlType.equals(xmlType)) continue;
            return mapping.javaType;
        }
        return null;
    }
}

