/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers;

import com.ibm.ws.extensionhelper.ExtensionHelper;
import com.ibm.ws.extensionhelper.TransactionControl;
import com.ibm.ws.extensionhelper.TxHandle;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.wsif.WSIFException;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.WSIFTransactionControl;

public class WSIFTransactionControlImpl
implements WSIFTransactionControl {
    private TransactionControl tranControl = null;
    private TxHandle txHandle = null;

    private void lookupTranControl() throws NamingException {
        Trc.entry(this);
        if (this.tranControl == null) {
            InitialContext iContext = new InitialContext();
            ExtensionHelper extHelper = (ExtensionHelper)iContext.lookup("services:websphere/ExtensionHelper");
            this.tranControl = extHelper.getTransactionControl();
        }
        Trc.exit(this.tranControl);
    }

    public void suspend() throws WSIFException {
        Trc.entry(this);
        if (this.txHandle != null) {
            throw new WSIFException("Transaction already suspended");
        }
        try {
            this.lookupTranControl();
            this.txHandle = this.tranControl.preinvoke(true, false);
        }
        catch (Exception e2) {
            Trc.ignoredException(e2);
            this.tranControl = null;
        }
        Trc.exit();
    }

    public void resume() {
        Trc.entry((Object)this, this.txHandle);
        try {
            this.lookupTranControl();
            if (this.txHandle != null) {
                this.tranControl.postinvoke(this.txHandle);
            }
        }
        catch (Exception e2) {
            Trc.ignoredException(e2);
        }
        this.txHandle = null;
        Trc.exit();
    }
}

