/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers.ejb;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.extensions.ExtensibilityElement;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFOperation;
import org.apache.wsif.base.WSIFDefaultPort;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.WSIFDynamicTypeMap;
import org.apache.wsif.providers.ejb.WSIFOperation_EJB;
import org.apache.wsif.util.WSIFUtils;
import org.apache.wsif.wsdl.extensions.ejb.EJBAddress;

public class WSIFPort_EJB
extends WSIFDefaultPort
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Definition fieldDefinition = null;
    private Port fieldPortModel = null;
    private transient EJBHome fieldEjbHome = null;
    private transient EJBObject fieldEjbObject = null;
    private final boolean separatedEJBRefs;
    private transient Class ejbObjectClass;
    private transient Method[] ejbObjectMethods = null;
    protected transient Map operationInstances = new HashMap();

    public WSIFPort_EJB(Definition def, Port port2, WSIFDynamicTypeMap typeMap) {
        Trc.entry(this, def, port2, typeMap);
        this.separatedEJBRefs = true;
        this.fieldDefinition = def;
        this.fieldPortModel = port2;
        Trc.exit();
    }

    public Definition getDefinition() {
        return this.fieldDefinition;
    }

    public WSIFOperation_EJB getDynamicWSIFOperation(String name2, String inputName, String outputName) throws WSIFException {
        BindingOperation bindingOperationModel;
        Trc.entry(this, name2, inputName, outputName);
        WSIFOperation_EJB tempOp = (WSIFOperation_EJB)this.operationInstances.get(this.getKey(name2, inputName, outputName));
        WSIFOperation_EJB operation = null;
        if (tempOp != null) {
            operation = tempOp.copy();
        }
        if (operation == null && (bindingOperationModel = WSIFUtils.getBindingOperation(this.fieldPortModel.getBinding(), name2, inputName, outputName)) != null) {
            operation = new WSIFOperation_EJB(this.fieldPortModel, bindingOperationModel, this);
            this.setDynamicWSIFOperation(name2, inputName, outputName, operation);
        }
        Trc.exit(operation);
        return operation;
    }

    public EJBHome getEjbHome() throws WSIFException {
        Trc.entry(this);
        if (this.fieldEjbHome == null) {
            EJBAddress address = null;
            try {
                Object tempHome;
                String providerURL;
                ExtensibilityElement portExtension = (ExtensibilityElement)this.fieldPortModel.getExtensibilityElements().get(0);
                if (portExtension == null) {
                    throw new WSIFException("missing port extension");
                }
                address = (EJBAddress)portExtension;
                Hashtable<String, String> hash = new Hashtable<String, String>();
                String icf = address.getInitialContextFactory();
                if (icf != null) {
                    hash.put("java.naming.factory.initial", icf);
                }
                if ((providerURL = address.getJndiProviderURL()) != null) {
                    hash.put("java.naming.provider.url", providerURL);
                }
                hash.put("java.naming.authoritative", "true");
                InitialContext initContext = new InitialContext(hash);
                Class<?> homeClass = null;
                try {
                    if (address.getClassName() != null && !EJBHome.class.isAssignableFrom(homeClass = Class.forName(address.getClassName(), true, Thread.currentThread().getContextClassLoader()))) {
                        homeClass = null;
                    }
                }
                catch (ClassNotFoundException cnf) {
                    Trc.ignoredException(cnf);
                }
                this.fieldEjbHome = homeClass != null ? (homeClass.isAssignableFrom((tempHome = initContext.lookup(address.getJndiName())).getClass()) ? (EJBHome)tempHome : (EJBHome)PortableRemoteObject.narrow((Object)tempHome, homeClass)) : (EJBHome)initContext.lookup(address.getJndiName());
            }
            catch (Exception ex) {
                Trc.exception(ex);
                throw new WSIFException("Failed to lookup EJB home using JNDI name '" + address.getJndiName() + "'", ex);
            }
        }
        Trc.exit(this.fieldEjbHome);
        return this.fieldEjbHome;
    }

    public EJBObject getEjbObject() throws WSIFException {
        Trc.entry(this);
        if (this.fieldEjbObject == null) {
            EJBHome ejbHome = this.getEjbHome();
            try {
                final EJBHome ejbHomeFin = ejbHome;
                Method createMethod = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws NoSuchMethodException {
                        return ejbHomeFin.getClass().getDeclaredMethod("create", null);
                    }
                });
                this.fieldEjbObject = (EJBObject)createMethod.invoke((Object)ejbHome, null);
            }
            catch (Exception ex) {
                if (ex instanceof PrivilegedActionException) {
                    ex = ((PrivilegedActionException)ex).getException();
                }
                Trc.exception(ex);
                throw new WSIFException("Could not create instance for home '" + ejbHome + "'", ex);
            }
        }
        Trc.exit(this.fieldEjbObject);
        return this.fieldEjbObject;
    }

    Class getEjbObjectClass() throws WSIFException {
        Trc.entry(this);
        if (this.ejbObjectClass == null) {
            if (this.fieldEjbObject != null) {
                this.ejbObjectClass = this.fieldEjbObject.getClass();
            } else {
                this.getEjbHome();
                if (this.fieldEjbHome == null) {
                    throw new WSIFException("Unable to get EJBObject class, fieldEjbHome is null");
                }
                try {
                    final EJBHome fieldEjbHomeFin = this.fieldEjbHome;
                    Method createMethod = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws NoSuchMethodException {
                            return fieldEjbHomeFin.getClass().getDeclaredMethod("create", null);
                        }
                    });
                    this.ejbObjectClass = createMethod.getReturnType();
                }
                catch (SecurityException se) {
                    Trc.ignoredException(se);
                }
                catch (PrivilegedActionException nsme) {
                    Trc.ignoredException(nsme);
                }
                if (this.ejbObjectClass == null) {
                    Method[] methods = (Method[])AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return WSIFPort_EJB.this.fieldEjbHome.getClass().getDeclaredMethods();
                        }
                    });
                    for (int m = 0; m < methods.length; ++m) {
                        Method temp = methods[m];
                        if (!temp.getName().equals("create")) continue;
                        this.ejbObjectClass = temp.getReturnType();
                        break;
                    }
                }
            }
        }
        if (this.ejbObjectClass == null) {
            throw new WSIFException("EJB Home: " + this.fieldEjbHome == null ? "<null>" : this.fieldEjbHome.getClass().getName() + " doesn't have a create method");
        }
        Trc.exit(this.ejbObjectClass);
        return this.ejbObjectClass;
    }

    Method[] getEjbObjectMethods() throws WSIFException {
        Trc.entry(this);
        if (this.ejbObjectMethods == null) {
            final Class c = this.getEjbObjectClass();
            this.ejbObjectMethods = (Method[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return c.getMethods();
                }
            });
        }
        Trc.exit(this.ejbObjectMethods);
        return this.ejbObjectMethods;
    }

    public Port getPortModel() {
        Trc.entry(this);
        Trc.exit(this.fieldPortModel);
        return this.fieldPortModel;
    }

    public void setDefinition(Definition value2) {
        Trc.entry((Object)this, value2);
        this.fieldDefinition = value2;
        Trc.exit();
    }

    public void setDynamicWSIFOperation(String name2, String inputName, String outputName, WSIFOperation_EJB value2) {
        Trc.entry(this, name2, inputName, outputName);
        this.operationInstances.put(this.getKey(name2, inputName, outputName), value2);
        Trc.exit();
    }

    public void setEjbHome(EJBHome newEjbHome) {
        Trc.entry((Object)this, newEjbHome);
        this.fieldEjbHome = newEjbHome;
        Trc.exit();
    }

    public void setEjbObject(EJBObject newEjbObject) {
        Trc.entry((Object)this, newEjbObject);
        this.fieldEjbObject = newEjbObject;
        if (this.fieldEjbObject != null) {
            this.ejbObjectClass = this.fieldEjbObject.getClass();
        }
        Trc.exit();
    }

    public void setPortModel(Port value2) {
        Trc.entry((Object)this, value2);
        this.fieldPortModel = value2;
        Trc.exit();
    }

    public WSIFOperation createOperation(String operationName) throws WSIFException {
        Trc.entry((Object)this, operationName);
        WSIFOperation wo = this.createOperation(operationName, null, null);
        Trc.exit(wo);
        return wo;
    }

    public WSIFOperation createOperation(String operationName, String inputName, String outputName) throws WSIFException {
        Trc.entry(this, operationName, inputName, outputName);
        WSIFOperation_EJB op = this.getDynamicWSIFOperation(operationName, inputName, outputName);
        if (op == null) {
            throw new WSIFException("Could not create operation: " + operationName + ":" + inputName + ":" + outputName);
        }
        WSIFOperation_EJB wo = op.copy();
        Trc.exit(wo);
        return wo;
    }

    public String deep() {
        String buff = "";
        try {
            buff = new String(super.toString() + ":\n");
            buff = buff + "definition:" + Trc.brief(this.fieldDefinition);
            buff = buff + " portModel:" + Trc.brief(this.fieldPortModel);
            buff = buff + " ejbHome:" + this.fieldEjbHome;
            buff = buff + " ejbObject" + this.fieldEjbObject;
            buff = buff + " operationInstances:";
            if (this.operationInstances == null) {
                buff = buff + "null";
            } else {
                buff = buff + " size:" + this.operationInstances.size();
                Iterator it = this.operationInstances.keySet().iterator();
                int i = 0;
                while (it.hasNext()) {
                    String key = (String)it.next();
                    WSIFOperation_EJB woejb = (WSIFOperation_EJB)this.operationInstances.get(key);
                    buff = buff + "\noperationInstances[" + i + "]:" + key + " " + woejb + " ";
                    ++i;
                }
            }
        }
        catch (Exception e2) {
            Trc.exceptionInTrace(e2);
        }
        return buff;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        if (this.fieldEjbHome != null) {
            HomeHandle homeHandle = this.fieldEjbHome.getHomeHandle();
            oos.writeObject(homeHandle);
        } else {
            oos.writeObject(this.fieldEjbHome);
        }
        if (this.fieldEjbObject != null) {
            Handle handle = this.fieldEjbObject.getHandle();
            oos.writeObject(handle);
        } else {
            oos.writeObject(this.fieldEjbObject);
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        if (this.separatedEJBRefs) {
            Object obj;
            Object objHome = ois.readObject();
            if (objHome != null && objHome instanceof HomeHandle) {
                HomeHandle homeHandle = (HomeHandle)objHome;
                this.fieldEjbHome = homeHandle.getEJBHome();
            }
            if ((obj = ois.readObject()) != null && obj instanceof Handle) {
                Handle handle = (Handle)obj;
                this.fieldEjbObject = handle.getEJBObject();
            }
        }
        this.operationInstances = new HashMap();
    }
}

