/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers.java;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.xml.namespace.QName;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.WSIFOperation;
import org.apache.wsif.WSIFPort;
import org.apache.wsif.attachments.WSIFAttachmentPart;
import org.apache.wsif.base.WSIFDefaultOperation;
import org.apache.wsif.logging.MessageLogger;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.InvocationHelper;
import org.apache.wsif.providers.ProviderUtils;
import org.apache.wsif.providers.java.WSIFPort_Java;
import org.apache.wsif.wsdl.extensions.java.JavaOperation;

public class WSIFOperation_Java
extends WSIFDefaultOperation
implements WSIFOperation {
    private static final long serialVersionUID = 1L;
    protected Port fieldPortModel;
    protected WSIFPort_Java fieldPort;
    protected BindingOperation fieldBindingOperationModel;
    protected JavaOperation fieldJavaOperationModel;
    protected Operation wsdlOperation;
    protected String[] fieldInParameterNames = null;
    protected String[] fieldOutParameterNames = null;
    protected Map fieldFaultMessageInfos = null;
    protected transient Method[] fieldMethods = null;
    protected transient Constructor[] fieldConstructors = null;
    protected String fieldOutputMessageName = null;
    protected boolean fieldIsStatic = false;
    protected boolean fieldIsConstructor = false;
    protected Map fieldTypeMaps = null;
    protected boolean multiOutParts = false;
    private transient Object returnClass = null;

    public WSIFOperation_Java(Port portModel, BindingOperation bindingOperationModel, WSIFPort_Java port2, Map typeMaps) throws WSIFException {
        Trc.entry(this, portModel, bindingOperationModel, port2, typeMaps);
        this.fieldPortModel = portModel;
        this.fieldBindingOperationModel = bindingOperationModel;
        this.fieldPort = port2;
        this.fieldTypeMaps = typeMaps;
        Method[] allMethods = this.fieldPort.getServiceObjectMethods();
        try {
            this.fieldJavaOperationModel = (JavaOperation)this.fieldBindingOperationModel.getExtensibilityElements().get(0);
        }
        catch (Exception e2) {
            Trc.exception(e2);
            throw new WSIFException("Unable to resolve Java binding for operation '" + bindingOperationModel.getName() + "'");
        }
        String methodType = this.fieldJavaOperationModel.getMethodType();
        if ("static".equals(methodType)) {
            this.fieldIsStatic = true;
            this.fieldMethods = this.getMethods(allMethods);
        } else if ("constructor".equals(methodType)) {
            this.fieldIsConstructor = true;
            this.fieldConstructors = this.getConstructors();
        } else {
            this.fieldMethods = this.getMethods(allMethods);
        }
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    private WSIFOperation_Java(Port p, WSIFPort_Java pj, BindingOperation bo, JavaOperation jo, String[] inPNames, String[] outPNames, Map faultMsgInfos, Method[] m, Constructor[] c, String outMName, boolean isSttc, boolean isCnstr, Map tMap, boolean mulOP, Object retCl) {
        Trc.entry(this, p, pj, bo, jo, inPNames, outPNames, faultMsgInfos, m, c, outMName, new Boolean(isSttc), new Boolean(isCnstr), tMap);
        Trc.event(this, "mulOP was " + mulOP + ", retCl was " + retCl);
        this.fieldPortModel = p;
        this.fieldPort = pj;
        this.fieldBindingOperationModel = bo;
        this.fieldJavaOperationModel = jo;
        this.fieldInParameterNames = inPNames;
        this.fieldOutParameterNames = outPNames;
        this.fieldFaultMessageInfos = faultMsgInfos;
        this.fieldMethods = m;
        this.fieldConstructors = c;
        this.fieldOutputMessageName = outMName;
        this.fieldIsStatic = isSttc;
        this.fieldIsConstructor = isCnstr;
        this.fieldTypeMaps = tMap;
        this.multiOutParts = mulOP;
        this.returnClass = retCl;
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    public WSIFOperation_Java copy() throws WSIFException {
        Trc.entry(this);
        WSIFOperation_Java woj = new WSIFOperation_Java(this.fieldPortModel, this.fieldPort, this.fieldBindingOperationModel, this.fieldJavaOperationModel, this.fieldInParameterNames, this.fieldOutParameterNames, this.fieldFaultMessageInfos, this.fieldMethods, this.fieldConstructors, this.fieldOutputMessageName, this.fieldIsStatic, this.fieldIsConstructor, this.fieldTypeMaps, this.multiOutParts, this.returnClass);
        woj.wsdlOperation = this.wsdlOperation;
        Trc.exit(woj);
        return woj;
    }

    protected static Class getClassForName(String classname) throws WSIFException {
        Trc.entry(null, classname);
        Class<Serializable> cls = null;
        if (classname == null) {
            throw new WSIFException("Error in getClassForName(): No class name specified!");
        }
        try {
            cls = classname.lastIndexOf(46) == -1 ? (classname.equals("char") ? Character.TYPE : (classname.equals("boolean") ? Boolean.TYPE : (classname.equals("byte") ? Byte.TYPE : (classname.equals("short") ? Short.TYPE : (classname.equals("int") ? Integer.TYPE : (classname.equals("long") ? Long.TYPE : (classname.equals("float") ? Float.TYPE : (classname.equals("double") ? Double.TYPE : Class.forName(classname, true, Thread.currentThread().getContextClassLoader()))))))))) : Class.forName(classname, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException ex) {
            Trc.exception(ex);
            throw new WSIFException("Could not instantiate class '" + classname + "'", ex);
        }
        Trc.exit(cls);
        return cls;
    }

    protected Constructor[] getConstructors() throws WSIFException {
        Trc.entry(this);
        Constructor[] constructors = this.fieldPort.getServiceObjectConstructors();
        Object[] args = this.getMethodArgumentClasses();
        Vector<Constructor> possibles = new Vector<Constructor>();
        for (int i = 0; i < constructors.length; ++i) {
            Class<?>[] params = constructors[i].getParameterTypes();
            if (params.length != args.length) continue;
            boolean match = true;
            for (int j = 0; j < params.length; ++j) {
                Object obj = args[j];
                if (obj instanceof Vector) {
                    Vector vec = (Vector)obj;
                    boolean found = false;
                    for (int p = 0; p < vec.size(); ++p) {
                        Class cl = (Class)vec.get(p);
                        if (cl.getName().equals(params[j].getName())) {
                            found = true;
                            break;
                        }
                        if (!params[j].isAssignableFrom(cl)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    match = false;
                    break;
                }
                if (((Class)obj).getName().equals(params[j].getName()) || params[j].isAssignableFrom((Class)obj)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            possibles.addElement(constructors[i]);
        }
        Constructor[] candidates = new Constructor[possibles.size()];
        for (int k = 0; k < candidates.length; ++k) {
            candidates[k] = (Constructor)possibles.get(k);
        }
        Trc.exit(candidates);
        return candidates;
    }

    protected Map getFaultMessageInfos() throws WSIFException {
        Trc.entry(this);
        Operation operation = null;
        try {
            operation = this.getOperation();
        }
        catch (Exception e2) {
            Trc.exception(e2);
            throw new WSIFException("Failed to get Operation", e2);
        }
        if (this.fieldFaultMessageInfos == null) {
            this.fieldFaultMessageInfos = new HashMap();
        }
        BindingFault bindingFaultModel = null;
        Map bindingFaultModels = this.fieldBindingOperationModel.getBindingFaults();
        Object parts = null;
        Iterator modelsIterator = bindingFaultModels.values().iterator();
        while (modelsIterator.hasNext()) {
            Object formatType;
            bindingFaultModel = (BindingFault)modelsIterator.next();
            String name2 = bindingFaultModel.getName();
            if (name2 == null) {
                throw new WSIFException("Fault name not found in binding");
            }
            Map map = operation.getFault(name2).getMessage().getParts();
            if (map.size() < 1) continue;
            Part part = (Part)map.values().iterator().next();
            QName partType = part.getTypeName();
            if (partType == null) {
                partType = part.getElementName();
            }
            if ((formatType = this.fieldTypeMaps.get(partType)) == null) {
                throw new WSIFException("formatType for typeName '" + part.getName() + "' not found in document");
            }
            if (formatType instanceof Vector) {
                Vector types = (Vector)formatType;
                Enumeration enumeration = types.elements();
                while (enumeration.hasMoreElements()) {
                    String type = (String)enumeration.nextElement();
                    this.fieldFaultMessageInfos.put(type, new FaultMessageInfo(name2, part.getName(), type));
                }
                continue;
            }
            String type = (String)formatType;
            this.fieldFaultMessageInfos.put(type, new FaultMessageInfo(name2, part.getName(), type));
        }
        Trc.exit(this.fieldFaultMessageInfos);
        return this.fieldFaultMessageInfos;
    }

    protected Method[] getMethods(Method[] allMethods) throws WSIFException {
        try {
            Trc.entry((Object)this, allMethods);
            ArrayList<Method> candidates = new ArrayList<Method>();
            if (!this.fieldIsConstructor) {
                String bindingMethodName = this.fieldJavaOperationModel.getMethodName();
                String bindingMethodName2 = null;
                if (Character.isUpperCase(bindingMethodName.charAt(0))) {
                    StringBuffer sb = new StringBuffer(bindingMethodName);
                    sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
                    bindingMethodName2 = sb.toString();
                }
                Object[] args = this.getMethodArgumentClasses();
                Object retClass = this.getMethodReturnClass();
                for (int i = 0; i < allMethods.length; ++i) {
                    boolean found;
                    Class<?>[] params;
                    String methodName = allMethods[i].getName();
                    if (!methodName.equals(bindingMethodName) && !methodName.equals(bindingMethodName2) || (params = allMethods[i].getParameterTypes()).length != args.length) continue;
                    Class<?> retType = allMethods[i].getReturnType();
                    boolean tryAMap = false;
                    if (this.multiOutParts) {
                        Class mapClass = class$java$util$Map == null ? WSIFOperation_Java.class$("java.util.Map") : class$java$util$Map;
                        found = false;
                        if (mapClass.getName().equals(retType.getName())) {
                            tryAMap = true;
                        } else if (mapClass.isAssignableFrom(retType)) {
                            tryAMap = true;
                        }
                    }
                    if (!tryAMap) {
                        if (retClass != null && retClass instanceof Vector) {
                            Vector vec = (Vector)retClass;
                            found = false;
                            for (int p = 0; p < vec.size(); ++p) {
                                Class cl = (Class)vec.get(p);
                                if (cl.getName().equals(retType.getName())) {
                                    found = true;
                                    break;
                                }
                                if (!cl.isAssignableFrom(retType)) continue;
                                found = true;
                                break;
                            }
                            if (!found) {
                                continue;
                            }
                        } else if (retType != null && retClass != null && !((Class)retClass).getName().equals(retType.getName()) && !((Class)retClass).isAssignableFrom(retType)) continue;
                    }
                    boolean match = true;
                    for (int j = 0; j < params.length; ++j) {
                        Object obj = args[j];
                        if (obj instanceof Vector) {
                            Vector vec = (Vector)obj;
                            boolean found2 = false;
                            for (int p = 0; p < vec.size(); ++p) {
                                Class cl = (Class)vec.get(p);
                                if (cl.getName().equals(params[j].getName())) {
                                    found2 = true;
                                    break;
                                }
                                if (!params[j].isAssignableFrom(cl)) continue;
                                found2 = true;
                                break;
                            }
                            if (found2) continue;
                            match = false;
                            break;
                        }
                        if (((Class)obj).getName().equals(params[j].getName()) || params[j].isAssignableFrom((Class)obj)) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                    candidates.add(allMethods[i]);
                }
            }
            Method[] methods = candidates.toArray(new Method[candidates.size()]);
            Trc.exit(methods);
            return methods;
        }
        catch (Exception e2) {
            if (e2 instanceof WSIFException) {
                throw (WSIFException)e2;
            }
            throw new WSIFException("Failure to get list of possible methods for Java service" + e2);
        }
    }

    protected Operation getOperation() throws Exception {
        Trc.entry(this);
        if (this.wsdlOperation == null) {
            String inputName = null;
            if (this.fieldBindingOperationModel.getBindingInput() != null) {
                inputName = this.fieldBindingOperationModel.getBindingInput().getName();
            }
            String outputName = null;
            if (this.fieldBindingOperationModel.getBindingOutput() != null) {
                outputName = this.fieldBindingOperationModel.getBindingOutput().getName();
            }
            this.wsdlOperation = this.fieldPortModel.getBinding().getPortType().getOperation(this.fieldBindingOperationModel.getName(), inputName, outputName);
        }
        Trc.exit(this.wsdlOperation);
        return this.wsdlOperation;
    }

    protected Object getMethodReturnClass() throws WSIFException {
        Serializable methodReturnClass;
        block10: {
            Trc.entry(this);
            methodReturnClass = null;
            try {
                String returnPartString = this.fieldJavaOperationModel.getReturnPart();
                List parameterOrder = this.fieldJavaOperationModel.getParameterOrder();
                if (this.fieldOutParameterNames.length > 1) {
                    this.multiOutParts = true;
                    for (int p = 0; p < this.fieldOutParameterNames.length; ++p) {
                        String pName = this.fieldOutParameterNames[p];
                        if (pName == null || !parameterOrder.contains(pName)) continue;
                        this.multiOutParts = false;
                    }
                }
                if (returnPartString == null) break block10;
                Part returnPart = this.getOperation().getOutput().getMessage().getPart(returnPartString);
                if (returnPart != null) {
                    Object obj;
                    QName partType = returnPart.getTypeName();
                    if (partType == null) {
                        partType = returnPart.getElementName();
                    }
                    if ((obj = this.fieldTypeMaps.get(partType)) == null) {
                        throw new WSIFException("Could not map type " + partType + " to a java type. Part name was " + returnPart.getName() == null ? "<null>" : returnPart.getName());
                    }
                    if (obj instanceof Vector) {
                        Vector v = (Vector)obj;
                        Vector<Class> argv = new Vector<Class>();
                        Enumeration enumeration = v.elements();
                        while (enumeration.hasMoreElements()) {
                            String cls = (String)enumeration.nextElement();
                            argv.addElement(WSIFOperation_Java.getClassForName(cls));
                        }
                        methodReturnClass = argv;
                    } else {
                        methodReturnClass = WSIFOperation_Java.getClassForName((String)obj);
                    }
                    break block10;
                }
                throw new Exception("returnPart '" + returnPartString + "' was not in the output message");
            }
            catch (Exception ex) {
                Trc.exception(ex);
                throw new WSIFException("Error while determining return class of method " + this.fieldJavaOperationModel.getMethodName() + " : The meta information is not consistent.", ex);
            }
        }
        this.returnClass = methodReturnClass;
        Trc.exit(methodReturnClass);
        return methodReturnClass;
    }

    protected Object[] getMethodArgumentClasses() throws WSIFException {
        Trc.entry(this);
        Object[] methodArgClasses = null;
        try {
            Operation operation = this.getOperation();
            Vector<String> parameterOrder = null;
            parameterOrder = this.fieldJavaOperationModel.getParameterOrder();
            if (parameterOrder == null) {
                parameterOrder = operation.getParameterOrdering();
            }
            if (parameterOrder == null) {
                List partList = operation.getInput().getMessage().getOrderedParts(null);
                parameterOrder = new Vector<String>();
                Iterator partListIterator = partList.iterator();
                while (partListIterator.hasNext()) {
                    Part part = (Part)partListIterator.next();
                    parameterOrder.add(part.getName());
                }
            }
            ArrayList<String> argNames = new ArrayList<String>();
            ArrayList<Serializable> argTypes = new ArrayList<Serializable>();
            Iterator parameterIterator = parameterOrder.iterator();
            while (parameterIterator.hasNext()) {
                Object obj;
                String param = (String)parameterIterator.next();
                Part part = operation.getInput().getMessage().getPart(param);
                if (part == null) {
                    part = operation.getOutput().getMessage().getPart(param);
                }
                if (part == null) {
                    throw new Exception("Part '" + param + "' from parameterOrder not found in input or output message");
                }
                argNames.add(part.getName());
                QName partType = part.getTypeName();
                if (partType == null) {
                    partType = part.getElementName();
                }
                if ((obj = this.fieldTypeMaps.get(partType)) == null) {
                    throw new WSIFException("Could not map type " + partType + " to a java type. Part name was " + part.getName() == null ? "<null>" : part.getName());
                }
                if (obj instanceof Vector) {
                    Vector v = (Vector)obj;
                    Vector<Class> argv = new Vector<Class>();
                    Enumeration enumeration = v.elements();
                    while (enumeration.hasMoreElements()) {
                        String cls = (String)enumeration.nextElement();
                        argv.addElement(WSIFOperation_Java.getClassForName(cls));
                    }
                    argTypes.add(argv);
                    continue;
                }
                argTypes.add(WSIFOperation_Java.getClassForName((String)obj));
            }
            methodArgClasses = argTypes.toArray();
            this.fieldInParameterNames = new String[argNames.size()];
            for (int i = 0; i < argNames.size(); ++i) {
                this.fieldInParameterNames[i] = (String)argNames.get(i);
            }
            if (operation.getStyle().equals(OperationType.REQUEST_RESPONSE)) {
                argNames = new ArrayList();
                String returnPart = this.fieldJavaOperationModel.getReturnPart();
                Iterator outputPartsIterator = operation.getOutput().getMessage().getOrderedParts(null).iterator();
                while (outputPartsIterator.hasNext()) {
                    Part part = (Part)outputPartsIterator.next();
                    String partName = part.getName();
                    if (partName != null && returnPart != null && partName.equals(returnPart)) {
                        argNames.add(0, partName);
                        continue;
                    }
                    argNames.add(part.getName());
                }
                this.fieldOutParameterNames = new String[argNames.size()];
                for (int i = 0; i < argNames.size(); ++i) {
                    this.fieldOutParameterNames[i] = (String)argNames.get(i);
                }
            } else {
                this.fieldOutParameterNames = new String[0];
            }
        }
        catch (Exception ex) {
            Trc.exception(ex);
            throw new WSIFException("Error while determining signature of method " + this.fieldJavaOperationModel.getMethodName() + " : The meta information is not consistent.", ex);
        }
        Trc.exit(methodArgClasses);
        return methodArgClasses;
    }

    protected Object[] getCompatibleArguments(Class[] parmTypes, Object[] args) {
        Trc.entry(this, parmTypes, args);
        if (args == null || parmTypes == null) {
            Object[] compatibleArgs = new Object[]{};
            return compatibleArgs;
        }
        Object[] compatibleArgs = new Object[args.length];
        for (int i = 0; i < parmTypes.length; ++i) {
            if (args[i] == null) {
                compatibleArgs[i] = ProviderUtils.getDefaultObject(parmTypes[i]);
                continue;
            }
            Object convertedArg = this.getCompatibleObject(parmTypes[i], args[i]);
            if (convertedArg == null) {
                return null;
            }
            compatibleArgs[i] = convertedArg;
        }
        Trc.exit(compatibleArgs);
        return compatibleArgs;
    }

    protected Object getCompatibleReturn(Method method2, Object returnObj) {
        Trc.entry(this, method2, returnObj);
        Object o = null;
        Class<?> rt = method2.getReturnType();
        Class<?> ct = null;
        int dims = 0;
        if (rt.isArray()) {
            ct = rt.getComponentType();
            ++dims;
            while (ct.isArray()) {
                ct = ct.getComponentType();
                ++dims;
            }
        }
        if (returnObj instanceof Character) {
            o = this.getCompatibleObject(String.class, returnObj);
        } else if (ct != null && (ct.equals(Character.class) || ct.equals(Character.TYPE))) {
            String stringArrayClassName = "[Ljava.lang.String;";
            for (int d = 1; d < dims; ++d) {
                stringArrayClassName = "[" + stringArrayClassName;
            }
            try {
                Class<?> stringArrayClass = Class.forName(stringArrayClassName, true, Thread.currentThread().getContextClassLoader());
                o = this.getCompatibleObject(stringArrayClass, returnObj);
            }
            catch (ClassNotFoundException cnf) {
                Trc.ignoredException(cnf);
                o = returnObj;
            }
        } else {
            o = returnObj;
        }
        Trc.exit(o);
        return o;
    }

    protected Object getCompatibleObject(Class cls, Object obj) {
        Trc.entry(this, cls, obj);
        if (cls.getName().equals(obj.getClass().getName())) {
            return obj;
        }
        if ((cls.equals(Character.class) || cls.equals(Character.TYPE)) && obj.getClass().equals(String.class)) {
            Character charArg = ProviderUtils.stringToCharacter((String)obj);
            if (charArg == null) {
                Trc.exit(null);
                return null;
            }
            Trc.exit(charArg);
            return charArg;
        }
        if (cls.isArray() && obj.getClass().isArray()) {
            Class<?> cct = cls.getComponentType();
            Class<?> objct = obj.getClass().getComponentType();
            while (cct.isArray()) {
                cct = cct.getComponentType();
            }
            while (objct.isArray()) {
                objct = objct.getComponentType();
            }
            if (objct.equals(String.class) && cct.equals(Character.TYPE)) {
                try {
                    Object charArray = ProviderUtils.stringArrayToCharArray(obj);
                    Trc.exit(charArray);
                    return charArray;
                }
                catch (Exception e2) {
                    Trc.ignoredException(e2);
                    Trc.exit(null);
                    return null;
                }
            }
            if (objct.equals(String.class) && cct.equals(Character.class)) {
                try {
                    Object charArray = ProviderUtils.stringArrayToCharacterArray(obj);
                    Trc.exit(charArray);
                    return charArray;
                }
                catch (Exception e3) {
                    Trc.ignoredException(e3);
                    Trc.exit(null);
                    return null;
                }
            }
            if (objct.equals(Character.class) && cct.equals(String.class)) {
                try {
                    Object charArray = ProviderUtils.characterArrayToStringArray(obj);
                    Trc.exit(charArray);
                    return charArray;
                }
                catch (Exception e4) {
                    Trc.ignoredException(e4);
                    Trc.exit(null);
                    return null;
                }
            }
            if (objct.equals(Character.TYPE) && cct.equals(String.class)) {
                try {
                    Object charArray = ProviderUtils.charArrayToStringArray(obj);
                    Trc.exit(charArray);
                    return charArray;
                }
                catch (Exception e5) {
                    Trc.ignoredException(e5);
                    Trc.exit(null);
                    return null;
                }
            }
        }
        if (cls.equals(String.class) && obj.getClass().equals(Character.class)) {
            Trc.exit(obj.toString());
            return obj.toString();
        }
        if (cls.equals(WSIFAttachmentPart.class) && obj.getClass().getName().equals("javax.activation.DataHandler")) {
            obj = new WSIFAttachmentPart(obj);
        }
        if (cls.getName().equals("javax.activation.DataHandler") && obj.getClass().equals(WSIFAttachmentPart.class)) {
            WSIFAttachmentPart wap = (WSIFAttachmentPart)obj;
            obj = wap.getDataHandler();
        }
        Trc.exit(obj);
        return obj;
    }

    protected String getOutputMessageName() throws WSIFException {
        BindingOutput bindingOutputModel;
        Trc.entry(this);
        if (this.fieldOutputMessageName == null && (bindingOutputModel = this.fieldBindingOperationModel.getBindingOutput()) != null) {
            this.fieldOutputMessageName = bindingOutputModel.getName();
        }
        Trc.exit(this.fieldOutputMessageName);
        return this.fieldOutputMessageName;
    }

    public WSIFPort getWSIFPort() {
        Trc.entry(this);
        Trc.exit(this.fieldPort);
        return this.fieldPort;
    }

    public boolean executeRequestResponseOperation(WSIFMessage input, WSIFMessage output, WSIFMessage fault2) throws WSIFException {
        boolean operationSucceeded;
        block60: {
            Trc.entry(this, input, output, fault2);
            this.close();
            WSIFMessage ctxt = this.getContext();
            if (ctxt != null) {
                InvocationHelper.setMessageContext(ctxt);
                this.setContext(ctxt);
            }
            operationSucceeded = true;
            boolean usedOutputParam = false;
            Method chosenMethod = null;
            try {
                int j;
                int a;
                Object[] compatibleArguments;
                Object result = null;
                if (this.fieldIsConstructor) {
                    if (this.fieldConstructors.length <= 0) {
                        throw new WSIFException("No constructor found that match the parts specified");
                    }
                } else if (this.fieldMethods.length <= 0) {
                    throw new WSIFException("No method named '" + this.fieldJavaOperationModel.getMethodName() + "' found that match the parts specified");
                }
                Object[] arguments = null;
                Object part = null;
                if (this.fieldInParameterNames != null && this.fieldInParameterNames.length > 0) {
                    arguments = new Object[this.fieldInParameterNames.length];
                    for (int i = 0; i < this.fieldInParameterNames.length; ++i) {
                        try {
                            arguments[i] = part = input.getObjectPart(this.fieldInParameterNames[i]);
                            continue;
                        }
                        catch (WSIFException e2) {
                            Trc.exception(e2);
                            arguments[i] = null;
                            if (this.fieldOutParameterNames.length <= 0) continue;
                            String outParameterName = null;
                            for (int j2 = 0; j2 < this.fieldOutParameterNames.length; ++j2) {
                                outParameterName = this.fieldOutParameterNames[j2];
                                if (outParameterName == null || !outParameterName.equals(this.fieldInParameterNames[i])) continue;
                                arguments[i] = this.fieldMethods[0].getParameterTypes()[i].newInstance();
                                usedOutputParam = true;
                            }
                        }
                    }
                }
                boolean invokedOK = false;
                if (this.fieldIsConstructor) {
                    for (int a2 = 0; a2 < this.fieldConstructors.length; ++a2) {
                        try {
                            compatibleArguments = this.getCompatibleArguments(this.fieldConstructors[a2].getParameterTypes(), arguments);
                            if (compatibleArguments == null) break;
                            Trc.event(this, "Invoking constructor ", this.fieldConstructors[a2], " with arguments ", compatibleArguments);
                            result = this.fieldConstructors[a2].newInstance(compatibleArguments);
                            Trc.event(this, "Returned from constructor, result is ", result);
                            this.fieldPort.setObjectReference(result);
                            invokedOK = true;
                            break;
                        }
                        catch (IllegalArgumentException ia) {
                            Trc.ignoredException(ia);
                            continue;
                        }
                    }
                    if (!invokedOK) {
                        throw new WSIFException("Failed to call constructor for object in Java operation");
                    }
                    break block60;
                }
                if (this.fieldIsStatic) {
                    for (a = 0; a < this.fieldMethods.length; ++a) {
                        if (usedOutputParam) {
                            for (int i = 0; i < this.fieldInParameterNames.length; ++i) {
                                String outParameterName = null;
                                for (j = 0; j < this.fieldOutParameterNames.length; ++j) {
                                    outParameterName = this.fieldOutParameterNames[j];
                                    if (outParameterName == null || !outParameterName.equals(this.fieldInParameterNames[i])) continue;
                                    arguments[i] = this.fieldMethods[a].getParameterTypes()[i].newInstance();
                                }
                            }
                        }
                        try {
                            compatibleArguments = this.getCompatibleArguments(this.fieldMethods[a].getParameterTypes(), arguments);
                            if (compatibleArguments == null) break;
                            Trc.event(this, "Invoking method ", this.fieldMethods[a], " with arguments ", compatibleArguments);
                            result = this.fieldMethods[a].invoke(null, compatibleArguments);
                            Trc.event(this, "Returned from method, result is ", result);
                            chosenMethod = this.fieldMethods[a];
                            invokedOK = true;
                            break;
                        }
                        catch (IllegalArgumentException ia) {
                            Trc.ignoredException(ia);
                            continue;
                        }
                    }
                    if (!invokedOK) {
                        throw new WSIFException("Failed to invoke method '" + this.fieldJavaOperationModel.getMethodName() + "'");
                    }
                } else {
                    for (a = 0; a < this.fieldMethods.length; ++a) {
                        if (usedOutputParam) {
                            for (int i = 0; i < this.fieldInParameterNames.length; ++i) {
                                String outParameterName = null;
                                for (j = 0; j < this.fieldOutParameterNames.length; ++j) {
                                    outParameterName = this.fieldOutParameterNames[j];
                                    if (outParameterName == null || !outParameterName.equals(this.fieldInParameterNames[i])) continue;
                                    arguments[i] = this.fieldMethods[a].getParameterTypes()[i].newInstance();
                                }
                            }
                        }
                        try {
                            compatibleArguments = this.getCompatibleArguments(this.fieldMethods[a].getParameterTypes(), arguments);
                            if (compatibleArguments == null) break;
                            Object objRef = this.fieldPort.getObjectReference();
                            Trc.event(this, "Invoking object ", objRef, " method ", this.fieldMethods[a], " with arguments ", compatibleArguments);
                            result = this.fieldMethods[a].invoke(objRef, compatibleArguments);
                            Trc.event(this, "Returned from method, result is ", result);
                            chosenMethod = this.fieldMethods[a];
                            invokedOK = true;
                            break;
                        }
                        catch (IllegalArgumentException ia) {
                            Trc.ignoredException(ia);
                            continue;
                        }
                    }
                    if (!invokedOK) {
                        throw new WSIFException("Failed to invoke method '" + this.fieldJavaOperationModel.getMethodName() + "'");
                    }
                }
                String outParameterName = null;
                if (this.fieldOutParameterNames.length == 1) {
                    output.setName(this.getOutputMessageName());
                    outParameterName = this.fieldOutParameterNames[0];
                    if (outParameterName != null) {
                        output.setObjectPart(outParameterName, this.getCompatibleReturn(chosenMethod, result));
                    }
                    break block60;
                }
                if (this.fieldOutParameterNames.length <= 1) break block60;
                if (this.multiOutParts) {
                    if (Map.class.isAssignableFrom(chosenMethod.getReturnType())) {
                        if (!(result instanceof Map)) {
                            throw new WSIFException("Operation " + this.getOperation().getName() + " defined as returning multiple parts " + "and the Java method did not return an instance of java.util.Map");
                        }
                        Map returnedMap = (Map)result;
                        output.setName(this.getOutputMessageName());
                        for (int p = 0; p < this.fieldOutParameterNames.length; ++p) {
                            Object typeObj;
                            Object outPart;
                            String pName = this.fieldOutParameterNames[p];
                            if (returnedMap.containsKey(pName)) {
                                outPart = returnedMap.get(pName);
                                Message outputMessage = this.getOperation().getOutput().getMessage();
                                Part wsdlPart = outputMessage.getPart(pName);
                                QName partType = wsdlPart.getTypeName();
                                if (partType == null) {
                                    partType = wsdlPart.getElementName();
                                }
                                if ((typeObj = this.fieldTypeMaps.get(partType)) == null) {
                                    throw new WSIFException("The Class of part " + pName + ", returned by the Java method for" + " operation " + this.getOperation().getName() + " does not match the Class defined in the format " + "binding for that part.");
                                }
                            } else {
                                if (this.returnClass != null && this.returnClass instanceof Class && Map.class.isAssignableFrom((Class)this.returnClass)) {
                                    HashMap<String, Object> m = new HashMap<String, Object>();
                                    m.put(this.fieldOutParameterNames[0], result);
                                    output.setParts(m);
                                    break block60;
                                }
                                throw new WSIFException("Operation " + this.getOperation().getName() + " defined as returning multiple parts." + " Part " + pName + " was missing from the Map returned by " + "the Java service class");
                            }
                            Class c = WSIFOperation_Java.getClassForName((String)typeObj);
                            Object outPart2 = this.getCompatibleObject(c, outPart);
                            output.setObjectPart(pName, outPart2);
                        }
                        break block60;
                    }
                    output.setName(this.getOutputMessageName());
                    outParameterName = this.fieldOutParameterNames[0];
                    if (outParameterName != null) {
                        output.setObjectPart(outParameterName, this.getCompatibleReturn(chosenMethod, result));
                    }
                    break block60;
                }
                output.setName(this.getOutputMessageName());
                outParameterName = this.fieldOutParameterNames[0];
                if (outParameterName != null) {
                    output.setObjectPart(outParameterName, this.getCompatibleReturn(chosenMethod, result));
                }
                if (arguments != null) {
                    block25: for (int i = 1; i < this.fieldOutParameterNames.length; ++i) {
                        outParameterName = this.fieldOutParameterNames[i];
                        if (outParameterName == null) continue;
                        try {
                            for (int r = 0; r < this.fieldInParameterNames.length; ++r) {
                                if (!outParameterName.equals(this.fieldInParameterNames[r])) continue;
                                output.setObjectPart(outParameterName, arguments[r]);
                                continue block25;
                            }
                            continue;
                        }
                        catch (WSIFException e3) {
                            Trc.ignoredException(e3);
                        }
                    }
                }
            }
            catch (InvocationTargetException ex) {
                Trc.exception(ex);
                Throwable invocationFault = ex.getTargetException();
                String className = invocationFault.getClass().getName();
                Map faultMessageInfos = this.getFaultMessageInfos();
                FaultMessageInfo faultMessageInfo = (FaultMessageInfo)faultMessageInfos.get(className);
                if (faultMessageInfo != null && faultMessageInfo.fieldPartName != null) {
                    Fault wsdlFault;
                    Throwable faultPart = invocationFault;
                    fault2.setObjectPart(faultMessageInfo.fieldPartName, faultPart);
                    fault2.setName(faultMessageInfo.fieldMessageName);
                    if (faultMessageInfo.fieldMessageName != null && (wsdlFault = this.fieldBindingOperationModel.getOperation().getFault(faultMessageInfo.fieldMessageName)) != null) {
                        fault2.setMessageDefinition(wsdlFault.getMessage());
                    }
                    operationSucceeded = false;
                } else {
                    Class<?> invocationFaultClass = invocationFault.getClass();
                    Class<?> tempClass = null;
                    Iterator it = faultMessageInfos.values().iterator();
                    boolean found = false;
                    while (it.hasNext()) {
                        faultMessageInfo = (FaultMessageInfo)it.next();
                        try {
                            Fault wsdlFault;
                            tempClass = Class.forName(faultMessageInfo.fieldFormatType, true, Thread.currentThread().getContextClassLoader());
                            if (!tempClass.isAssignableFrom(invocationFaultClass)) continue;
                            found = true;
                            Throwable faultPart = invocationFault;
                            fault2.setObjectPart(faultMessageInfo.fieldPartName, faultPart);
                            fault2.setName(faultMessageInfo.fieldMessageName);
                            if (faultMessageInfo.fieldMessageName != null && (wsdlFault = this.fieldBindingOperationModel.getOperation().getFault(faultMessageInfo.fieldMessageName)) != null) {
                                fault2.setMessageDefinition(wsdlFault.getMessage());
                            }
                            operationSucceeded = false;
                        }
                        catch (Exception exc) {
                            Trc.ignoredException(exc);
                        }
                    }
                    if (!found) {
                        throw new WSIFException("Operation failed!", invocationFault);
                    }
                }
            }
            catch (Exception ex) {
                Trc.exception(ex);
                MessageLogger.log("WSIF.0005E", "Java", this.fieldJavaOperationModel.getMethodName());
                throw new WSIFException(this + " : Could not invoke '" + this.fieldJavaOperationModel.getMethodName() + "'", ex);
            }
        }
        Trc.exit(operationSucceeded);
        return operationSucceeded;
    }

    public void executeInputOnlyOperation(WSIFMessage input) throws WSIFException {
        Trc.entry((Object)this, input);
        this.close();
        WSIFMessage ctxt = this.getContext();
        if (ctxt != null) {
            InvocationHelper.setMessageContext(ctxt);
            this.setContext(ctxt);
        }
        try {
            Object result = null;
            if (this.fieldIsConstructor) {
                if (this.fieldConstructors.length <= 0) {
                    throw new WSIFException("No constructors found that match the parts specified");
                }
            } else if (this.fieldMethods.length <= 0) {
                throw new WSIFException("No methods named '" + this.fieldJavaOperationModel.getMethodName() + "' found that match the parts specified");
            }
            Object[] arguments = null;
            Object part = null;
            if (this.fieldInParameterNames != null && this.fieldInParameterNames.length > 0) {
                arguments = new Object[this.fieldInParameterNames.length];
                for (int i = 0; i < this.fieldInParameterNames.length; ++i) {
                    try {
                        arguments[i] = part = input.getObjectPart(this.fieldInParameterNames[i]);
                        continue;
                    }
                    catch (WSIFException e2) {
                        Trc.exception(e2);
                        arguments[i] = null;
                    }
                }
            }
            boolean invokedOK = false;
            if (this.fieldIsConstructor) {
                for (int a = 0; a < this.fieldConstructors.length; ++a) {
                    try {
                        Object[] compatibleArguments = this.getCompatibleArguments(this.fieldConstructors[a].getParameterTypes(), arguments);
                        if (compatibleArguments == null) break;
                        Trc.event(this, "Invoking constructor ", this.fieldConstructors[a], " with arguments ", compatibleArguments);
                        result = this.fieldConstructors[a].newInstance(compatibleArguments);
                        Trc.event(this, "Returned from constructor, result is ", result);
                        this.fieldPort.setObjectReference(result);
                        invokedOK = true;
                        break;
                    }
                    catch (IllegalArgumentException ia) {
                        Trc.ignoredException(ia);
                        continue;
                    }
                }
                if (!invokedOK) {
                    throw new WSIFException("Failed to call constructor for object in Java operation");
                }
            } else if (this.fieldIsStatic) {
                for (int a = 0; a < this.fieldMethods.length; ++a) {
                    try {
                        Object[] compatibleArguments = this.getCompatibleArguments(this.fieldMethods[a].getParameterTypes(), arguments);
                        if (compatibleArguments == null) break;
                        Trc.event(this, "Invoking method ", this.fieldMethods[a], " with arguments ", compatibleArguments);
                        result = this.fieldMethods[a].invoke(null, compatibleArguments);
                        Trc.event(this, "Returned from method, result is ", result);
                        invokedOK = true;
                        break;
                    }
                    catch (IllegalArgumentException ia) {
                        Trc.ignoredException(ia);
                        continue;
                    }
                }
                if (!invokedOK) {
                    throw new WSIFException("Failed to invoke method '" + this.fieldJavaOperationModel.getMethodName() + "'");
                }
            } else {
                for (int a = 0; a < this.fieldMethods.length; ++a) {
                    try {
                        Object[] compatibleArguments = this.getCompatibleArguments(this.fieldMethods[a].getParameterTypes(), arguments);
                        if (compatibleArguments == null) break;
                        Object objRef = this.fieldPort.getObjectReference();
                        Trc.event(this, "Invoking object ", objRef, " method ", this.fieldMethods[a], " with arguments ", compatibleArguments);
                        result = this.fieldMethods[a].invoke(objRef, compatibleArguments);
                        Trc.event(this, "Returned from method, result is ", result);
                        invokedOK = true;
                        break;
                    }
                    catch (IllegalArgumentException ia) {
                        Trc.ignoredException(ia);
                        continue;
                    }
                }
                if (!invokedOK) {
                    throw new WSIFException("Failed to invoke method '" + this.fieldJavaOperationModel.getMethodName() + "'");
                }
            }
        }
        catch (InvocationTargetException ex) {
            Trc.exception(ex);
            MessageLogger.log("WSIF.0005E", "Java", this.fieldJavaOperationModel.getMethodName());
            throw new WSIFException(this + " : Invocation of '" + this.fieldJavaOperationModel.getMethodName() + "' failed.", ex);
        }
        catch (Exception ex) {
            Trc.exception(ex);
            MessageLogger.log("WSIF.0005E", "Java", this.fieldJavaOperationModel.getMethodName());
            throw new WSIFException(this + " : Could not invoke '" + this.fieldJavaOperationModel.getMethodName() + "'", ex);
        }
        Trc.exit();
    }

    public String deep() {
        String buff = "";
        try {
            Object key;
            int i;
            Iterator it;
            buff = new String(super.toString() + ":\n");
            buff = buff + "portModel:" + Trc.brief(this.fieldPortModel);
            buff = buff + " wsifPort_Java:" + this.fieldPort;
            buff = buff + " bindingOperationModel:" + Trc.brief(this.fieldBindingOperationModel);
            buff = buff + " JavaOperation:" + this.fieldJavaOperationModel;
            buff = buff + Trc.brief("inParameterNames", this.fieldInParameterNames);
            buff = buff + Trc.brief("outParameterNames", this.fieldOutParameterNames);
            if (this.fieldFaultMessageInfos == null) {
                buff = buff + " faultMessageInfos:null";
            } else {
                it = this.fieldFaultMessageInfos.keySet().iterator();
                i = 0;
                while (it.hasNext()) {
                    key = (String)it.next();
                    buff = buff + " faultMessageInfos[" + i + "]:" + (String)key + " " + this.fieldFaultMessageInfos.get(key);
                    ++i;
                }
            }
            buff = buff + Trc.brief("methods", this.fieldMethods);
            buff = buff + Trc.brief("constructors", this.fieldConstructors);
            buff = buff + " outputMessageName:" + this.fieldOutputMessageName;
            buff = buff + " isStatic:" + this.fieldIsStatic;
            buff = buff + " isConstructor:" + this.fieldIsConstructor;
            if (this.fieldTypeMaps == null) {
                buff = buff + " faultTypeMaps:null";
            } else {
                it = this.fieldTypeMaps.keySet().iterator();
                i = 0;
                while (it.hasNext()) {
                    key = (QName)it.next();
                    buff = buff + " typeMaps[" + i + "]:" + key + " " + this.fieldTypeMaps.get(key);
                    ++i;
                }
            }
        }
        catch (Exception e2) {
            Trc.exceptionInTrace(e2);
        }
        return buff;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        Method[] allMethods = this.fieldPort.getServiceObjectMethods();
        if (this.fieldIsConstructor) {
            this.fieldConstructors = this.getConstructors();
        } else {
            this.fieldMethods = this.getMethods(allMethods);
        }
    }

    private class FaultMessageInfo {
        String fieldMessageName;
        String fieldPartName;
        String fieldFormatType;

        FaultMessageInfo(String messageName, String partName, String formatType) {
            this.fieldMessageName = messageName;
            this.fieldPartName = partName;
            this.fieldFormatType = formatType;
        }
    }
}

