/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers.jca.toolplugin;

import javax.wsdl.Definition;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.WSIFOperation;
import org.apache.wsif.WSIFPort;
import org.apache.wsif.WSIFService;
import org.apache.wsif.WSIFServiceFactory;
import org.apache.wsif.providers.jca.toolplugin.ImportDefinition;
import org.apache.wsif.providers.jca.toolplugin.PortTypeArray;
import org.apache.wsif.providers.jca.toolplugin.PortTypeSelection;

public abstract class Import {
    private static final long serialVersionUID = 1L;
    private Definition serviceDefintion = null;
    private Service importService = null;
    private PortType importPortType = null;
    public static final String IMPORT_SERVICE_BASE_NAMESPACE = "http://importservice.jca.providers.wsif.apache.org/";
    public static final String IMPORT_SERVICE_BASE_PORTTYPE_NAME = "Import";
    public static final String GET_PORTTYPES_OPERATION = "getPortTypes";
    public static final String GET_DEFINITION_OPERATION = "getDefinition";
    public static final String GET_RAW_EIS_METADATA_OPERATION = "getRawEISMetaData";
    public static final String PORT_TYPE_SELECTION_PART = "portTypeSelection";
    public static final String RESULT_PART = "result";
    public static final String QUERY_STRING_PART = "queryString";

    public Import() {
    }

    public Import(Definition definition, String string) throws WSIFException {
        try {
            this.serviceDefintion = definition;
            this.importPortType = this.serviceDefintion.getPortType(new QName(IMPORT_SERVICE_BASE_NAMESPACE, IMPORT_SERVICE_BASE_PORTTYPE_NAME));
            this.importService = this.serviceDefintion.getService(new QName(this.serviceDefintion.getTargetNamespace(), string));
        }
        catch (Exception exception) {
            if (exception instanceof WSIFException) {
                throw (WSIFException)exception;
            }
            throw new WSIFException(exception.getMessage(), exception);
        }
    }

    public PortTypeArray getPortTypes(String string) throws WSIFException {
        try {
            WSIFService wSIFService = WSIFServiceFactory.newInstance().getService(this.serviceDefintion, this.importService, this.importPortType);
            WSIFPort wSIFPort = wSIFService.getPort();
            WSIFOperation wSIFOperation = wSIFPort.createOperation(GET_PORTTYPES_OPERATION);
            WSIFMessage wSIFMessage = wSIFOperation.createInputMessage();
            WSIFMessage wSIFMessage2 = wSIFOperation.createOutputMessage();
            wSIFMessage.setObjectPart(QUERY_STRING_PART, string);
            wSIFOperation.executeRequestResponseOperation(wSIFMessage, wSIFMessage2, null);
            PortTypeArray portTypeArray = (PortTypeArray)wSIFMessage2.getObjectPart(RESULT_PART);
            wSIFPort.close();
            return portTypeArray;
        }
        catch (Exception exception) {
            if (exception instanceof WSIFException) {
                throw (WSIFException)exception;
            }
            throw new WSIFException(exception.getMessage(), exception);
        }
    }

    public ImportDefinition getDefinition(PortTypeSelection portTypeSelection) throws WSIFException {
        try {
            WSIFService wSIFService = WSIFServiceFactory.newInstance().getService(this.serviceDefintion, this.importService, this.importPortType);
            WSIFPort wSIFPort = wSIFService.getPort();
            WSIFOperation wSIFOperation = wSIFPort.createOperation(GET_DEFINITION_OPERATION);
            WSIFMessage wSIFMessage = wSIFOperation.createInputMessage();
            WSIFMessage wSIFMessage2 = wSIFOperation.createOutputMessage();
            wSIFMessage.setObjectPart(PORT_TYPE_SELECTION_PART, portTypeSelection);
            wSIFOperation.executeRequestResponseOperation(wSIFMessage, wSIFMessage2, null);
            ImportDefinition importDefinition = (ImportDefinition)wSIFMessage2.getObjectPart(RESULT_PART);
            wSIFPort.close();
            return importDefinition;
        }
        catch (Exception exception) {
            if (exception instanceof WSIFException) {
                throw (WSIFException)exception;
            }
            throw new WSIFException(exception.getMessage(), exception);
        }
    }

    public byte[] getRawEISMetaData(String string) throws WSIFException {
        try {
            WSIFService wSIFService = WSIFServiceFactory.newInstance().getService(this.serviceDefintion, this.importService, this.importPortType);
            WSIFPort wSIFPort = wSIFService.getPort();
            WSIFOperation wSIFOperation = wSIFPort.createOperation(GET_RAW_EIS_METADATA_OPERATION);
            WSIFMessage wSIFMessage = wSIFOperation.createInputMessage();
            WSIFMessage wSIFMessage2 = wSIFOperation.createOutputMessage();
            wSIFMessage.setObjectPart(QUERY_STRING_PART, string);
            wSIFOperation.executeRequestResponseOperation(wSIFMessage, wSIFMessage2, null);
            byte[] byArray = (byte[])wSIFMessage2.getObjectPart(RESULT_PART);
            wSIFPort.close();
            return byArray;
        }
        catch (Exception exception) {
            if (exception instanceof WSIFException) {
                throw (WSIFException)exception;
            }
            throw new WSIFException(exception.getMessage(), exception);
        }
    }

    public PortType getImportPortType() {
        return this.importPortType;
    }

    public Service getImportService() {
        return this.importService;
    }

    public Definition getServiceDefintion() {
        return this.serviceDefintion;
    }

    public void setImportPortType(PortType portType) {
        this.importPortType = portType;
    }

    public void setImportService(Service service) {
        this.importService = service;
    }

    public void setServiceDefintion(Definition definition) {
        this.serviceDefintion = definition;
    }
}

