/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers.jms;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.WSIFRequest;
import org.apache.wsif.WSIFResponse;
import org.apache.wsif.format.WSIFFormatter;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.jms.JMSMessage;
import org.apache.wsif.util.WSIFUtils;
import org.apache.wsif.wsdl.extensions.jms.JMSFault;
import org.apache.wsif.wsdl.extensions.jms.JMSFaultIndicator;
import org.apache.wsif.wsdl.extensions.jms.JMSFaultProperty;
import org.apache.wsif.wsdl.extensions.jms.JMSInput;
import org.apache.wsif.wsdl.extensions.jms.JMSOutput;

public class JMSFormatter
implements WSIFFormatter,
Serializable {
    private static final long serialVersionUID = 1L;
    private Definition fieldDefinition;
    private Port fieldPort;
    private String reqOpName;
    private String reqInputName;
    private String reqOutputName;
    private BindingFault lastBindingFault = null;

    public JMSFormatter(Definition def, Port port2) {
        Trc.entry(this, def, port2);
        this.fieldDefinition = def;
        this.fieldPort = port2;
        Trc.exit();
    }

    public void formatRequest(WSIFRequest req, OutputStream out) {
        Trc.entry((Object)this, req);
        Trc.exit();
    }

    public WSIFRequest unformatRequest(InputStream in) {
        Trc.entry(this);
        Trc.exit();
        return null;
    }

    public void formatResponse(WSIFResponse resp, OutputStream out) {
        Trc.entry((Object)this, resp);
        Trc.exit();
    }

    public WSIFResponse unformatResponse(InputStream in) {
        Trc.entry(this);
        Trc.exit();
        return null;
    }

    public void formatRequest(WSIFRequest req, javax.jms.Message out) throws WSIFException {
        Trc.entry(this, req, out);
        Binding binding = this.fieldPort.getBinding();
        BindingOperation bop = binding.getBindingOperation(req.getOperationName(), req.getInputName(), req.getOutputName());
        Message inMessage = bop.getOperation().getInput().getMessage();
        JMSMessage fhMsg = new JMSMessage(this.fieldDefinition, binding, inMessage, this.getInputParts(bop));
        this.copyTo(req.getIncomingMessage(), fhMsg);
        fhMsg.write(out);
        this.setOperationName(req.getOperationName());
        this.setInputName(req.getInputName());
        this.setOutputName(req.getOutputName());
        Trc.exit();
    }

    public WSIFRequest unformatRequest(javax.jms.Message in) throws WSIFException {
        Trc.entry((Object)this, in);
        WSIFRequest req = this.createRequest(in);
        Binding binding = this.fieldPort.getBinding();
        BindingOperation bop = binding.getBindingOperation(req.getOperationName(), req.getInputName(), req.getOutputName());
        Message inMessage = bop.getOperation().getInput().getMessage();
        JMSMessage fhMsg = new JMSMessage(this.fieldDefinition, binding, inMessage, this.getInputParts(bop));
        fhMsg.read(in);
        req.setIncomingMessage(fhMsg);
        Trc.exit(req);
        return req;
    }

    protected WSIFRequest createRequest(javax.jms.Message msg) throws WSIFException {
        List operations;
        Trc.entry((Object)this, msg);
        QName serviceName = null;
        String operationName = null;
        String input = null;
        String output = null;
        Binding fieldBinding = this.fieldPort.getBinding();
        if (fieldBinding == null) {
            throw new WSIFException("Unable to locate Binding");
        }
        Map sm = WSIFUtils.getAllItems(this.fieldDefinition, "Service");
        Iterator services = sm.values().iterator();
        block2: while (services.hasNext() && serviceName == null) {
            Service s = (Service)services.next();
            Iterator ports = s.getPorts().values().iterator();
            while (ports.hasNext()) {
                Port p = (Port)ports.next();
                if (p.getBinding() == null || !p.getBinding().getQName().equals(fieldBinding.getQName())) continue;
                serviceName = s.getQName();
                continue block2;
            }
        }
        if (serviceName == null) {
            throw new WSIFException("Unable to locate Service");
        }
        PortType portType = fieldBinding.getPortType();
        if (portType != null && (operations = portType.getOperations()) != null && operations.size() == 1) {
            Operation o = (Operation)operations.get(0);
            operationName = o.getName();
            if (o.getInput() != null) {
                input = o.getInput().getName();
            }
            if (o.getOutput() != null) {
                output = o.getOutput().getName();
            }
        }
        if (operationName == null) {
            try {
                operationName = msg.getStringProperty("WSDLOperation");
                input = msg.getStringProperty("WSDLInput");
                output = msg.getStringProperty("WSDLOutput");
            }
            catch (JMSException e2) {
                Trc.exception(e2);
            }
        }
        if (operationName == null) {
            throw new WSIFException("Unable to determine Operation");
        }
        WSIFRequest request = new WSIFRequest(serviceName);
        request.setPortName(this.fieldPort.getName());
        request.setOperationName(operationName);
        request.setInputName(input);
        request.setOutputName(output);
        Trc.exit(request);
        return request;
    }

    protected WSIFResponse createResponse(javax.jms.Message msg) throws WSIFException {
        List operations;
        PortType portType;
        Trc.entry((Object)this, msg);
        QName serviceName = null;
        String operationName = null;
        String input = null;
        String output = null;
        Binding fieldBinding = this.fieldPort.getBinding();
        if (fieldBinding == null) {
            throw new WSIFException("Unable to locate Binding");
        }
        Map sm = WSIFUtils.getAllItems(this.fieldDefinition, "Service");
        Iterator services = sm.values().iterator();
        block0: while (services.hasNext() && serviceName == null) {
            Service s = (Service)services.next();
            Iterator ports = s.getPorts().values().iterator();
            while (ports.hasNext()) {
                Port p = (Port)ports.next();
                if (p.getBinding() == null || !p.getBinding().getQName().equals(fieldBinding.getQName())) continue;
                serviceName = s.getQName();
                continue block0;
            }
        }
        if (serviceName == null) {
            throw new WSIFException("Unable to locate Service");
        }
        operationName = this.getOperationName();
        input = this.getInputName();
        output = this.getOutputName();
        if ((operationName == null || operationName.equals("")) && (portType = fieldBinding.getPortType()) != null && (operations = portType.getOperations()) != null) {
            if (operations.size() == 1) {
                Operation o = (Operation)operations.get(0);
                operationName = o.getName();
                if (o.getInput() != null) {
                    input = o.getInput().getName();
                }
                if (o.getOutput() != null) {
                    output = o.getOutput().getName();
                }
            } else {
                throw new WSIFException("Port Type definition contains multiple operations.");
            }
        }
        if (operationName == null) {
            throw new WSIFException("Unable to locate Operation");
        }
        WSIFResponse response = new WSIFResponse(serviceName);
        response.setPortName(this.fieldPort.getName());
        response.setOperationName(operationName);
        response.setInputName(input);
        response.setOutputName(output);
        Trc.exit(response);
        return response;
    }

    public void formatResponse(WSIFResponse resp, javax.jms.Message out) throws WSIFException {
        Trc.entry(this, resp, out);
        Binding binding = this.fieldPort.getBinding();
        BindingOperation bop = binding.getBindingOperation(resp.getOperationName(), resp.getInputName(), resp.getOutputName());
        Message outMessage = bop.getOperation().getOutput().getMessage();
        JMSMessage fhMsg = new JMSMessage(this.fieldDefinition, binding, outMessage, this.getOutputParts(bop));
        this.copyTo(resp.getOutgoingMessage(), fhMsg);
        fhMsg.write(out);
        this.setOperationName(resp.getOperationName());
        this.setInputName(resp.getInputName());
        this.setOutputName(resp.getOutputName());
        Trc.exit();
    }

    public WSIFResponse unformatResponse(javax.jms.Message out) throws WSIFException {
        Trc.entry((Object)this, out);
        WSIFResponse resp = this.createResponse(out);
        Binding binding = this.fieldPort.getBinding();
        BindingOperation bop = binding.getBindingOperation(resp.getOperationName(), resp.getInputName(), resp.getOutputName());
        if (this.unformatResponseFault(resp, out, binding, bop)) {
            Trc.exit(resp);
            return resp;
        }
        Operation op = bop.getOperation();
        Output output = op.getOutput();
        if (output != null) {
            Message outMessage = output.getMessage();
            JMSMessage fhMsg = new JMSMessage(this.fieldDefinition, binding, outMessage, this.getOutputParts(bop));
            fhMsg.read(out);
            resp.setOutgoingMessage(fhMsg);
        }
        Trc.exit(resp);
        return resp;
    }

    private boolean unformatResponseFault(WSIFResponse resp, javax.jms.Message out, Binding binding, BindingOperation bop) throws WSIFException {
        Trc.entry(this, resp, out, binding, bop);
        Map bndFs = bop.getBindingFaults();
        if (bndFs != null && !bndFs.isEmpty()) {
            Iterator itBndFNames = bndFs.keySet().iterator();
            while (itBndFNames.hasNext()) {
                String bndFName = (String)itBndFNames.next();
                BindingFault bndF = (BindingFault)bndFs.get(bndFName);
                List bndFElems = bndF.getExtensibilityElements();
                if (bndFElems == null || bndFElems.isEmpty()) continue;
                Iterator itBndFElems = bndFElems.iterator();
                while (itBndFElems.hasNext()) {
                    JMSFaultIndicator indic;
                    Object bndFElem = itBndFElems.next();
                    if (!(bndFElem instanceof JMSFaultIndicator) || !this.matchesFaultIndicator(indic = (JMSFaultIndicator)bndFElem, out)) continue;
                    WSIFMessage msg = this.unformatFaultMessage(out, binding, bop, bndFName, bndF);
                    resp.setOutgoingMessage(msg);
                    resp.setIsFault(true);
                    this.lastBindingFault = bndF;
                    Trc.exit(true);
                    return true;
                }
            }
        }
        Trc.exit(false);
        return false;
    }

    private boolean matchesFaultIndicator(JMSFaultIndicator indic, javax.jms.Message out) {
        Trc.entry(this, indic, out);
        String type = indic.getType();
        if (type == null || !"property".equals(type)) {
            Trc.exit(false);
            return false;
        }
        List fProps = indic.getJMSFaultProperties();
        if (fProps == null || fProps.isEmpty()) {
            Trc.exit(false);
            return false;
        }
        Iterator itFProps = fProps.iterator();
        while (itFProps.hasNext()) {
            JMSFaultProperty fProp = (JMSFaultProperty)itFProps.next();
            String propName = fProp.getName();
            if (propName == null || fProp.getType() == null || fProp.getValue() == null) continue;
            Object propValue = null;
            try {
                if (!out.propertyExists(propName)) continue;
                propValue = out.getObjectProperty(propName);
            }
            catch (JMSException je) {
                Trc.ignoredException(je);
                continue;
            }
            if (propValue == null || !fProp.getValue().equals(propValue.toString())) continue;
            Trc.exit(true);
            return true;
        }
        Trc.exit(false);
        return false;
    }

    private WSIFMessage unformatFaultMessage(javax.jms.Message out, Binding binding, BindingOperation bop, String bndFName, BindingFault bndF) throws WSIFException {
        Trc.entry(this, out, binding, bop, bndFName, bndF);
        Operation op = bop.getOperation();
        Fault fault2 = op.getFault(bndFName);
        if (fault2 == null) {
            throw new WSIFException("No fault " + bndFName + " found in operation " + op.getName());
        }
        JMSMessage fhMsg = new JMSMessage(this.fieldDefinition, binding, fault2.getMessage(), this.getFaultParts(bndF));
        fhMsg.read(out);
        Trc.exit(fhMsg);
        return fhMsg;
    }

    void copyTo(WSIFMessage source, WSIFMessage target) throws WSIFException {
        if (source == null || target == null) {
            return;
        }
        Iterator i = source.getPartNames();
        while (i.hasNext()) {
            String partName = i.next().toString();
            target.setObjectPart(partName, source.getObjectPart(partName));
        }
    }

    private List getInputParts(BindingOperation bindingOperation) {
        if (bindingOperation.getBindingInput() != null) {
            Iterator inputIterator = bindingOperation.getBindingInput().getExtensibilityElements().iterator();
            while (inputIterator.hasNext()) {
                ExtensibilityElement ele = (ExtensibilityElement)inputIterator.next();
                if (!(ele instanceof JMSInput)) continue;
                return ((JMSInput)ele).getParts();
            }
        }
        return null;
    }

    private List getOutputParts(BindingOperation bindingOperation) {
        if (bindingOperation.getBindingOutput() != null) {
            Iterator outputIterator = bindingOperation.getBindingOutput().getExtensibilityElements().iterator();
            while (outputIterator.hasNext()) {
                ExtensibilityElement ele = (ExtensibilityElement)outputIterator.next();
                if (!(ele instanceof JMSOutput)) continue;
                return ((JMSOutput)ele).getParts();
            }
        }
        return null;
    }

    private List getFaultParts(BindingFault bindingFault) {
        Trc.entry((Object)this, bindingFault);
        List list = null;
        if (bindingFault != null) {
            Iterator it = bindingFault.getExtensibilityElements().iterator();
            while (it.hasNext()) {
                Object ele = it.next();
                if (!(ele instanceof JMSFault)) continue;
                list = ((JMSFault)ele).getParts();
                break;
            }
        }
        Trc.exit(list);
        return list;
    }

    public String getOperationName() {
        return this.reqOpName;
    }

    public void setOperationName(String s) {
        this.reqOpName = s;
    }

    public String getInputName() {
        return this.reqInputName;
    }

    private void setInputName(String s) {
        this.reqInputName = s;
    }

    public String getOutputName() {
        return this.reqOutputName;
    }

    private void setOutputName(String s) {
        this.reqOutputName = s;
    }

    public BindingFault getLastBindingFault() {
        Trc.entry(this);
        Trc.exit(this.lastBindingFault);
        return this.lastBindingFault;
    }

    public Definition getDefinition() {
        return this.fieldDefinition;
    }

    public Port getPort() {
        return this.fieldPort;
    }
}

