/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Part;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.wsif.WSIFException;
import org.apache.wsif.base.WSIFDefaultMessage;
import org.apache.wsif.format.jms.JMSFormatHandler;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.jms.PrimitiveTypeFormatHandler;
import org.apache.wsif.util.WSIFUtils;
import org.apache.wsif.wsdl.extensions.format.TypeMapping;
import org.apache.wsif.wsdl.extensions.jms.JMSBinding;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.TextSerializer;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class JMSMessage
extends WSIFDefaultMessage {
    private static final long serialVersionUID = 1L;
    private static String XML_ENCODING = "XML";
    private static String JAVA_ENCODING = "Java";
    static String XML_SCHEMA_1999 = "http://www.w3.org/1999/XMLSchema";
    static String XML_SCHEMA_2000_10 = "http://www.w3.org/2000/10/XMLSchema";
    static String XML_SCHEMA_2001 = "http://www.w3.org/2001/XMLSchema";
    static final HashMap PRIMITIVE_JAVA_MAPPING = new HashMap();
    private Definition fieldDefinitionModel;
    private Binding fieldBindingModel;
    private javax.wsdl.Message fieldMessageModel;
    private List fieldMessageParts;

    public JMSMessage(Definition definitionModel, Binding bindingModel, javax.wsdl.Message messageModel, List parts) {
        Trc.entry(this, definitionModel, bindingModel, messageModel, parts);
        this.fieldDefinitionModel = definitionModel;
        this.fieldBindingModel = bindingModel;
        this.fieldMessageModel = messageModel;
        this.fieldMessageParts = parts;
        Trc.exit();
    }

    public void write(Message message) throws WSIFException {
        Trc.entry((Object)this, message);
        if (!this.isCorrectMessageType(message)) {
            throw new WSIFException("Incorrect message type");
        }
        if (message instanceof TextMessage) {
            this.write((TextMessage)message);
        } else if (message instanceof ObjectMessage) {
            this.write((ObjectMessage)message);
        } else {
            throw new WSIFException("Unsupported Message Type: " + message.getClass().getName());
        }
        Trc.exit();
    }

    private void write(TextMessage message) throws WSIFException {
        Trc.entry((Object)this, message);
        if (!XML_ENCODING.equals(JMSMessage.getFormatEncoding(this.fieldBindingModel))) {
            throw new WSIFException("Unable to support non XML encodings in a JMS Text Message");
        }
        try {
            ArrayList al = new ArrayList();
            Iterator i = this.getPartNames();
            while (i.hasNext()) {
                al.add(i.next());
            }
            String[] partNames = al.toArray(new String[al.size()]);
            if (partNames.length == 1) {
                String partName = partNames[0];
                Part partModel = this.fieldMessageModel.getPart(partName);
                QName partQName = partModel.getElementName() != null ? partModel.getElementName() : partModel.getTypeName();
                JMSFormatHandler fh = this.getFormatHandler(partName);
                if (fh != null) {
                    fh.setPartQName(partQName);
                    fh.setObjectPart(this.parts.get(partName));
                    fh.write((Message)message);
                } else {
                    Object part = this.parts.get(partName);
                    message.setText(part.toString());
                }
            } else {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                OutputStreamWriter writer = new OutputStreamWriter(os);
                OutputFormat format = new OutputFormat();
                XMLSerializer serializer = new XMLSerializer((Writer)writer, format);
                String namespace = "";
                serializer.startDocument();
                serializer.startElement(namespace, this.fieldMessageModel.getQName().getLocalPart(), "", (Attributes)new AttributesImpl());
                for (int i2 = 0; i2 < partNames.length; ++i2) {
                    String partName = partNames[i2];
                    serializer.startElement(namespace, partName, "", (Attributes)new AttributesImpl());
                    Part partModel = this.fieldMessageModel.getPart(partName);
                    QName partQName = partModel.getElementName() != null ? partModel.getElementName() : partModel.getTypeName();
                    JMSFormatHandler fh = this.getFormatHandler(partName);
                    if (fh != null) {
                        fh.setPartQName(partQName);
                        fh.setObjectPart(this.parts.get(partName));
                        message.setText("");
                        fh.write((Message)message);
                        char[] c = message.getText().toCharArray();
                        serializer.characters(c, 0, c.length);
                    } else {
                        Object part = this.parts.get(partName);
                        char[] c = part.toString().toCharArray();
                        serializer.characters(c, 0, c.length);
                    }
                    serializer.endElement(partName);
                }
                serializer.endElement(this.fieldMessageModel.getQName().getLocalPart());
                serializer.endDocument();
                writer.flush();
                String msgContents = os.toString();
                message.setText(msgContents);
            }
            Trc.event(this, message.getText());
        }
        catch (JMSException e2) {
            Trc.exception(e2);
            throw new WSIFException("Error in write.", e2);
        }
        catch (IOException e3) {
            Trc.exception(e3);
            throw new WSIFException("Error in write.", e3);
        }
        catch (SAXException e4) {
            Trc.exception(e4);
            throw new WSIFException("Error in write.", e4);
        }
        Trc.exit();
    }

    private void write(ObjectMessage message) throws WSIFException {
        Trc.entry((Object)this, message);
        if (!JAVA_ENCODING.equals(JMSMessage.getFormatEncoding(this.fieldBindingModel))) {
            throw new WSIFException("Unable to support non Java encodings in a JMS Object Message");
        }
        try {
            ArrayList al = new ArrayList();
            Iterator i = this.getPartNames();
            while (i.hasNext()) {
                al.add(i.next());
            }
            String[] partNames = al.toArray(new String[al.size()]);
            if (partNames.length == 1) {
                String partName = partNames[0];
                Part partModel = this.fieldMessageModel.getPart(partName);
                QName partQName = partModel.getElementName() != null ? partModel.getElementName() : partModel.getTypeName();
                JMSFormatHandler fh = this.getFormatHandler(partName);
                if (fh != null) {
                    fh.setPartQName(partQName);
                    fh.setObjectPart(this.parts.get(partName));
                    fh.write((Message)message);
                } else {
                    Object part = this.parts.get(partName);
                    try {
                        message.setObject((Serializable)part);
                    }
                    catch (ClassCastException e2) {
                        Trc.exception(e2);
                        throw new WSIFException("Unable to serialize a part");
                    }
                }
            } else {
                HashMap<String, Serializable> result = new HashMap<String, Serializable>();
                for (int i2 = 0; i2 < partNames.length; ++i2) {
                    String partName = partNames[i2];
                    Part partModel = this.fieldMessageModel.getPart(partName);
                    QName partQName = partModel.getElementName() != null ? partModel.getElementName() : partModel.getTypeName();
                    JMSFormatHandler fh = this.getFormatHandler(partName);
                    if (fh != null) {
                        fh.setPartQName(partQName);
                        fh.setObjectPart(this.parts.get(partName));
                        fh.write((Message)message);
                        result.put(partName, message.getObject());
                        continue;
                    }
                    Object part = this.parts.get(partName);
                    try {
                        result.put(partName, (Serializable)part);
                        continue;
                    }
                    catch (ClassCastException e3) {
                        Trc.exception(e3);
                        throw new WSIFException("Unable to serialize a part");
                    }
                }
                message.setObject(result);
            }
            Trc.event(this, message.getObject());
        }
        catch (JMSException e4) {
            Trc.exception(e4);
            throw new WSIFException("Error in write.", e4);
        }
        Trc.exit();
    }

    public void read(Message message) throws WSIFException {
        Trc.entry((Object)this, message);
        if (!this.isCorrectMessageType(message)) {
            throw new WSIFException("Incorrect message type");
        }
        if (message instanceof TextMessage) {
            this.read((TextMessage)message);
        } else if (message instanceof ObjectMessage) {
            this.read((ObjectMessage)message);
        } else {
            throw new WSIFException("Unsupported Message Type: " + message.getClass().getName());
        }
        Trc.exit();
    }

    private void read(TextMessage message) throws WSIFException {
        Object[] partNames;
        Trc.entry((Object)this, message);
        if (!XML_ENCODING.equals(JMSMessage.getFormatEncoding(this.fieldBindingModel))) {
            throw new WSIFException("Unable to support non XML encodings in a JMS Text Message");
        }
        boolean wsifFormat = false;
        Object[] objectArray = partNames = this.fieldMessageParts != null ? this.fieldMessageParts.toArray() : this.fieldMessageModel.getParts().keySet().toArray();
        if (partNames.length > 1) {
            try {
                Trc.event(this, Integer.toString(partNames.length), message.getText());
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setValidating(false);
                DocumentBuilder builder = factory.newDocumentBuilder();
                builder.setErrorHandler(null);
                String text = message.getText();
                ByteArrayInputStream is = new ByteArrayInputStream(text.getBytes());
                Document doc = builder.parse(is);
                if (this.fieldMessageModel.getQName().getLocalPart().equals(doc.getDocumentElement().getLocalName())) {
                    wsifFormat = true;
                    message.clearBody();
                    for (Node n = doc.getDocumentElement().getFirstChild(); n != null; n = n.getNextSibling()) {
                        QName partQName;
                        if (n.getNodeType() != 1) continue;
                        String partName = n.getLocalName();
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        OutputFormat format = new OutputFormat();
                        TextSerializer serializer = new TextSerializer();
                        serializer.setOutputFormat(format);
                        serializer.setOutputByteStream((OutputStream)os);
                        format.setOmitXMLDeclaration(true);
                        serializer.serialize((Element)n);
                        os.flush();
                        String partText = os.toString();
                        Part partModel = this.fieldMessageModel.getPart(partName);
                        JMSFormatHandler fh = this.getFormatHandler(partName);
                        QName qName = partQName = partModel.getElementName() != null ? partModel.getElementName() : partModel.getTypeName();
                        if (fh != null) {
                            fh.setPartQName(partQName);
                            message.setText(partText);
                            fh.read((Message)message);
                            this.setObjectPart(partName, fh.getObjectPart());
                            continue;
                        }
                        this.setObjectPart(partName, partText);
                    }
                    message.setText(text);
                }
            }
            catch (JMSException e2) {
                Trc.exception(e2);
                throw new WSIFException("Error in read.", e2);
            }
            catch (ParserConfigurationException e3) {
                Trc.exception(e3);
                throw new WSIFException("Error in read.", e3);
            }
            catch (Exception e4) {
                Trc.exception(e4);
            }
        }
        try {
            if (!wsifFormat) {
                QName partQName;
                Trc.event(this, Integer.toString(partNames.length), message.getText());
                if (partNames.length != 1) {
                    throw new WSIFException("There should only be one part defined in " + this.fieldMessageModel.getQName().getLocalPart());
                }
                String partName = partNames[0].toString();
                Part partModel = this.fieldMessageModel.getPart(partName);
                JMSFormatHandler fh = this.getFormatHandler(partName);
                QName qName = partQName = partModel.getElementName() != null ? partModel.getElementName() : partModel.getTypeName();
                if (fh != null) {
                    fh.setPartQName(partQName);
                    fh.read((Message)message);
                    this.setObjectPart(partName, fh.getObjectPart());
                } else {
                    this.setObjectPart(partName, message.getText());
                }
            }
        }
        catch (JMSException e5) {
            Trc.exception(e5);
            throw new WSIFException("Error in read.", e5);
        }
        Trc.exit();
    }

    private void read(ObjectMessage message) throws WSIFException {
        Trc.entry((Object)this, message);
        if (!JAVA_ENCODING.equals(JMSMessage.getFormatEncoding(this.fieldBindingModel))) {
            throw new WSIFException("Unable to support non Java encodings in a JMS Object Message");
        }
        try {
            Object[] partNames;
            Trc.event(this, message.getObject());
            Serializable object = message.getObject();
            Object[] objectArray = partNames = this.fieldMessageParts != null ? this.fieldMessageParts.toArray() : this.fieldMessageModel.getParts().keySet().toArray();
            if (partNames.length == 0) {
                return;
            }
            if (object instanceof Map) {
                message.clearBody();
                Map map = (Map)((Object)object);
                for (int i = 0; i < partNames.length; ++i) {
                    QName partQName;
                    String partName = partNames[i].toString();
                    if (!map.containsKey(partName)) continue;
                    Part partModel = this.fieldMessageModel.getPart(partName);
                    JMSFormatHandler fh = this.getFormatHandler(partName);
                    QName qName = partQName = partModel.getElementName() != null ? partModel.getElementName() : partModel.getTypeName();
                    if (fh != null) {
                        fh.setPartQName(partQName);
                        message.setObject((Serializable)map.get(partName));
                        fh.read((Message)message);
                        this.setObjectPart(partName, fh.getObjectPart());
                        continue;
                    }
                    this.setObjectPart(partName, map.get(partName));
                }
                message.setObject(object);
            } else {
                QName partQName;
                if (partNames.length != 1) {
                    throw new WSIFException("There should only be one part defined in " + this.fieldMessageModel.getQName().getLocalPart() + " or the JMS ObjectMessage should be a Map of " + "all the parts in the message");
                }
                String partName = partNames[0].toString();
                Part partModel = this.fieldMessageModel.getPart(partName);
                JMSFormatHandler fh = this.getFormatHandler(partName);
                QName qName = partQName = partModel.getElementName() != null ? partModel.getElementName() : partModel.getTypeName();
                if (fh != null) {
                    fh.setPartQName(partQName);
                    fh.read((Message)message);
                    this.setObjectPart(partName, fh.getObjectPart());
                } else {
                    this.setObjectPart(partName, message.getObject());
                }
            }
        }
        catch (JMSException e2) {
            Trc.exception(e2);
            throw new WSIFException("Error in read.", e2);
        }
        Trc.exit();
    }

    private static String getFormatEncoding(Binding bindingModel) {
        Trc.entry(null, bindingModel);
        Iterator iterator = bindingModel.getExtensibilityElements().iterator();
        while (iterator.hasNext()) {
            ExtensibilityElement ee = (ExtensibilityElement)iterator.next();
            if (!(ee instanceof TypeMapping)) continue;
            TypeMapping typeMapping = (TypeMapping)ee;
            String s = typeMapping.getEncoding();
            Trc.exit(s);
            return s;
        }
        Trc.exit(null);
        return null;
    }

    private JMSFormatHandler getFormatHandler(String partName) {
        Trc.entry((Object)this, partName);
        Part partModel = this.fieldMessageModel.getPart(partName);
        JMSFormatHandler fh = null;
        QName partType = partModel.getTypeName();
        if (partType == null) {
            partType = partModel.getElementName();
        }
        try {
            fh = JMSMessage.isSchemaNamespace(partType.getNamespaceURI()) && JMSMessage.isXSDPrimitiveType(partType.getLocalPart()) ? new PrimitiveTypeFormatHandler((Class)PRIMITIVE_JAVA_MAPPING.get(partType.getLocalPart().toLowerCase())) : (JMSFormatHandler)WSIFUtils.getFormatHandler(partModel, this.fieldDefinitionModel, this.fieldBindingModel);
        }
        catch (Exception e2) {
            Trc.exception(e2);
        }
        Trc.exit(fh);
        return fh;
    }

    static boolean isSchemaNamespace(String namespaceURI) {
        return XML_SCHEMA_1999.equals(namespaceURI) || XML_SCHEMA_2000_10.equals(namespaceURI) || XML_SCHEMA_2001.equals(namespaceURI);
    }

    static boolean isXSDPrimitiveType(String type) {
        Trc.entry(null, type);
        Object[] types = PRIMITIVE_JAVA_MAPPING.keySet().toArray();
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].toString().equalsIgnoreCase(type)) continue;
            Trc.exit(true);
            return true;
        }
        Trc.exit(false);
        return false;
    }

    private int getMessageType() {
        Trc.entry(this);
        Iterator iterator = this.fieldBindingModel.getExtensibilityElements().iterator();
        while (iterator.hasNext()) {
            ExtensibilityElement ee = (ExtensibilityElement)iterator.next();
            if (!(ee instanceof JMSBinding)) continue;
            JMSBinding jmsBinding = (JMSBinding)ee;
            int type = jmsBinding.getJmsMessageType();
            Trc.exit(type);
            return type;
        }
        int type = 0;
        Trc.exit(type);
        return type;
    }

    private boolean isCorrectMessageType(Message message) {
        Trc.entry((Object)this, message);
        int type = this.getMessageType();
        boolean result = message instanceof TextMessage && type == 50 || message instanceof ObjectMessage && type == 30 || message instanceof StreamMessage && type == 40 || message instanceof BytesMessage && type == 10 || message instanceof MapMessage && type == 20;
        Trc.exit(result);
        return result;
    }

    static {
        PRIMITIVE_JAVA_MAPPING.put("anySimpleType", String.class);
        PRIMITIVE_JAVA_MAPPING.put("anyURI", String.class);
        PRIMITIVE_JAVA_MAPPING.put("base64Binary", [B.class);
        PRIMITIVE_JAVA_MAPPING.put("boolean", Boolean.class);
        PRIMITIVE_JAVA_MAPPING.put("byte", Byte.class);
        PRIMITIVE_JAVA_MAPPING.put("date", GregorianCalendar.class);
        PRIMITIVE_JAVA_MAPPING.put("dateTime", Date.class);
        PRIMITIVE_JAVA_MAPPING.put("decimal", BigDecimal.class);
        PRIMITIVE_JAVA_MAPPING.put("double", Double.class);
        PRIMITIVE_JAVA_MAPPING.put("duration", String.class);
        PRIMITIVE_JAVA_MAPPING.put("ENTITIES", String.class);
        PRIMITIVE_JAVA_MAPPING.put("ENTITY", String.class);
        PRIMITIVE_JAVA_MAPPING.put("float", Float.class);
        PRIMITIVE_JAVA_MAPPING.put("gDay", String.class);
        PRIMITIVE_JAVA_MAPPING.put("gMonth", String.class);
        PRIMITIVE_JAVA_MAPPING.put("gMonthDay", String.class);
        PRIMITIVE_JAVA_MAPPING.put("gYear", String.class);
        PRIMITIVE_JAVA_MAPPING.put("gYearMonth", String.class);
        PRIMITIVE_JAVA_MAPPING.put("hexBinary", [B.class);
        PRIMITIVE_JAVA_MAPPING.put("ID", String.class);
        PRIMITIVE_JAVA_MAPPING.put("IDREF", String.class);
        PRIMITIVE_JAVA_MAPPING.put("IDREFS", String.class);
        PRIMITIVE_JAVA_MAPPING.put("int", Integer.class);
        PRIMITIVE_JAVA_MAPPING.put("integer", BigInteger.class);
        PRIMITIVE_JAVA_MAPPING.put("language", String.class);
        PRIMITIVE_JAVA_MAPPING.put("long", Long.class);
        PRIMITIVE_JAVA_MAPPING.put("Name", String.class);
        PRIMITIVE_JAVA_MAPPING.put("NCName", String.class);
        PRIMITIVE_JAVA_MAPPING.put("negativeInteger", BigInteger.class);
        PRIMITIVE_JAVA_MAPPING.put("NMTOKEN", String.class);
        PRIMITIVE_JAVA_MAPPING.put("NMTOKENS", String.class);
        PRIMITIVE_JAVA_MAPPING.put("nonNegativeInteger", BigInteger.class);
        PRIMITIVE_JAVA_MAPPING.put("nonPositiveInteger", BigInteger.class);
        PRIMITIVE_JAVA_MAPPING.put("normalizedString", String.class);
        PRIMITIVE_JAVA_MAPPING.put("NOTATION", String.class);
        PRIMITIVE_JAVA_MAPPING.put("positiveInteger", BigInteger.class);
        PRIMITIVE_JAVA_MAPPING.put("QName", QName.class);
        PRIMITIVE_JAVA_MAPPING.put("short", Short.class);
        PRIMITIVE_JAVA_MAPPING.put("string", String.class);
        PRIMITIVE_JAVA_MAPPING.put("time", String.class);
        PRIMITIVE_JAVA_MAPPING.put("token", String.class);
        PRIMITIVE_JAVA_MAPPING.put("unsignedByte", Short.class);
        PRIMITIVE_JAVA_MAPPING.put("unsignedInt", Long.class);
        PRIMITIVE_JAVA_MAPPING.put("unsignedLong", BigInteger.class);
        PRIMITIVE_JAVA_MAPPING.put("unsignedShort", Integer.class);
    }
}

