/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers.jms;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.Message;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import org.apache.wsif.WSIFCorrelationId;
import org.apache.wsif.WSIFCorrelationService;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.WSIFOperation;
import org.apache.wsif.WSIFPort;
import org.apache.wsif.WSIFRequest;
import org.apache.wsif.WSIFResponse;
import org.apache.wsif.WSIFResponseHandler;
import org.apache.wsif.base.WSIFDefaultOperation;
import org.apache.wsif.logging.MessageLogger;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.WSIFTransactionControl;
import org.apache.wsif.providers.jms.JMSFormatter;
import org.apache.wsif.providers.jms.JMSMessage;
import org.apache.wsif.providers.jms.WSIFPort_Jms;
import org.apache.wsif.util.WSIFCorrelationServiceLocator;
import org.apache.wsif.util.WSIFProperties;
import org.apache.wsif.util.WSIFUtils;
import org.apache.wsif.util.jms.WSIFJMSCorrelationId;
import org.apache.wsif.util.jms.WSIFJMSDestination;
import org.apache.wsif.util.jms.WSIFJMSMessageProperties;
import org.apache.wsif.util.jms.WSIFJMSProperties;
import org.apache.wsif.wsdl.extensions.jms.JMSAddress;
import org.apache.wsif.wsdl.extensions.jms.JMSBinding;
import org.apache.wsif.wsdl.extensions.jms.JMSConstants;
import org.apache.wsif.wsdl.extensions.jms.JMSFaultIndicator;
import org.apache.wsif.wsdl.extensions.jms.JMSFaultProperty;
import org.apache.wsif.wsdl.extensions.jms.JMSInput;
import org.apache.wsif.wsdl.extensions.jms.JMSOutput;
import org.apache.wsif.wsdl.extensions.jms.JMSProperty;
import org.apache.wsif.wsdl.extensions.jms.JMSPropertyValue;

public class WSIFOperation_Jms
extends WSIFDefaultOperation
implements WSIFOperation {
    private static final long serialVersionUID = 1L;
    protected Port fieldBasePort;
    protected BindingOperation fieldBindingOperation;
    protected WSIFPort_Jms fieldJmsPort;
    protected Operation fieldOperation;
    private boolean inputOnlyOp = false;
    protected String fieldInputMessageName;
    protected HashMap fieldInputJmsPropertyValues;
    protected HashMap fieldInputJmsProperties;
    protected JMSInput fieldInput;
    protected String fieldOutputMessageName;
    protected HashMap fieldOutputProperties;
    protected JMSOutput fieldOutput;
    private WSIFResponseHandler handler;
    private boolean asyncOperation;
    private JMSFormatter formatter;
    private long syncTimeout;
    private long asyncTimeout;
    private transient WSIFTransactionControl transControl;

    public WSIFOperation_Jms(Port basePort, BindingOperation bindingOperation, WSIFPort_Jms jmsPort) throws WSIFException {
        String name2;
        Trc.entry(this, basePort, bindingOperation, jmsPort);
        this.fieldBasePort = basePort;
        this.fieldBindingOperation = bindingOperation;
        this.fieldJmsPort = jmsPort;
        this.syncTimeout = WSIFProperties.getSyncTimeout();
        this.asyncTimeout = WSIFProperties.getAsyncTimeout();
        String tName = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("wsif.transactioncontrol.impl");
            }
        });
        if (tName == null || "".equals(tName)) {
            tName = WSIFProperties.getProperty("wsif.transactioncontrol.impl");
        }
        if ((name2 = tName) != null) {
            Class clazz = (Class)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return Class.forName(name2, true, Thread.currentThread().getContextClassLoader());
                    }
                    catch (Throwable ignored) {
                        Trc.ignoredException(ignored);
                        return null;
                    }
                }
            });
            if (clazz != null) {
                try {
                    this.transControl = (WSIFTransactionControl)clazz.newInstance();
                }
                catch (Exception ignored) {
                    Trc.ignoredException(ignored);
                    this.transControl = null;
                }
            } else {
                this.transControl = null;
            }
        }
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    public WSIFOperation_Jms copy() throws WSIFException {
        Trc.entry(this);
        WSIFOperation_Jms woj = new WSIFOperation_Jms(this.fieldBasePort, this.fieldBindingOperation, this.fieldJmsPort);
        if (Trc.ON) {
            Trc.exit(woj.deep());
        }
        return woj;
    }

    public boolean executeRequestResponseOperation(WSIFMessage input, WSIFMessage output, WSIFMessage fault2) throws WSIFException {
        Trc.entry(this, input, output, fault2);
        this.close();
        if (!this.fieldJmsPort.supportsSync()) {
            throw new WSIFException("synchronous operations not available");
        }
        this.setAsyncOperation(false);
        boolean operationSucceeded = true;
        boolean txnSuspended = false;
        try {
            this.getOperation();
            if (this.transControl != null) {
                this.transControl.suspend();
                txnSuspended = true;
            }
            String correlId = this.sendJmsMessage(input);
            if (txnSuspended) {
                this.transControl.resume();
                txnSuspended = false;
            }
            WSIFJMSDestination jmsDest = this.fieldJmsPort.getJmsDestination();
            Message response = jmsDest.receive(correlId, this.syncTimeout);
            operationSucceeded = this.receiveJmsMessage(response, output, fault2);
        }
        catch (Exception ex) {
            Trc.exception(ex);
            MessageLogger.log("WSIF.0005E", "Jms", this.fieldBindingOperation.getName());
            throw new WSIFException(this + " : Could not invoke '" + this.fieldBindingOperation.getName() + "'", ex);
        }
        finally {
            if (txnSuspended) {
                this.transControl.resume();
            }
        }
        Trc.exit(operationSucceeded);
        return operationSucceeded;
    }

    public void executeInputOnlyOperation(WSIFMessage input) throws WSIFException {
        Trc.entry((Object)this, input);
        this.inputOnlyOp = true;
        this.executeRequestResponseAsync(input, null);
        Trc.exit();
    }

    public WSIFCorrelationId executeRequestResponseAsync(WSIFMessage input) throws WSIFException {
        return this.executeRequestResponseAsync(input, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WSIFCorrelationId executeRequestResponseAsync(WSIFMessage input, WSIFResponseHandler handler2) throws WSIFException {
        WSIFJMSCorrelationId correlId;
        block8: {
            Trc.entry(this, input, handler2);
            this.close();
            if (!this.fieldJmsPort.supportsAsync()) {
                throw new WSIFException("asynchronous operations not available");
            }
            this.setAsyncOperation(true);
            correlId = null;
            try {
                WSIFCorrelationService cs;
                this.getOperation();
                this.handler = handler2;
                if (this.inputOnlyOp) {
                    this.sendJmsMessage(input);
                    break block8;
                }
                if (handler2 == null) {
                    correlId = new WSIFJMSCorrelationId(this.sendJmsMessage(input));
                    break block8;
                }
                WSIFCorrelationService wSIFCorrelationService = cs = WSIFCorrelationServiceLocator.getCorrelationService();
                synchronized (wSIFCorrelationService) {
                    correlId = new WSIFJMSCorrelationId(this.sendJmsMessage(input));
                    cs.put(correlId, this, this.asyncTimeout);
                }
            }
            catch (Exception ex) {
                Trc.exception(ex);
                MessageLogger.log("WSIF.0005E", "Jms", this.fieldBindingOperation.getName());
                throw new WSIFException(this + " : Could not invoke '" + this.fieldBindingOperation.getName() + "'", ex);
            }
        }
        Trc.exit(correlId);
        return correlId;
    }

    public boolean processAsyncResponse(Object responseObject, WSIFMessage output, WSIFMessage fault2) throws WSIFException {
        Trc.entry(this, responseObject, output, fault2);
        boolean ok = false;
        try {
            this.getOperation();
            output.setName(this.fieldBindingOperation.getBindingOutput().getName());
            ok = this.receiveJmsMessage(responseObject, output, fault2);
        }
        catch (Exception ex) {
            Trc.exception(ex);
            MessageLogger.log("WSIF.0005E", "Jms", this.fieldBindingOperation.getName());
            throw new WSIFException(this + " : Could not invoke '" + this.fieldBindingOperation.getName() + "'", ex);
        }
        Trc.exit(ok);
        return ok;
    }

    public void fireAsyncResponse(Object response) throws WSIFException {
        Trc.entry((Object)this, response);
        WSIFMessage output = this.createOutputMessage();
        WSIFMessage fault2 = this.createFaultMessage();
        this.receiveJmsMessage(response, output, fault2);
        this.handler.executeAsyncResponse(output, fault2);
        Trc.exit();
    }

    private String sendJmsMessage(WSIFMessage input) throws WSIFException {
        String correlId = null;
        WSIFJMSDestination jmsDest = this.fieldJmsPort.getJmsDestination();
        this.setPropertyValues();
        ArrayList wsdlInputParts = this.getWSDLInputPartNames();
        HashMap propertyParts = this.getPropertyParts();
        WSIFMessage message = this.createInputMessage();
        Iterator i = input.getPartNames();
        while (i.hasNext()) {
            String partName = (String)i.next();
            if (propertyParts.containsKey(partName)) {
                Object value2;
                String name2 = (String)propertyParts.get(partName);
                if (this.timeoutProperty(name2, value2 = input.getObjectPart(partName))) continue;
                jmsDest.setProperty(name2, value2);
                continue;
            }
            if (!wsdlInputParts.contains(partName)) continue;
            wsdlInputParts.remove(partName);
            if (this.fieldInput == null) {
                message.setObjectPart(partName, input.getObjectPart(partName));
                continue;
            }
            if (!this.fieldInput.getParts().contains(partName)) continue;
            message.setObjectPart(partName, input.getObjectPart(partName));
        }
        i = wsdlInputParts.iterator();
        while (i.hasNext()) {
            message.setObjectPart((String)i.next(), null);
        }
        this.setDestinationContext();
        Service serviceModel = null;
        Definition def = this.fieldJmsPort.getDefinition();
        Map services = WSIFUtils.getAllItems(def, "Service");
        Port port2 = this.fieldJmsPort.getPortModel();
        Iterator i2 = services.values().iterator();
        while (i2.hasNext()) {
            Service s = (Service)i2.next();
            if (!s.getPorts().values().contains(port2)) continue;
            serviceModel = s;
            break;
        }
        if (serviceModel == null) {
            throw new WSIFException("cannot find service for port: " + port2);
        }
        this.formatter = (JMSFormatter)this.fieldJmsPort.getFormatter();
        WSIFRequest request = new WSIFRequest(serviceModel.getQName());
        request.setIncomingMessage(message);
        request.setOperationName(this.fieldOperation.getName());
        request.setPortName(this.fieldJmsPort.getPortModel().getName());
        request.setInputName(this.fieldBindingOperation.getBindingInput().getName());
        Message jmsMessage = jmsDest.createMessage(this.getJMSMessageType());
        this.formatter.formatRequest(request, jmsMessage);
        if (this.isAsyncOperation() && this.handler != null) {
            jmsDest.setAsyncMode(true);
        }
        correlId = jmsDest.send(jmsMessage, null, !this.inputOnlyOp);
        return correlId;
    }

    private boolean receiveJmsMessage(Object responseObject, WSIFMessage output, WSIFMessage fault2) throws WSIFException {
        WSIFResponse resp;
        Trc.entry(this, responseObject, output, fault2);
        if (!(responseObject instanceof Message)) {
            throw new WSIFException("Object is not of type javax.jms.Message");
        }
        WSIFJMSMessageProperties messageProps = new WSIFJMSMessageProperties();
        messageProps.setMessage((Message)responseObject);
        if (this.formatter == null) {
            this.formatter = (JMSFormatter)this.fieldJmsPort.getFormatter();
            this.formatter.setOperationName(this.fieldOperation.getName());
        }
        if ((resp = this.formatter.unformatResponse((Message)responseObject)).getIsFault()) {
            this.formatter.copyTo(resp.getOutgoingMessage(), fault2);
            this.setFaultProperties(fault2, this.formatter.getLastBindingFault(), messageProps);
            Trc.exit(false);
            return false;
        }
        ArrayList wsdlOutputParts = this.getWSDLOutputPartNames();
        WSIFMessage m = resp.getOutgoingMessage();
        if (m != null) {
            Iterator i = m.getPartNames();
            while (i.hasNext()) {
                String partName = (String)i.next();
                output.setObjectPart(partName, m.getObjectPart(partName));
                wsdlOutputParts.remove(partName);
            }
        }
        Iterator i = wsdlOutputParts.iterator();
        while (i.hasNext()) {
            output.setObjectPart((String)i.next(), null);
        }
        this.setOutProperties(output, messageProps);
        Trc.exit(true);
        return true;
    }

    private HashMap getPropertyParts() {
        HashMap propertyParts = new HashMap();
        if (this.fieldInputJmsProperties != null) {
            Iterator i = this.fieldInputJmsProperties.keySet().iterator();
            while (i.hasNext()) {
                String propertyName = (String)i.next();
                propertyParts.put(propertyName, this.fieldInputJmsProperties.get(propertyName));
            }
        }
        return propertyParts;
    }

    private void setPropertyValues() throws WSIFException {
        String value2;
        WSIFJMSDestination jmsDest = this.fieldJmsPort.getJmsDestination();
        try {
            value2 = this.fieldOperation.getName();
            if (value2 != null && value2.length() > 0) {
                jmsDest.setProperty("WSDLOperation", value2);
            }
        }
        catch (WSIFException ex) {
            Trc.ignoredException(ex);
        }
        try {
            BindingInput bi = this.fieldBindingOperation.getBindingInput();
            String string = value2 = bi == null ? null : bi.getName();
            if (value2 != null && value2.length() > 0) {
                jmsDest.setProperty("WSDLInput", value2);
            }
        }
        catch (WSIFException ex) {
            Trc.ignoredException(ex);
        }
        try {
            BindingOutput bo = this.fieldBindingOperation.getBindingOutput();
            String string = value2 = bo == null ? null : bo.getName();
            if (value2 != null && value2.length() > 0) {
                jmsDest.setProperty("WSDLOutput", value2);
            }
        }
        catch (WSIFException ex) {
            Trc.ignoredException(ex);
        }
        try {
            JMSAddress ja = this.fieldJmsPort.getObjectReference();
            if (ja != null) {
                this.setJMSPropertyValues(ja.getJMSPropertyValues());
            }
        }
        catch (WSIFException ex) {
            Trc.ignoredException(ex);
        }
        if (this.fieldInputJmsPropertyValues != null) {
            try {
                this.setJmsPropertyValues(this.fieldInputJmsPropertyValues);
            }
            catch (WSIFException ex) {
                Trc.ignoredException(ex);
            }
        }
    }

    private void setOutProperties(WSIFMessage output, WSIFJMSMessageProperties messageProps) throws WSIFException {
        Trc.entry(this, output, messageProps);
        if (output != null && this.fieldOutputProperties != null) {
            Iterator i = this.fieldOutputProperties.keySet().iterator();
            while (i.hasNext()) {
                String partName = (String)i.next();
                String propertyName = (String)this.fieldOutputProperties.get(partName);
                try {
                    Object propertyValue = messageProps.getProperty(propertyName);
                    output.setObjectPart(partName, propertyValue);
                }
                catch (WSIFException ex) {
                    Trc.ignoredException(ex);
                }
            }
        }
        Trc.exit();
    }

    private void setFaultProperties(WSIFMessage fault2, BindingFault bindingFault, WSIFJMSMessageProperties messageProps) throws WSIFException {
        Trc.entry(this, fault2, bindingFault, messageProps);
        Iterator it = bindingFault.getExtensibilityElements().iterator();
        while (it.hasNext()) {
            Object ele = it.next();
            if (ele instanceof JMSFaultIndicator) {
                JMSFaultIndicator indic = (JMSFaultIndicator)ele;
                List fProps = indic.getJMSFaultProperties();
                Iterator itFProp = fProps.iterator();
                while (itFProp.hasNext()) {
                    Object next = itFProp.next();
                    if (!(next instanceof JMSFaultProperty)) continue;
                    JMSFaultProperty fProp = (JMSFaultProperty)next;
                    String partName = fProp.getPart();
                    String propName = fProp.getName();
                    if (partName == null || partName.length() <= 0) continue;
                    try {
                        Object propValue = messageProps.getProperty(propName);
                        fault2.setObjectPart(partName, propValue);
                    }
                    catch (WSIFException ex) {
                        Trc.ignoredException(ex);
                    }
                }
                continue;
            }
            if (!(ele instanceof JMSProperty)) continue;
            JMSProperty prop = (JMSProperty)ele;
            String partName = prop.getPart();
            String propName = prop.getName();
            try {
                Object propValue = messageProps.getProperty(propName);
                fault2.setObjectPart(partName, propValue);
            }
            catch (WSIFException ex) {
                Trc.ignoredException(ex);
            }
        }
        Trc.exit();
    }

    private void setJMSPropertyValues(List propertyValues) throws WSIFException {
        if (propertyValues != null) {
            WSIFJMSDestination jmsDest = this.fieldJmsPort.getJmsDestination();
            Iterator i = propertyValues.iterator();
            while (i.hasNext()) {
                JMSPropertyValue pv = (JMSPropertyValue)i.next();
                if (pv == null) continue;
                Object o = this.getObjectValue(pv.getType(), pv.getValue());
                if (this.timeoutProperty(pv.getName(), o)) continue;
                jmsDest.setProperty(pv.getName(), o);
            }
        }
    }

    private void setJmsPropertyValues(HashMap attr) throws WSIFException {
        Iterator iter = attr.keySet().iterator();
        while (iter.hasNext()) {
            Object o;
            String attName = (String)iter.next();
            JMSPropertyValue value2 = (JMSPropertyValue)attr.get(attName);
            if (value2 == null || this.timeoutProperty(attName, o = this.getObjectValue(value2.getType(), value2.getValue()))) continue;
            WSIFJMSDestination jmsDest = this.fieldJmsPort.getJmsDestination();
            jmsDest.setProperty(attName, o);
        }
    }

    private boolean timeoutProperty(String propertyName, Object value2) {
        boolean isTimeoutProperty = false;
        if ("wsif.syncrequest.timeout".equals(propertyName)) {
            isTimeoutProperty = true;
            try {
                this.syncTimeout = Long.parseLong(value2.toString());
                Trc.event(this, "overridding syncTimeout to " + this.syncTimeout);
            }
            catch (NumberFormatException ex) {
                Trc.ignoredException(ex);
            }
        } else if ("wsif.asyncrequest.timeout".equals(propertyName)) {
            isTimeoutProperty = true;
            try {
                this.asyncTimeout = Long.parseLong(value2.toString());
                Trc.event(this, "overridding asyncTimeout to " + this.syncTimeout);
            }
            catch (NumberFormatException ex) {
                Trc.ignoredException(ex);
            }
        }
        return isTimeoutProperty;
    }

    protected Operation getOperation() throws Exception {
        if (this.fieldOperation == null) {
            ExtensibilityElement ele;
            if (this.fieldBindingOperation.getBindingInput() != null) {
                this.fieldInputMessageName = this.fieldBindingOperation.getBindingInput().getName();
            }
            if (this.fieldBindingOperation.getBindingOutput() != null) {
                this.fieldOutputMessageName = this.fieldBindingOperation.getBindingOutput().getName();
            }
            this.fieldOperation = this.fieldBasePort.getBinding().getPortType().getOperation(this.fieldBindingOperation.getName(), this.fieldInputMessageName, this.fieldOutputMessageName);
            if (this.fieldBindingOperation.getBindingInput() != null) {
                Iterator inputIterator = this.fieldBindingOperation.getBindingInput().getExtensibilityElements().iterator();
                this.fieldInputJmsProperties = new HashMap();
                this.fieldInputJmsPropertyValues = new HashMap();
                while (inputIterator.hasNext()) {
                    ele = (ExtensibilityElement)inputIterator.next();
                    if (ele instanceof JMSInput) {
                        this.fieldInput = (JMSInput)ele;
                        continue;
                    }
                    if (ele instanceof JMSProperty) {
                        this.fieldInputJmsProperties.put(((JMSProperty)ele).getPart(), ((JMSProperty)ele).getName());
                        continue;
                    }
                    if (!(ele instanceof JMSPropertyValue)) continue;
                    this.fieldInputJmsPropertyValues.put(((JMSPropertyValue)ele).getName(), ele);
                }
            }
            if (this.fieldBindingOperation.getBindingOutput() != null) {
                Iterator outputIterator = this.fieldBindingOperation.getBindingOutput().getExtensibilityElements().iterator();
                this.fieldOutputProperties = new HashMap();
                while (outputIterator.hasNext()) {
                    ele = (ExtensibilityElement)outputIterator.next();
                    if (ele instanceof JMSOutput) {
                        this.fieldOutput = (JMSOutput)ele;
                        continue;
                    }
                    if (!(ele instanceof JMSProperty)) continue;
                    this.fieldOutputProperties.put(((JMSProperty)ele).getPart(), ((JMSProperty)ele).getName());
                }
            }
        }
        if (this.fieldOperation == null) {
            throw new WSIFException("Unable to resolve Jms binding for operation '" + this.fieldBindingOperation.getName() + ":" + this.fieldInputMessageName + ":" + this.fieldOutputMessageName + "'");
        }
        return this.fieldOperation;
    }

    private Object getObjectValue(QName type, String value2) throws WSIFException {
        Object primitiveType = null;
        if (JMSMessage.isSchemaNamespace(type.getNamespaceURI()) && JMSMessage.isXSDPrimitiveType(type.getLocalPart())) {
            Class cls = (Class)JMSMessage.PRIMITIVE_JAVA_MAPPING.get(type.getLocalPart().toLowerCase());
            if (cls == String.class) {
                primitiveType = value2;
            } else if (cls == [B.class) {
                primitiveType = value2.getBytes();
            } else if (!GregorianCalendar.class.isAssignableFrom(cls) && !Date.class.isAssignableFrom(cls)) {
                try {
                    final Class clsFin = cls;
                    Constructor constructor = (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws NoSuchMethodException {
                            return clsFin.getConstructor(class$java$lang$String == null ? (class$java$lang$String = WSIFOperation_Jms.class$("java.lang.String")) : class$java$lang$String);
                        }
                    });
                    primitiveType = constructor.newInstance(value2);
                }
                catch (Exception e2) {
                    Trc.ignoredException(e2);
                }
            }
        }
        if (primitiveType != null) {
            return primitiveType;
        }
        throw new WSIFException("Unable to create the java object for XSD Type '" + type.toString() + "' using value '" + value2 + "'");
    }

    public int getJMSMessageType() {
        Trc.entry(this);
        Iterator bindingIterator = this.fieldBasePort.getBinding().getExtensibilityElements().iterator();
        while (bindingIterator.hasNext()) {
            try {
                ExtensibilityElement ele = (ExtensibilityElement)bindingIterator.next();
                if (!JMSConstants.Q_ELEM_JMS_BINDING.equals(ele.getElementType())) continue;
                int t = ((JMSBinding)ele).getJmsMessageType();
                Trc.exit(t);
                return t;
            }
            catch (ClassCastException exn) {
                Trc.ignoredException(exn);
            }
        }
        Trc.exit(0);
        return 0;
    }

    private void setAsyncOperation(boolean b) {
        this.asyncOperation = b;
    }

    public boolean isAsyncOperation() {
        Trc.entry(this);
        Trc.exit(this.asyncOperation);
        return this.asyncOperation;
    }

    private void setDestinationContext() throws WSIFException {
        if (this.context == null) {
            return;
        }
        HashMap<String, Object> jmsProps = new HashMap<String, Object>();
        Iterator i = this.context.getPartNames();
        while (i.hasNext()) {
            String partName = (String)i.next();
            try {
                Object value2 = this.context.getObjectPart(partName);
                if (this.timeoutProperty(partName, value2) || !partName.startsWith("JMSProperty.")) continue;
                jmsProps.put(partName.substring("JMSProperty.".length()), value2);
            }
            catch (WSIFException ex) {
                Trc.ignoredException(ex);
            }
        }
        if (jmsProps.size() > 0) {
            WSIFJMSDestination jmsDest = this.fieldJmsPort.getJmsDestination();
            jmsDest.setProperties(jmsProps);
        }
    }

    private ArrayList getWSDLInputPartNames() {
        ArrayList<String> wsdlInputParts = new ArrayList<String>();
        Input wsdlInput = this.fieldOperation.getInput();
        if (wsdlInput != null) {
            javax.wsdl.Message inputMessage = wsdlInput.getMessage();
            Iterator i = inputMessage.getParts().keySet().iterator();
            while (i.hasNext()) {
                String partName = (String)i.next();
                if (this.fieldInputJmsProperties != null && this.fieldInputJmsProperties.containsKey(partName)) continue;
                wsdlInputParts.add(partName);
            }
        }
        return wsdlInputParts;
    }

    private ArrayList getWSDLOutputPartNames() {
        ArrayList<String> wsdlOutputParts = new ArrayList<String>();
        Output wsdlOutput = this.fieldOperation.getOutput();
        if (wsdlOutput != null) {
            javax.wsdl.Message outputMessage = wsdlOutput.getMessage();
            Iterator i = outputMessage.getParts().keySet().iterator();
            while (i.hasNext()) {
                String partName = (String)i.next();
                if (this.fieldOutputProperties != null && this.fieldOutputProperties.containsKey(partName)) continue;
                wsdlOutputParts.add(partName);
            }
        }
        return wsdlOutputParts;
    }

    public WSIFPort getWSIFPort() {
        Trc.entry(this);
        Trc.exit(this.fieldJmsPort);
        return this.fieldJmsPort;
    }

    public static void setJMSMessageOutputHeaderProperties(Message targetMsg, WSIFMessage srcMsg, JMSFormatter formatter) throws WSIFException {
        Trc.entry(null, targetMsg, srcMsg, formatter);
        if (targetMsg == null) {
            throw new IllegalArgumentException("targetMsg is null");
        }
        if (srcMsg == null) {
            throw new IllegalArgumentException("srcMsg is null");
        }
        if (formatter == null) {
            throw new IllegalArgumentException("formatter is null");
        }
        WSIFJMSProperties jmsProps = new WSIFJMSProperties("out");
        HashMap<String, Object> newParts = new HashMap<String, Object>();
        Map properties = WSIFOperation_Jms.getJMSOutputProperties(formatter);
        Iterator i = srcMsg.getPartNames();
        while (i.hasNext()) {
            String partName = (String)i.next();
            Object value2 = null;
            try {
                value2 = srcMsg.getObjectPart(partName);
            }
            catch (WSIFException e2) {
                Trc.ignoredException(e2);
            }
            if (properties.containsKey(partName)) {
                String jmsProperty = (String)properties.get(partName);
                jmsProps.put(jmsProperty, value2);
                continue;
            }
            newParts.put(partName, value2);
        }
        jmsProps.set(null, targetMsg);
        srcMsg.setParts(newParts);
        Trc.exit();
    }

    protected static Map getJMSOutputProperties(JMSFormatter f) throws WSIFException {
        HashMap<String, String> jmsProperties = new HashMap<String, String>();
        BindingOperation bop = WSIFOperation_Jms.getFormatterOperation(f);
        BindingOutput bout = bop.getBindingOutput();
        if (bout != null) {
            List extEls = bout.getExtensibilityElements();
            Iterator i = extEls.iterator();
            while (i.hasNext()) {
                ExtensibilityElement ele = (ExtensibilityElement)i.next();
                if (!(ele instanceof JMSProperty)) continue;
                jmsProperties.put(((JMSProperty)ele).getPart(), ((JMSProperty)ele).getName());
            }
        }
        return jmsProperties;
    }

    protected static BindingOperation getFormatterOperation(JMSFormatter f) throws WSIFException {
        Port port2 = f.getPort();
        if (port2 == null) {
            throw new WSIFException("formatter contains a null Port");
        }
        BindingOperation bop = WSIFUtils.getBindingOperation(port2.getBinding(), f.getOperationName(), f.getInputName(), f.getOutputName());
        if (bop == null) {
            throw new WSIFException("cannot find binding operation for formatter");
        }
        return bop;
    }

    public String deep() {
        String buff = "";
        try {
            buff = new String(super.toString() + ":\n");
            buff = buff + "basePort:" + Trc.brief(this.fieldBasePort);
            buff = buff + " bindingOperation:" + Trc.brief(this.fieldBindingOperation);
            buff = buff + " wsifPort_Jms:" + this.fieldJmsPort;
            buff = buff + " Operation:" + Trc.brief(this.fieldOperation);
            buff = buff + " InputOnlyOperation:" + this.inputOnlyOp;
            buff = buff + " JmsMessageType:" + this.getJMSMessageType();
            buff = buff + " inputMessageName:" + this.fieldInputMessageName;
            buff = buff + " InputJmsPropertyValues:" + this.fieldInputJmsPropertyValues;
            buff = buff + " InputProperty:" + this.fieldInputJmsProperties;
            buff = buff + " Input:" + this.fieldInput;
            buff = buff + " outputMessageName:" + this.fieldOutputMessageName;
            buff = buff + " OutputProperties:" + this.fieldOutputProperties;
            buff = buff + " Output:" + this.fieldOutput;
            buff = buff + " Formater:" + this.formatter;
            buff = buff + " handler:" + this.handler;
            buff = buff + " asyncOperation:" + this.asyncOperation;
            buff = buff + " transControl:" + (this.transControl == null ? "unset" : this.transControl.getClass().getName() + " " + this.transControl);
        }
        catch (Exception e2) {
            Trc.exceptionInTrace(e2);
        }
        return buff;
    }
}

