/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers.jms;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.extensions.ExtensibilityElement;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFOperation;
import org.apache.wsif.base.WSIFDefaultPort;
import org.apache.wsif.format.WSIFFormatter;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.WSIFDynamicTypeMap;
import org.apache.wsif.providers.jms.JMSFormatter;
import org.apache.wsif.providers.jms.WSIFOperation_Jms;
import org.apache.wsif.util.WSIFProperties;
import org.apache.wsif.util.WSIFUtils;
import org.apache.wsif.util.jms.WSIFJMSDestination;
import org.apache.wsif.util.jms.WSIFJMSFinder;
import org.apache.wsif.wsdl.extensions.jms.JMSAddress;

public class WSIFPort_Jms
extends WSIFDefaultPort
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Definition fieldDefinition = null;
    private Port fieldPortModel = null;
    private JMSAddress fieldObjectReference = null;
    protected Map operationInstances = new HashMap();
    private transient WSIFJMSDestination jmsDest;

    public WSIFPort_Jms(Definition def, Port port2, WSIFDynamicTypeMap typeMap) throws WSIFException {
        Trc.entry(this, def, port2, typeMap);
        this.fieldDefinition = def;
        this.fieldPortModel = port2;
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    public WSIFOperation createOperation(String operationName) throws WSIFException {
        Trc.entry((Object)this, operationName);
        WSIFOperation wo = this.createOperation(operationName, null, null);
        Trc.exit(wo);
        return wo;
    }

    public WSIFOperation createOperation(String operationName, String inputName, String outputName) throws WSIFException {
        Trc.entry(this, operationName, inputName, outputName);
        WSIFOperation_Jms op = this.getDynamicWSIFOperation(operationName, inputName, outputName);
        if (op == null) {
            throw new WSIFException("Could not create operation: " + operationName + ":" + inputName + ":" + outputName);
        }
        WSIFOperation_Jms wo = op.copy();
        Trc.exit(wo);
        return wo;
    }

    public WSIFOperation_Jms getDynamicWSIFOperation(String name2, String inputName, String outputName) throws WSIFException {
        BindingOperation bindingOperationModel;
        Trc.entry(this, name2, inputName, outputName);
        WSIFOperation_Jms tempOp = (WSIFOperation_Jms)this.operationInstances.get(this.getKey(name2, inputName, outputName));
        WSIFOperation_Jms operation = null;
        if (tempOp != null) {
            operation = tempOp.copy();
        }
        if (operation == null && (bindingOperationModel = WSIFUtils.getBindingOperation(this.fieldPortModel.getBinding(), name2, inputName, outputName)) != null) {
            operation = new WSIFOperation_Jms(this.fieldPortModel, bindingOperationModel, this);
            this.setDynamicWSIFOperation(name2, inputName, outputName, operation);
        }
        Trc.exit(operation);
        return operation;
    }

    public void setDynamicWSIFOperation(String name2, String inputName, String outputName, WSIFOperation_Jms value2) {
        Trc.entry(this, name2, inputName, outputName);
        this.operationInstances.put(this.getKey(name2, inputName, outputName), value2);
        Trc.exit();
    }

    public boolean supportsSync() {
        Trc.entry(this);
        Trc.exit(true);
        return true;
    }

    public boolean supportsAsync() {
        Trc.entry(this);
        Trc.exit(true);
        return true;
    }

    public Definition getDefinition() {
        Trc.entry(this);
        Trc.exit(this.fieldDefinition);
        return this.fieldDefinition;
    }

    public void setDefinition(Definition value2) {
        Trc.entry((Object)this, value2);
        this.fieldDefinition = value2;
        Trc.exit();
    }

    public Port getPortModel() {
        Trc.entry(this);
        Trc.exit(this.fieldPortModel);
        return this.fieldPortModel;
    }

    public void setPortModel(Port value2) {
        Trc.entry((Object)this, value2);
        this.fieldPortModel = value2;
        Trc.exit();
    }

    public JMSAddress getObjectReference() throws WSIFException {
        Trc.entry(this);
        if (this.fieldObjectReference == null) {
            try {
                ExtensibilityElement portExtension = (ExtensibilityElement)this.fieldPortModel.getExtensibilityElements().get(0);
                if (portExtension == null) {
                    throw new WSIFException("Jms missing port extension");
                }
                this.fieldObjectReference = (JMSAddress)portExtension;
            }
            catch (Exception ex) {
                Trc.exception(ex);
                throw new WSIFException("Could not create object of class '???todo??? '", ex);
            }
        }
        Trc.exit(this.fieldObjectReference);
        return this.fieldObjectReference;
    }

    public void setObjectReference(JMSAddress newObjectReference) {
        Trc.entry((Object)this, newObjectReference);
        this.fieldObjectReference = newObjectReference;
        Trc.exit();
    }

    public WSIFFormatter getFormatter() {
        Trc.entry(this);
        JMSFormatter wf = new JMSFormatter(this.fieldDefinition, this.fieldPortModel);
        Trc.exit(wf);
        return wf;
    }

    public WSIFJMSDestination getJmsDestination() throws WSIFException {
        if (this.jmsDest == null) {
            this.jmsDest = new WSIFJMSDestination(WSIFJMSFinder.newFinder(this.getObjectReference(), this.fieldPortModel.getName()), this.getObjectReference().getJmsProvDestName(), WSIFProperties.getSyncTimeout());
        }
        return this.jmsDest;
    }

    public void close() throws WSIFException {
        Trc.entry(this);
        if (this.jmsDest != null) {
            this.jmsDest.close();
        }
        Trc.exit();
    }

    public String deep() {
        String buff = "";
        try {
            buff = new String(super.toString() + ":\n");
            buff = buff + "definition:" + Trc.brief(this.fieldDefinition);
            buff = buff + " portModel:" + Trc.brief(this.fieldPortModel);
            buff = buff + " objectReference:" + this.fieldObjectReference;
            buff = buff + " operationInstances: ";
            if (this.operationInstances == null) {
                buff = buff + "null";
            } else {
                buff = buff + "size:" + this.operationInstances.size();
                Iterator it = this.operationInstances.keySet().iterator();
                int i = 0;
                while (it.hasNext()) {
                    String key = (String)it.next();
                    WSIFOperation_Jms woj = (WSIFOperation_Jms)this.operationInstances.get(key);
                    buff = buff + "\noperationInstances[" + i + "]:" + key + " " + woj + " ";
                    ++i;
                }
            }
        }
        catch (Exception e2) {
            Trc.exceptionInTrace(e2);
        }
        return buff;
    }
}

