/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers.soap.apachesoap;

import com.ibm.jrom.JROMException;
import com.ibm.jrom.JROMValue;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.soap.apachesoap.JROMSerializer;

public class JROMSOAPMappingRegistry
extends SOAPMappingRegistry {
    public JROMSOAPMappingRegistry() {
        Trc.entry(this);
        Trc.exit();
    }

    public JROMSOAPMappingRegistry(SOAPMappingRegistry registry) {
        super(registry);
        Trc.entry((Object)this, registry);
        Trc.exit();
    }

    public JROMSOAPMappingRegistry(SOAPMappingRegistry registry, String schemaURI) {
        super(registry, schemaURI);
        Trc.entry(this, registry, schemaURI);
        Trc.exit();
    }

    public Serializer querySerializer(Class javaType, String encodingStyleURI) {
        Trc.entry(this, javaType, encodingStyleURI);
        if (JROMValue.class.isAssignableFrom(javaType)) {
            try {
                return new JROMSerializer();
            }
            catch (JROMException je) {
                Trc.ignoredException(je);
                return null;
            }
        }
        Serializer ser = super.querySerializer(javaType, encodingStyleURI);
        Trc.exit(ser);
        return ser;
    }

    public Deserializer queryDeserializer(QName elementType, String encodingStyleURI) {
        String ns;
        Trc.entry(this, elementType, encodingStyleURI);
        Deserializer deser = super.queryDeserializer(elementType, encodingStyleURI);
        if (deser != null && ((ns = elementType.getNamespaceURI()).equals("http://www.w3.org/1999/XMLSchema") || ns.equals("http://www.w3.org/2000/10/XMLSchema") || ns.equals("http://www.w3.org/2001/XMLSchema"))) {
            try {
                return new JROMSerializer();
            }
            catch (JROMException je) {
                Trc.ignoredException(je);
                return null;
            }
        }
        Trc.exit(deser);
        return deser;
    }
}

