/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers.soap.apachesoap;

import com.ibm.jrom.JROMComplexValue;
import com.ibm.jrom.JROMDurationValue;
import com.ibm.jrom.JROMException;
import com.ibm.jrom.JROMQNameValue;
import com.ibm.jrom.JROMType;
import com.ibm.jrom.JROMValue;
import com.ibm.jrom.convertors.JROM2XML;
import com.ibm.jrom.factory.JROMFactory;
import com.ibm.jrom.util.ConvertorUtils;
import com.ibm.jrom.util.JROMUtils;
import java.io.IOException;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.soap.Constants;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.encoding.soapenc.SoapEncUtils;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.RPCConstants;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.util.Bean;
import org.apache.soap.util.StringUtils;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.PrefixedName;
import org.apache.soap.util.xml.Serializer;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JROMSerializer
implements Serializer,
Deserializer {
    private SOAPMappingRegistry simpleTypeSMR;
    private org.apache.soap.util.xml.QName elementType = new org.apache.soap.util.xml.QName("", "");
    private JROMFactory factory;
    private JROMComplexValue parent = null;
    private Map jrom2XMLMap = JROM2XML.createDefaultTypeMap();

    public JROMSerializer() throws JROMException {
        try {
            this.factory = (JROMFactory)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws JROMException {
                    return JROMFactory.newInstance();
                }
            });
        }
        catch (PrivilegedActionException ex) {
            JROMException e2 = (JROMException)ex.getException();
            throw e2;
        }
    }

    public JROMSerializer(JROMFactory factory) {
        this.factory = factory;
    }

    public void marshall(String inScopeEncStyle, Class javaType, Object src, Object context, Writer sink, NSStack nsStack, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException, IOException {
        nsStack.pushScope();
        boolean isNull = false;
        JROMValue jromEl = (JROMValue)src;
        String elNameLP = jromEl.getNameLocalPart();
        String elNameNS = jromEl.getNameNamespace();
        String elName = elNameLP != null ? elNameLP : context.toString();
        org.apache.soap.util.xml.QName qname = new org.apache.soap.util.xml.QName(elNameNS, elName);
        PrefixedName pname = new PrefixedName(null, qname);
        JROMType jType = jromEl.getJROMType();
        sink.write(StringUtils.lineSeparator);
        if (jType != JROMType.JROM_COMPLEX_VALUE) {
            Object jromVal = ConvertorUtils.getSimpleJROMObject(jromEl);
            if (jromVal == null) {
                org.apache.soap.util.xml.QName sQName = this.toSoapQName((QName)this.jrom2XMLMap.get(jType));
                JROMSerializer.generateStructureHeader(inScopeEncStyle, sQName, pname, sink, nsStack, xjmr, null, null, true);
            } else if (jType == JROMType.JROM_DURATION_VALUE) {
                int[] val = ((JROMDurationValue)jromEl).getValue();
                JROMSerializer.generateStructureHeader(inScopeEncStyle, new org.apache.soap.util.xml.QName("http://www.w3.org/2001/XMLSchema", "duration"), pname, sink, nsStack, xjmr, null, null, false);
                sink.write(ConvertorUtils.durationToString(val));
                sink.write("</" + elName + ">");
            } else {
                if (jType == JROMType.JROM_QNAME_VALUE) {
                    jromVal = this.toSoapQName((QName)jromVal);
                }
                Parameter p = new Parameter(elName, jromVal.getClass(), jromVal, null);
                xjmr.marshall(inScopeEncStyle, Parameter.class, p, pname, sink, nsStack, ctx);
            }
            sink.write(StringUtils.lineSeparator);
        } else {
            JROMValue childElement;
            JROMComplexValue jromComplex = (JROMComplexValue)jromEl;
            Iterator elements = jromComplex.getElementValues();
            this.elementType.setNamespaceURI(jromComplex.getTypeNamespace());
            this.elementType.setLocalPart(jromComplex.getTypeLocalPart());
            if (this.elementType.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/encoding/") && this.elementType.getLocalPart().equals("Array")) {
                if (!elements.hasNext()) {
                    throw new IllegalArgumentException("Currently, JROM does not support empty arrays");
                }
                org.apache.soap.util.xml.QName arrayElType = null;
                childElement = (JROMValue)elements.next();
                if (childElement.getJROMType() != JROMType.JROM_COMPLEX_VALUE) {
                    if (childElement.getJROMType() == JROMType.JROM_DURATION_VALUE) {
                        arrayElType = new org.apache.soap.util.xml.QName("http://www.w3.org/2001/XMLSchema", "duration");
                    } else {
                        Object obj = ConvertorUtils.getSimpleJROMObject(childElement);
                        arrayElType = xjmr.queryElementType(obj.getClass(), "http://schemas.xmlsoap.org/soap/encoding/");
                    }
                } else {
                    arrayElType = new org.apache.soap.util.xml.QName(((JROMComplexValue)childElement).getTypeNamespace(), ((JROMComplexValue)childElement).getTypeLocalPart());
                }
                int numChildren = jromComplex.getNumElements();
                JROMSerializer.generateStructureHeader(inScopeEncStyle, this.elementType, pname, sink, nsStack, xjmr, arrayElType, String.valueOf(numChildren), false);
                elements = jromComplex.getElementValues();
            } else {
                isNull = jromComplex.getNumElements() == 0 && jromComplex.getNumAttributes() == 0;
                JROMSerializer.generateStructureHeader(inScopeEncStyle, this.elementType, pname, sink, nsStack, xjmr, null, null, isNull);
            }
            sink.write(StringUtils.lineSeparator);
            while (elements.hasNext()) {
                childElement = (JROMValue)elements.next();
                this.marshall(inScopeEncStyle, javaType, childElement, null, sink, nsStack, xjmr, ctx);
            }
            sink.write(StringUtils.lineSeparator);
            if (!isNull) {
                sink.write("</" + pname + '>' + "\n");
            }
        }
        sink.write(StringUtils.lineSeparator);
        nsStack.popScope();
    }

    public Bean unmarshall(String inScopeEncStyle, org.apache.soap.util.xml.QName elementType, Node src, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException {
        Class jromType;
        JROMValue jromVal;
        if (elementType == null || elementType.getLocalPart() == null) {
            throw new IllegalArgumentException("JROMSerializer: Cannot deserialize an element that does not have a type attribute: " + src);
        }
        Element root = (Element)src;
        String typeNameNSURI = elementType.getNamespaceURI();
        String typeNameLP = elementType.getLocalPart();
        String elementNameNamespace = root.getNamespaceURI();
        String[] prefAndLP = JROMUtils.splitStringOnColon(root.getTagName());
        String elementNameLocalPart = prefAndLP[1];
        if (this.simpleTypeSMR == null) {
            this.simpleTypeSMR = ((SOAPMappingRegistry)xjmr).getParent();
            if (this.simpleTypeSMR == null) {
                throw new IllegalArgumentException("smr.getParent() in JROMSerializer unmarshall returned null");
            }
        }
        JROMType jromValueType = null;
        Class javaClass = null;
        try {
            javaClass = this.simpleTypeSMR.queryJavaType(elementType, null);
        }
        catch (Exception e2) {
            // empty catch block
        }
        if (javaClass != null) {
            jromValueType = javaClass.equals(org.apache.soap.util.xml.QName.class) ? JROMType.JROM_QNAME_VALUE : ConvertorUtils.getJROMType(javaClass);
        }
        if (jromValueType != null && !jromValueType.equals(JROMType.JROM_COMPLEX_VALUE)) {
            Bean paramBean = this.simpleTypeSMR.unmarshall(inScopeEncStyle, RPCConstants.Q_ELEM_PARAMETER, root, ctx);
            Parameter param = (Parameter)paramBean.value;
            if (jromValueType.equals(JROMType.JROM_QNAME_VALUE)) {
                jromVal = this.factory.newJROMQNameValue(this.parent);
                jromVal.setNameNamespace(elementNameNamespace);
                jromVal.setNameLocalPart(elementNameLocalPart);
                if (param.getValue() != null) {
                    QName qname = this.toWsdlQName((org.apache.soap.util.xml.QName)param.getValue());
                    ((JROMQNameValue)jromVal).setValue(qname);
                }
            } else {
                jromVal = ConvertorUtils.createSimpleJrom(this.factory, jromValueType, param.getValue(), elementNameNamespace, elementNameLocalPart, this.parent);
            }
            jromType = jromVal.getClass();
        } else if (typeNameLP.equals("duration") && (typeNameNSURI.equals("http://www.w3.org/1999/XMLSchema") || typeNameNSURI.equals("http://www.w3.org/2000/10/XMLSchema") || typeNameNSURI.equals("http://www.w3.org/2001/XMLSchema"))) {
            int[] durationVal = ConvertorUtils.stringToDuration(DOMUtils.getChildCharacterData(root));
            jromVal = ConvertorUtils.createSimpleJrom(this.factory, JROMType.JROM_DURATION_VALUE, durationVal, elementNameNamespace, elementNameLocalPart, this.parent);
            jromType = jromVal.getClass();
        } else {
            jromType = JROMComplexValue.class;
            jromVal = this.factory.newJROMComplexValue(typeNameNSURI, typeNameLP, this.parent);
            jromVal.setNameNamespace(elementNameNamespace);
            jromVal.setNameLocalPart(elementNameLocalPart);
            Element childEl = DOMUtils.getFirstChildElement(root);
            this.parent = (JROMComplexValue)jromVal;
            while (childEl != null) {
                JROMValue childVal = null;
                Element tempEl = null;
                org.apache.soap.util.xml.QName tempElType = null;
                String href = DOMUtils.getAttribute(childEl, "href");
                if (href != null) {
                    if (href.length() > 0 && href.charAt(0) == '#') {
                        href = href.substring(1);
                        tempEl = DOMUtils.getElementByID(childEl.getOwnerDocument().getDocumentElement(), href);
                        if (tempEl == null) {
                            throw new IllegalArgumentException("No such ID '" + href + "'.");
                        }
                    }
                } else {
                    tempEl = childEl;
                }
                tempElType = SoapEncUtils.getTypeQName(tempEl);
                childVal = (JROMValue)this.unmarshall((String)inScopeEncStyle, (org.apache.soap.util.xml.QName)tempElType, (Node)tempEl, (XMLJavaMappingRegistry)xjmr, (SOAPContext)ctx).value;
                if (tempEl != childEl) {
                    childVal.setNameNamespace(childEl.getNamespaceURI());
                    String[] prefLP = JROMUtils.splitStringOnColon(childEl.getTagName());
                    childVal.setNameLocalPart(prefLP[1]);
                }
                ((JROMComplexValue)jromVal).addElementValue(childVal);
                childEl = DOMUtils.getNextSiblingElement(childEl);
            }
            this.parent = null;
        }
        return new Bean(jromType, jromVal);
    }

    private static void generateStructureHeader(String inScopeEncStyle, org.apache.soap.util.xml.QName elementType, Object context, Writer sink, NSStack nsStack, XMLJavaMappingRegistry xjmr, org.apache.soap.util.xml.QName arrayElementType, String arrayLengthStr, boolean isNull) throws IllegalArgumentException, IOException {
        String namespaceURI;
        PrefixedName pname;
        org.apache.soap.util.xml.QName qname;
        String namespaceDecl = "";
        if (context instanceof PrefixedName && (qname = (pname = (PrefixedName)context).getQName()) != null && (namespaceURI = qname.getNamespaceURI()) != null && !namespaceURI.equals("") && pname.getPrefix() == null) {
            String prefix = nsStack.getPrefixFromURI(namespaceURI);
            if (prefix == null) {
                prefix = nsStack.addNSDeclaration(namespaceURI);
                namespaceDecl = " xmlns:" + prefix + "=\"" + namespaceURI + '\"';
            }
            pname.setPrefix(prefix);
        }
        sink.write('<' + context.toString() + namespaceDecl);
        String xsiNSPrefix = nsStack.getPrefixFromURI("http://www.w3.org/2001/XMLSchema-instance", sink);
        String elementTypeNSPrefix = nsStack.getPrefixFromURI(elementType.getNamespaceURI(), sink);
        sink.write(' ' + xsiNSPrefix + ':' + "type" + "=\"" + elementTypeNSPrefix + ':' + elementType.getLocalPart() + '\"');
        if (inScopeEncStyle == null || !inScopeEncStyle.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
            String soapEnvNSPrefix = nsStack.getPrefixFromURI("http://schemas.xmlsoap.org/soap/envelope/", sink);
            sink.write(' ' + soapEnvNSPrefix + ':' + "encodingStyle" + "=\"" + "http://schemas.xmlsoap.org/soap/encoding/" + '\"');
        }
        if (arrayElementType != null) {
            String arrayElementTypeNSPrefix = nsStack.getPrefixFromURI(arrayElementType.getNamespaceURI(), sink);
            String arrayTypeValue = arrayElementTypeNSPrefix + ':' + arrayElementType.getLocalPart() + '[' + arrayLengthStr + ']';
            String soapEncNSPrefix = nsStack.getPrefixFromURI("http://schemas.xmlsoap.org/soap/encoding/", sink);
            sink.write(' ' + soapEncNSPrefix + ':' + "arrayType" + "=\"" + arrayTypeValue + '\"');
        }
        if (isNull) {
            sink.write(' ' + xsiNSPrefix + ':' + "null" + "=\"" + Constants.ATTRVAL_TRUE + "\"/");
        }
        sink.write(62);
    }

    private org.apache.soap.util.xml.QName toSoapQName(QName name2) {
        if (name2 != null) {
            return new org.apache.soap.util.xml.QName(name2.getNamespaceURI(), name2.getLocalPart());
        }
        return null;
    }

    private QName toWsdlQName(org.apache.soap.util.xml.QName name2) {
        if (name2 != null) {
            return new QName(name2.getNamespaceURI(), name2.getLocalPart());
        }
        return null;
    }
}

