/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers.soap.apachesoap;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import javax.mail.MessagingException;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.transport.SOAPTransport;
import org.apache.wsif.WSIFCorrelationService;
import org.apache.wsif.WSIFException;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.soap.apachesoap.WSIFOperation_ApacheSOAP;
import org.apache.wsif.util.WSIFCorrelationServiceLocator;
import org.apache.wsif.util.WSIFProperties;
import org.apache.wsif.util.jms.WSIFJMSCorrelationId;
import org.apache.wsif.util.jms.WSIFJMSDestination;
import org.apache.wsif.util.jms.WSIFJMSFinder;
import org.apache.wsif.wsdl.extensions.jms.JMSAddress;

public class SOAPJMSConnection
implements SOAPTransport {
    private BufferedReader responseReader = null;
    private SOAPContext responseSOAPContext = null;
    private WSIFJMSDestination destination = null;
    private boolean asyncOperation = false;
    private WSIFOperation_ApacheSOAP wsifOperation = null;
    private long syncTimeout;
    private long asyncTimeout;
    private static final String DUMMY_RESPONSE = "<?xml version='1.0' encoding='UTF-8'?>\n<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/1999/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/1999/XMLSchema\">\n<SOAP-ENV:Body>\n<ns1:addEntryResponse xmlns:ns1=\"http://wsifservice.addressbook/\" SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\n</ns1:addEntryResponse>\n\n</SOAP-ENV:Body>\n</SOAP-ENV:Envelope>";

    public SOAPJMSConnection(JMSAddress ja, String portName) throws WSIFException {
        Trc.entry(this, ja, portName);
        this.destination = new WSIFJMSDestination(WSIFJMSFinder.newFinder(ja, portName), ja.getJmsProvDestName(), WSIFProperties.getSyncTimeout());
        Trc.exit(ja);
    }

    public Hashtable getHeaders() {
        Trc.entry(this);
        Trc.exit(null);
        return null;
    }

    public SOAPContext getResponseSOAPContext() {
        Trc.entry(this);
        Trc.exit(this.responseSOAPContext);
        return this.responseSOAPContext;
    }

    public long getSyncTimeout() {
        Trc.entry(this);
        Trc.exit(new Long(this.syncTimeout));
        return this.syncTimeout;
    }

    public long getAsyncTimeout() {
        Trc.entry(this);
        Trc.exit(new Long(this.asyncTimeout));
        return this.asyncTimeout;
    }

    public BufferedReader receive() {
        Trc.entry(this);
        Trc.exit();
        return this.responseReader;
    }

    public void send(URL sendTo, String action, Hashtable headers, Envelope env, SOAPMappingRegistry smr, SOAPContext ctx) throws SOAPException {
        Trc.entry(this, sendTo, action, headers, env, smr, ctx);
        try {
            if (this.isAsyncOperation()) {
                this.performAsyncSend(sendTo, action, headers, env, smr, ctx);
            } else {
                StringWriter payloadSW = new StringWriter();
                env.marshall(payloadSW, smr, ctx);
                String id = this.destination.send(payloadSW.toString(), null);
                String response = this.destination.receiveString(id, this.syncTimeout);
                this.responseSOAPContext = new SOAPContext();
                this.responseSOAPContext.setRootPart(response, "text/xml");
                this.responseReader = new BufferedReader(new StringReader(response));
            }
        }
        catch (IOException ioe) {
            Trc.exception(ioe);
            throw new SOAPException("WSIF SOAPJMSConnection ", ioe.toString());
        }
        catch (MessagingException me) {
            Trc.exception(me);
            throw new SOAPException("WSIF SOAPJMSConnection ", me.toString());
        }
        Trc.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performAsyncSend(URL sendTo, String action, Hashtable headers, Envelope env, SOAPMappingRegistry smr, SOAPContext ctx) throws IOException, SOAPException, MessagingException {
        String msgID;
        StringWriter payloadSW = new StringWriter();
        env.marshall(payloadSW, smr, ctx);
        WSIFOperation_ApacheSOAP wsifOp = this.getWsifOperation();
        if (wsifOp.getResponseHandler() == null) {
            msgID = this.destination.send(payloadSW.toString(), null);
            WSIFJMSCorrelationId cid = new WSIFJMSCorrelationId(msgID);
        } else {
            WSIFCorrelationService correlator;
            WSIFCorrelationService wSIFCorrelationService = correlator = WSIFCorrelationServiceLocator.getCorrelationService();
            synchronized (wSIFCorrelationService) {
                msgID = this.destination.send(payloadSW.toString(), null);
                WSIFJMSCorrelationId cid = new WSIFJMSCorrelationId(msgID);
                if (correlator != null) {
                    correlator.put(cid, this.getWsifOperation(), this.asyncTimeout);
                }
            }
        }
        wsifOp.setAsyncRequestID(new WSIFJMSCorrelationId(msgID));
        this.responseSOAPContext = new SOAPContext();
        this.responseSOAPContext.setRootPart(DUMMY_RESPONSE, "text/xml");
        this.responseReader = new BufferedReader(new StringReader(DUMMY_RESPONSE));
    }

    public void setAsyncOperation(boolean b) {
        Trc.entry((Object)this, b);
        this.asyncOperation = b;
        Trc.exit();
    }

    public boolean isAsyncOperation() {
        Trc.entry(this);
        Trc.exit(this.asyncOperation);
        return this.asyncOperation;
    }

    public WSIFOperation_ApacheSOAP getWsifOperation() {
        Trc.entry(this);
        Trc.exit(this.wsifOperation);
        return this.wsifOperation;
    }

    public void setWsifOperation(WSIFOperation_ApacheSOAP op) {
        Trc.entry((Object)this, op);
        this.wsifOperation = op;
        Trc.exit();
    }

    public void setJmsProperty(String name2, Object value2) throws WSIFException {
        Trc.entry(this, name2, value2);
        this.destination.setProperty(name2, value2);
        Trc.exit();
    }

    public void setJmsProperties(HashMap hm) {
        Trc.entry((Object)this, hm);
        this.destination.setProperties(hm);
        Trc.exit();
    }

    public HashMap getJmsProperties() throws WSIFException {
        Trc.entry(this);
        HashMap hm = this.destination.getProperties();
        Trc.exit(hm);
        return hm;
    }

    void close() throws WSIFException {
        Trc.entry(this);
        this.destination.close();
        Trc.exit();
    }

    public void setSyncTimeout(long timeout) {
        Trc.entry((Object)this, new Long(timeout));
        this.syncTimeout = timeout;
        Trc.exit();
    }

    public void setAsyncTimeout(long timeout) {
        Trc.entry((Object)this, new Long(timeout));
        this.asyncTimeout = timeout;
        Trc.exit();
    }
}

