/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers.soap.apachesoap;

import com.ibm.jrom.JROMValue;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.jms.TextMessage;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.Body;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.Fault;
import org.apache.soap.Header;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.encoding.soapenc.BeanSerializer;
import org.apache.soap.messaging.Message;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.Response;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.transport.SOAPTransport;
import org.apache.soap.transport.http.SOAPHTTPConnection;
import org.apache.soap.util.Bean;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.Serializer;
import org.apache.soap.util.xml.XMLParserUtils;
import org.apache.wsif.WSIFCorrelationId;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.WSIFOperation;
import org.apache.wsif.WSIFPort;
import org.apache.wsif.WSIFResponseHandler;
import org.apache.wsif.base.WSIFDefaultMessage;
import org.apache.wsif.base.WSIFDefaultOperation;
import org.apache.wsif.base.WSIFServiceImpl;
import org.apache.wsif.logging.MessageLogger;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.WSIFDynamicTypeMap;
import org.apache.wsif.providers.soap.apachesoap.JROMSOAPMappingRegistry;
import org.apache.wsif.providers.soap.apachesoap.PartSerializer;
import org.apache.wsif.providers.soap.apachesoap.SOAPEncSerializerWrapper;
import org.apache.wsif.providers.soap.apachesoap.SOAPJMSConnection;
import org.apache.wsif.providers.soap.apachesoap.WSIFPort_ApacheSOAP;
import org.apache.wsif.util.WSIFProperties;
import org.apache.wsif.util.WSIFUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class WSIFOperation_ApacheSOAP
extends WSIFDefaultOperation
implements WSIFOperation,
Serializable {
    private static final long serialVersionUID = 1L;
    protected transient String style = null;
    protected transient WSIFPort_ApacheSOAP portInstance;
    protected transient Operation operation;
    protected transient Definition definition;
    protected transient List partNames;
    protected transient String[] names;
    protected transient Class[] types;
    protected transient String inputEncodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
    protected transient String inputNamespace;
    protected transient Class returnType;
    protected transient String actionUri;
    protected transient boolean asyncOperation;
    protected transient WSIFCorrelationId asyncRequestID;
    protected WSIFResponseHandler responseHandler;
    protected String outputEncodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
    protected String returnName;
    protected boolean prepared = false;
    protected WSIFDynamicTypeMap typeMap;
    protected String inputUse = null;
    protected String outputUse = null;
    protected String partSerializerName = null;
    protected boolean usingJROM = false;
    protected ArrayList wsdlOutParams;
    private static final String HTTP_PROXY_HOST_PROPERTY = "http.proxyHost";
    private static final String HTTP_PROXY_PORT_PROPERTY = "http.proxyPort";
    private static final String PROXY_EXCLUDES_PROPERTY = "http.nonProxyHosts";
    static /* synthetic */ Class class$java$lang$Class;

    public WSIFOperation_ApacheSOAP(WSIFPort_ApacheSOAP pi, Operation op, WSIFDynamicTypeMap typeMap) throws WSIFException {
        Trc.entry(this, pi, op, typeMap);
        this.typeMap = typeMap;
        this.setDynamicWSIFPort(pi);
        this.setOperation(op);
        this.setDefinition(pi.getDefinition());
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    public WSIFOperation_ApacheSOAP copy() throws WSIFException {
        Trc.entry(this);
        WSIFOperation_ApacheSOAP op = new WSIFOperation_ApacheSOAP(this.portInstance, this.operation, this.typeMap);
        op.setSoapActionURI(this.getSoapActionURI());
        op.setInputNamespace(this.getInputNamespace());
        op.setInputEncodingStyle(this.getInputEncodingStyle());
        op.setOutputEncodingStyle(this.getOutputEncodingStyle());
        op.setPartNames(this.getPartNames());
        op.setReturnName(this.getReturnName());
        op.setStyle(this.getStyle());
        op.setInputUse(this.getInputUse());
        op.setOutputUse(this.getOutputUse());
        op.setPartSerializerName(this.getPartSerializerName());
        op.setResponseHandler(this.getResponseHandler());
        op.setInputJmsProperties(this.getInputJmsProperties());
        op.setOutputJmsProperties(this.getOutputJmsProperties());
        op.setInputJmsPropertyValues(this.getInputJmsPropertyValues());
        if (Trc.ON) {
            Trc.exit(op.deep());
        }
        return op;
    }

    public String getTargetNamespaceURI() {
        Trc.entry(this);
        Definition d = this.getDefinition();
        String s = d == null ? "" : d.getTargetNamespace();
        Trc.exit(s);
        return s;
    }

    void prepare(WSIFMessage inputMessage, WSIFMessage outputMessage) throws WSIFException {
        Output output;
        Input input;
        Trc.entry(this, inputMessage, outputMessage);
        HashMap mapOfUserTypes = this.portInstance.getLocalTypeMap();
        SOAPMappingRegistry smr = this.portInstance.getSOAPMappingRegistry();
        this.usingJROM = "http://www.apache.org/namespaces/jrom".equals(inputMessage.getRepresentationStyle());
        BeanSerializer beanSer = new BeanSerializer();
        PartSerializer partSer = null;
        if (this.partSerializerName != null) {
            try {
                partSer = (PartSerializer)Class.forName(this.partSerializerName, true, Thread.currentThread().getContextClassLoader()).newInstance();
            }
            catch (Throwable ignored) {
                Trc.ignoredException(ignored);
            }
        }
        if ((input = this.operation.getInput()) != null) {
            Part part;
            List<Part> parts;
            if (this.partNames != null) {
                parts = new Vector();
                Iterator i = this.partNames.iterator();
                while (i.hasNext()) {
                    String partName = (String)i.next();
                    part = input.getMessage().getPart(partName);
                    if (part == null) {
                        throw new WSIFException("no input part named " + partName + " for binding operation " + this.getName());
                    }
                    parts.add(part);
                }
            } else {
                parts = input.getMessage().getOrderedParts(null);
            }
            int count = parts.size();
            this.names = new String[count];
            this.types = new Class[count];
            for (int i = 0; i < count; ++i) {
                part = (Part)parts.get(i);
                this.names[i] = part.getName();
                QName partType = part.getTypeName();
                if (partType == null) {
                    partType = part.getElementName();
                }
                if (partType == null) {
                    throw new WSIFException("part " + this.names[i] + " must have type name declared");
                }
                org.apache.soap.util.xml.QName qname = new org.apache.soap.util.xml.QName(partType.getNamespaceURI(), partType.getLocalPart());
                try {
                    this.types[i] = (Class)mapOfUserTypes.get(qname);
                }
                catch (Throwable ignored) {
                    Trc.ignoredException(ignored);
                }
                if (this.types[i] != null) continue;
                try {
                    this.types[i] = smr.queryJavaType(qname, this.inputEncodingStyle);
                    continue;
                }
                catch (Throwable exn) {
                    if (this.types[i] != null) continue;
                    try {
                        String packageName = WSIFUtils.getPackageNameFromNamespaceURI(qname.getNamespaceURI());
                        String className = WSIFUtils.getJavaClassNameFromXMLName(qname.getLocalPart());
                        Class<?> inputClass = null;
                        try {
                            inputClass = Class.forName(packageName + "." + className, true, Thread.currentThread().getContextClassLoader());
                        }
                        catch (ClassNotFoundException exn5) {
                            inputClass = Class.forName(packageName + "." + className + "Element", true, Thread.currentThread().getContextClassLoader());
                        }
                        this.types[i] = inputClass;
                        if ("literal".equals(this.inputUse)) {
                            smr.mapTypes("literal", qname, inputClass, partSer, partSer);
                        } else {
                            smr.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", qname, inputClass, beanSer, beanSer);
                        }
                        this.mapSubtypes(inputClass, beanSer, partSer, smr, this.inputUse);
                        continue;
                    }
                    catch (ClassNotFoundException exn1) {
                        Trc.ignoredException(exn1);
                    }
                }
            }
        } else {
            this.names = new String[0];
            this.types = new Class[0];
        }
        if ((output = this.operation.getOutput()) != null) {
            List parts;
            block42: {
                Part returnPart = null;
                if (this.returnName != null) {
                    returnPart = output.getMessage().getPart(this.returnName);
                    if (returnPart == null) {
                        throw new WSIFException("no output part named " + this.returnName + " for bining operation " + this.getName());
                    }
                } else {
                    List parts2 = output.getMessage().getOrderedParts(null);
                    if (parts2.size() > 0) {
                        returnPart = (Part)parts2.get(0);
                        this.returnName = returnPart.getName();
                    }
                }
                if (returnPart != null) {
                    QName partType = returnPart.getTypeName();
                    if (partType == null) {
                        partType = returnPart.getElementName();
                    }
                    org.apache.soap.util.xml.QName qname = new org.apache.soap.util.xml.QName(partType.getNamespaceURI(), partType.getLocalPart());
                    try {
                        this.returnType = (Class)mapOfUserTypes.get(qname);
                    }
                    catch (Throwable ignored) {
                        Trc.ignoredException(ignored);
                    }
                    if (this.returnType == null) {
                        try {
                            this.returnType = smr.queryJavaType(qname, this.outputEncodingStyle);
                        }
                        catch (Throwable exn) {
                            if (this.returnType != null) break block42;
                            try {
                                String packageName = WSIFUtils.getPackageNameFromNamespaceURI(qname.getNamespaceURI());
                                String className = WSIFUtils.getJavaClassNameFromXMLName(qname.getLocalPart());
                                try {
                                    this.returnType = Class.forName(packageName + "." + className, true, Thread.currentThread().getContextClassLoader());
                                }
                                catch (ClassNotFoundException exn5) {
                                    this.returnType = Class.forName(packageName + "." + className + "Element", true, Thread.currentThread().getContextClassLoader());
                                }
                                if ("literal".equals(this.outputUse)) {
                                    smr.mapTypes("literal", qname, this.returnType, partSer, partSer);
                                } else {
                                    smr.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", qname, this.returnType, beanSer, beanSer);
                                }
                                this.mapSubtypes(this.returnType, beanSer, partSer, smr, this.outputUse);
                            }
                            catch (ClassNotFoundException exn1) {
                                Trc.ignoredException(exn1);
                            }
                        }
                    }
                }
            }
            if ((parts = output.getMessage().getOrderedParts(null)).size() > 1) {
                ArrayList<String> al = new ArrayList<String>();
                for (int i = 1; i < parts.size(); ++i) {
                    al.add(((Part)parts.get(i)).getName());
                }
                this.setWSDLOutParams(al);
            }
        }
        this.prepared = true;
        Trc.exit();
    }

    private void mapSubtypes(Class javaType, BeanSerializer beanSer, PartSerializer partSer, SOAPMappingRegistry smr, String use) {
        PropertyDescriptor[] properties;
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(javaType);
        }
        catch (IntrospectionException e2) {
            Trc.ignoredException(e2);
        }
        if (beanInfo != null && (properties = beanInfo.getPropertyDescriptors()) != null) {
            for (int i = 0; i < properties.length; ++i) {
                Class<?> propType = properties[i].getPropertyType();
                try {
                    org.apache.soap.util.xml.QName qname = smr.queryElementType(propType, this.inputEncodingStyle);
                    continue;
                }
                catch (IllegalArgumentException exn) {
                    Trc.exception(exn);
                    if (propType.equals(class$java$lang$Class == null ? WSIFOperation_ApacheSOAP.class$("java.lang.Class") : class$java$lang$Class)) continue;
                    String packageName = propType.getPackage().getName();
                    String fullClassName = propType.getName();
                    String className = fullClassName.substring(fullClassName.lastIndexOf(".") + 1);
                    org.apache.soap.util.xml.QName qname = new org.apache.soap.util.xml.QName(WSIFUtils.getXSDNamespaceFromPackageName(packageName), className);
                    if ("literal".equals(use)) {
                        smr.mapTypes("literal", qname, propType, partSer, partSer);
                    } else {
                        smr.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", qname, propType, beanSer, beanSer);
                    }
                    this.mapSubtypes(propType, beanSer, partSer, smr, use);
                }
            }
        }
    }

    private void setupTypeMappings(HashMap mapOfUserTypes, SOAPMappingRegistry smr, JROMSOAPMappingRegistry jromSMR) throws WSIFException {
        if (this.portInstance == null) {
            HashMap tempMap = new HashMap();
            WSIFPort_ApacheSOAP.prepareTypeMappings(smr, this.typeMap, this.partSerializerName, tempMap);
            WSIFPort_ApacheSOAP.prepareJROMTypeMappings(jromSMR, this.typeMap);
        }
    }

    public boolean executeRequestResponseOperation(WSIFMessage input, WSIFMessage output, WSIFMessage fault2) throws WSIFException {
        Trc.entry(this, input, output, fault2);
        this.close();
        this.setAsyncOperation(false);
        boolean succ = "document".equals(this.style) ? this.invokeRequestResponseOperationDocument(input, output, fault2) : this.invokeRequestResponseOperation(input, output, fault2);
        Trc.exit(succ);
        return succ;
    }

    public void executeInputOnlyOperation(WSIFMessage input) throws WSIFException {
        Trc.entry((Object)this, input);
        this.setAsyncOperation(false);
        this.invokeRequestResponseOperation(input, null, null);
        Trc.exit();
    }

    public boolean invokeRequestResponseOperation(WSIFMessage input, WSIFMessage output, WSIFMessage fault2) throws WSIFException {
        Response resp;
        Trc.entry(this, input, output, fault2);
        if (!this.prepared) {
            this.prepare(input, output);
        }
        this.usingJROM = "http://www.apache.org/namespaces/jrom".equals(input.getRepresentationStyle());
        Call call = this.usingJROM ? this.portInstance.getJROMCall() : this.portInstance.getCall();
        call.setEncodingStyleURI(this.getInputEncodingStyle());
        SOAPTransport st = this.getTransport();
        if (st != null) {
            call.setSOAPTransport(st);
            if (st instanceof SOAPJMSConnection) {
                SOAPJMSConnection sjt = (SOAPJMSConnection)st;
                sjt.setSyncTimeout(WSIFProperties.getSyncTimeout());
                sjt.setAsyncTimeout(WSIFProperties.getAsyncTimeout());
            }
        }
        call.setTargetObjectURI(this.getInputNamespace());
        call.setMethodName(this.getName());
        if (this.inJmsPropVals != null && !this.inJmsPropVals.isEmpty()) {
            this.checkForTimeoutProperties(st, this.inJmsPropVals);
            ((SOAPJMSConnection)st).setJmsProperties(this.inJmsPropVals);
        }
        Vector<Parameter> params = new Vector<Parameter>();
        for (int i = 0; i < this.names.length; ++i) {
            Object partInst;
            try {
                partInst = input.getObjectPart(this.names[i]);
            }
            catch (WSIFException ex) {
                Trc.exception(ex);
                partInst = null;
            }
            Object value2 = partInst;
            if (this.usingJROM) {
                this.types[i] = class$com$ibm$jrom$JROMValue == null ? WSIFOperation_ApacheSOAP.class$("com.ibm.jrom.JROMValue") : class$com$ibm$jrom$JROMValue;
            } else if (value2 != null && !this.types[i].isPrimitive() && !this.types[i].isAssignableFrom(value2.getClass())) {
                throw new WSIFException("value " + value2 + " has unexpected type " + value2.getClass() + " instead of " + this.types[i]);
            }
            if (this.inJmsProps.containsKey(this.names[i]) && st != null) {
                String name2 = (String)this.inJmsProps.get(this.names[i]);
                if (this.timeoutProperty(st, name2, value2)) continue;
                ((SOAPJMSConnection)st).setJmsProperty(name2, value2);
                continue;
            }
            Parameter param = new Parameter(this.names[i], this.types[i], value2, this.inputEncodingStyle);
            params.addElement(param);
        }
        call.setParams(params);
        this.setTransportContext(st);
        this.setCallContext(call);
        boolean respOK = true;
        URL locationUri = this.portInstance.getEndPoint();
        if (locationUri != null && !this.isHostInNonProxyProperty(locationUri)) {
            this.setSOAPProxy(st);
        }
        Trc.event(this, "Invoking operation ", this.getName(), " on ", locationUri, " call object ", call);
        try {
            resp = call.invoke(locationUri, this.getSoapActionURI());
        }
        catch (SOAPException e2) {
            Trc.exception(e2);
            MessageLogger.log("WSIF.0005E", "ApacheSOAP", this.getName());
            throw new WSIFException("SOAPException: " + e2.getFaultCode() + e2.getMessage(), e2);
        }
        Trc.event(this, "Operation returned ", resp);
        if (!this.isAsyncOperation() && this.returnType != null) {
            respOK = this.buildResponseMessages(resp, output, fault2);
        }
        if (resp instanceof Response) {
            Header soapHeader = resp.getHeader();
            this.addContextResponseSOAPHeaders(soapHeader);
        }
        Trc.exit(respOK);
        return respOK;
    }

    public boolean invokeRequestResponseOperationDocument(WSIFMessage input, WSIFMessage output, WSIFMessage fault2) throws WSIFException {
        Trc.entry(this, input, output, fault2);
        if (!this.prepared) {
            this.prepare(input, output);
        }
        Envelope msgEnv = new Envelope();
        Body msgBody = new Body();
        Vector<Bean> vect = new Vector<Bean>();
        Iterator iterator = this.operation.getInput().getMessage().getParts().keySet().iterator();
        while (iterator.hasNext()) {
            String partName = (String)iterator.next();
            Object part = input.getObjectPart(partName);
            String encoding = null;
            encoding = "literal".equals(this.inputUse) ? "literal" : this.inputEncodingStyle;
            PartSerializer partSerializer = null;
            Serializer o = this.portInstance.getSOAPMappingRegistry().querySerializer(part.getClass(), this.inputUse);
            if (o instanceof PartSerializer) {
                PartSerializer tmp = (PartSerializer)o;
                try {
                    partSerializer = (PartSerializer)tmp.getClass().newInstance();
                }
                catch (InstantiationException e2) {
                    Trc.ignoredException(e2);
                }
                catch (IllegalAccessException e3) {
                    Trc.ignoredException(e3);
                }
                partSerializer.setPart(part);
                Part modelPart = this.operation.getInput().getMessage().getPart(partName);
                QName partType = modelPart.getTypeName();
                if (partType == null) {
                    partType = modelPart.getElementName();
                }
                partSerializer.setPartQName(partType);
            } else {
                partSerializer = new SOAPEncSerializerWrapper();
                partSerializer.setPart(part);
                ((SOAPEncSerializerWrapper)partSerializer).setTargetSerializer(o);
            }
            Bean bean = new Bean(partSerializer.getClass(), partSerializer);
            vect.add(bean);
        }
        URL url = this.portInstance.getEndPoint();
        Envelope env = null;
        msgBody.setBodyEntries(vect);
        msgEnv.setBody(msgBody);
        SOAPTransport st = this.getTransport();
        if (st instanceof SOAPJMSConnection) {
            SOAPJMSConnection sjt = (SOAPJMSConnection)st;
            sjt.setSyncTimeout(WSIFProperties.getSyncTimeout());
            sjt.setAsyncTimeout(WSIFProperties.getAsyncTimeout());
        }
        if (this.inJmsPropVals != null && !this.inJmsPropVals.isEmpty()) {
            this.checkForTimeoutProperties(st, this.inJmsPropVals);
            ((SOAPJMSConnection)st).setJmsProperties(this.inJmsPropVals);
        }
        if (url != null && !this.isHostInNonProxyProperty(url)) {
            this.setSOAPProxy(st);
        }
        try {
            Message msg = new Message();
            if (st != null) {
                msg.setSOAPTransport(st);
            }
            Trc.event(this, "Invoking operation ", this.getName(), " url ", url, " soapaction ", this.getSoapActionURI(), " envelope ", msgEnv, " message ", msg);
            msg.send(url, this.getSoapActionURI(), msgEnv);
            env = msg.receiveEnvelope();
        }
        catch (SOAPException exn) {
            Trc.exception(exn);
            WSIFException e4 = new WSIFException("SOAP Exception: " + exn.getMessage());
            e4.setTargetException(exn);
            throw e4;
        }
        Trc.event(this, "Returned from operation, envelope ", env);
        Body retbody = env.getBody();
        Vector v = retbody.getBodyEntries();
        int index = 0;
        String encoding = null;
        encoding = "literal".equals(this.outputUse) ? "literal" : this.outputEncodingStyle;
        iterator = this.operation.getOutput().getMessage().getParts().keySet().iterator();
        while (iterator.hasNext()) {
            Object retBean;
            Element element = (Element)v.get(index++);
            String partName = (String)iterator.next();
            Part modelPart = this.operation.getOutput().getMessage().getPart(partName);
            QName partType = modelPart.getTypeName();
            if (partType == null) {
                partType = modelPart.getElementName();
            }
            PartSerializer partSerializer = null;
            Deserializer o = this.portInstance.getSOAPMappingRegistry().queryDeserializer(new org.apache.soap.util.xml.QName(partType.getNamespaceURI(), partType.getLocalPart()), encoding);
            if (o instanceof PartSerializer) {
                PartSerializer tmp = (PartSerializer)o;
                try {
                    partSerializer = (PartSerializer)tmp.getClass().newInstance();
                }
                catch (InstantiationException e5) {
                    Trc.ignoredException(e5);
                }
                catch (IllegalAccessException e6) {
                    Trc.ignoredException(e6);
                }
                partSerializer.setPartQName(partType);
                partSerializer.unmarshall(null, null, element, null, null);
                retBean = partSerializer.getPart();
                output.setObjectPart(partName, retBean);
                continue;
            }
            Bean bean = o.unmarshall(null, null, element, null, null);
            retBean = bean.value;
        }
        Header soapHeader = env.getHeader();
        this.addContextResponseSOAPHeaders(soapHeader);
        Trc.exit(true);
        return true;
    }

    public WSIFCorrelationId executeRequestResponseAsync(WSIFMessage input) throws WSIFException {
        Trc.entry((Object)this, input);
        WSIFCorrelationId id = this.executeRequestResponseAsync(input, null);
        Trc.exit(id);
        return id;
    }

    public WSIFCorrelationId executeRequestResponseAsync(WSIFMessage input, WSIFResponseHandler handler2) throws WSIFException {
        Trc.entry(this, input, handler2);
        this.close();
        if (!this.prepared) {
            this.prepare(input, null);
        }
        if (!this.portInstance.supportsAsync()) {
            throw new WSIFException("asynchronous operations not available");
        }
        if ("document".equals(this.style)) {
            throw new WSIFException("docstyle asynchronous operations not implemented");
        }
        this.setAsyncOperation(true);
        this.setResponseHandler(handler2);
        SOAPJMSConnection transport2 = (SOAPJMSConnection)this.getTransport();
        transport2.setWsifOperation(this);
        transport2.setAsyncOperation(true);
        this.invokeRequestResponseOperation(input, null, null);
        transport2.setAsyncOperation(false);
        WSIFCorrelationId id = this.getAsyncRequestID();
        Trc.exit(id);
        return id;
    }

    public void fireAsyncResponse(Object response) throws WSIFException {
        Trc.entry((Object)this, response);
        Response resp = this.deserialiseResponseObject(response);
        WSIFMessage outMsg = this.createOutputMessage();
        WSIFMessage faultMsg = this.createFaultMessage();
        this.buildResponseMessages(resp, outMsg, faultMsg);
        this.getResponseHandler().executeAsyncResponse(outMsg, faultMsg);
        Trc.exit(outMsg);
    }

    public boolean processAsyncResponse(Object response, WSIFMessage output, WSIFMessage fault2) throws WSIFException {
        Trc.entry(this, response, output, fault2);
        Response resp = this.deserialiseResponseObject(response);
        boolean ok = this.buildResponseMessages(resp, output, fault2);
        Trc.exit(ok);
        return ok;
    }

    private Response deserialiseResponseObject(Object msg) throws WSIFException {
        if (msg == null) {
            throw new WSIFException("null response to async send");
        }
        if (!(msg instanceof TextMessage)) {
            throw new WSIFException("response not a javax.jms.TextMessage");
        }
        HashMap mapOfUserTypes = new HashMap();
        SOAPMappingRegistry smr = WSIFPort_ApacheSOAP.createSOAPMappingRegistry(new Call());
        JROMSOAPMappingRegistry jromSMR = null;
        boolean jromAvailable = WSIFServiceImpl.getJROMAvailability();
        if (jromAvailable) {
            jromSMR = new JROMSOAPMappingRegistry(smr);
        }
        this.setDynamicWSIFPort(null);
        this.setupTypeMappings(mapOfUserTypes, smr, jromSMR);
        try {
            TextMessage m = (TextMessage)msg;
            String payloadStr = m.getText();
            SOAPContext respCtx = new SOAPContext();
            respCtx.setRootPart(payloadStr, "text/xml");
            DocumentBuilder xdb = XMLParserUtils.getXMLDocBuilder();
            Document respDoc = xdb.parse(new InputSource(new StringReader(payloadStr)));
            Element payload = null;
            if (respDoc == null) {
                throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Parsing error, response was:\n" + payloadStr);
            }
            payload = respDoc.getDocumentElement();
            Envelope respEnv = Envelope.unmarshall(payload, respCtx);
            Response resp = null;
            resp = this.usingJROM ? Response.extractFromEnvelope(respEnv, jromSMR, respCtx) : Response.extractFromEnvelope(respEnv, smr, respCtx);
            return resp;
        }
        catch (Exception ex) {
            Trc.exception(ex);
            throw new WSIFException(ex.getMessage());
        }
    }

    private boolean buildResponseMessages(Response resp, WSIFMessage outMsg, WSIFMessage faultMsg) throws WSIFException {
        boolean respOK;
        if (resp == null) {
            throw new WSIFException("soap response is null");
        }
        if (resp.generatedFault()) {
            respOK = false;
            if (faultMsg != null) {
                Fault soapFault = resp.getFault();
                faultMsg.setName("org.apache.wsif.soap.fault");
                faultMsg.setObjectPart("org.apache.wsif.soap.fault.object", soapFault);
            }
        } else {
            respOK = true;
            this.populateOutMsgReturnPart(resp, outMsg);
            this.populateOutMsgParts(resp, outMsg);
        }
        return respOK;
    }

    private void populateOutMsgReturnPart(Response resp, WSIFMessage outMsg) throws WSIFException {
        if (outMsg != null && this.returnName != null) {
            Parameter retValue = resp.getReturnValue();
            if (retValue == null) {
                throw new WSIFException("return value not found in response message");
            }
            Object result = retValue.getValue();
            if (this.usingJROM) {
                if (!JROMValue.class.isAssignableFrom(result.getClass())) {
                    throw new WSIFException("return value " + result + " has unexpected type " + result.getClass() + " instead of an implementation of com.ibm.jrom.JROMValue");
                }
                outMsg.setRepresentationStyle("http://www.apache.org/namespaces/jrom");
            } else if (this.returnType != null && !this.returnType.isPrimitive() && result != null && !this.returnType.isAssignableFrom(result.getClass())) {
                throw new WSIFException("return value " + result + " has unexpected type " + result.getClass() + " instead of " + this.returnType);
            }
            outMsg.setObjectPart(this.returnName, result);
        }
    }

    private void populateOutMsgParts(Response resp, WSIFMessage outMsg) throws WSIFException {
        if (outMsg != null) {
            Vector respParms = resp.getParams();
            ArrayList wsdlOutParameters = this.getWSDLOutParams();
            if (respParms != null) {
                Iterator i = respParms.iterator();
                while (i.hasNext()) {
                    Parameter p = (Parameter)i.next();
                    String name2 = p.getName();
                    Object value2 = p.getValue();
                    if (this.usingJROM && value2 != null && !(value2 instanceof JROMValue)) {
                        throw new WSIFException("response part " + name2 + ", value " + value2 + " has unexpected type " + value2.getClass() + " instead of com.ibm.jrom.JROMValue");
                    }
                    outMsg.setObjectPart(name2, value2);
                    wsdlOutParameters.remove(name2);
                }
            }
            Iterator i = wsdlOutParameters.iterator();
            while (i.hasNext()) {
                outMsg.setObjectPart((String)i.next(), null);
            }
        }
    }

    public String getName() {
        Trc.entry(this);
        String s = this.operation.getName();
        Trc.exit(s);
        return s;
    }

    public String getSoapActionURI() {
        Trc.entry(this);
        Trc.exit(this.actionUri);
        return this.actionUri;
    }

    public void setSoapActionURI(String value2) {
        Trc.entry((Object)this, value2);
        this.actionUri = value2;
        Trc.exit();
    }

    public String getInputNamespace() {
        Trc.entry(this);
        Trc.exit(this.inputNamespace);
        return this.inputNamespace;
    }

    public void setInputNamespace(String value2) {
        Trc.entry((Object)this, value2);
        this.inputNamespace = value2;
        Trc.exit();
    }

    public String getInputEncodingStyle() {
        Trc.entry(this);
        Trc.exit(this.inputEncodingStyle);
        return this.inputEncodingStyle;
    }

    public void setInputEncodingStyle(String value2) {
        Trc.entry((Object)this, value2);
        this.inputEncodingStyle = value2;
        Trc.exit();
    }

    public String getOutputEncodingStyle() {
        Trc.entry(this);
        Trc.exit(this.outputEncodingStyle);
        return this.outputEncodingStyle;
    }

    public void setOutputEncodingStyle(String value2) {
        Trc.entry((Object)this, value2);
        this.outputEncodingStyle = value2;
        Trc.exit();
    }

    public List getPartNames() {
        Trc.entry(this);
        Trc.exit(this.partNames);
        return this.partNames;
    }

    public void setPartNames(List value2) {
        Trc.entry((Object)this, value2);
        this.partNames = value2;
        Trc.exit();
    }

    public String getReturnName() {
        Trc.entry(this);
        Trc.exit(this.returnName);
        return this.returnName;
    }

    public void setReturnName(String value2) {
        Trc.entry((Object)this, value2);
        this.returnName = value2;
        Trc.exit();
    }

    public Operation getOperation() {
        Trc.entry(this);
        Trc.exit(this.operation);
        return this.operation;
    }

    public void setOperation(Operation value2) {
        Trc.entry((Object)this, value2);
        this.operation = value2;
        Trc.exit();
    }

    public Definition getDefinition() {
        Trc.entry(this);
        Trc.exit(this.definition);
        return this.definition;
    }

    public void setDefinition(Definition value2) {
        Trc.entry((Object)this, value2);
        this.definition = value2;
        Trc.exit();
    }

    public WSIFPort_ApacheSOAP getDynamicWSIFPort() {
        Trc.entry(this);
        Trc.exit(this.portInstance);
        return this.portInstance;
    }

    public void setDynamicWSIFPort(WSIFPort_ApacheSOAP value2) {
        Trc.entry((Object)this, value2);
        this.portInstance = value2;
        Trc.exit();
    }

    public String getStyle() {
        Trc.entry(this);
        Trc.exit(this.style);
        return this.style;
    }

    WSIFResponseHandler getResponseHandler() {
        Trc.entry(this);
        Trc.exit(this.responseHandler);
        return this.responseHandler;
    }

    public SOAPTransport getTransport() {
        Trc.entry(this);
        SOAPTransport t = this.portInstance.getSOAPTransport();
        Trc.exit(t);
        return t;
    }

    public WSIFCorrelationId getAsyncRequestID() {
        Trc.entry(this);
        Trc.exit(this.asyncRequestID);
        return this.asyncRequestID;
    }

    void setAsyncRequestID(WSIFCorrelationId asyncRequestID) {
        Trc.entry((Object)this, asyncRequestID);
        this.asyncRequestID = asyncRequestID;
        Trc.exit();
    }

    private void setAsyncOperation(boolean b) {
        this.asyncOperation = b;
    }

    public void setStyle(String style) {
        Trc.entry((Object)this, style);
        this.style = style;
        Trc.exit();
    }

    private void setResponseHandler(WSIFResponseHandler responseHandler) {
        this.responseHandler = responseHandler;
    }

    public String getInputUse() {
        Trc.entry(this);
        Trc.exit(this.inputUse);
        return this.inputUse;
    }

    public void setInputUse(String inputUse) {
        Trc.entry((Object)this, inputUse);
        this.inputUse = inputUse;
        Trc.exit();
    }

    public String getOutputUse() {
        Trc.entry(this);
        Trc.exit(this.outputUse);
        return this.outputUse;
    }

    public void setOutputUse(String outputUse) {
        Trc.entry((Object)this, outputUse);
        this.outputUse = outputUse;
        Trc.exit();
    }

    public String getPartSerializerName() {
        Trc.entry(this);
        Trc.exit(this.partSerializerName);
        return this.partSerializerName;
    }

    private ArrayList getWSDLOutParams() {
        if (this.wsdlOutParams == null) {
            this.wsdlOutParams = new ArrayList();
        }
        return this.wsdlOutParams;
    }

    private void setWSDLOutParams(ArrayList al) {
        this.wsdlOutParams = al;
    }

    public WSIFPort getWSIFPort() {
        Trc.entry(this);
        Trc.exit(this.portInstance);
        return this.portInstance;
    }

    public boolean isAsyncOperation() {
        Trc.entry(this);
        Trc.exit(this.asyncOperation);
        return this.asyncOperation;
    }

    public void setPartSerializerName(String partSerializerName) {
        Trc.entry((Object)this, partSerializerName);
        this.partSerializerName = partSerializerName;
        Trc.exit();
    }

    private void setJMSOutPropsInContext(SOAPTransport t) throws WSIFException {
        if (!(t instanceof SOAPJMSConnection)) {
            return;
        }
        HashMap props = ((SOAPJMSConnection)t).getJmsProperties();
        if (props != null) {
            if (this.context == null) {
                this.context = new WSIFDefaultMessage();
            }
            this.context.setParts(props);
        }
    }

    private void setTransportContext(SOAPTransport t) {
        if (this.context == null || !(t instanceof SOAPJMSConnection)) {
            return;
        }
        HashMap<String, Object> jmsProps = new HashMap<String, Object>();
        Iterator i = this.context.getPartNames();
        while (i.hasNext()) {
            try {
                Object value2;
                String partName = (String)i.next();
                if (this.timeoutProperty(t, partName, value2 = this.context.getObjectPart(partName)) || !partName.startsWith("JMSProperty.")) continue;
                jmsProps.put(partName.substring("JMSProperty.".length()), value2);
            }
            catch (WSIFException ex) {
                Trc.ignoredException(ex);
            }
        }
        if (jmsProps.size() > 0) {
            ((SOAPJMSConnection)t).setJmsProperties(jmsProps);
        }
    }

    private void setCallContext(Call call) {
        Object o;
        call.setHeader(null);
        this.addHTTPHeader(call, "org.apache.wsif.http.UserName", null);
        this.addHTTPHeader(call, "org.apache.wsif.http.Password", null);
        if (this.context == null) {
            return;
        }
        String name2 = "org.apache.wsif.http.UserName";
        try {
            o = this.context.getObjectPart(name2);
            if (o instanceof String) {
                this.addHTTPHeader(call, name2, (String)o);
            }
        }
        catch (WSIFException ex) {
            Trc.ignoredException(ex);
            this.addHTTPHeader(call, name2, null);
        }
        name2 = "org.apache.wsif.http.Password";
        try {
            o = this.context.getObjectPart(name2);
            if (o instanceof String) {
                this.addHTTPHeader(call, name2, (String)o);
            }
        }
        catch (WSIFException ex) {
            Trc.ignoredException(ex);
            this.addHTTPHeader(call, name2, null);
        }
        try {
            name2 = "org.apache.wsif.soap.RequestHeaders";
            o = this.context.getObjectPart(name2);
            if (o instanceof List) {
                this.addSOAPHeader(call, name2, (List)o);
            }
        }
        catch (WSIFException ex) {
            Trc.ignoredException(ex);
        }
    }

    private void addSOAPHeader(Call call, String name2, List soapHeaders) {
        Header h = new Header();
        h.setHeaderEntries(new Vector(soapHeaders));
        call.setHeader(h);
    }

    private void addHTTPHeader(Call call, String name2, String value2) {
        SOAPTransport st = call.getSOAPTransport();
        if (st instanceof SOAPHTTPConnection) {
            SOAPHTTPConnection httpTransport = (SOAPHTTPConnection)st;
            if (name2.equals("org.apache.wsif.http.UserName")) {
                httpTransport.setUserName(value2);
            } else if (name2.equals("org.apache.wsif.http.Password")) {
                httpTransport.setPassword(value2);
            }
        }
    }

    private void addContextResponseSOAPHeaders(Header soapHeader) throws WSIFException {
        Vector headerEntries;
        if (soapHeader != null && (headerEntries = soapHeader.getHeaderEntries()) != null) {
            ArrayList headers = new ArrayList();
            Iterator i = headerEntries.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (o instanceof Element) {
                    headers.add(o);
                    continue;
                }
                Trc.event("unexpected response SOAP header type: ", o);
            }
            if (headers.size() > 0) {
                WSIFMessage context = this.getContext();
                context.setObjectPart("org.apache.wsif.soap.ResponseHeaders", headers);
                this.setContext(context);
            }
        }
    }

    private boolean isHostInNonProxyProperty(URL u) {
        String excludeList;
        if (u != null && (excludeList = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(WSIFOperation_ApacheSOAP.PROXY_EXCLUDES_PROPERTY);
            }
        })) != null) {
            StringTokenizer st = new StringTokenizer(excludeList, "|");
            while (st.hasMoreTokens()) {
                String xhost = st.nextToken().trim();
                if (!WSIFUtils.wildcardCompare(xhost, u.getHost(), '*')) continue;
                return true;
            }
        }
        return false;
    }

    private void setSOAPProxy(SOAPTransport st) throws WSIFException {
        if (st instanceof SOAPHTTPConnection) {
            SOAPHTTPConnection shttpc = (SOAPHTTPConnection)st;
            String proxyHost = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(WSIFOperation_ApacheSOAP.HTTP_PROXY_HOST_PROPERTY);
                }
            });
            String proxyPort = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(WSIFOperation_ApacheSOAP.HTTP_PROXY_PORT_PROPERTY);
                }
            });
            if (proxyHost != null && proxyHost.length() > 0) {
                shttpc.setProxyHost(proxyHost);
                if (proxyPort != null && proxyPort.length() > 0) {
                    try {
                        int port2 = Integer.parseInt(proxyPort);
                        shttpc.setProxyPort(port2);
                    }
                    catch (NumberFormatException ex) {
                        Trc.ignoredException(ex);
                    }
                }
                this.setProxyUserFromContext(shttpc);
            }
        }
    }

    private void setProxyUserFromContext(SOAPHTTPConnection shttpc) throws WSIFException {
        String pswd;
        String uid;
        block7: {
            WSIFMessage ctx = this.getContext();
            uid = null;
            pswd = null;
            try {
                Object o = ctx.getObjectPart("org.apache.wsif.http.proxy.UserName");
                if (o != null) {
                    if (o instanceof String) {
                        uid = (String)o;
                    } else {
                        throw new WSIFException("invalid value type for context part 'org.apache.wsif.http.proxy.UserName', found value: " + o);
                    }
                }
                if ((o = ctx.getObjectPart("org.apache.wsif.http.proxy.Password")) == null) break block7;
                if (o instanceof String) {
                    pswd = (String)o;
                    break block7;
                }
                throw new WSIFException("invalid value type for context part 'org.apache.wsif.http.proxy.Password', found value: " + o);
            }
            catch (WSIFException e2) {
                Trc.ignoredException(e2);
            }
        }
        if (uid != null) {
            shttpc.setProxyUserName(uid);
            shttpc.setProxyPassword(pswd);
        }
    }

    private void checkForTimeoutProperties(SOAPTransport st, HashMap inJmsPropVals) {
        if (inJmsPropVals != null) {
            Iterator i = inJmsPropVals.keySet().iterator();
            while (i.hasNext()) {
                Object value2;
                String name2 = (String)i.next();
                if (!this.timeoutProperty(st, name2, value2 = inJmsPropVals.get(name2))) continue;
                i.remove();
            }
        }
    }

    private boolean timeoutProperty(SOAPTransport t, String propertyName, Object value2) {
        Trc.entry(this, t, propertyName, value2);
        boolean isTimeoutProperty = false;
        if (t != null && t instanceof SOAPJMSConnection) {
            SOAPJMSConnection st = (SOAPJMSConnection)t;
            try {
                if ("wsif.syncrequest.timeout".equals(propertyName)) {
                    isTimeoutProperty = true;
                    long syncTimeout = Long.parseLong(value2.toString());
                    st.setSyncTimeout(syncTimeout);
                    Trc.event(this, "overridding syncTimeout to " + syncTimeout);
                } else if ("wsif.asyncrequest.timeout".equals(propertyName)) {
                    isTimeoutProperty = true;
                    long asyncTimeout = Long.parseLong(value2.toString());
                    st.setAsyncTimeout(asyncTimeout);
                    Trc.event(this, "overridding asyncTimeout to " + asyncTimeout);
                }
            }
            catch (NumberFormatException ex) {
                Trc.ignoredException(ex);
            }
        }
        Trc.exit(isTimeoutProperty);
        return isTimeoutProperty;
    }

    public String deep() {
        String buff = "";
        try {
            buff = new String(super.toString() + ":\n");
            buff = buff + " style:" + this.style;
            buff = buff + " portInstance:" + this.portInstance;
            buff = buff + " operation:" + Trc.brief(this.operation);
            buff = buff + " definition:" + Trc.brief(this.definition);
            buff = buff + " context:" + this.context;
            buff = buff + " partNames:" + this.partNames;
            buff = buff + Trc.brief("names", this.names);
            buff = buff + Trc.brief("types", this.types);
            buff = buff + " inputEncodingStyle:" + this.inputEncodingStyle;
            buff = buff + " inputNamespace:" + this.inputNamespace;
            buff = buff + " returnType:" + this.returnType;
            buff = buff + " actionUri:" + this.actionUri;
            buff = buff + " inJmsProps:" + this.inJmsProps;
            buff = buff + " outJmsProps:" + this.outJmsProps;
            buff = buff + " inJmsPropVals:" + this.inJmsPropVals;
            buff = buff + " asyncOperation:" + this.asyncOperation;
            buff = buff + " asyncRequestID:" + this.asyncRequestID;
            buff = buff + " responseHandler:" + this.responseHandler;
            buff = buff + " outputEncodingStyle:" + this.outputEncodingStyle;
            buff = buff + " returnName:" + this.returnName;
            buff = buff + " prepared:" + this.prepared;
            buff = buff + " typeMap:" + this.typeMap;
            buff = buff + " inputUse:" + this.inputUse;
            buff = buff + " outputUse:" + this.outputUse;
            buff = buff + " partSerializerName:" + this.partSerializerName;
        }
        catch (Exception e2) {
            Trc.exceptionInTrace(e2);
        }
        return buff;
    }
}

