/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers.soap.apachesoap;

import java.math.BigDecimal;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.apache.wsif.logging.Trc;

public class WSIFSOAPMappingRegistry
extends SOAPMappingRegistry {
    public WSIFSOAPMappingRegistry() {
        Trc.entry(this);
        Trc.exit();
    }

    public WSIFSOAPMappingRegistry(SOAPMappingRegistry registry) {
        super(registry);
        Trc.entry((Object)this, registry);
        Trc.exit();
    }

    public WSIFSOAPMappingRegistry(SOAPMappingRegistry registry, String schemaURI) {
        super(registry, schemaURI);
        Trc.entry(this, registry, schemaURI);
        Trc.exit();
    }

    protected Serializer querySerializer_(Class javaType, String encodingStyleURI) {
        Trc.entry(this, javaType, encodingStyleURI);
        Serializer ser = super.querySerializer_(javaType, encodingStyleURI);
        Trc.exit(ser);
        return ser;
    }

    protected Deserializer queryDeserializer_(QName elementType, String encodingStyleURI) {
        QName qn;
        Trc.entry(this, elementType, encodingStyleURI);
        Deserializer deser = null;
        if (elementType != null && elementType.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/encoding/") && (qn = this.getEquivalentXSDSimpleType(elementType)) != null) {
            deser = super.queryDeserializer_(qn, encodingStyleURI);
        }
        if (deser == null) {
            deser = super.queryDeserializer_(elementType, encodingStyleURI);
        }
        Trc.exit(deser);
        return deser;
    }

    protected QName queryElementType_(Class javaType, String encodingStyleURI) {
        return super.queryElementType_(javaType, encodingStyleURI);
    }

    protected Class queryJavaType_(QName elementType, String encodingStyleURI) {
        Class cls = null;
        if (elementType != null && elementType.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/encoding/")) {
            cls = this.resolveSOAPENCSimpleType(elementType);
        }
        if (cls == null) {
            return super.queryJavaType_(elementType, encodingStyleURI);
        }
        return cls;
    }

    private QName getEquivalentXSDSimpleType(QName elementType) {
        if (elementType == null || !elementType.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/encoding/")) {
            return null;
        }
        String lp = elementType.getLocalPart();
        if (lp == null) {
            return null;
        }
        if (lp.equals("string")) {
            return new QName("http://www.w3.org/2001/XMLSchema", "string");
        }
        if (lp.equals("boolean")) {
            return new QName("http://www.w3.org/2001/XMLSchema", "boolean");
        }
        if (lp.equals("float")) {
            return new QName("http://www.w3.org/2001/XMLSchema", "float");
        }
        if (lp.equals("double")) {
            return new QName("http://www.w3.org/2001/XMLSchema", "double");
        }
        if (lp.equals("decimal")) {
            return new QName("http://www.w3.org/2001/XMLSchema", "decimal");
        }
        if (lp.equals("int")) {
            return new QName("http://www.w3.org/2001/XMLSchema", "int");
        }
        if (lp.equals("short")) {
            return new QName("http://www.w3.org/2001/XMLSchema", "short");
        }
        if (lp.equals("byte")) {
            return new QName("http://www.w3.org/2001/XMLSchema", "byte");
        }
        if (lp.equals("base64")) {
            return new QName("http://www.w3.org/2001/XMLSchema", "base64Binary");
        }
        return null;
    }

    private Class resolveSOAPENCSimpleType(QName elementType) {
        if (elementType == null || !elementType.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/encoding/")) {
            return null;
        }
        String lp = elementType.getLocalPart();
        if (lp == null) {
            return null;
        }
        if (lp.equals("string")) {
            return String.class;
        }
        if (lp.equals("boolean")) {
            return Boolean.class;
        }
        if (lp.equals("float")) {
            return Float.class;
        }
        if (lp.equals("double")) {
            return Double.class;
        }
        if (lp.equals("decimal")) {
            return BigDecimal.class;
        }
        if (lp.equals("int")) {
            return Integer.class;
        }
        if (lp.equals("short")) {
            return Short.class;
        }
        if (lp.equals("byte")) {
            return Byte.class;
        }
        if (lp.equals("base64")) {
            return [B.class;
        }
        return null;
    }
}

