/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.schema;

import java.io.Serializable;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.wsif.schema.Attribute;
import org.apache.wsif.schema.ComplexContent;
import org.apache.wsif.schema.Restriction;
import org.apache.wsif.schema.SchemaType;
import org.apache.wsif.schema.SequenceElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ComplexType
extends SchemaType
implements Serializable {
    static final long serialVersionUID = 1L;
    private boolean isAnArray = false;
    private String name = "";
    private QName typeName = null;
    private QName arrayType = null;
    private int arrayDim = 0;
    private ComplexContent complexContent = null;
    private static final QName soapEncArray = new QName("http://schemas.xmlsoap.org/soap/encoding/", "Array");
    private static final QName soapEncArrayType = new QName("http://schemas.xmlsoap.org/soap/encoding/", "arrayType");
    private static final QName wsdlArrayType = new QName("http://schemas.xmlsoap.org/wsdl/", "arrayType");
    ArrayList sequenceElements = new ArrayList();

    ComplexType(Element el, String tns) {
        String lp;
        String ns;
        QName tempType;
        this.typeName = ComplexType.getAttributeQName(el, "name", tns);
        if (this.typeName != null) {
            this.name = this.typeName.getLocalPart();
        }
        this.process(el, tns);
        if (this.sequenceElements.size() == 1) {
            SequenceElement sel = (SequenceElement)this.sequenceElements.get(0);
            QName maxOccursQN = sel.getXMLAttribute("maxOccurs");
            QName minOccursQN = sel.getXMLAttribute("minOccurs");
            if (maxOccursQN != null && minOccursQN != null) {
                String max2 = maxOccursQN.getLocalPart();
                String min2 = minOccursQN.getLocalPart();
                if ("unbounded".equals(max2) && "0".equals(min2) && (tempType = sel.getXMLAttribute("type")) != null) {
                    ns = tempType.getNamespaceURI();
                    lp = tempType.getLocalPart();
                    this.arrayType = new QName(ns, lp);
                    this.isAnArray = true;
                }
            }
        }
        if (!this.isAnArray && this.name.startsWith("ArrayOf") && this.complexContent != null) {
            QName base;
            Restriction res = this.complexContent.getRestriction();
            if (res != null && soapEncArray.equals(base = res.getBase())) {
                Attribute[] atts = res.getAttributes();
                if (atts != null && atts.length > 0) {
                    for (int i = 0; i < atts.length; ++i) {
                        QName ref;
                        Attribute a = atts[i];
                        if (a == null || !soapEncArrayType.equals(ref = a.getXMLAttribute("ref"))) continue;
                        QName tempType2 = a.getXMLAttribute(wsdlArrayType);
                        if (tempType2 != null) {
                            String ns2 = tempType2.getNamespaceURI();
                            String lp2 = tempType2.getLocalPart();
                            int index = lp2.lastIndexOf("[]");
                            while (index != -1) {
                                lp2 = lp2.substring(0, index);
                                ++this.arrayDim;
                                index = lp2.lastIndexOf("[]");
                            }
                            this.arrayType = new QName(ns2, lp2);
                        }
                        break;
                    }
                } else {
                    SequenceElement sel;
                    SequenceElement[] sels = res.getSequenceElements();
                    if (sels != null && sels.length == 1 && (tempType = (sel = sels[0]).getXMLAttribute("type")) != null) {
                        ns = tempType.getNamespaceURI();
                        lp = tempType.getLocalPart();
                        this.arrayType = new QName(ns, lp);
                    }
                }
            }
            this.isAnArray = true;
        }
    }

    public boolean isComplex() {
        return true;
    }

    public boolean isArray() {
        return this.isAnArray;
    }

    public QName getArrayType() {
        return this.arrayType;
    }

    public int getArrayDimension() {
        return this.arrayDim;
    }

    public QName getTypeName() {
        return this.typeName;
    }

    public SequenceElement[] getSequenceElements() {
        return this.sequenceElements.toArray(new SequenceElement[this.sequenceElements.size()]);
    }

    private void process(Element el, String tns) {
        NodeList children = el.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child2 = children.item(i);
            if (child2.getNodeType() != 1) continue;
            Element subEl = (Element)child2;
            String elType = subEl.getLocalName();
            if (elType.equals("complexContent")) {
                this.complexContent = new ComplexContent(subEl, tns);
                continue;
            }
            if (!elType.equals("sequence")) continue;
            this.parseSequenceElements(subEl, tns);
        }
    }

    private void parseSequenceElements(Element el, String tns) {
        NodeList children = el.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element subEl;
            String elType;
            Node child2 = children.item(i);
            if (child2.getNodeType() != 1 || !(elType = (subEl = (Element)child2).getLocalName()).equals("element")) continue;
            this.sequenceElements.add(new SequenceElement(subEl, tns));
        }
    }
}

