/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.wsif.schema.ComplexType;
import org.apache.wsif.schema.SchemaType;
import org.apache.wsif.schema.SimpleType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ElementType
extends SchemaType
implements Serializable {
    static final long serialVersionUID = 1L;
    private String name = "";
    private QName typeName = null;
    private QName elementType = null;
    private List childTypes = new ArrayList();
    private boolean nillable = false;

    ElementType(Element el, String tns) {
        this.elementType = ElementType.getAttributeQName(el, "type", tns);
        this.typeName = ElementType.getAttributeQName(el, "name", tns);
        QName nillableAttr = ElementType.getAttributeQName(el, "nillable", null);
        String stTrue = "true";
        if (nillableAttr != null && stTrue.equals(nillableAttr.getLocalPart())) {
            this.nillable = true;
        }
        if (this.typeName == null) {
            return;
        }
        this.name = this.typeName.getLocalPart();
        NodeList children = el.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child2 = children.item(i);
            if (child2.getNodeType() != 1) continue;
            Element subEl = (Element)child2;
            String elType = subEl.getLocalName();
            if (elType.equals("complexType")) {
                this.childTypes.add(new ComplexType(subEl, tns));
                continue;
            }
            if (elType.equals("simpleType")) {
                this.childTypes.add(new SimpleType(subEl, tns));
                continue;
            }
            if (!elType.equals("element")) continue;
            this.childTypes.add(new ElementType(subEl, tns));
        }
    }

    public boolean isElement() {
        return true;
    }

    public QName getTypeName() {
        return this.typeName;
    }

    public QName getElementType() {
        return this.elementType;
    }

    public boolean isNillable() {
        return this.nillable;
    }

    public List getChildren() {
        return this.childTypes;
    }
}

