/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wsif.schema.ComplexType;
import org.apache.wsif.schema.ElementType;
import org.apache.wsif.schema.SimpleType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Schema
implements Serializable {
    static final long serialVersionUID = 1L;
    private String targetNamespace = "";
    private ArrayList types = new ArrayList();
    private ArrayList imports = new ArrayList();
    private ArrayList includes = new ArrayList();

    public Schema(Element el) {
        this.initialize(el, null);
    }

    public Schema(Element el, String parentTargetNamespace) {
        this.initialize(el, parentTargetNamespace);
    }

    private void initialize(Element el, String parentTargetNamespace) {
        this.targetNamespace = el.getAttribute("targetNamespace");
        if (parentTargetNamespace != null && !el.hasAttribute("targetNamespace")) {
            this.targetNamespace = parentTargetNamespace;
        }
        NodeList children = el.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String loc;
            Node child2 = children.item(i);
            if (child2.getNodeType() != 1) continue;
            Element subEl = (Element)child2;
            String elType = subEl.getLocalName();
            if (elType.equals("complexType")) {
                this.types.add(new ComplexType(subEl, this.targetNamespace));
                continue;
            }
            if (elType.equals("simpleType")) {
                this.types.add(new SimpleType(subEl, this.targetNamespace));
                continue;
            }
            if (elType.equals("element")) {
                this.types.add(new ElementType(subEl, this.targetNamespace));
                continue;
            }
            if (elType.equals("import")) {
                loc = subEl.getAttribute("schemaLocation");
                if (loc == null || loc.equals("")) continue;
                this.imports.add(loc);
                continue;
            }
            if (!elType.equals("include") || (loc = subEl.getAttribute("schemaLocation")) == null || loc.equals("")) continue;
            this.includes.add(loc);
        }
    }

    public List getTypes() {
        return this.types;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public String[] getImportsAndIncludes() {
        int i;
        int importsSize = this.imports.size();
        int includesSize = this.includes.size();
        String[] importsAndIncludes = new String[importsSize + includesSize];
        for (i = 0; i < importsSize; ++i) {
            importsAndIncludes[i] = (String)this.imports.get(i);
        }
        for (i = 0; i < includesSize; ++i) {
            importsAndIncludes[i + importsSize] = (String)this.includes.get(i);
        }
        return importsAndIncludes;
    }

    public String[] getImports() {
        return this.imports.toArray(new String[this.imports.size()]);
    }

    public String[] getIncludes() {
        return this.includes.toArray(new String[this.includes.size()]);
    }
}

