/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.util;

import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import org.apache.wsif.logging.Trc;

public class WSIFProperties {
    private static Properties properties;

    public static String getProperty(String property) {
        Trc.entry(null, property);
        if (properties == null) {
            properties = (Properties)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("wsif.properties");
                    if (in == null) {
                        in = this.getClass().getClassLoader().getResourceAsStream("wsif.properties");
                    }
                    Properties p2 = new Properties();
                    try {
                        p2.load(in);
                    }
                    catch (Exception ignored) {
                        Trc.exception(ignored);
                        return null;
                    }
                    return p2;
                }
            });
        }
        if (properties == null) {
            Trc.exit(null);
            return null;
        }
        String s = properties.getProperty(property);
        Trc.exit(s);
        return s;
    }

    public static long getAsyncTimeout() {
        long t;
        Trc.entry(null);
        try {
            t = Long.parseLong(WSIFProperties.getProperty("wsif.asyncrequest.timeout"));
            t = t < 0L ? 0L : (t *= 1000L);
        }
        catch (NumberFormatException e2) {
            Trc.exception(e2);
            t = 0L;
        }
        Trc.exit(new Long(t));
        return t;
    }

    public static long getSyncTimeout() {
        long t;
        Trc.entry(null);
        try {
            t = Long.parseLong(WSIFProperties.getProperty("wsif.syncrequest.timeout"));
            if (t < 0L) {
                t = 0L;
            }
        }
        catch (NumberFormatException e2) {
            Trc.exception(e2);
            t = 0L;
        }
        Trc.exit(new Long(t));
        return t;
    }

    public static boolean areUnreferencedAttachmentsSupported() {
        Trc.entry(null);
        boolean ret = false;
        String value2 = WSIFProperties.getProperty("wsif.unreferencedattachments");
        if ("on".equals(value2)) {
            ret = true;
        }
        Trc.exit(ret);
        return ret;
    }
}

