/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.util.jms;

import java.util.ArrayList;
import java.util.Arrays;
import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import org.apache.wsif.WSIFException;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.util.jms.WSIFJMSFinderForJndi;
import org.apache.wsif.util.jms.WSIFJMSFinderForMq;
import org.apache.wsif.wsdl.extensions.jms.JMSAddress;

public abstract class WSIFJMSFinder {
    public static final String STYLE_QUEUE = "queue";
    public static final String STYLE_TOPIC = "topic";
    protected static final ArrayList allStyles = new ArrayList<Object>(Arrays.asList("queue", "topic"));
    private static final String MQ_URL_PREFIX = "mq://";

    public abstract QueueConnectionFactory getFactory();

    public abstract Destination getInitialDestination();

    abstract Queue findQueue(String var1) throws WSIFException;

    abstract String getStyle();

    /*
     * WARNING - void declaration
     */
    public static WSIFJMSFinder newFinder(JMSAddress ja, String portName) throws WSIFException {
        void var4_4;
        WSIFJMSFinder finder;
        Trc.entry(null, ja);
        boolean jndiSpecified = ja.getInitCxtFact() != null || ja.getJndiProvURL() != null || ja.getDestStyle() != null || ja.getJndiConnFactName() != null || ja.getJndiDestName() != null || ja.getJmsProvDestName() != null;
        String implSpecURI = ja.getJmsImplSpecURI();
        if (jndiSpecified && implSpecURI != null) {
            throw new WSIFException("Cannot specify both JNDI attributes and jmsImplementationSpecificURL in the jms:address in port " + portName);
        }
        if (!jndiSpecified && implSpecURI == null) {
            throw new WSIFException("Must specify either JNDI attributes or jmsImplementationSpecificURL in the jms:address in port " + portName);
        }
        if (jndiSpecified) {
            finder = new WSIFJMSFinderForJndi(ja.getJmsVendorURI(), ja.getInitCxtFact(), ja.getJndiProvURL(), ja.getDestStyle(), ja.getJndiConnFactName(), ja.getJndiDestName(), portName);
        } else if (implSpecURI.startsWith(MQ_URL_PREFIX)) {
            finder = new WSIFJMSFinderForMq(ja.getJmsVendorURI(), implSpecURI);
        } else {
            throw new WSIFException("No jms implementation found for jmsImplementationSpecificURI '" + implSpecURI + "' for port " + portName);
        }
        Trc.exit(var4_4);
        return var4_4;
    }
}

