/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.util.jms;

import java.util.Hashtable;
import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import org.apache.wsif.WSIFException;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.util.jms.WSIFJMSFinder;

public class WSIFJMSFinderForJndi
extends WSIFJMSFinder {
    private InitialDirContext namedJndiContext;
    private InitialDirContext containersJndiContext;
    private QueueConnectionFactory factory;
    private Destination initialDestination;
    private String style;
    private String portName;

    public WSIFJMSFinderForJndi(String jmsVendorURL, String initialContextFactory, String jndiProviderURL, String style, String jndiConnectionFactory, String jndiDestinationName, String portName) throws WSIFException {
        block21: {
            this.namedJndiContext = null;
            this.containersJndiContext = null;
            this.initialDestination = null;
            Trc.entry(this, jmsVendorURL, initialContextFactory, jndiProviderURL, style, jndiConnectionFactory, jndiDestinationName, portName);
            if (!allStyles.contains(style)) {
                throw new WSIFException("Style must either be queue or topic");
            }
            this.style = style;
            if (portName == null) {
                portName = "<null>";
            }
            this.portName = portName;
            if (initialContextFactory == null && jndiProviderURL != null || initialContextFactory != null && jndiProviderURL == null) {
                throw new WSIFException("Either both initialContextFactory and jndiProviderURL must be specified or neither of them must be specified. Port=" + portName);
            }
            if (initialContextFactory != null && jndiProviderURL != null) {
                Hashtable<String, String> environment = new Hashtable<String, String>();
                environment.put("java.naming.factory.initial", initialContextFactory);
                environment.put("java.naming.provider.url", jndiProviderURL);
                try {
                    this.namedJndiContext = new InitialDirContext(environment);
                }
                catch (NamingException ne) {
                    Trc.exception(ne);
                    throw new WSIFException("WSIFJMSFinderForJndi caught '" + ne + "'. InitialContextFactory was '" + initialContextFactory + "' ProviderUrl was '" + jndiProviderURL + "'. Port=" + portName);
                }
            }
            try {
                this.containersJndiContext = new InitialDirContext();
            }
            catch (NamingException ne) {
                Trc.exception(ne);
                if (initialContextFactory != null || jndiProviderURL != null) break block21;
                throw new WSIFException("WSIFJMSFinderForJndi caught '" + ne + "' using the default JNDI repository. Port=" + portName);
            }
        }
        if ("topic".equals(style)) {
            throw new WSIFException("Topics not implemented. Port=" + portName);
        }
        if (!"queue".equals(style)) {
            throw new WSIFException("jms:address must either be a queue or a topic not a '" + (style == null ? "null" : style) + "'. Port=" + portName);
        }
        if (jndiConnectionFactory == null) {
            throw new WSIFException("jndiConnectionFactory must be specified in port " + portName);
        }
        try {
            this.factory = (QueueConnectionFactory)this.lookup(jndiConnectionFactory);
            if (this.factory == null) {
                throw new WSIFException("WSIFJMSFinderForJndi was not able to lookup the ConnectionFactory " + jndiConnectionFactory + " in JNDI. Port=" + portName);
            }
        }
        catch (ClassCastException cce) {
            Trc.exception(cce);
            throw new WSIFException("WSIFJMSFinderForJndi caught ClassCastException. The ConnectionFactory " + jndiConnectionFactory + " in JNDI was not defined to be a connection factory. Port=" + portName + " " + cce);
        }
        catch (NamingException ne) {
            Trc.exception(ne);
            throw new WSIFException("WSIFJMSFinderForJndi caught NamingException. The ConnectionFactory " + jndiConnectionFactory + " in JNDI was not defined to be a connection factory. Port=" + portName + " " + ne);
        }
        if (jndiDestinationName != null) {
            try {
                this.initialDestination = (Destination)this.lookup(jndiDestinationName);
                if (this.initialDestination == null) {
                    throw new WSIFException("WSIFJMSFinderForJndi was not able to lookup the Destination " + jndiDestinationName + " in JNDI. Port=" + portName);
                }
            }
            catch (ClassCastException cce) {
                Trc.exception(cce);
                throw new WSIFException("WSIFJMSFinderForJndi caught ClassCastException. The Destination " + jndiDestinationName + " in JNDI was not defined to be a destination. Port=" + portName + " " + cce);
            }
            catch (NamingException cce) {
                Trc.exception(cce);
                throw new WSIFException("WSIFJMSFinderForJndi caught NamingException. The Destination " + jndiDestinationName + " in JNDI was not defined to be a destination. Port=" + portName + " " + cce);
            }
        }
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    public QueueConnectionFactory getFactory() {
        Trc.entry(this);
        Trc.exit(this.factory);
        return this.factory;
    }

    public Destination getInitialDestination() {
        Trc.entry(this);
        Trc.exit(this.initialDestination);
        return this.initialDestination;
    }

    String getStyle() {
        Trc.entry(this);
        Trc.exit(this.style);
        return this.style;
    }

    Queue findQueue(String name2) throws WSIFException {
        Trc.entry((Object)this, name2);
        Queue q = null;
        try {
            q = (Queue)this.lookup(name2);
            if (q == null) {
                throw new WSIFException("WSIFJMSFinderForJndi was not able to lookup the Destination " + name2 + " in JNDI.Port=" + this.portName);
            }
        }
        catch (ClassCastException cce) {
            Trc.exception(cce);
            throw new WSIFException("WSIFJMSFinderForJndi caught ClassCastException. The Queue " + name2 + " in JNDI was not defined to be a queue. Port=" + this.portName + " " + cce);
        }
        catch (NamingException ne) {
            Trc.exception(ne);
            throw new WSIFException("WSIFJMSFinderForJndi caught NamingException. The Queue " + name2 + " in JNDI was not defined to be a queue. Port=" + this.portName + " " + ne);
        }
        Trc.exit(q);
        return q;
    }

    private Object lookupJNDIName(String name2) throws NamingException {
        Trc.entry((Object)this, name2);
        Object result = null;
        if (this.containersJndiContext != null) {
            try {
                result = this.containersJndiContext.lookup(name2);
            }
            catch (NamingException ne) {
                Trc.ignoredException(ne);
                if (this.namedJndiContext != null) {
                    result = this.namedJndiContext.lookup(name2);
                }
                throw ne;
            }
        } else {
            result = this.namedJndiContext.lookup(name2);
        }
        Trc.exit(result);
        return result;
    }

    private Object lookup(String name2) throws NamingException {
        Trc.entry((Object)this, name2);
        Object result = null;
        try {
            result = this.lookupJNDIName("java:comp/env/" + name2);
        }
        catch (NamingException ignored) {
            Trc.ignoredException(ignored);
            result = this.lookupJNDIName(name2);
        }
        Trc.exit(result);
        return result;
    }

    public String deep() {
        StringBuffer buff = new StringBuffer();
        try {
            buff.append(this.toString() + "\n");
            buff.append("containersJndiContext: " + this.containersJndiContext);
            buff.append(" namedJndiContext: " + this.namedJndiContext);
            buff.append(" factory: " + this.factory);
            buff.append(" initialDestination: " + this.initialDestination);
            buff.append(" style: " + this.style);
            buff.append(" portName: " + this.portName);
        }
        catch (Exception e2) {
            Trc.exceptionInTrace(e2);
        }
        return buff.toString();
    }
}

