/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.util.jms;

import java.util.HashMap;
import javax.jms.Message;
import org.apache.wsif.WSIFException;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.util.jms.WSIFJMSProperties;

public class WSIFJMSMessageProperties {
    private Message lastMessage;
    private WSIFJMSProperties outProps;

    public WSIFJMSMessageProperties() throws WSIFException {
        Trc.entry(this);
        this.outProps = new WSIFJMSProperties("out");
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    public void setMessage(Message msg) {
        Trc.entry((Object)this, msg);
        this.lastMessage = msg;
        Trc.exit();
    }

    public HashMap getProperties() throws WSIFException {
        Trc.entry(this);
        if (this.lastMessage == null) {
            Trc.exit(null);
            return null;
        }
        if (this.outProps.isEmpty()) {
            this.outProps.getPropertiesFromMessage(this.lastMessage);
        }
        if (!this.outProps.isEmpty()) {
            Trc.exit(this.outProps);
            return this.outProps;
        }
        Trc.exit(null);
        return null;
    }

    public Object getProperty(String name2) throws WSIFException {
        Trc.entry((Object)this, name2);
        if (this.lastMessage == null) {
            Trc.exit(null);
            return null;
        }
        if (this.outProps.isEmpty()) {
            this.outProps.getPropertiesFromMessage(this.lastMessage);
        }
        Object prop = null;
        if (name2 != null) {
            prop = this.outProps.get(name2);
        }
        Trc.exit(prop);
        return prop;
    }

    public String deep() {
        String buff = "";
        try {
            buff = new String(this.toString() + "\n");
            buff = buff + " outProps: " + this.outProps;
            buff = buff + " message: " + this.lastMessage;
        }
        catch (Exception e2) {
            Trc.exceptionInTrace(e2);
        }
        return buff;
    }

    public String toString() {
        return "WSIFJMSMessageProperties(" + this.hashCode() + ")";
    }
}

