/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.wsdl;

import com.ibm.wsdl.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.wsdl.xml.WSDLLocator;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.wsdl.ClosableLocator;
import org.xml.sax.InputSource;

public class WSIFWSDLLocatorImpl
implements WSDLLocator,
ClosableLocator {
    private static final String DUMMY_XSD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xsd:schema targetNamespace=\"http://wsif.temp\" xmlns=\"http://wsif.temp\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" />";
    protected Reader baseReader = null;
    protected InputStream baseInputStream = null;
    protected InputStream importInputStream = null;
    protected String contextURI = null;
    protected String wsdlLocation = null;
    protected String documentBase = null;
    protected String importBase = null;
    protected ClassLoader loader = null;

    public WSIFWSDLLocatorImpl(String ctxt, String wsdlURI, ClassLoader cl) {
        Trc.entry(this, ctxt, wsdlURI, cl);
        this.contextURI = ctxt;
        this.wsdlLocation = wsdlURI;
        this.loader = cl;
        Trc.exit();
    }

    public WSIFWSDLLocatorImpl(String docBase, Reader reader, ClassLoader cl) {
        Trc.entry(this, docBase, cl);
        this.documentBase = docBase;
        this.baseReader = reader;
        this.loader = cl;
        Trc.exit();
    }

    public InputSource getBaseInputSource() {
        Trc.entry(this);
        if (this.baseReader != null) {
            InputSource ret = new InputSource(this.baseReader);
            Trc.exit(ret);
            return ret;
        }
        if (this.baseInputStream == null) {
            try {
                URL contextURL;
                URL url = null;
                URL uRL = contextURL = this.contextURI != null ? StringUtils.getURL(null, this.contextURI) : null;
                if (this.loader != null) {
                    try {
                        boolean remoteBase;
                        url = contextURL != null ? new URL(contextURL, this.wsdlLocation) : (this.wsdlLocation.indexOf(":") == -1 ? new URL("file", null, this.wsdlLocation) : new URL(this.wsdlLocation));
                        String protocol2 = url.getProtocol();
                        boolean bl = protocol2 != null ? protocol2.startsWith("http") || protocol2.startsWith("ftp") : (remoteBase = false);
                        if (!remoteBase) {
                            String wsdlRelativeLocation = url.getPath();
                            if (wsdlRelativeLocation.startsWith("/")) {
                                wsdlRelativeLocation = wsdlRelativeLocation.substring(1);
                            }
                            this.baseInputStream = this.loader.getResourceAsStream(wsdlRelativeLocation);
                        }
                    }
                    catch (Exception exc) {
                        Trc.ignoredException(exc);
                    }
                }
                if (this.baseInputStream == null) {
                    url = StringUtils.getURL(contextURL, this.wsdlLocation);
                    this.baseInputStream = this.getContentAsInputStreamSec(url);
                }
                if (url != null) {
                    this.documentBase = url.toString();
                } else if (this.baseInputStream == null) {
                    this.documentBase = this.wsdlLocation;
                }
            }
            catch (Exception e2) {
                Trc.exception(e2);
                this.documentBase = this.wsdlLocation;
            }
        }
        if (this.baseInputStream == null) {
            Trc.exit(null);
            return null;
        }
        InputSource ret = new InputSource(this.baseInputStream);
        Trc.exit(ret);
        return ret;
    }

    public InputSource getImportInputSource(String base, String relativeLocation) {
        Trc.entry(this, base, relativeLocation);
        if (relativeLocation.startsWith("http://schemas.xmlsoap.org")) {
            InputSource dummy = this.getDummySchema();
            this.importBase = relativeLocation;
            Trc.exit(dummy);
            return dummy;
        }
        this.importInputStream = null;
        boolean triedSU = false;
        try {
            boolean remoteBase;
            URL url = null;
            boolean bl = base != null ? base.startsWith("http") || base.startsWith("ftp") : (remoteBase = false);
            if (this.loader != null && !remoteBase) {
                if (relativeLocation.startsWith("/") || relativeLocation.startsWith("\\")) {
                    relativeLocation = relativeLocation.substring(1, relativeLocation.length());
                    this.importInputStream = this.loader.getResourceAsStream(relativeLocation);
                } else if (relativeLocation.indexOf("://") != -1) {
                    triedSU = true;
                    url = StringUtils.getURL(null, relativeLocation);
                    this.importInputStream = this.getContentAsInputStreamSec(url);
                } else if (base != null) {
                    int i = base.lastIndexOf("/");
                    if (i == -1) {
                        i = base.lastIndexOf("\\");
                    }
                    if (i != -1) {
                        String path = base.substring(0, i + 1);
                        String resolvedPath = path + relativeLocation;
                        if (relativeLocation.startsWith("..")) {
                            resolvedPath = this.resolvePath(path, relativeLocation);
                        }
                        if (resolvedPath == null) {
                            throw new Exception("Invalid Path");
                        }
                        url = (resolvedPath = this.tidyPath(resolvedPath)).startsWith("file:") ? new URL(null, resolvedPath) : new URL(null, "file:" + resolvedPath);
                    } else {
                        url = new URL(null, "file:" + relativeLocation);
                    }
                    this.importInputStream = this.loader.getResourceAsStream(url.getPath());
                } else {
                    url = new URL(null, "file:" + relativeLocation);
                    this.importInputStream = this.loader.getResourceAsStream(url.getPath());
                }
            } else {
                triedSU = true;
                URL contextURL = base != null ? StringUtils.getURL(null, base) : null;
                url = StringUtils.getURL(contextURL, relativeLocation);
                this.importInputStream = this.getContentAsInputStreamSec(url);
            }
            if (this.importInputStream == null) {
                if (!triedSU) {
                    try {
                        URL contextURL = base != null ? StringUtils.getURL(null, base) : null;
                        URL url2 = StringUtils.getURL(contextURL, relativeLocation);
                        this.importInputStream = this.getContentAsInputStreamSec(url2);
                        this.importBase = url2 == null ? relativeLocation : url2.toString();
                    }
                    catch (Exception e2) {
                        Trc.exception(e2);
                        this.importBase = "unknownImportURI";
                    }
                } else {
                    this.importBase = "unknownImportURI";
                }
            } else {
                this.importBase = url == null ? relativeLocation : url.toString();
            }
        }
        catch (Exception e2) {
            Trc.exception(e2);
            if (!triedSU) {
                try {
                    URL contextURL = base != null ? StringUtils.getURL(null, base) : null;
                    URL url = StringUtils.getURL(contextURL, relativeLocation);
                    this.importInputStream = this.getContentAsInputStreamSec(url);
                    this.importBase = url == null ? relativeLocation : url.toString();
                }
                catch (Exception e22) {
                    Trc.exception(e22);
                    this.importBase = "unknownImportURI";
                }
            }
            this.importBase = "unknownImportURI";
        }
        if (this.importInputStream == null) {
            if (Trc.isDebugEnabled()) {
                Trc.event(this, "WSIFWSDLLocatorImpl failed to read import at " + base + " relative to " + relativeLocation);
            }
            Trc.exit(null);
            return null;
        }
        InputSource ret = new InputSource(this.importInputStream);
        Trc.exit(ret);
        return ret;
    }

    public Reader getBaseReader() {
        InputSource is = this.getBaseInputSource();
        if (is == null) {
            return null;
        }
        if (is.getCharacterStream() != null) {
            return is.getCharacterStream();
        }
        if (is.getByteStream() != null) {
            return new InputStreamReader(is.getByteStream());
        }
        return null;
    }

    public Reader getImportReader(String base, String relativeLocation) {
        InputSource is = this.getImportInputSource(base, relativeLocation);
        if (is == null) {
            return null;
        }
        if (is.getCharacterStream() != null) {
            return is.getCharacterStream();
        }
        if (is.getByteStream() != null) {
            return new InputStreamReader(is.getByteStream());
        }
        return null;
    }

    public String getBaseURI() {
        Trc.entry(this);
        Trc.exit(this.documentBase);
        return this.documentBase;
    }

    public String getLatestImportURI() {
        Trc.entry(this);
        this.importBase = this.tidyPath(this.importBase);
        Trc.exit(this.importBase);
        return this.importBase;
    }

    private String tidyPath(String path) {
        if (path == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(path);
        int i = path.indexOf("/./");
        while (i >= 0) {
            sb.replace(i, i + 3, "/");
            i = sb.toString().indexOf("/./");
        }
        int j = sb.toString().indexOf("\\.\\");
        while (j >= 0) {
            sb.replace(j, j + 3, "\\");
            j = sb.toString().indexOf("\\.\\");
        }
        return sb.toString();
    }

    private String resolvePath(String ba, String rel) {
        StringBuffer sb = new StringBuffer(rel);
        int dd = 0;
        while (sb.length() > 0 && sb.length() > 3 && sb.charAt(0) == '.' && sb.charAt(1) == '.' && (sb.charAt(2) == '/' || sb.charAt(2) == '\\')) {
            ++dd;
            sb.delete(0, 3);
        }
        StringBuffer sb2 = new StringBuffer(ba);
        int j = sb2.length() - 1;
        int found = 0;
        for (int k = j; k >= 0; --k) {
            if (k != j && (sb2.charAt(k) == '/' || sb2.charAt(k) == '\\')) {
                ++found;
            }
            if (found >= dd) break;
            sb2.deleteCharAt(k);
        }
        if (found + 1 < dd) {
            return null;
        }
        return sb2.toString() + sb.toString();
    }

    public void close() {
        Trc.entry(this);
        try {
            if (this.baseReader != null) {
                this.baseReader.close();
            }
            if (this.importInputStream != null) {
                this.importInputStream.close();
            }
            if (this.baseInputStream != null) {
                this.baseInputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Trc.exit();
    }

    private InputStream getContentAsInputStreamSec(URL url) throws Exception {
        Trc.entry((Object)this, url);
        InputStream returnIS = null;
        final URL finalUrl = url;
        try {
            returnIS = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IllegalArgumentException, IOException {
                    return StringUtils.getContentAsInputStream(finalUrl);
                }
            });
        }
        catch (PrivilegedActionException ex) {
            Trc.exception(ex);
            Exception e2 = ex.getException();
            throw e2;
        }
        Trc.exit(returnIS);
        return returnIS;
    }

    private InputSource getDummySchema() {
        StringReader sr = new StringReader(DUMMY_XSD);
        return new InputSource(sr);
    }
}

