/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.wsdl.extensions.ejb;

import com.ibm.wsdl.Constants;
import com.ibm.wsdl.util.StringUtils;
import com.ibm.wsdl.util.xml.DOMUtils;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.xml.namespace.QName;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.wsdl.extensions.ejb.EJBAddress;
import org.apache.wsif.wsdl.extensions.ejb.EJBBinding;
import org.apache.wsif.wsdl.extensions.ejb.EJBBindingConstants;
import org.apache.wsif.wsdl.extensions.ejb.EJBOperation;
import org.w3c.dom.Element;

public class EJBBindingSerializer
implements ExtensionSerializer,
ExtensionDeserializer,
Serializable {
    private static final long serialVersionUID = 1L;

    public void marshall(Class parentType, QName elementType, ExtensibilityElement extension2, PrintWriter pw, Definition def, ExtensionRegistry extReg) throws WSDLException {
        Trc.entry(this, parentType, elementType, extension2, pw, def, extReg);
        if (extension2 == null) {
            Trc.exit();
            return;
        }
        if (extension2 instanceof EJBBinding) {
            EJBBinding ejbBinding = (EJBBinding)extension2;
            pw.print("      <ejb:binding");
            Boolean required = extension2.getRequired();
            if (required != null) {
                DOMUtils.printQualifiedAttribute(Constants.Q_ATTR_REQUIRED, required.toString(), def, pw);
            }
            pw.println("/>");
        } else if (extension2 instanceof EJBOperation) {
            Boolean required;
            EJBOperation ejbOperation = (EJBOperation)extension2;
            pw.print("      <ejb:operation");
            if (ejbOperation.getMethodName() != null) {
                DOMUtils.printAttribute("methodName", ejbOperation.getMethodName(), pw);
            }
            if (ejbOperation.getEjbInterface() != null) {
                DOMUtils.printAttribute("interface", ejbOperation.getEjbInterface(), pw);
            }
            if (ejbOperation.getParameterOrder() != null) {
                DOMUtils.printAttribute("parameterOrder", StringUtils.getNMTokens(ejbOperation.getParameterOrder()), pw);
            }
            if (ejbOperation.getReturnPart() != null) {
                DOMUtils.printAttribute("returnPart", ejbOperation.getReturnPart(), pw);
            }
            if ((required = extension2.getRequired()) != null) {
                DOMUtils.printQualifiedAttribute(Constants.Q_ATTR_REQUIRED, required.toString(), def, pw);
            }
            pw.println("/>");
        } else if (extension2 instanceof EJBAddress) {
            Boolean required;
            EJBAddress ejbAddress = (EJBAddress)extension2;
            pw.print("      <ejb:address");
            if (ejbAddress.getClassName() != null) {
                DOMUtils.printAttribute("className", ejbAddress.getClassName(), pw);
            }
            if (ejbAddress.getArchive() != null) {
                DOMUtils.printAttribute("archive", ejbAddress.getArchive(), pw);
            }
            if (ejbAddress.getClassLoader() != null) {
                DOMUtils.printAttribute("classLoader", ejbAddress.getClassLoader(), pw);
            }
            if (ejbAddress.getJndiName() != null) {
                DOMUtils.printAttribute("jndiName", ejbAddress.getJndiName(), pw);
            }
            if (ejbAddress.getJndiProviderURL() != null) {
                DOMUtils.printAttribute("jndiProviderURL", ejbAddress.getJndiProviderURL(), pw);
            }
            if (ejbAddress.getInitialContextFactory() != null) {
                DOMUtils.printAttribute("initialContextFactory", ejbAddress.getInitialContextFactory(), pw);
            }
            if ((required = extension2.getRequired()) != null) {
                DOMUtils.printQualifiedAttribute(Constants.Q_ATTR_REQUIRED, required.toString(), def, pw);
            }
            pw.println("/>");
        }
        Trc.exit();
    }

    public void registerSerializer(ExtensionRegistry registry) {
        Trc.entry((Object)this, registry);
        registry.registerSerializer(Binding.class, EJBBindingConstants.Q_ELEM_EJB_BINDING, this);
        registry.registerDeserializer(Binding.class, EJBBindingConstants.Q_ELEM_EJB_BINDING, this);
        registry.mapExtensionTypes(Binding.class, EJBBindingConstants.Q_ELEM_EJB_BINDING, EJBBinding.class);
        registry.registerSerializer(BindingOperation.class, EJBBindingConstants.Q_ELEM_EJB_OPERATION, this);
        registry.registerDeserializer(BindingOperation.class, EJBBindingConstants.Q_ELEM_EJB_OPERATION, this);
        registry.mapExtensionTypes(BindingOperation.class, EJBBindingConstants.Q_ELEM_EJB_OPERATION, EJBOperation.class);
        registry.registerSerializer(Port.class, EJBBindingConstants.Q_ELEM_EJB_ADDRESS, this);
        registry.registerDeserializer(Port.class, EJBBindingConstants.Q_ELEM_EJB_ADDRESS, this);
        registry.mapExtensionTypes(Port.class, EJBBindingConstants.Q_ELEM_EJB_ADDRESS, EJBAddress.class);
        Trc.exit();
    }

    public ExtensibilityElement unmarshall(Class parentType, QName elementType, Element el, Definition def, ExtensionRegistry extReg) throws WSDLException {
        Trc.entry(this, parentType, elementType, el, def, extReg);
        ExtensibilityElement returnValue = null;
        if (EJBBindingConstants.Q_ELEM_EJB_BINDING.equals(elementType)) {
            EJBBinding ejbBinding = new EJBBinding();
            Trc.exit(ejbBinding);
            return ejbBinding;
        }
        if (EJBBindingConstants.Q_ELEM_EJB_OPERATION.equals(elementType)) {
            String returnPart;
            String parameterOrder;
            String ejbInterface;
            EJBOperation ejbOperation = new EJBOperation();
            String methodName = DOMUtils.getAttribute(el, "methodName");
            if (methodName != null) {
                ejbOperation.setMethodName(methodName);
            }
            if ((ejbInterface = DOMUtils.getAttribute(el, "interface")) != null) {
                ejbOperation.setEjbInterface(ejbInterface);
            }
            if ((parameterOrder = DOMUtils.getAttribute(el, "parameterOrder")) != null) {
                ejbOperation.setParameterOrder(parameterOrder);
            }
            if ((returnPart = DOMUtils.getAttribute(el, "returnPart")) != null) {
                ejbOperation.setReturnPart(returnPart);
            }
            Trc.exit(ejbOperation);
            return ejbOperation;
        }
        if (EJBBindingConstants.Q_ELEM_EJB_ADDRESS.equals(elementType)) {
            String icf;
            String jndiProviderURL;
            String jndiName;
            String classLoader;
            String archive;
            EJBAddress ejbAddress = new EJBAddress();
            String className = DOMUtils.getAttribute(el, "className");
            if (className != null) {
                ejbAddress.setClassName(className);
            }
            if ((archive = DOMUtils.getAttribute(el, "archive")) != null) {
                ejbAddress.setArchive(archive);
            }
            if ((classLoader = DOMUtils.getAttribute(el, "classLoader")) != null) {
                ejbAddress.setClassLoader(classLoader);
            }
            if ((jndiName = DOMUtils.getAttribute(el, "jndiName")) != null) {
                ejbAddress.setJndiName(jndiName);
            }
            if ((jndiProviderURL = DOMUtils.getAttribute(el, "jndiProviderURL")) != null) {
                ejbAddress.setJndiProviderURL(jndiProviderURL);
            }
            if ((icf = DOMUtils.getAttribute(el, "initialContextFactory")) != null) {
                ejbAddress.setInitialContextFactory(icf);
            }
            Trc.exit(ejbAddress);
            return ejbAddress;
        }
        Trc.exit(returnValue);
        return returnValue;
    }
}

