/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.wsdl.extensions.jms;

import com.ibm.wsdl.Constants;
import com.ibm.wsdl.util.xml.DOMUtils;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.xml.namespace.QName;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.wsdl.extensions.jms.JMSBinding;
import org.apache.wsif.wsdl.extensions.jms.JMSConstants;
import org.w3c.dom.Element;

public class JMSBindingSerializer
implements ExtensionSerializer,
ExtensionDeserializer,
Serializable {
    private static final long serialVersionUID = 1L;

    public void marshall(Class parentType, QName elementType, ExtensibilityElement extension2, PrintWriter pw, Definition def, ExtensionRegistry extReg) throws WSDLException {
        Boolean required;
        Trc.entry(this, parentType, elementType, extension2, pw, def, extReg);
        if (extension2 == null) {
            Trc.exit();
            return;
        }
        JMSBinding jmsBinding = (JMSBinding)extension2;
        String tagName = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/jms/", "binding", def);
        pw.print("      <" + tagName);
        if (jmsBinding.getJmsMessageType() != 0) {
            DOMUtils.printAttribute("type", JMSBinding.JmsMessageTypeAsString(jmsBinding.getJmsMessageType()), pw);
        }
        if ((required = extension2.getRequired()) != null) {
            DOMUtils.printQualifiedAttribute(Constants.Q_ATTR_REQUIRED, required.toString(), def, pw);
        }
        pw.println("/>");
        Trc.exit();
    }

    public void registerSerializer(ExtensionRegistry registry) {
        Trc.entry((Object)this, registry);
        registry.registerSerializer(Binding.class, JMSConstants.Q_ELEM_JMS_BINDING, this);
        registry.registerDeserializer(Binding.class, JMSConstants.Q_ELEM_JMS_BINDING, this);
        registry.mapExtensionTypes(Binding.class, JMSConstants.Q_ELEM_JMS_BINDING, JMSBinding.class);
        Trc.exit();
    }

    public ExtensibilityElement unmarshall(Class parentType, QName elementType, Element el, Definition def, ExtensionRegistry extReg) throws WSDLException {
        Trc.entry(this, parentType, elementType, el, def, extReg);
        JMSBinding jmsBinding = (JMSBinding)extReg.createExtension(parentType, elementType);
        String msgType = DOMUtils.getAttribute(el, "type");
        if ("ByteMessage".equals(msgType)) {
            jmsBinding.setJmsMessageType(10);
        } else if ("MapMessage".equals(msgType)) {
            jmsBinding.setJmsMessageType(20);
        } else if ("ObjectMessage".equals(msgType)) {
            jmsBinding.setJmsMessageType(30);
        } else if ("StreamMessage".equals(msgType)) {
            jmsBinding.setJmsMessageType(40);
        } else if ("TextMessage".equals(msgType)) {
            jmsBinding.setJmsMessageType(50);
        } else {
            jmsBinding.setJmsMessageType(0);
        }
        Trc.exit(jmsBinding);
        return jmsBinding;
    }
}

