/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.wsdl.extensions.jms;

import com.ibm.wsdl.Constants;
import com.ibm.wsdl.util.StringUtils;
import com.ibm.wsdl.util.xml.DOMUtils;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.xml.namespace.QName;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.wsdl.extensions.jms.JMSConstants;
import org.apache.wsif.wsdl.extensions.jms.JMSOutput;
import org.w3c.dom.Element;

public class JMSOutputSerializer
implements ExtensionSerializer,
ExtensionDeserializer,
Serializable {
    private static final long serialVersionUID = 1L;

    public void marshall(Class parentType, QName elementType, ExtensibilityElement extension2, PrintWriter pw, Definition def, ExtensionRegistry extReg) throws WSDLException {
        Boolean required;
        Trc.entry(this, parentType, elementType, extension2, pw, def, extReg);
        if (extension2 == null) {
            Trc.exit();
            return;
        }
        JMSOutput jmsOutput = (JMSOutput)extension2;
        String tagName = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/jms/", "output", def);
        pw.print("      <" + tagName);
        if (jmsOutput.getParts() != null) {
            DOMUtils.printAttribute("parts", StringUtils.getNMTokens(jmsOutput.getParts()), pw);
        }
        if (jmsOutput.getSchema() != null) {
            DOMUtils.printAttribute("schema", jmsOutput.getSchema(), pw);
        }
        if ((required = extension2.getRequired()) != null) {
            DOMUtils.printQualifiedAttribute(Constants.Q_ATTR_REQUIRED, required.toString(), def, pw);
        }
        pw.println("/>");
        Trc.exit();
    }

    public void registerSerializer(ExtensionRegistry registry) {
        Trc.entry((Object)this, registry);
        registry.registerSerializer(BindingInput.class, JMSConstants.Q_ELEM_JMS_OUTPUT, this);
        registry.registerDeserializer(BindingInput.class, JMSConstants.Q_ELEM_JMS_OUTPUT, this);
        registry.mapExtensionTypes(BindingInput.class, JMSConstants.Q_ELEM_JMS_OUTPUT, JMSOutput.class);
        registry.registerSerializer(BindingOutput.class, JMSConstants.Q_ELEM_JMS_OUTPUT, this);
        registry.registerDeserializer(BindingOutput.class, JMSConstants.Q_ELEM_JMS_OUTPUT, this);
        registry.mapExtensionTypes(BindingOutput.class, JMSConstants.Q_ELEM_JMS_OUTPUT, JMSOutput.class);
        Trc.exit();
    }

    public ExtensibilityElement unmarshall(Class parentType, QName elementType, Element el, Definition def, ExtensionRegistry extReg) throws WSDLException {
        String schema;
        Trc.entry(this, parentType, elementType, el, def, extReg);
        JMSOutput jmsOutput = (JMSOutput)extReg.createExtension(parentType, elementType);
        String parts = DOMUtils.getAttribute(el, "parts");
        if (parts != null) {
            jmsOutput.setParts(StringUtils.parseNMTokens(parts));
        }
        if ((schema = DOMUtils.getAttribute(el, "schema")) != null) {
            jmsOutput.setSchema(schema);
        }
        Trc.exit(jmsOutput);
        return jmsOutput;
    }
}

