/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.wsdl.extensions.jms;

import com.ibm.wsdl.Constants;
import com.ibm.wsdl.util.xml.DOMUtils;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.xml.namespace.QName;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.wsdl.extensions.jms.JMSConstants;
import org.apache.wsif.wsdl.extensions.jms.JMSProperty;
import org.w3c.dom.Element;

public class JMSPropertySerializer
implements ExtensionSerializer,
ExtensionDeserializer,
Serializable {
    private static final long serialVersionUID = 1L;

    public void marshall(Class parentType, QName elementType, ExtensibilityElement extension2, PrintWriter pw, Definition def, ExtensionRegistry extReg) throws WSDLException {
        Boolean required;
        Trc.entry(this, parentType, elementType, extension2, pw, def, extReg);
        if (extension2 == null) {
            Trc.exit();
            return;
        }
        JMSProperty jmsProperty = (JMSProperty)extension2;
        String tagName = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/jms/", "property", def);
        pw.print("      <" + tagName);
        if (jmsProperty.getName() != null) {
            DOMUtils.printAttribute("name", jmsProperty.getName(), pw);
        }
        if (jmsProperty.getPart() != null) {
            DOMUtils.printAttribute("part", jmsProperty.getPart(), pw);
        }
        if ((required = extension2.getRequired()) != null) {
            DOMUtils.printQualifiedAttribute(Constants.Q_ATTR_REQUIRED, required.toString(), def, pw);
        }
        pw.println("/>");
        Trc.exit();
    }

    public void registerSerializer(ExtensionRegistry registry) {
        Trc.entry((Object)this, registry);
        registry.registerSerializer(BindingInput.class, JMSConstants.Q_ELEM_JMS_PROPERTY, this);
        registry.registerDeserializer(BindingInput.class, JMSConstants.Q_ELEM_JMS_PROPERTY, this);
        registry.mapExtensionTypes(BindingInput.class, JMSConstants.Q_ELEM_JMS_PROPERTY, JMSProperty.class);
        registry.registerSerializer(BindingOutput.class, JMSConstants.Q_ELEM_JMS_PROPERTY, this);
        registry.registerDeserializer(BindingOutput.class, JMSConstants.Q_ELEM_JMS_PROPERTY, this);
        registry.mapExtensionTypes(BindingOutput.class, JMSConstants.Q_ELEM_JMS_PROPERTY, JMSProperty.class);
        registry.registerSerializer(BindingFault.class, JMSConstants.Q_ELEM_JMS_PROPERTY, this);
        registry.registerDeserializer(BindingFault.class, JMSConstants.Q_ELEM_JMS_PROPERTY, this);
        registry.mapExtensionTypes(BindingFault.class, JMSConstants.Q_ELEM_JMS_PROPERTY, JMSProperty.class);
        Trc.exit();
    }

    public ExtensibilityElement unmarshall(Class parentType, QName elementType, Element el, Definition def, ExtensionRegistry extReg) throws WSDLException {
        String part;
        Trc.entry(this, parentType, elementType, el, def, extReg);
        JMSProperty jmsProperty = (JMSProperty)extReg.createExtension(parentType, elementType);
        String name2 = DOMUtils.getAttribute(el, "name");
        if (name2 != null) {
            jmsProperty.setName(name2);
        }
        if ((part = DOMUtils.getAttribute(el, "part")) != null) {
            jmsProperty.setPart(part);
        }
        Trc.exit(jmsProperty);
        return jmsProperty;
    }
}

