/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.wsdl.extensions.jms;

import com.ibm.wsdl.Constants;
import com.ibm.wsdl.util.xml.DOMUtils;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.wsdl.BindingInput;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.xml.namespace.QName;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.wsdl.extensions.jms.JMSAddress;
import org.apache.wsif.wsdl.extensions.jms.JMSConstants;
import org.apache.wsif.wsdl.extensions.jms.JMSPropertyValue;
import org.w3c.dom.Element;

public class JMSPropertyValueSerializer
implements ExtensionSerializer,
ExtensionDeserializer,
Serializable {
    private static final long serialVersionUID = 1L;

    public void marshall(Class parentType, QName elementType, ExtensibilityElement extension2, PrintWriter pw, Definition def, ExtensionRegistry extReg) throws WSDLException {
        Boolean required;
        Trc.entry(this, parentType, elementType, extension2, pw, def, extReg);
        if (extension2 == null) {
            Trc.exit();
            return;
        }
        JMSPropertyValue jmsPropertyValue = (JMSPropertyValue)extension2;
        String tagName = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/jms/", "propertyValue", def);
        pw.print("      <" + tagName);
        if (jmsPropertyValue.getName() != null) {
            DOMUtils.printAttribute("name", jmsPropertyValue.getName(), pw);
        }
        if (jmsPropertyValue.getType() != null) {
            DOMUtils.printQualifiedAttribute("type", jmsPropertyValue.getType(), def, pw);
        }
        if (jmsPropertyValue.getValue() != null) {
            DOMUtils.printAttribute("value", jmsPropertyValue.getValue(), pw);
        }
        if ((required = extension2.getRequired()) != null) {
            DOMUtils.printQualifiedAttribute(Constants.Q_ATTR_REQUIRED, required.toString(), def, pw);
        }
        pw.println("/>");
        Trc.exit();
    }

    public void registerSerializer(ExtensionRegistry registry) {
        Trc.entry((Object)this, registry);
        registry.registerSerializer(BindingInput.class, JMSConstants.Q_ELEM_JMS_PROPERTY_VALUE, this);
        registry.registerDeserializer(BindingInput.class, JMSConstants.Q_ELEM_JMS_PROPERTY_VALUE, this);
        registry.mapExtensionTypes(BindingInput.class, JMSConstants.Q_ELEM_JMS_PROPERTY_VALUE, JMSPropertyValue.class);
        registry.registerSerializer(JMSAddress.class, JMSConstants.Q_ELEM_JMS_PROPERTY_VALUE, this);
        registry.registerDeserializer(JMSAddress.class, JMSConstants.Q_ELEM_JMS_PROPERTY_VALUE, this);
        registry.mapExtensionTypes(JMSAddress.class, JMSConstants.Q_ELEM_JMS_PROPERTY_VALUE, JMSPropertyValue.class);
        Trc.exit();
    }

    public ExtensibilityElement unmarshall(Class parentType, QName elementType, Element el, Definition def, ExtensionRegistry extReg) throws WSDLException {
        String value2;
        QName type;
        Trc.entry(this, parentType, elementType, el, def, extReg);
        JMSPropertyValue jmsPropertyValue = (JMSPropertyValue)extReg.createExtension(parentType, elementType);
        String name2 = DOMUtils.getAttribute(el, "name");
        if (name2 != null) {
            jmsPropertyValue.setName(name2);
        }
        if ((type = DOMUtils.getQualifiedAttributeValue(el, "type", "propertyValue", false, def)) != null) {
            jmsPropertyValue.setType(type);
        }
        if ((value2 = DOMUtils.getAttribute(el, "value")) != null) {
            jmsPropertyValue.setValue(value2);
        }
        Trc.exit(jmsPropertyValue);
        return jmsPropertyValue;
    }
}

