/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.ssl.protocol;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.config.SSLConfigManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.Properties;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocket;

public class SSLServerSocketFactory
extends javax.net.ssl.SSLServerSocketFactory {
    private static final TraceComponent tc = Tr.register((Class)SSLServerSocketFactory.class, (String)"SSL", (String)"com.ibm.ws.ssl.resources.ssl");
    private Properties props;
    private javax.net.ssl.SSLServerSocketFactory default_factory = null;
    private javax.net.ssl.SSLServerSocketFactory factory = null;
    private static SSLServerSocketFactory thisClass = null;

    public SSLServerSocketFactory() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SSLServerSocketFactory");
        }
        try {
            this.props = SSLConfigManager.getInstance().getDefaultSystemProperties(true);
            if (this.props == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Getting default SSL properties from WebSphere configuration.");
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("com.ibm.ssl.direction", "inbound");
                this.props = JSSEHelper.getInstance().getProperties(null, hashMap, null);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Getting javax.net.ssl.* SSL System properties.");
            }
            this.factory = this.default_factory = JSSEHelper.getInstance().getSSLServerSocketFactory(this.props);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"SSLServerSocketFactory");
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SSLServerSocketFactory exception getting default SSL properties.", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.ssl.protocol.SSLServerSocketFactory.constructor", (String)"90", (Object)this);
            this.factory = this.default_factory;
        }
    }

    public SSLServerSocketFactory(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SSLServerSocketFactory", (Object)new Object[]{string});
        }
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("com.ibm.ssl.direction", "inbound");
            Properties properties = JSSEHelper.getInstance().getProperties(null, hashMap, null);
            this.default_factory = JSSEHelper.getInstance().getSSLServerSocketFactory(properties);
            this.props = JSSEHelper.getInstance().getProperties(string, hashMap, null);
            this.factory = JSSEHelper.getInstance().getSSLServerSocketFactory(this.props);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"SSLServerSocketFactory");
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SSLServerSocketFactory exception getting SSL properties from alias.", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.ssl.protocol.SSLServerSocketFactory.constructor(alias)", (String)"126", (Object)this);
            this.factory = this.default_factory;
        }
    }

    public SSLServerSocketFactory(Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SSLServerSocketFactory");
        }
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("com.ibm.ssl.direction", "inbound");
            Properties properties2 = JSSEHelper.getInstance().getProperties(null, hashMap, null);
            this.default_factory = JSSEHelper.getInstance().getSSLServerSocketFactory(properties2);
            this.props = properties;
            this.factory = JSSEHelper.getInstance().getSSLServerSocketFactory(this.props);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"SSLServerSocketFactory");
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SSLServerSocketFactory exception getting SSL properties from properties.", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.ssl.protocol.SSLServerSocketFactory.constructor(sslprops)", (String)"162", (Object)this);
            this.factory = this.default_factory;
        }
    }

    public SSLServerSocketFactory(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SSLServerSocketFactory", (Object)new Object[]{string, string2});
        }
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("com.ibm.ssl.direction", "inbound");
            hashMap.put("com.ibm.ssl.endPointName", string2);
            Properties properties = JSSEHelper.getInstance().getProperties(null, hashMap, null);
            this.default_factory = JSSEHelper.getInstance().getSSLServerSocketFactory(properties);
            this.props = JSSEHelper.getInstance().getProperties(string, hashMap, null);
            this.factory = JSSEHelper.getInstance().getSSLServerSocketFactory(this.props);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"SSLServerSocketFactory");
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SSLServerSocketFactory exception getting SSL properties from selections.", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.ssl.protocol.SSLServerSocketFactory.constructor(alias, dynamicSelectionInfo, endPointName)", (String)"204", (Object)this);
            this.factory = this.default_factory;
        }
    }

    public static ServerSocketFactory getDefault() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDefault");
        }
        if (thisClass == null) {
            try {
                thisClass = new SSLServerSocketFactory();
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"SSLServerSocketFactory exception getting default socket factory.", (Object)new Object[]{exception});
                }
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.ssl.protocol.SSLServerSocketFactory.getDefault", (String)"229");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getDefault");
        }
        return thisClass;
    }

    public String[] getDefaultCipherSuites() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDefaultCipherSuites");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getDefaultCipherSuites");
        }
        return this.default_factory.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSupportedCipherSuites");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSupportedCipherSuites");
        }
        return this.default_factory.getSupportedCipherSuites();
    }

    public ServerSocket createServerSocket() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createServerSocket(0)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createServerSocket(0)");
        }
        return this.default_factory.createServerSocket();
    }

    public ServerSocket createServerSocket(int n) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createServerSocket(1)", (Object)new Object[]{new Integer(n)});
        }
        SSLServerSocket sSLServerSocket = null;
        try {
            if (this.factory == null) {
                this.factory = JSSEHelper.getInstance().getSSLServerSocketFactory(this.props);
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception getting SSLServerSocketFactory.", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.ssl.protocol.SSLServerSocketFactory.createServerSocket(2)", (String)"306", (Object)this);
            this.factory = this.default_factory;
        }
        sSLServerSocket = (SSLServerSocket)this.factory.createServerSocket(n);
        sSLServerSocket = SSLConfigManager.getInstance().setCipherListOnServerSocket(this.props, sSLServerSocket);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createServerSocket(1)");
        }
        return sSLServerSocket;
    }

    public ServerSocket createServerSocket(int n, int n2) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createServerSocket(2)", (Object)new Object[]{new Integer(n), new Integer(n2)});
        }
        SSLServerSocket sSLServerSocket = null;
        try {
            if (this.factory == null) {
                this.factory = JSSEHelper.getInstance().getSSLServerSocketFactory(this.props);
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception getting SSLServerSocketFactory.", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.ssl.protocol.SSLServerSocketFactory.createServerSocket(3)", (String)"341", (Object)this);
            this.factory = this.default_factory;
        }
        sSLServerSocket = (SSLServerSocket)this.factory.createServerSocket(n, n2);
        sSLServerSocket = SSLConfigManager.getInstance().setCipherListOnServerSocket(this.props, sSLServerSocket);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createServerSocket(2)");
        }
        return sSLServerSocket;
    }

    public ServerSocket createServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createServerSocket(3)", (Object)new Object[]{new Integer(n), new Integer(n2), inetAddress});
        }
        SSLServerSocket sSLServerSocket = null;
        try {
            if (this.factory == null) {
                this.factory = JSSEHelper.getInstance().getSSLServerSocketFactory(this.props);
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception getting SSLServerSocketFactory.", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.ssl.protocol.SSLServerSocketFactory.createServerSocket(4)", (String)"378", (Object)this);
            this.factory = this.default_factory;
        }
        sSLServerSocket = (SSLServerSocket)this.factory.createServerSocket(n, n2, inetAddress);
        sSLServerSocket = SSLConfigManager.getInstance().setCipherListOnServerSocket(this.props, sSLServerSocket);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createServerSocket(3), not null");
        }
        return sSLServerSocket;
    }
}

