/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.ssl.protocol;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.config.SSLConfigManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;

public class SSLSocketFactory
extends javax.net.ssl.SSLSocketFactory {
    private static final TraceComponent tc = Tr.register((Class)SSLSocketFactory.class, (String)"SSL", (String)"com.ibm.ws.ssl.resources.ssl");
    protected Properties props;
    private javax.net.ssl.SSLSocketFactory default_factory = null;
    private javax.net.ssl.SSLSocketFactory factory = null;
    protected boolean default_constructor = true;
    private static SSLSocketFactory thisClass = null;

    public SSLSocketFactory() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SSLSocketFactory(1)");
        }
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("com.ibm.ssl.direction", "outbound");
            this.props = SSLConfigManager.getInstance().getDefaultSystemProperties(true);
            if (this.props == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Getting default SSL properties from WebSphere configuration.");
                }
                this.props = JSSEHelper.getInstance().getProperties(null, hashMap, null);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Getting javax.net.ssl.* SSL System properties.");
                }
                this.default_constructor = false;
            }
            this.default_factory = JSSEHelper.getInstance().getSSLSocketFactory(hashMap, this.props);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"SSLSocketFactory(1)");
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SSLSocketFactory exception getting default SSL properties.", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.ssl.protocol.SSLSocketFactory.constructor", (String)"94", (Object)this);
            this.props = null;
        }
    }

    public SSLSocketFactory(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SSLSocketFactory(2)", (Object)new Object[]{string});
        }
        try {
            this.default_constructor = false;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("com.ibm.ssl.direction", "outbound");
            this.props = JSSEHelper.getInstance().getProperties(string, hashMap, null);
            this.default_factory = JSSEHelper.getInstance().getSSLSocketFactory(hashMap, this.props);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"SSLSocketFactory(2)");
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SSLSocketFactory exception getting SSL properties from alias.", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.ssl.protocol.SSLSocketFactory.constructor(alias)", (String)"123", (Object)this);
            this.props = null;
        }
    }

    public SSLSocketFactory(Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SSLSocketFactory(3)");
        }
        try {
            this.default_constructor = false;
            this.props = properties;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("com.ibm.ssl.direction", "outbound");
            this.default_factory = JSSEHelper.getInstance().getSSLSocketFactory(hashMap, this.props);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"SSLSocketFactory(3)");
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SSLSocketFactory exception getting SSL properties from properties.", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.ssl.protocol.SSLSocketFactory.constructor(sslprops)", (String)"153", (Object)this);
            this.props = null;
        }
    }

    public SSLSocketFactory(String string, Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SSLSocketFactory(4)", (Object)new Object[]{string, map});
        }
        try {
            this.default_constructor = false;
            this.props = JSSEHelper.getInstance().getProperties(string, map, null);
            this.default_factory = JSSEHelper.getInstance().getSSLSocketFactory(map, this.props);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"SSLSocketFactory(4)");
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SSLSocketFactory exception getting SSL properties from selections.", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.ssl.protocol.SSLSocketFactory.constructor(alias, dynamicSelectionInfo, endPointName)", (String)"192", (Object)this);
            this.props = null;
        }
    }

    public static SocketFactory getDefault() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDefault");
        }
        if (thisClass == null) {
            try {
                thisClass = new SSLSocketFactory();
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"SSLSocketFactory exception getting default socket factory.", (Object)new Object[]{exception});
                }
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.ssl.protocol.SSLSocketFactory.getDefault", (String)"215");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getDefault");
        }
        return thisClass;
    }

    public String[] getDefaultCipherSuites() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDefaultCipherSuites");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getDefaultCipherSuites");
        }
        return this.default_factory.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSupportedCipherSuites");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSupportedCipherSuites");
        }
        return this.default_factory.getSupportedCipherSuites();
    }

    public Socket createSocket() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createSocket(0)");
        }
        javax.net.ssl.SSLSocketFactory sSLSocketFactory = this.default_factory;
        SSLSocket sSLSocket = null;
        Properties properties = this.props;
        if (this.default_constructor) {
            try {
                Properties properties2 = JSSEHelper.getInstance().getSSLPropertiesOnThread();
                HashMap<String, String> hashMap = JSSEHelper.getInstance().getOutboundConnectionInfo();
                if (properties2 != null || hashMap != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"either SSLProperties on thread or connectionInfo is available.");
                    }
                    if (hashMap == null) {
                        hashMap = new HashMap<String, String>();
                        hashMap.put("com.ibm.ssl.direction", "outbound");
                    }
                    properties = JSSEHelper.getInstance().getProperties(null, hashMap, null);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Getting SSLSocketFactory");
                    }
                    sSLSocketFactory = JSSEHelper.getInstance().getSSLSocketFactory(hashMap, properties);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Got SSLSocketFactory", (Object)new Object[]{sSLSocketFactory});
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Use default SSLSocketFactory - Neither SSLProperties nor outboundConnectionInfo is set");
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception getting SSLSocketFactory. Fall back to the default SSLSocketFactory", (Object)new Object[]{exception});
                }
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.ssl.protocol.SSLSocketFactory.createSocket(0)", (String)"288", (Object)this);
                sSLSocketFactory = this.default_factory;
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Use default SSLSocketFactory - the default constructor was not used");
        }
        sSLSocket = (SSLSocket)sSLSocketFactory.createSocket();
        sSLSocket = SSLConfigManager.getInstance().setCipherListOnSocket(properties, sSLSocket);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createSocket(0)");
        }
        return sSLSocket;
    }

    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException, UnknownHostException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createSocket(1)", (Object)new Object[]{socket, string, new Integer(n), new Boolean(bl)});
        }
        SSLSocket sSLSocket = null;
        Properties properties = this.props;
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("com.ibm.ssl.direction", "outbound");
            hashMap.put("com.ibm.ssl.remoteHost", string);
            hashMap.put("com.ibm.ssl.remotePort", Integer.toString(n));
            if (this.default_constructor) {
                properties = JSSEHelper.getInstance().getProperties(null, hashMap, null);
            }
            this.factory = JSSEHelper.getInstance().getSSLSocketFactory(hashMap, properties);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception getting SSLSocketFactory.", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.ssl.protocol.SSLSocketFactory.createSocket(1)", (String)"345", (Object)this);
            this.factory = this.default_factory;
        }
        sSLSocket = (SSLSocket)this.factory.createSocket(socket, string, n, bl);
        sSLSocket = SSLConfigManager.getInstance().setCipherListOnSocket(properties, sSLSocket);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createSocket(1)");
        }
        return sSLSocket;
    }

    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createSocket(2)", (Object)new Object[]{inetAddress, new Integer(n)});
        }
        SSLSocket sSLSocket = null;
        Properties properties = this.props;
        try {
            String string = null;
            if (inetAddress != null) {
                try {
                    string = inetAddress.getHostName();
                    if (string == null) {
                        string = inetAddress.getCanonicalHostName();
                    }
                }
                catch (Throwable throwable) {
                    string = inetAddress.getHostAddress();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Exception getting hostname from socket.", (Object)new Object[]{throwable});
                    }
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.websphere.ssl.protocol.SSLSocketFactory.createSocket(2)", (String)"393", (Object)this);
                }
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("com.ibm.ssl.direction", "outbound");
            hashMap.put("com.ibm.ssl.remoteHost", string);
            hashMap.put("com.ibm.ssl.remotePort", Integer.toString(n));
            if (this.default_constructor) {
                properties = JSSEHelper.getInstance().getProperties(null, hashMap, null);
            }
            this.factory = JSSEHelper.getInstance().getSSLSocketFactory(hashMap, properties);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception getting SSLSocketFactory.", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.ssl.protocol.SSLSocketFactory.createSocket(2)", (String)"414", (Object)this);
            this.factory = this.default_factory;
        }
        sSLSocket = (SSLSocket)this.factory.createSocket(inetAddress, n);
        sSLSocket = SSLConfigManager.getInstance().setCipherListOnSocket(properties, sSLSocket);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createSocket(2)");
        }
        return sSLSocket;
    }

    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createSocket(3)", (Object)new Object[]{inetAddress, new Integer(n), inetAddress2, new Integer(n2)});
        }
        SSLSocket sSLSocket = null;
        Properties properties = this.props;
        try {
            String string = null;
            if (inetAddress != null) {
                try {
                    string = inetAddress.getHostName();
                    if (string == null) {
                        string = inetAddress.getCanonicalHostName();
                    }
                }
                catch (Throwable throwable) {
                    string = inetAddress.getHostAddress();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Exception getting hostname from socket.", (Object)new Object[]{throwable});
                    }
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.websphere.ssl.protocol.SSLSocketFactory.createSocket(3)", (String)"468", (Object)this);
                }
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("com.ibm.ssl.direction", "outbound");
            hashMap.put("com.ibm.ssl.remoteHost", string);
            hashMap.put("com.ibm.ssl.remotePort", Integer.toString(n));
            if (this.default_constructor) {
                properties = JSSEHelper.getInstance().getProperties(null, hashMap, null);
            }
            this.factory = JSSEHelper.getInstance().getSSLSocketFactory(hashMap, properties);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception getting SSLSocketFactory.", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.ssl.protocol.SSLSocketFactory.createSocket(3)", (String)"490", (Object)this);
            this.factory = this.default_factory;
        }
        sSLSocket = (SSLSocket)this.factory.createSocket(inetAddress, n, inetAddress2, n2);
        sSLSocket = SSLConfigManager.getInstance().setCipherListOnSocket(properties, sSLSocket);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createSocket(3)");
        }
        return sSLSocket;
    }

    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createSocket(4)", (Object)new Object[]{string, new Integer(n)});
        }
        SSLSocket sSLSocket = null;
        Properties properties = this.props;
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("com.ibm.ssl.direction", "outbound");
            hashMap.put("com.ibm.ssl.remoteHost", string);
            hashMap.put("com.ibm.ssl.remotePort", Integer.toString(n));
            if (this.default_constructor) {
                properties = JSSEHelper.getInstance().getProperties(null, hashMap, null);
            }
            this.factory = JSSEHelper.getInstance().getSSLSocketFactory(hashMap, properties);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception getting SSLSocketFactory.", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.ssl.protocol.SSLSocketFactory.createSocket(4)", (String)"546", (Object)this);
            this.factory = this.default_factory;
        }
        sSLSocket = (SSLSocket)this.factory.createSocket(string, n);
        sSLSocket = SSLConfigManager.getInstance().setCipherListOnSocket(properties, sSLSocket);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createSocket(4), not null");
        }
        return sSLSocket;
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createSocket(5)", (Object)new Object[]{string, new Integer(n), inetAddress, new Integer(n2)});
        }
        SSLSocket sSLSocket = null;
        Properties properties = this.props;
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("com.ibm.ssl.direction", "outbound");
            hashMap.put("com.ibm.ssl.remoteHost", string);
            hashMap.put("com.ibm.ssl.remotePort", Integer.toString(n));
            if (this.default_constructor) {
                properties = JSSEHelper.getInstance().getProperties(null, hashMap, null);
            }
            this.factory = JSSEHelper.getInstance().getSSLSocketFactory(hashMap, properties);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception getting SSLSocketFactory.", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.ssl.protocol.SSLSocketFactory.createSocket(5)", (String)"602", (Object)this);
            this.factory = this.default_factory;
        }
        sSLSocket = (SSLSocket)this.factory.createSocket(string, n, inetAddress, n2);
        sSLSocket = SSLConfigManager.getInstance().setCipherListOnSocket(properties, sSLSocket);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createSocket(5)");
        }
        return sSLSocket;
    }
}

