/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.fips.provider;

import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.util.Arrays;
import javax.crypto.spec.DHParameterSpec;

public final class DHPublicKey
implements PublicKey,
javax.crypto.interfaces.DHPublicKey,
Serializable {
    static final long serialVersionUID = 2607870640963059136L;
    private BigInteger y;
    private byte[] key;
    private byte[] encodedKey;
    private BigInteger p;
    private BigInteger g;
    private int l;
    private int[] DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};
    private static String[] z;

    public DHPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws InvalidKeyException {
        this(bigInteger, bigInteger2, bigInteger3, 0);
    }

    public DHPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n2) throws InvalidKeyException {
        this.y = bigInteger;
        this.p = bigInteger2;
        this.g = bigInteger3;
        this.l = n2;
        try {
            this.key = new DerValue(2, this.y.toByteArray()).toByteArray();
            this.encodedKey = this.getEncoded();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[4]);
        }
    }

    public DHPublicKey(byte[] byArray) throws InvalidKeyException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            DerValue derValue = new DerValue((InputStream)byteArrayInputStream);
            if (derValue.getTag() != 48) {
                throw new InvalidKeyException(z[10]);
            }
            DerValue derValue2 = derValue.getData().getDerValue();
            if (derValue2.getTag() != 48) {
                throw new InvalidKeyException(z[7]);
            }
            DerInputStream derInputStream = derValue2.toDerInputStream();
            ObjectIdentifier objectIdentifier = derInputStream.getOID();
            if (derInputStream.available() == 0) {
                throw new InvalidKeyException(z[13]);
            }
            DerValue derValue3 = derInputStream.getDerValue();
            if (derValue3.getTag() == 5) {
                throw new InvalidKeyException(z[12]);
            }
            if (derValue3.getTag() != 48) {
                throw new InvalidKeyException(z[11]);
            }
            derValue3.getData().reset();
            this.p = derValue3.getData().getInteger();
            this.g = derValue3.getData().getInteger();
            if (derValue3.getData().available() != 0) {
                this.l = derValue3.getData().getInteger().intValue();
            }
            if (derValue3.getData().available() != 0) {
                throw new InvalidKeyException(z[8]);
            }
            this.key = derValue.getData().getBitString();
            this.a();
            if (derValue.getData().available() != 0) {
                throw new InvalidKeyException(z[14]);
            }
            this.encodedKey = (byte[])byArray.clone();
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidKeyException(z[9]);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.toString());
        }
    }

    public String getFormat() {
        return z[6];
    }

    public String getAlgorithm() {
        return z[5];
    }

    public synchronized byte[] getEncoded() {
        if (this.encodedKey == null) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                derOutputStream.putOID(new ObjectIdentifier(this.DH_data));
                DerOutputStream derOutputStream2 = new DerOutputStream();
                derOutputStream2.putInteger(this.p);
                derOutputStream2.putInteger(this.g);
                if (this.l != 0) {
                    derOutputStream2.putInteger(BigInteger.valueOf(this.l));
                }
                DerValue derValue = new DerValue(48, derOutputStream2.toByteArray());
                derOutputStream.putDerValue(derValue);
                DerOutputStream derOutputStream3 = new DerOutputStream();
                derOutputStream3.write((byte)48, derOutputStream);
                derOutputStream3.putBitString(this.key);
                DerOutputStream derOutputStream4 = new DerOutputStream();
                derOutputStream4.write((byte)48, derOutputStream3);
                this.encodedKey = derOutputStream4.toByteArray();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return (byte[])this.encodedKey.clone();
    }

    public BigInteger getY() {
        return this.y;
    }

    public DHParameterSpec getParams() {
        if (this.l != 0) {
            return new DHParameterSpec(this.p, this.g, this.l);
        }
        return new DHParameterSpec(this.p, this.g);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(z[1] + this.y.toString() + "\n" + z[0] + this.p.toString() + "\n" + z[3] + this.g.toString());
        if (this.l != 0) {
            stringBuffer.append(z[2] + this.l);
        }
        return stringBuffer.toString();
    }

    private void a() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.key);
            this.y = derInputStream.getInteger();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.toString());
        }
    }

    public int hashCode() {
        int n2 = 0;
        byte[] byArray = this.getEncoded();
        for (int i2 = 1; i2 < byArray.length; ++i2) {
            n2 += byArray[i2] * i2;
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PublicKey)) {
            return false;
        }
        byte[] byArray = this.getEncoded();
        byte[] byArray2 = ((PublicKey)object).getEncoded();
        return Arrays.equals(byArray, byArray2);
    }

    public void zeroize() {
        this.y = BigInteger.ZERO;
        this.p = BigInteger.ZERO;
        this.g = BigInteger.ZERO;
        this.l = 0;
    }

    protected void finalize() {
        this.zeroize();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block164: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block163: {
                char[] cArray3;
                Object var0;
                block162: {
                    int n5;
                    int n6;
                    char[] cArray4;
                    block161: {
                        char[] cArray5;
                        block160: {
                            int n7;
                            int n8;
                            char[] cArray6;
                            block159: {
                                char[] cArray7;
                                block158: {
                                    int n9;
                                    int n10;
                                    char[] cArray8;
                                    block157: {
                                        char[] cArray9;
                                        block156: {
                                            int n11;
                                            int n12;
                                            char[] cArray10;
                                            block155: {
                                                char[] cArray11;
                                                block154: {
                                                    int n13;
                                                    int n14;
                                                    char[] cArray12;
                                                    block153: {
                                                        char[] cArray13;
                                                        block152: {
                                                            int n15;
                                                            int n16;
                                                            char[] cArray14;
                                                            block151: {
                                                                char[] cArray15;
                                                                block150: {
                                                                    int n17;
                                                                    int n18;
                                                                    char[] cArray16;
                                                                    block149: {
                                                                        char[] cArray17;
                                                                        block148: {
                                                                            int n19;
                                                                            int n20;
                                                                            char[] cArray18;
                                                                            block147: {
                                                                                char[] cArray19;
                                                                                block146: {
                                                                                    int n21;
                                                                                    int n22;
                                                                                    char[] cArray20;
                                                                                    block145: {
                                                                                        char[] cArray21;
                                                                                        block144: {
                                                                                            int n23;
                                                                                            int n24;
                                                                                            char[] cArray22;
                                                                                            block143: {
                                                                                                char[] cArray23;
                                                                                                block142: {
                                                                                                    int n25;
                                                                                                    int n26;
                                                                                                    char[] cArray24;
                                                                                                    block141: {
                                                                                                        char[] cArray25;
                                                                                                        block140: {
                                                                                                            int n27;
                                                                                                            int n28;
                                                                                                            char[] cArray26;
                                                                                                            block139: {
                                                                                                                char[] cArray27;
                                                                                                                block138: {
                                                                                                                    int n29;
                                                                                                                    int n30;
                                                                                                                    char[] cArray28;
                                                                                                                    block137: {
                                                                                                                        char[] cArray29;
                                                                                                                        block136: {
                                                                                                                            int n31;
                                                                                                                            int n32;
                                                                                                                            char[] cArray30;
                                                                                                                            block135: {
                                                                                                                                stringArray = new String[15];
                                                                                                                                var0 = null;
                                                                                                                                char[] cArray31 = "\u001a*{".toCharArray();
                                                                                                                                n4 = 0;
                                                                                                                                int n33 = cArray31.length;
                                                                                                                                cArray30 = cArray31;
                                                                                                                                n32 = n33;
                                                                                                                                if (n33 <= 1) break block135;
                                                                                                                                cArray29 = cArray30;
                                                                                                                                n31 = n32;
                                                                                                                                if (n32 <= n4) break block136;
                                                                                                                            }
                                                                                                                            do {
                                                                                                                                char[] cArray32 = cArray30;
                                                                                                                                char[] cArray33 = cArray30;
                                                                                                                                int n34 = n4;
                                                                                                                                while (true) {
                                                                                                                                    int n35;
                                                                                                                                    char c2 = cArray32[n34];
                                                                                                                                    switch (n4 % 5) {
                                                                                                                                        case 0: {
                                                                                                                                            n35 = 106;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        case 1: {
                                                                                                                                            n35 = 16;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        case 2: {
                                                                                                                                            n35 = 113;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        case 3: {
                                                                                                                                            n35 = 62;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        default: {
                                                                                                                                            n35 = 79;
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                    cArray32[n34] = (char)(c2 ^ n35);
                                                                                                                                    ++n4;
                                                                                                                                    cArray30 = cArray33;
                                                                                                                                    n32 = n32;
                                                                                                                                    if (n32 != 0) break;
                                                                                                                                    cArray33 = cArray30;
                                                                                                                                    n31 = n32;
                                                                                                                                    n34 = n32;
                                                                                                                                    cArray32 = cArray30;
                                                                                                                                }
                                                                                                                                cArray29 = cArray30;
                                                                                                                                n31 = n32;
                                                                                                                            } while (n32 > n4);
                                                                                                                        }
                                                                                                                        stringArray[0] = new String(cArray29).intern();
                                                                                                                        var0 = null;
                                                                                                                        char[] cArray34 = "#R<t\f/V8n\u001cJT\u0018X)\u0003u\\v*\u0006|\u001c_!J@\u0004\\#\u0003sQu*\u0013*{Gu`".toCharArray();
                                                                                                                        n4 = 0;
                                                                                                                        int n36 = cArray34.length;
                                                                                                                        cArray28 = cArray34;
                                                                                                                        n30 = n36;
                                                                                                                        if (n36 <= 1) break block137;
                                                                                                                        cArray27 = cArray28;
                                                                                                                        n29 = n30;
                                                                                                                        if (n30 <= n4) break block138;
                                                                                                                    }
                                                                                                                    do {
                                                                                                                        char[] cArray35 = cArray28;
                                                                                                                        char[] cArray36 = cArray28;
                                                                                                                        int n37 = n4;
                                                                                                                        while (true) {
                                                                                                                            int n38;
                                                                                                                            char c3 = cArray35[n37];
                                                                                                                            switch (n4 % 5) {
                                                                                                                                case 0: {
                                                                                                                                    n38 = 106;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 1: {
                                                                                                                                    n38 = 16;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 2: {
                                                                                                                                    n38 = 113;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 3: {
                                                                                                                                    n38 = 62;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                default: {
                                                                                                                                    n38 = 79;
                                                                                                                                }
                                                                                                                            }
                                                                                                                            cArray35[n37] = (char)(c3 ^ n38);
                                                                                                                            ++n4;
                                                                                                                            cArray28 = cArray36;
                                                                                                                            n30 = n30;
                                                                                                                            if (n30 != 0) break;
                                                                                                                            cArray36 = cArray28;
                                                                                                                            n29 = n30;
                                                                                                                            n37 = n30;
                                                                                                                            cArray35 = cArray28;
                                                                                                                        }
                                                                                                                        cArray27 = cArray28;
                                                                                                                        n29 = n30;
                                                                                                                    } while (n30 > n4);
                                                                                                                }
                                                                                                                stringArray[1] = new String(cArray27).intern();
                                                                                                                var0 = null;
                                                                                                                char[] cArray37 = "`|K4oJ0Q".toCharArray();
                                                                                                                n4 = 0;
                                                                                                                int n39 = cArray37.length;
                                                                                                                cArray26 = cArray37;
                                                                                                                n28 = n39;
                                                                                                                if (n39 <= 1) break block139;
                                                                                                                cArray25 = cArray26;
                                                                                                                n27 = n28;
                                                                                                                if (n28 <= n4) break block140;
                                                                                                            }
                                                                                                            do {
                                                                                                                char[] cArray38 = cArray26;
                                                                                                                char[] cArray39 = cArray26;
                                                                                                                int n40 = n4;
                                                                                                                while (true) {
                                                                                                                    int n41;
                                                                                                                    char c4 = cArray38[n40];
                                                                                                                    switch (n4 % 5) {
                                                                                                                        case 0: {
                                                                                                                            n41 = 106;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 1: {
                                                                                                                            n41 = 16;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 2: {
                                                                                                                            n41 = 113;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 3: {
                                                                                                                            n41 = 62;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        default: {
                                                                                                                            n41 = 79;
                                                                                                                        }
                                                                                                                    }
                                                                                                                    cArray38[n40] = (char)(c4 ^ n41);
                                                                                                                    ++n4;
                                                                                                                    cArray26 = cArray39;
                                                                                                                    n28 = n28;
                                                                                                                    if (n28 != 0) break;
                                                                                                                    cArray39 = cArray26;
                                                                                                                    n27 = n28;
                                                                                                                    n40 = n28;
                                                                                                                    cArray38 = cArray26;
                                                                                                                }
                                                                                                                cArray25 = cArray26;
                                                                                                                n27 = n28;
                                                                                                            } while (n28 > n4);
                                                                                                        }
                                                                                                        stringArray[2] = new String(cArray25).intern();
                                                                                                        var0 = null;
                                                                                                        char[] cArray40 = "\r*{".toCharArray();
                                                                                                        n4 = 0;
                                                                                                        int n42 = cArray40.length;
                                                                                                        cArray24 = cArray40;
                                                                                                        n26 = n42;
                                                                                                        if (n42 <= 1) break block141;
                                                                                                        cArray23 = cArray24;
                                                                                                        n25 = n26;
                                                                                                        if (n26 <= n4) break block142;
                                                                                                    }
                                                                                                    do {
                                                                                                        char[] cArray41 = cArray24;
                                                                                                        char[] cArray42 = cArray24;
                                                                                                        int n43 = n4;
                                                                                                        while (true) {
                                                                                                            int n44;
                                                                                                            char c5 = cArray41[n43];
                                                                                                            switch (n4 % 5) {
                                                                                                                case 0: {
                                                                                                                    n44 = 106;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 1: {
                                                                                                                    n44 = 16;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 2: {
                                                                                                                    n44 = 113;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 3: {
                                                                                                                    n44 = 62;
                                                                                                                    break;
                                                                                                                }
                                                                                                                default: {
                                                                                                                    n44 = 79;
                                                                                                                }
                                                                                                            }
                                                                                                            cArray41[n43] = (char)(c5 ^ n44);
                                                                                                            ++n4;
                                                                                                            cArray24 = cArray42;
                                                                                                            n26 = n26;
                                                                                                            if (n26 != 0) break;
                                                                                                            cArray42 = cArray24;
                                                                                                            n25 = n26;
                                                                                                            n43 = n26;
                                                                                                            cArray41 = cArray24;
                                                                                                        }
                                                                                                        cArray23 = cArray24;
                                                                                                        n25 = n26;
                                                                                                    } while (n26 > n4);
                                                                                                }
                                                                                                stringArray[3] = new String(cArray23).intern();
                                                                                                var0 = null;
                                                                                                char[] cArray43 = ")q\u001fP \u001e0\u0001L \u000ee\u0012[o+C?\u0010~Ju\u001f] \u000ey\u001fY".toCharArray();
                                                                                                n4 = 0;
                                                                                                int n45 = cArray43.length;
                                                                                                cArray22 = cArray43;
                                                                                                n24 = n45;
                                                                                                if (n45 <= 1) break block143;
                                                                                                cArray21 = cArray22;
                                                                                                n23 = n24;
                                                                                                if (n24 <= n4) break block144;
                                                                                            }
                                                                                            do {
                                                                                                char[] cArray44 = cArray22;
                                                                                                char[] cArray45 = cArray22;
                                                                                                int n46 = n4;
                                                                                                while (true) {
                                                                                                    int n47;
                                                                                                    char c6 = cArray44[n46];
                                                                                                    switch (n4 % 5) {
                                                                                                        case 0: {
                                                                                                            n47 = 106;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 1: {
                                                                                                            n47 = 16;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 2: {
                                                                                                            n47 = 113;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 3: {
                                                                                                            n47 = 62;
                                                                                                            break;
                                                                                                        }
                                                                                                        default: {
                                                                                                            n47 = 79;
                                                                                                        }
                                                                                                    }
                                                                                                    cArray44[n46] = (char)(c6 ^ n47);
                                                                                                    ++n4;
                                                                                                    cArray22 = cArray45;
                                                                                                    n24 = n24;
                                                                                                    if (n24 != 0) break;
                                                                                                    cArray45 = cArray22;
                                                                                                    n23 = n24;
                                                                                                    n46 = n24;
                                                                                                    cArray44 = cArray22;
                                                                                                }
                                                                                                cArray21 = cArray22;
                                                                                                n23 = n24;
                                                                                            } while (n24 > n4);
                                                                                        }
                                                                                        stringArray[4] = new String(cArray21).intern();
                                                                                        var0 = null;
                                                                                        char[] cArray46 = ".X".toCharArray();
                                                                                        n4 = 0;
                                                                                        int n48 = cArray46.length;
                                                                                        cArray20 = cArray46;
                                                                                        n22 = n48;
                                                                                        if (n48 <= 1) break block145;
                                                                                        cArray19 = cArray20;
                                                                                        n21 = n22;
                                                                                        if (n22 <= n4) break block146;
                                                                                    }
                                                                                    do {
                                                                                        char[] cArray47 = cArray20;
                                                                                        char[] cArray48 = cArray20;
                                                                                        int n49 = n4;
                                                                                        while (true) {
                                                                                            int n50;
                                                                                            char c7 = cArray47[n49];
                                                                                            switch (n4 % 5) {
                                                                                                case 0: {
                                                                                                    n50 = 106;
                                                                                                    break;
                                                                                                }
                                                                                                case 1: {
                                                                                                    n50 = 16;
                                                                                                    break;
                                                                                                }
                                                                                                case 2: {
                                                                                                    n50 = 113;
                                                                                                    break;
                                                                                                }
                                                                                                case 3: {
                                                                                                    n50 = 62;
                                                                                                    break;
                                                                                                }
                                                                                                default: {
                                                                                                    n50 = 79;
                                                                                                }
                                                                                            }
                                                                                            cArray47[n49] = (char)(c7 ^ n50);
                                                                                            ++n4;
                                                                                            cArray20 = cArray48;
                                                                                            n22 = n22;
                                                                                            if (n22 != 0) break;
                                                                                            cArray48 = cArray20;
                                                                                            n21 = n22;
                                                                                            n49 = n22;
                                                                                            cArray47 = cArray20;
                                                                                        }
                                                                                        cArray19 = cArray20;
                                                                                        n21 = n22;
                                                                                    } while (n22 > n4);
                                                                                }
                                                                                stringArray[5] = new String(cArray19).intern();
                                                                                var0 = null;
                                                                                char[] cArray49 = "2>D\u000ev".toCharArray();
                                                                                n4 = 0;
                                                                                int n51 = cArray49.length;
                                                                                cArray18 = cArray49;
                                                                                n20 = n51;
                                                                                if (n51 <= 1) break block147;
                                                                                cArray17 = cArray18;
                                                                                n19 = n20;
                                                                                if (n20 <= n4) break block148;
                                                                            }
                                                                            do {
                                                                                char[] cArray50 = cArray18;
                                                                                char[] cArray51 = cArray18;
                                                                                int n52 = n4;
                                                                                while (true) {
                                                                                    int n53;
                                                                                    char c8 = cArray50[n52];
                                                                                    switch (n4 % 5) {
                                                                                        case 0: {
                                                                                            n53 = 106;
                                                                                            break;
                                                                                        }
                                                                                        case 1: {
                                                                                            n53 = 16;
                                                                                            break;
                                                                                        }
                                                                                        case 2: {
                                                                                            n53 = 113;
                                                                                            break;
                                                                                        }
                                                                                        case 3: {
                                                                                            n53 = 62;
                                                                                            break;
                                                                                        }
                                                                                        default: {
                                                                                            n53 = 79;
                                                                                        }
                                                                                    }
                                                                                    cArray50[n52] = (char)(c8 ^ n53);
                                                                                    ++n4;
                                                                                    cArray18 = cArray51;
                                                                                    n20 = n20;
                                                                                    if (n20 != 0) break;
                                                                                    cArray51 = cArray18;
                                                                                    n19 = n20;
                                                                                    n52 = n20;
                                                                                    cArray50 = cArray18;
                                                                                }
                                                                                cArray17 = cArray18;
                                                                                n19 = n20;
                                                                            } while (n20 > n4);
                                                                        }
                                                                        stringArray[6] = new String(cArray17).intern();
                                                                        var0 = null;
                                                                        char[] cArray52 = "+|\u0016w+Jy\u0002\u001e!\u0005dQ_o9U k\n$S4".toCharArray();
                                                                        n4 = 0;
                                                                        int n54 = cArray52.length;
                                                                        cArray16 = cArray52;
                                                                        n18 = n54;
                                                                        if (n54 <= 1) break block149;
                                                                        cArray15 = cArray16;
                                                                        n17 = n18;
                                                                        if (n18 <= n4) break block150;
                                                                    }
                                                                    do {
                                                                        char[] cArray53 = cArray16;
                                                                        char[] cArray54 = cArray16;
                                                                        int n55 = n4;
                                                                        while (true) {
                                                                            int n56;
                                                                            char c9 = cArray53[n55];
                                                                            switch (n4 % 5) {
                                                                                case 0: {
                                                                                    n56 = 106;
                                                                                    break;
                                                                                }
                                                                                case 1: {
                                                                                    n56 = 16;
                                                                                    break;
                                                                                }
                                                                                case 2: {
                                                                                    n56 = 113;
                                                                                    break;
                                                                                }
                                                                                case 3: {
                                                                                    n56 = 62;
                                                                                    break;
                                                                                }
                                                                                default: {
                                                                                    n56 = 79;
                                                                                }
                                                                            }
                                                                            cArray53[n55] = (char)(c9 ^ n56);
                                                                            ++n4;
                                                                            cArray16 = cArray54;
                                                                            n18 = n18;
                                                                            if (n18 != 0) break;
                                                                            cArray54 = cArray16;
                                                                            n17 = n18;
                                                                            n55 = n18;
                                                                            cArray53 = cArray16;
                                                                        }
                                                                        cArray15 = cArray16;
                                                                        n17 = n18;
                                                                    } while (n18 > n4);
                                                                }
                                                                stringArray[7] = new String(cArray15).intern();
                                                                var0 = null;
                                                                char[] cArray55 = "/h\u0005L.J`\u0010L.\u0007u\u0005[=Jt\u0010J.".toCharArray();
                                                                n4 = 0;
                                                                int n57 = cArray55.length;
                                                                cArray14 = cArray55;
                                                                n16 = n57;
                                                                if (n57 <= 1) break block151;
                                                                cArray13 = cArray14;
                                                                n15 = n16;
                                                                if (n16 <= n4) break block152;
                                                            }
                                                            do {
                                                                char[] cArray56 = cArray14;
                                                                char[] cArray57 = cArray14;
                                                                int n58 = n4;
                                                                while (true) {
                                                                    int n59;
                                                                    char c10 = cArray56[n58];
                                                                    switch (n4 % 5) {
                                                                        case 0: {
                                                                            n59 = 106;
                                                                            break;
                                                                        }
                                                                        case 1: {
                                                                            n59 = 16;
                                                                            break;
                                                                        }
                                                                        case 2: {
                                                                            n59 = 113;
                                                                            break;
                                                                        }
                                                                        case 3: {
                                                                            n59 = 62;
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            n59 = 79;
                                                                        }
                                                                    }
                                                                    cArray56[n58] = (char)(c10 ^ n59);
                                                                    ++n4;
                                                                    cArray14 = cArray57;
                                                                    n16 = n16;
                                                                    if (n16 != 0) break;
                                                                    cArray57 = cArray14;
                                                                    n15 = n16;
                                                                    n58 = n16;
                                                                    cArray56 = cArray14;
                                                                }
                                                                cArray13 = cArray14;
                                                                n15 = n16;
                                                            } while (n16 > n4);
                                                        }
                                                        stringArray[8] = new String(cArray13).intern();
                                                        var0 = null;
                                                        char[] cArray58 = ":b\u0018H.\u001eu\\H.\u0006e\u0014\u001e#\u000f~\u0016J'Jd\u001eQo\by\u0016".toCharArray();
                                                        n4 = 0;
                                                        int n60 = cArray58.length;
                                                        cArray12 = cArray58;
                                                        n14 = n60;
                                                        if (n60 <= 1) break block153;
                                                        cArray11 = cArray12;
                                                        n13 = n14;
                                                        if (n14 <= n4) break block154;
                                                    }
                                                    do {
                                                        char[] cArray59 = cArray12;
                                                        char[] cArray60 = cArray12;
                                                        int n61 = n4;
                                                        while (true) {
                                                            int n62;
                                                            char c11 = cArray59[n61];
                                                            switch (n4 % 5) {
                                                                case 0: {
                                                                    n62 = 106;
                                                                    break;
                                                                }
                                                                case 1: {
                                                                    n62 = 16;
                                                                    break;
                                                                }
                                                                case 2: {
                                                                    n62 = 113;
                                                                    break;
                                                                }
                                                                case 3: {
                                                                    n62 = 62;
                                                                    break;
                                                                }
                                                                default: {
                                                                    n62 = 79;
                                                                }
                                                            }
                                                            cArray59[n61] = (char)(c11 ^ n62);
                                                            ++n4;
                                                            cArray12 = cArray60;
                                                            n14 = n14;
                                                            if (n14 != 0) break;
                                                            cArray60 = cArray12;
                                                            n13 = n14;
                                                            n61 = n14;
                                                            cArray59 = cArray12;
                                                        }
                                                        cArray11 = cArray12;
                                                        n13 = n14;
                                                    } while (n14 > n4);
                                                }
                                                stringArray[9] = new String(cArray11).intern();
                                                var0 = null;
                                                char[] cArray61 = "#~\u0007_#\u0003tQU*\u00130\u0017Q=\u0007q\u0005".toCharArray();
                                                n4 = 0;
                                                int n63 = cArray61.length;
                                                cArray10 = cArray61;
                                                n12 = n63;
                                                if (n63 <= 1) break block155;
                                                cArray9 = cArray10;
                                                n11 = n12;
                                                if (n12 <= n4) break block156;
                                            }
                                            do {
                                                char[] cArray62 = cArray10;
                                                char[] cArray63 = cArray10;
                                                int n64 = n4;
                                                while (true) {
                                                    int n65;
                                                    char c12 = cArray62[n64];
                                                    switch (n4 % 5) {
                                                        case 0: {
                                                            n65 = 106;
                                                            break;
                                                        }
                                                        case 1: {
                                                            n65 = 16;
                                                            break;
                                                        }
                                                        case 2: {
                                                            n65 = 113;
                                                            break;
                                                        }
                                                        case 3: {
                                                            n65 = 62;
                                                            break;
                                                        }
                                                        default: {
                                                            n65 = 79;
                                                        }
                                                    }
                                                    cArray62[n64] = (char)(c12 ^ n65);
                                                    ++n4;
                                                    cArray10 = cArray63;
                                                    n12 = n12;
                                                    if (n12 != 0) break;
                                                    cArray63 = cArray10;
                                                    n11 = n12;
                                                    n64 = n12;
                                                    cArray62 = cArray10;
                                                }
                                                cArray9 = cArray10;
                                                n11 = n12;
                                            } while (n12 > n4);
                                        }
                                        stringArray[10] = new String(cArray9).intern();
                                        var0 = null;
                                        char[] cArray64 = ":q\u0003_\"\u000fd\u0014L<J~\u001eJo\u000b0\"{\u001e?U?}\n".toCharArray();
                                        n4 = 0;
                                        int n66 = cArray64.length;
                                        cArray8 = cArray64;
                                        n10 = n66;
                                        if (n66 <= 1) break block157;
                                        cArray7 = cArray8;
                                        n9 = n10;
                                        if (n10 <= n4) break block158;
                                    }
                                    do {
                                        char[] cArray65 = cArray8;
                                        char[] cArray66 = cArray8;
                                        int n67 = n4;
                                        while (true) {
                                            int n68;
                                            char c13 = cArray65[n67];
                                            switch (n4 % 5) {
                                                case 0: {
                                                    n68 = 106;
                                                    break;
                                                }
                                                case 1: {
                                                    n68 = 16;
                                                    break;
                                                }
                                                case 2: {
                                                    n68 = 113;
                                                    break;
                                                }
                                                case 3: {
                                                    n68 = 62;
                                                    break;
                                                }
                                                default: {
                                                    n68 = 79;
                                                }
                                            }
                                            cArray65[n67] = (char)(c13 ^ n68);
                                            ++n4;
                                            cArray8 = cArray66;
                                            n10 = n10;
                                            if (n10 != 0) break;
                                            cArray66 = cArray8;
                                            n9 = n10;
                                            n67 = n10;
                                            cArray65 = cArray8;
                                        }
                                        cArray7 = cArray8;
                                        n9 = n10;
                                    } while (n10 > n4);
                                }
                                stringArray[11] = new String(cArray7).intern();
                                var0 = null;
                                char[] cArray67 = "$e\u001dRo\u001aq\u0003_\"\u000fd\u0014L<".toCharArray();
                                n4 = 0;
                                int n69 = cArray67.length;
                                cArray6 = cArray67;
                                n8 = n69;
                                if (n69 <= 1) break block159;
                                cArray5 = cArray6;
                                n7 = n8;
                                if (n8 <= n4) break block160;
                            }
                            do {
                                char[] cArray68 = cArray6;
                                char[] cArray69 = cArray6;
                                int n70 = n4;
                                while (true) {
                                    int n71;
                                    char c14 = cArray68[n70];
                                    switch (n4 % 5) {
                                        case 0: {
                                            n71 = 106;
                                            break;
                                        }
                                        case 1: {
                                            n71 = 16;
                                            break;
                                        }
                                        case 2: {
                                            n71 = 113;
                                            break;
                                        }
                                        case 3: {
                                            n71 = 62;
                                            break;
                                        }
                                        default: {
                                            n71 = 79;
                                        }
                                    }
                                    cArray68[n70] = (char)(c14 ^ n71);
                                    ++n4;
                                    cArray6 = cArray69;
                                    n8 = n8;
                                    if (n8 != 0) break;
                                    cArray69 = cArray6;
                                    n7 = n8;
                                    n70 = n8;
                                    cArray68 = cArray6;
                                }
                                cArray5 = cArray6;
                                n7 = n8;
                            } while (n8 > n4);
                        }
                        stringArray[12] = new String(cArray5).intern();
                        var0 = null;
                        char[] cArray70 = ":q\u0003_\"\u000fd\u0014L<J}\u0018M<\u0003~\u0016".toCharArray();
                        n4 = 0;
                        int n72 = cArray70.length;
                        cArray4 = cArray70;
                        n6 = n72;
                        if (n72 <= 1) break block161;
                        cArray3 = cArray4;
                        n5 = n6;
                        if (n6 <= n4) break block162;
                    }
                    do {
                        char[] cArray71 = cArray4;
                        char[] cArray72 = cArray4;
                        int n73 = n4;
                        while (true) {
                            int n74;
                            char c15 = cArray71[n73];
                            switch (n4 % 5) {
                                case 0: {
                                    n74 = 106;
                                    break;
                                }
                                case 1: {
                                    n74 = 16;
                                    break;
                                }
                                case 2: {
                                    n74 = 113;
                                    break;
                                }
                                case 3: {
                                    n74 = 62;
                                    break;
                                }
                                default: {
                                    n74 = 79;
                                }
                            }
                            cArray71[n73] = (char)(c15 ^ n74);
                            ++n4;
                            cArray4 = cArray72;
                            n6 = n6;
                            if (n6 != 0) break;
                            cArray72 = cArray4;
                            n5 = n6;
                            n73 = n6;
                            cArray71 = cArray4;
                        }
                        cArray3 = cArray4;
                        n5 = n6;
                    } while (n6 > n4);
                }
                stringArray[13] = new String(cArray3).intern();
                var0 = null;
                char[] cArray73 = "/h\u0012[<\u00190\u001a[6Jt\u0010J.".toCharArray();
                n4 = 0;
                int n75 = cArray73.length;
                cArray2 = cArray73;
                n3 = n75;
                if (n75 <= 1) break block163;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block164;
            }
            do {
                char[] cArray74 = cArray2;
                char[] cArray75 = cArray2;
                int n76 = n4;
                while (true) {
                    int n77;
                    char c16 = cArray74[n76];
                    switch (n4 % 5) {
                        case 0: {
                            n77 = 106;
                            break;
                        }
                        case 1: {
                            n77 = 16;
                            break;
                        }
                        case 2: {
                            n77 = 113;
                            break;
                        }
                        case 3: {
                            n77 = 62;
                            break;
                        }
                        default: {
                            n77 = 79;
                        }
                    }
                    cArray74[n76] = (char)(c16 ^ n77);
                    ++n4;
                    cArray2 = cArray75;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray75 = cArray2;
                    n2 = n3;
                    n76 = n3;
                    cArray74 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        stringArray[14] = new String(cArray).intern();
        z = stringArray;
    }
}

